/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi.explanation.io.rdfxml;

import com.clarkparsia.owlapi.explanation.io.ExplanationRenderer;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import openllet.owlapi.OWL;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.RDFXMLRenderer;

public class RDFXMLExplanationRenderer
implements ExplanationRenderer {
    private Set<OWLAxiom> _axioms;
    private Writer _writer;

    public void startRendering(Writer writer) {
        this._writer = writer;
        this._axioms = new HashSet<OWLAxiom>();
    }

    public void render(OWLAxiom axiom, Set<Set<OWLAxiom>> explanations) {
        this._axioms.add(axiom);
        for (Set<OWLAxiom> explanation : explanations) {
            this._axioms.addAll(explanation);
        }
    }

    public void endRendering() throws IOException {
        OWLOntology ontology = OWL.Ontology(this._axioms);
        RDFXMLRenderer renderer = new RDFXMLRenderer(ontology, new PrintWriter(this._writer));
        renderer.render();
    }
}

