/*
 * Decompiled with CFR 0.152.
 */
package openllet.aterm.pure;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import openllet.aterm.AFun;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermFactory;
import openllet.aterm.ATermPlaceholder;
import openllet.aterm.VisitFailure;
import openllet.aterm.pure.ATermVisitableImpl;
import openllet.aterm.pure.ATermWriter;
import openllet.aterm.pure.PureFactory;
import openllet.atom.OpenError;
import openllet.shared.hash.SharedObjectWithID;

public abstract class ATermImpl
extends ATermVisitableImpl
implements ATerm,
SharedObjectWithID {
    protected PureFactory _factory;
    private int _hashCode;
    private int _uniqueId;

    protected ATermImpl(PureFactory factory) {
        this._factory = factory;
    }

    @Override
    public final int hashCode() {
        return this._hashCode;
    }

    protected void setHashCode(int hashcode) {
        this._hashCode = hashcode;
    }

    protected void init(int hashCode) {
        this._hashCode = hashCode;
    }

    @Override
    public ATermFactory getFactory() {
        return this._factory;
    }

    protected PureFactory getPureFactory() {
        return this._factory;
    }

    @Override
    public List<Object> match(String pattern) {
        return this.match(this._factory.parsePattern(pattern));
    }

    @Override
    public List<Object> match(ATerm pattern) {
        LinkedList<Object> list = new LinkedList<Object>();
        if (this.match(pattern, list)) {
            return list;
        }
        return null;
    }

    @Override
    public boolean isEqual(ATerm term) {
        if (term instanceof ATermImpl) {
            return this == term;
        }
        return this._factory.isDeepEqual(this, term);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    protected boolean match(ATerm pattern, List<Object> list) {
        ATermAppl appl;
        AFun afun;
        ATerm type;
        if (pattern.getType() == 5 && (type = ((ATermPlaceholder)pattern).getPlaceholder()).getType() == 1 && (afun = (appl = (ATermAppl)type).getAFun()).getName().equals("term") && afun.getArity() == 0 && !afun.isQuoted()) {
            list.add(this);
            return true;
        }
        return false;
    }

    @Override
    public ATerm make(List<Object> list) {
        return this;
    }

    public void writeToTextFile(ATermWriter writer) throws IOException {
        try {
            writer.voidVisitChild(this);
            writer.getStream().flush();
        }
        catch (VisitFailure e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void writeToSharedTextFile(OutputStream stream) throws IOException {
        ATermWriter writer = new ATermWriter(stream);
        writer.initializeSharing();
        stream.write(33);
        this.writeToTextFile(writer);
    }

    @Override
    public void writeToTextFile(OutputStream stream) throws IOException {
        this.writeToTextFile(new ATermWriter(stream));
    }

    @Override
    public String toString() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ATermWriter writer = new ATermWriter(stream);
            this.writeToTextFile(writer);
            return ((Object)stream).toString();
        }
        catch (IOException e) {
            throw new OpenError("IOException: " + e.getMessage());
        }
    }

    @Override
    public int getNrSubTerms() {
        return 0;
    }

    @Override
    public ATerm getSubTerm(int index) {
        throw new OpenError("no children!");
    }

    @Override
    public ATerm setSubTerm(int index, ATerm t) {
        throw new OpenError("no children!");
    }

    @Override
    public int getUniqueIdentifier() {
        return this._uniqueId;
    }

    @Override
    public void setUniqueIdentifier(int uniqueId) {
        this._uniqueId = uniqueId;
    }
}

