/*
 * Decompiled with CFR 0.152.
 */
package openllet.shared.hash;

import java.lang.ref.WeakReference;
import openllet.atom.OpenError;
import openllet.shared.hash.SharedObject;
import openllet.shared.hash.SharedObjectWithID;

public class SharedObjectFactory {
    private static final int DEFAULT_NR_OF_SEGMENTS_BITSIZE = 5;
    private final Segment[] _segments = new Segment[32];

    public SharedObjectFactory() {
        for (int i = this._segments.length - 1; i >= 0; --i) {
            this._segments[i] = new Segment(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        for (int i = this._segments.length - 1; i >= 0; --i) {
            Segment segment;
            Segment segment2 = segment = this._segments[i];
            synchronized (segment2) {
                segment.cleanup();
                continue;
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int nrOfSegments = this._segments.length;
        for (int i = 0; i < nrOfSegments; ++i) {
            int startHash = i << 27;
            int endHash = (i + 1 << 27) - 1;
            sb.append("Segment hash range: ");
            sb.append(startHash);
            sb.append(" till ");
            sb.append(endHash);
            sb.append(" | ");
            sb.append(this._segments[i].toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public <T extends SharedObject> T build(T prototype) {
        int hash = prototype.hashCode();
        int segmentNr = hash >>> 27;
        return (T)this._segments[segmentNr].get(prototype, hash);
    }

    public boolean contains(SharedObject object) {
        int hash = object.hashCode();
        int segmentNr = hash >>> 27;
        return this._segments[segmentNr].contains(object, hash);
    }

    private static final class Segment {
        private static final int MAX_SEGMENT_BITSIZE = 27;
        private static final int DEFAULT_SEGMENT_BITSIZE = 5;
        private static final float DEFAULT_LOAD_FACTOR = 2.0f;
        private volatile Entry[] _entries;
        private int _bitSize;
        private int _threshold;
        private int _load;
        public volatile boolean _flaggedForCleanup;
        public volatile WeakReference<GarbageCollectionDetector> _garbageCollectionDetector;
        private int _cleanupScaler;
        private int _cleanupThreshold;
        private final int _segmentID;
        private int _numberOfFreeIDs;
        private int[] _freeIDs;
        private int _freeIDsIndex;
        private int _nextFreeID;
        private final int _maxFreeIDPlusOne;

        public Segment(int segmentID) {
            this._segmentID = segmentID;
            this._bitSize = 5;
            int nrOfEntries = 1 << this._bitSize;
            this._entries = new Entry[nrOfEntries];
            this._threshold = (int)((float)nrOfEntries * 2.0f);
            this._load = 0;
            this._flaggedForCleanup = false;
            this._garbageCollectionDetector = new WeakReference<GarbageCollectionDetector>(new GarbageCollectionDetector(this));
            this._cleanupThreshold = this._cleanupScaler = 50;
            this._numberOfFreeIDs = 1 << this._bitSize;
            this._freeIDs = new int[this._numberOfFreeIDs];
            this._freeIDsIndex = 0;
            this._nextFreeID = segmentID << 27;
            this._maxFreeIDPlusOne = segmentID + 1 << 27;
        }

        public void cleanup() {
            Entry[] table = this._entries;
            int newLoad = this._load;
            for (int i = this._entries.length - 1; i >= 0; --i) {
                Entry next;
                Entry e = table[i];
                if (e == null) continue;
                Entry previous = null;
                do {
                    next = e._next;
                    if (e.get() == null) {
                        if (previous == null) {
                            table[i] = next;
                        } else {
                            previous._next = next;
                        }
                        --newLoad;
                        if (!(e instanceof EntryWithID)) continue;
                        EntryWithID ewid = (EntryWithID)e;
                        this.releaseID(ewid._id);
                        continue;
                    }
                    previous = e;
                } while ((e = next) != null);
            }
            this._load = newLoad;
            this._entries = table;
        }

        private void rehash() {
            int nrOfEntries = 1 << ++this._bitSize;
            int newHashMask = nrOfEntries - 1;
            Entry[] oldEntries = this._entries;
            Entry[] newEntries = new Entry[nrOfEntries];
            Entry currentEntryRoot = new Entry(null, null, 0);
            Entry shiftedEntryRoot = new Entry(null, null, 0);
            int newLoad = this._load;
            int oldSize = oldEntries.length;
            for (int i = oldSize - 1; i >= 0; --i) {
                Entry e = oldEntries[i];
                if (e == null) continue;
                Entry lastCurrentEntry = currentEntryRoot;
                Entry lastShiftedEntry = shiftedEntryRoot;
                do {
                    if (e.get() != null) {
                        int position = e._hash & newHashMask;
                        if (position == i) {
                            lastCurrentEntry._next = e;
                            lastCurrentEntry = e;
                            continue;
                        }
                        lastShiftedEntry._next = e;
                        lastShiftedEntry = e;
                        continue;
                    }
                    --newLoad;
                    if (!(e instanceof EntryWithID)) continue;
                    EntryWithID ewid = (EntryWithID)e;
                    this.releaseID(ewid._id);
                } while ((e = e._next) != null);
                lastCurrentEntry._next = null;
                lastShiftedEntry._next = null;
                newEntries[i] = currentEntryRoot._next;
                newEntries[i | oldSize] = shiftedEntryRoot._next;
            }
            this._load = newLoad;
            this._threshold <<= 1;
            this._entries = newEntries;
        }

        private void ensureCapacity() {
            if (this._load > this._threshold && this._bitSize < 27) {
                this.rehash();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tryCleanup() {
            if (this._flaggedForCleanup) {
                Segment segment = this;
                synchronized (segment) {
                    if (this._garbageCollectionDetector == null) {
                        this._flaggedForCleanup = false;
                        if (this._cleanupThreshold > 8) {
                            int oldLoad = this._load;
                            this.cleanup();
                            int cleanupPercentate = oldLoad == 0 ? 50 : 100 - this._load * 100 / oldLoad;
                            this._cleanupScaler = this._cleanupScaler * 25 + cleanupPercentate * 7 >> 5;
                            this._cleanupThreshold = this._cleanupScaler > 0 ? this._cleanupScaler : 1;
                        } else {
                            this._cleanupThreshold <<= 1;
                        }
                        this._garbageCollectionDetector = new WeakReference<GarbageCollectionDetector>(new GarbageCollectionDetector(this));
                    }
                }
            }
        }

        private void put(SharedObject object, int hash) {
            Entry[] table = this._entries;
            int hashMask = table.length - 1;
            int position = hash & hashMask;
            Entry next = table[position];
            if (object instanceof SharedObjectWithID) {
                SharedObjectWithID sharedObjectWithID = (SharedObjectWithID)object;
                int id = this.generateID();
                sharedObjectWithID.setUniqueIdentifier(id);
                table[position] = new EntryWithID(next, sharedObjectWithID, hash, id);
            } else {
                table[position] = new Entry(next, object, hash);
            }
            ++this._load;
            this._entries = table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(SharedObject prototype, int hash) {
            Entry[] currentEntries = this._entries;
            int hashMask = currentEntries.length - 1;
            int position = hash & hashMask;
            Entry e = currentEntries[position];
            if (e != null) {
                do {
                    if (e.get() != prototype) continue;
                    return true;
                } while ((e = e._next) != null);
            }
            Segment segment = this;
            synchronized (segment) {
                currentEntries = this._entries;
                hashMask = currentEntries.length - 1;
                position = hash & hashMask;
                e = currentEntries[position];
                if (e != null) {
                    do {
                        if (e.get() != prototype) continue;
                        return true;
                    } while ((e = e._next) != null);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final SharedObject get(SharedObject prototype, int hash) {
            this.tryCleanup();
            Entry[] currentEntries = this._entries;
            int hashMask = currentEntries.length - 1;
            int position = hash & hashMask;
            Entry e = currentEntries[position];
            if (e != null) {
                do {
                    SharedObject object;
                    if (hash != e._hash || (object = (SharedObject)e.get()) == null || !prototype.equivalent(object)) continue;
                    return object;
                } while ((e = e._next) != null);
            }
            Segment segment = this;
            synchronized (segment) {
                currentEntries = this._entries;
                hashMask = currentEntries.length - 1;
                position = hash & hashMask;
                e = currentEntries[position];
                if (e != null) {
                    do {
                        SharedObject object;
                        if (hash != e._hash || (object = (SharedObject)e.get()) == null || !prototype.equivalent(object)) continue;
                        return object;
                    } while ((e = e._next) != null);
                }
                this.ensureCapacity();
                SharedObject result = prototype.duplicate();
                this.put(result, hash);
                return result;
            }
        }

        private int generateID() {
            if (this._freeIDsIndex > 0) {
                if (this._freeIDsIndex < this._numberOfFreeIDs >> 2 && this._numberOfFreeIDs > 32) {
                    int newNumberOfFreeIDs = this._numberOfFreeIDs >> 1;
                    int[] newFreeIds = new int[newNumberOfFreeIDs];
                    System.arraycopy(this._freeIDs, 0, newFreeIds, 0, newNumberOfFreeIDs);
                    this._freeIDs = newFreeIds;
                    this._numberOfFreeIDs = newNumberOfFreeIDs;
                }
                return this._freeIDs[--this._freeIDsIndex];
            }
            if (this._nextFreeID != this._maxFreeIDPlusOne) {
                return this._nextFreeID++;
            }
            this.cleanup();
            if (this._freeIDsIndex > 0) {
                return this._freeIDs[--this._freeIDsIndex];
            }
            throw new OpenError("No more unique identifiers available for segment(" + this._segmentID + ").");
        }

        private void releaseID(int id) {
            if (this._freeIDsIndex == this._numberOfFreeIDs) {
                int newNumberOfFreeIDs = this._numberOfFreeIDs << 1;
                int[] newFreeIds = new int[newNumberOfFreeIDs];
                System.arraycopy(this._freeIDs, 0, newFreeIds, 0, this._numberOfFreeIDs);
                this._freeIDs = newFreeIds;
                this._numberOfFreeIDs = newNumberOfFreeIDs;
            }
            this._freeIDs[this._freeIDsIndex++] = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuilder sb = new StringBuilder();
            Segment segment = this;
            synchronized (segment) {
                Entry[] table = this._entries;
                int tableSize = table.length;
                sb.append("Table size: ");
                sb.append(tableSize);
                sb.append(", ");
                sb.append("Number of entries: ");
                sb.append(this._load);
                sb.append(", ");
                sb.append("Threshold: ");
                sb.append(this._threshold);
                sb.append(", ");
                int nrOfFilledBuckets = 0;
                int totalNrOfCollisions = 0;
                int maxBucketLength = 0;
                for (int i = 0; i < tableSize; ++i) {
                    Entry e = table[i];
                    if (e == null) continue;
                    ++nrOfFilledBuckets;
                    int bucketLength = 1;
                    while ((e = e._next) != null) {
                        ++bucketLength;
                    }
                    if (bucketLength > maxBucketLength) {
                        maxBucketLength = bucketLength;
                    }
                    totalNrOfCollisions += bucketLength - 1;
                }
                double averageBucketLength = 0.0;
                double distribution = 100.0;
                if (nrOfFilledBuckets != 0) {
                    averageBucketLength = (double)(totalNrOfCollisions * 1000 / nrOfFilledBuckets) / 1000.0 + 1.0;
                    distribution = 100.0 - (double)((float)(totalNrOfCollisions * 1000 / nrOfFilledBuckets) / 2.0f) / 10.0;
                }
                sb.append("Number of filled buckets: ");
                sb.append(nrOfFilledBuckets);
                sb.append(", ");
                sb.append("Load factor: ");
                sb.append(2.0f);
                sb.append(", ");
                sb.append("Distribution (collisions vs filled buckets): ");
                sb.append(distribution);
                sb.append("%, ");
                sb.append("Total number of collisions: ");
                sb.append(totalNrOfCollisions);
                sb.append(", ");
                sb.append("Average (filled) bucket length: ");
                sb.append(averageBucketLength);
                sb.append(", ");
                sb.append("Maximal bucket length: ");
                sb.append(maxBucketLength);
                sb.append(", ");
                sb.append("Cleanup scaler: ");
                sb.append(this._cleanupScaler);
                sb.append("%");
            }
            return sb.toString();
        }

        private static class EntryWithID
        extends Entry {
            public final int _id;

            public EntryWithID(Entry next, SharedObjectWithID sharedObjectWithID, int hash, int id) {
                super(next, sharedObjectWithID, hash);
                this._id = id;
            }
        }

        private static class Entry
        extends WeakReference<SharedObject> {
            public final int _hash;
            public volatile Entry _next;

            public Entry(Entry next, SharedObject sharedObject, int hash) {
                super(sharedObject);
                this._next = next;
                this._hash = hash;
            }
        }

        private static class GarbageCollectionDetector {
            private final Segment _segment;

            public GarbageCollectionDetector(Segment segment) {
                this._segment = segment;
            }

            public void finalize() {
                this._segment._garbageCollectionDetector = null;
                this._segment._flaggedForCleanup = true;
            }
        }
    }
}

