/*
 * Decompiled with CFR 0.152.
 */
package openllet.shared.tools;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import openllet.shared.tools.Logging;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class Log
implements Logging {
    public static final java.util.logging.Logger _parent = java.util.logging.Logger.getLogger(Log.class.getName());
    public static volatile Level _defaultLevel = Level.INFO;
    public static volatile boolean _setDefaultParent = false;
    public static final Handler _systemOutHandler = new Handler(){

        @Override
        public void publish(LogRecord record) {
            StringBuffer buff = new StringBuffer();
            buff.append(record.getLevel()).append(' ');
            buff.append(record.getThreadID()).append(' ');
            buff.append(record.getLoggerName()).append(' ');
            buff.append(record.getMessage()).append(' ');
            System.out.println(buff.toString());
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    };
    private static Map<String, java.util.logging.Logger> _loggers;

    @Override
    public java.util.logging.Logger getLogger() {
        return _parent;
    }

    public void reset() {
        _loggers.clear();
    }

    private static java.util.logging.Logger config(java.util.logging.Logger logger, Level level) {
        if (_setDefaultParent) {
            logger.setParent(_parent);
        }
        _loggers.put(logger.getName(), logger);
        logger.setLevel(level);
        return logger;
    }

    public static java.util.logging.Logger getLogger(String name) {
        return Log.config(java.util.logging.Logger.getLogger(name), _defaultLevel);
    }

    public static java.util.logging.Logger getLogger(Class<?> type) {
        return Log.config(java.util.logging.Logger.getLogger(type.getSimpleName()), _defaultLevel);
    }

    public static java.util.logging.Logger getLogger(String name, Level specificLevel) {
        return Log.config(java.util.logging.Logger.getLogger(name), specificLevel);
    }

    public static java.util.logging.Logger getLogger(Class<?> type, Level specificLevel) {
        return Log.config(java.util.logging.Logger.getLogger(type.getSimpleName()), specificLevel);
    }

    public static Logger logger(String name) {
        return Log.toSlf4j(Log.config(java.util.logging.Logger.getLogger(name), _defaultLevel));
    }

    public static Logger logger(Class<?> type) {
        return Log.toSlf4j(Log.config(java.util.logging.Logger.getLogger(type.getSimpleName()), _defaultLevel));
    }

    public static Logger logger(String name, Level specificLevel) {
        return Log.toSlf4j(Log.config(java.util.logging.Logger.getLogger(name), specificLevel));
    }

    public static Logger logger(Class<?> type, Level specificLevel) {
        return Log.toSlf4j(Log.config(java.util.logging.Logger.getLogger(type.getSimpleName()), specificLevel));
    }

    public static void setLevel(java.util.logging.Logger logger, Level level) {
        logger.setLevel(level);
    }

    public static void setLevel(Level level, String filter) {
        _loggers.values().parallelStream().filter(l -> l.getName().contains(filter)).forEach(l -> l.setLevel(level));
    }

    public static void setLevel(Level level) {
        _loggers.values().parallelStream().forEach(l -> l.setLevel(level));
    }

    public static void setLevel(Level level, Class<?> type) {
        Log.setLevel(level, type.getSimpleName());
    }

    public static String error(java.util.logging.Logger logger, String msg, Function<String, Exception> pe) throws Exception {
        logger.log(Level.SEVERE, msg);
        throw pe.apply(msg);
    }

    public static void error(java.util.logging.Logger logger, Throwable e) {
        logger.log(Level.SEVERE, "", e);
    }

    public static void error(java.util.logging.Logger logger, String msg, Throwable e) {
        logger.log(Level.SEVERE, msg, e);
    }

    public static void warning(java.util.logging.Logger logger, Throwable e) {
        logger.log(Level.WARNING, "", e);
    }

    public static void warning(java.util.logging.Logger logger, String msg, Throwable e) {
        logger.log(Level.WARNING, msg, e);
    }

    public static Logger toSlf4j(final java.util.logging.Logger logger) {
        return new Logger(){

            public String getName() {
                return logger.getName();
            }

            public boolean isTraceEnabled() {
                return logger.isLoggable(Level.FINEST);
            }

            public void trace(String msg) {
                logger.finest(msg);
            }

            public void trace(String format, Object arg) {
                logger.log(Level.FINEST, format, arg);
            }

            public void trace(String format, Object arg1, Object arg2) {
                Object[] t = new Object[]{arg1, arg2};
                logger.log(Level.FINEST, format, t);
            }

            public void trace(String format, Object ... arguments) {
                logger.log(Level.FINEST, format, arguments);
            }

            public void trace(String msg, Throwable t) {
                logger.log(Level.FINEST, msg, t);
            }

            public boolean isTraceEnabled(Marker marker) {
                return this.isTraceEnabled();
            }

            public void trace(Marker marker, String msg) {
                this.trace(msg);
            }

            public void trace(Marker marker, String format, Object arg) {
                this.trace(format, arg);
            }

            public void trace(Marker marker, String format, Object arg1, Object arg2) {
                this.trace(format, arg1, arg2);
            }

            public void trace(Marker marker, String format, Object ... argArray) {
                this.trace(format, argArray);
            }

            public void trace(Marker marker, String msg, Throwable t) {
                this.trace(msg, t);
            }

            public boolean isDebugEnabled() {
                return logger.isLoggable(Level.FINE);
            }

            public void debug(String msg) {
                logger.finest(msg);
            }

            public void debug(String format, Object arg) {
                logger.log(Level.FINE, format, arg);
            }

            public void debug(String format, Object arg1, Object arg2) {
                Object[] t = new Object[]{arg1, arg2};
                logger.log(Level.FINE, format, t);
            }

            public void debug(String format, Object ... arguments) {
                logger.log(Level.FINE, format, arguments);
            }

            public void debug(String msg, Throwable t) {
                logger.log(Level.FINE, msg, t);
            }

            public boolean isDebugEnabled(Marker marker) {
                return this.isDebugEnabled();
            }

            public void debug(Marker marker, String msg) {
                this.debug(msg);
            }

            public void debug(Marker marker, String format, Object arg) {
                this.debug(format, arg);
            }

            public void debug(Marker marker, String format, Object arg1, Object arg2) {
                this.debug(format, arg1, arg2);
            }

            public void debug(Marker marker, String format, Object ... argArray) {
                this.debug(format, argArray);
            }

            public void debug(Marker marker, String msg, Throwable t) {
                this.debug(msg, t);
            }

            public boolean isInfoEnabled() {
                return logger.isLoggable(Level.INFO);
            }

            public void info(String msg) {
                logger.finest(msg);
            }

            public void info(String format, Object arg) {
                logger.log(Level.INFO, format, arg);
            }

            public void info(String format, Object arg1, Object arg2) {
                Object[] t = new Object[]{arg1, arg2};
                logger.log(Level.INFO, format, t);
            }

            public void info(String format, Object ... arguments) {
                logger.log(Level.INFO, format, arguments);
            }

            public void info(String msg, Throwable t) {
                logger.log(Level.INFO, msg, t);
            }

            public boolean isInfoEnabled(Marker marker) {
                return this.isInfoEnabled();
            }

            public void info(Marker marker, String msg) {
                this.info(msg);
            }

            public void info(Marker marker, String format, Object arg) {
                this.info(format, arg);
            }

            public void info(Marker marker, String format, Object arg1, Object arg2) {
                this.info(format, arg1, arg2);
            }

            public void info(Marker marker, String format, Object ... argArray) {
                this.info(format, argArray);
            }

            public void info(Marker marker, String msg, Throwable t) {
                this.info(msg, t);
            }

            public boolean isWarnEnabled() {
                return logger.isLoggable(Level.WARNING);
            }

            public void warn(String msg) {
                logger.finest(msg);
            }

            public void warn(String format, Object arg) {
                logger.log(Level.WARNING, format, arg);
            }

            public void warn(String format, Object arg1, Object arg2) {
                Object[] t = new Object[]{arg1, arg2};
                logger.log(Level.WARNING, format, t);
            }

            public void warn(String format, Object ... arguments) {
                logger.log(Level.WARNING, format, arguments);
            }

            public void warn(String msg, Throwable t) {
                logger.log(Level.WARNING, msg, t);
            }

            public boolean isWarnEnabled(Marker marker) {
                return this.isWarnEnabled();
            }

            public void warn(Marker marker, String msg) {
                this.warn(msg);
            }

            public void warn(Marker marker, String format, Object arg) {
                this.warn(format, arg);
            }

            public void warn(Marker marker, String format, Object arg1, Object arg2) {
                this.warn(format, arg1, arg2);
            }

            public void warn(Marker marker, String format, Object ... argArray) {
                this.warn(format, argArray);
            }

            public void warn(Marker marker, String msg, Throwable t) {
                this.warn(msg, t);
            }

            public boolean isErrorEnabled() {
                return logger.isLoggable(Level.SEVERE);
            }

            public void error(String msg) {
                logger.finest(msg);
            }

            public void error(String format, Object arg) {
                logger.log(Level.SEVERE, format, arg);
            }

            public void error(String format, Object arg1, Object arg2) {
                Object[] t = new Object[]{arg1, arg2};
                logger.log(Level.SEVERE, format, t);
            }

            public void error(String format, Object ... arguments) {
                logger.log(Level.FINEST, format, arguments);
            }

            public void error(String msg, Throwable t) {
                logger.log(Level.SEVERE, msg, t);
            }

            public boolean isErrorEnabled(Marker marker) {
                return this.isErrorEnabled();
            }

            public void error(Marker marker, String msg) {
                this.error(msg);
            }

            public void error(Marker marker, String format, Object arg) {
                this.error(format, arg);
            }

            public void error(Marker marker, String format, Object arg1, Object arg2) {
                this.error(format, arg1, arg2);
            }

            public void error(Marker marker, String format, Object ... argArray) {
                this.error(format, argArray);
            }

            public void error(Marker marker, String msg, Throwable t) {
                this.error(msg, t);
            }
        };
    }

    static {
        String property = System.getProperty("java.util.logging.SimpleFormatter.format");
        if (null == property) {
            System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tF %1$tT %4$s %2$s %5$s%6$s%n");
        }
        _parent.setLevel(_defaultLevel);
        _loggers = new ConcurrentHashMap<String, java.util.logging.Logger>();
    }
}

