/*
 * Decompiled with CFR 0.152.
 */
package openllet.jena;

import openllet.core.KBLoader;
import openllet.core.KnowledgeBase;
import openllet.jena.PelletInfGraph;
import openllet.jena.PelletReasonerFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.util.FileManager;

public class JenaLoader
extends KBLoader {
    private static final FileManager _manager = FileManager.get();
    private OntModel _model;
    private PelletInfGraph _pellet;

    public JenaLoader() {
        this.clear();
    }

    public PelletInfGraph getGraph() {
        return this._pellet;
    }

    public KnowledgeBase getKB() {
        return this._pellet.getKB();
    }

    public OntModel getModel() {
        return this._model;
    }

    public void load() {
        this._pellet.prepare(false);
    }

    protected void parseFile(String file) {
        _manager.readModel((Model)this._model, file, this._inputFormat);
    }

    public void clear() {
        if (this._model != null) {
            this._model.close();
        }
        this._model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        this._pellet = (PelletInfGraph)this._model.getGraph();
    }

    public void setInputFormat(String inputFormat) {
        this._inputFormat = inputFormat.toUpperCase();
    }

    public void setIgnoreImports(boolean ignoreImports) {
        this._model.getDocumentManager().setProcessImports(!ignoreImports);
    }
}

