/*
 * Decompiled with CFR 0.152.
 */
package openllet.jena;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.output.ATermManchesterSyntaxRenderer;
import openllet.core.output.ATermRenderer;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.QNameProvider;
import openllet.jena.JenaUtils;
import openllet.jena.vocabulary.OWL2;
import openllet.shared.tools.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.InfModel;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;

public class NodeFormatter {
    protected static Logger _logger = Log.getLogger(NodeFormatter.class);
    private final QNameProvider _qnames;
    private final StringWriter _sw;
    private final ATermRenderer _renderer;
    private final PrintWriter _formatter;
    private final Model _rawModel;
    private static final Resource NULL = null;

    public NodeFormatter(Model model) {
        if (model == null) {
            throw new NullPointerException("No model given!");
        }
        this._renderer = new ATermManchesterSyntaxRenderer();
        this._sw = new StringWriter();
        this._formatter = new PrintWriter(this._sw);
        this._renderer.setWriter(this._formatter);
        this._qnames = JenaUtils.makeQNameProvider((PrefixMapping)model);
        if (model instanceof InfModel) {
            InfGraph graph = (InfGraph)model.getGraph();
            this._rawModel = ModelFactory.createModelForGraph((Graph)graph.getRawGraph());
        } else {
            this._rawModel = model;
        }
    }

    public QNameProvider getQNames() {
        return this._qnames;
    }

    public String format(RDFNode node) {
        if (node == null) {
            return "<<null>>";
        }
        this._sw.getBuffer().setLength(0);
        ATerm term = this.node2term(node);
        if (term instanceof ATermAppl) {
            this._renderer.visit((ATermAppl)term);
        } else {
            this._sw.write("{");
            this._renderer.visitList((ATermList)term);
            this._sw.write("}");
        }
        return this._sw.toString();
    }

    public ATerm node2term(RDFNode node) {
        ATermAppl aTerm = null;
        if (node.equals(OWL.Thing)) {
            return ATermUtils.TOP;
        }
        if (node.equals(OWL.Nothing)) {
            return ATermUtils.BOTTOM;
        }
        if (node.equals(OWL2.topDataProperty)) {
            return ATermUtils.TOP_DATA_PROPERTY;
        }
        if (node.equals(OWL2.bottomDataProperty)) {
            return ATermUtils.BOTTOM_DATA_PROPERTY;
        }
        if (node.equals(OWL2.topObjectProperty)) {
            return ATermUtils.TOP_OBJECT_PROPERTY;
        }
        if (node.equals(OWL2.bottomObjectProperty)) {
            return ATermUtils.BOTTOM_OBJECT_PROPERTY;
        }
        if (node instanceof Literal) {
            Literal l = (Literal)node;
            String datatypeURI = l.getDatatypeURI();
            aTerm = datatypeURI != null ? ATermUtils.makeTypedLiteral((String)l.getString(), (String)datatypeURI) : ATermUtils.makePlainLiteral((String)l.getString(), (String)l.getLanguage());
        } else if (node instanceof Resource) {
            Resource r = (Resource)node;
            if (this._rawModel.contains(r, OWL.onProperty, (RDFNode)NULL)) {
                aTerm = this.createRestriction(r);
            } else if (r.isAnon()) {
                if (this._rawModel.contains(r, RDF.first, (RDFNode)NULL)) {
                    aTerm = this.createList(r);
                } else if (this._rawModel.contains(r, OWL.intersectionOf)) {
                    ATermList list = this.createList(this._rawModel.getProperty(r, OWL.intersectionOf).getResource());
                    aTerm = ATermUtils.makeAnd((ATermList)list);
                } else if (this._rawModel.contains(r, OWL.unionOf)) {
                    ATermList list = this.createList(this._rawModel.getProperty(r, OWL.unionOf).getResource());
                    aTerm = ATermUtils.makeOr((ATermList)list);
                } else if (this._rawModel.contains(r, OWL.oneOf)) {
                    ATermList list = this.createList(this._rawModel.getProperty(r, OWL.oneOf).getResource());
                    ATermList result = ATermUtils.EMPTY_LIST;
                    ATermList l = list;
                    while (!l.isEmpty()) {
                        ATermAppl c = (ATermAppl)l.getFirst();
                        ATermAppl nominal = ATermUtils.makeValue((ATerm)c);
                        result = result.insert((ATerm)nominal);
                        l = l.getNext();
                    }
                    aTerm = ATermUtils.makeOr((ATermList)result);
                } else if (this._rawModel.contains(r, OWL.complementOf)) {
                    ATerm complement = this.node2term((RDFNode)this._rawModel.getProperty(r, OWL.complementOf).getResource());
                    aTerm = ATermUtils.makeNot((ATerm)complement);
                } else {
                    aTerm = ATermUtils.makeBnode((String)r.getId().toString());
                }
            } else {
                aTerm = ATermUtils.makeTermAppl((String)r.getURI());
            }
        }
        return aTerm;
    }

    private ATermAppl createRestriction(Resource s) {
        ATermAppl aTerm = ATermUtils.BOTTOM;
        Statement stmt = this._rawModel.getProperty(s, OWL.onProperty);
        Resource p = stmt.getResource();
        ATerm pt = this.node2term((RDFNode)p);
        if (s.hasProperty(OWL.hasValue)) {
            stmt = this._rawModel.getProperty(s, OWL.hasValue);
            RDFNode o = stmt.getObject();
            ATerm ot = this.node2term(o);
            aTerm = ATermUtils.makeHasValue((ATerm)pt, (ATerm)ot);
        } else if (s.hasProperty(OWL.allValuesFrom)) {
            stmt = this._rawModel.getProperty(s, OWL.allValuesFrom);
            Resource o = stmt.getResource();
            ATerm ot = this.node2term((RDFNode)o);
            aTerm = ATermUtils.makeAllValues((ATerm)pt, (ATerm)ot);
        } else if (s.hasProperty(OWL.someValuesFrom)) {
            stmt = this._rawModel.getProperty(s, OWL.someValuesFrom);
            Resource o = stmt.getResource();
            ATerm ot = this.node2term((RDFNode)o);
            aTerm = ATermUtils.makeSomeValues((ATerm)pt, (ATerm)ot);
        } else if (s.hasProperty(OWL.minCardinality)) {
            stmt = this._rawModel.getProperty(s, OWL.minCardinality);
            int cardinality = 0;
            try {
                cardinality = stmt.getInt();
            }
            catch (Exception ex) {
                _logger.log(Level.FINER, "", ex);
                cardinality = Integer.parseInt(stmt.getLiteral().getLexicalForm());
            }
            aTerm = ATermUtils.makeDisplayMin((ATerm)pt, (int)cardinality, (ATerm)ATermUtils.EMPTY);
        } else if (s.hasProperty(OWL.maxCardinality)) {
            stmt = this._rawModel.getProperty(s, OWL.maxCardinality);
            int cardinality = 0;
            try {
                cardinality = stmt.getInt();
            }
            catch (Exception ex) {
                _logger.log(Level.FINER, "", ex);
                cardinality = Integer.parseInt(stmt.getLiteral().getLexicalForm());
            }
            aTerm = ATermUtils.makeDisplayMax((ATerm)pt, (int)cardinality, (ATerm)ATermUtils.EMPTY);
        } else if (s.hasProperty(OWL.cardinality)) {
            stmt = this._rawModel.getProperty(s, OWL.cardinality);
            int cardinality = 0;
            try {
                cardinality = stmt.getInt();
            }
            catch (Exception ex) {
                _logger.log(Level.FINER, "", ex);
                cardinality = Integer.parseInt(stmt.getLiteral().getLexicalForm());
            }
            aTerm = ATermUtils.makeDisplayCard((ATerm)pt, (int)cardinality, (ATerm)ATermUtils.EMPTY);
        }
        return aTerm;
    }

    private ATermList createList(Resource r) {
        if (r.equals((Object)RDF.nil)) {
            return ATermUtils.EMPTY_LIST;
        }
        if (!this._rawModel.contains(r, RDF.first)) {
            System.err.println("Invalid list structure: List " + r + " does not have a rdf:first property. Ignoring rest of the list.");
            return ATermUtils.EMPTY_LIST;
        }
        ATerm first = this.node2term(this._rawModel.getProperty(r, RDF.first).getObject());
        Resource rest = this._rawModel.getProperty(r, RDF.rest).getResource();
        return ATermUtils.makeList((ATerm)first, (ATermList)this.createList(rest));
    }
}

