/*
 * Decompiled with CFR 0.152.
 */
package openllet.jena;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.KnowledgeBase;
import openllet.core.KnowledgeBaseImpl;
import openllet.core.OpenlletOptions;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.OntBuilder;
import openllet.jena.BuiltinTerm;
import openllet.jena.JenaUtils;
import openllet.jena.ModelExtractor;
import openllet.jena.PelletGraphListener;
import openllet.jena.PelletReasoner;
import openllet.jena.SimpleUnion;
import openllet.jena.graph.converter.AxiomConverter;
import openllet.jena.graph.loader.DefaultGraphLoader;
import openllet.jena.graph.loader.GraphLoader;
import openllet.jena.graph.query.GraphQueryHandler;
import openllet.shared.tools.Log;
import org.apache.jena.graph.Factory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.reasoner.BaseInfGraph;
import org.apache.jena.reasoner.Finder;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.StandardValidityReport;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.ValidityReport;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.UniqueFilter;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class PelletInfGraph
extends BaseInfGraph {
    public static final Logger _logger = Log.getLogger(PelletInfGraph.class);
    private static final Triple INCONCISTENCY_TRIPLE = Triple.create((Node)OWL.Thing.asNode(), (Node)RDFS.subClassOf.asNode(), (Node)OWL.Nothing.asNode());
    private final KnowledgeBase _kb;
    private final ModelExtractor _extractor;
    private final PelletGraphListener _graphListener;
    private volatile GraphLoader _loader;
    private volatile Graph _deductionsGraph;
    private boolean _autoDetectChanges;
    private boolean _skipBuiltinPredicates;

    public PelletInfGraph(KnowledgeBase kb, PelletReasoner pellet, GraphLoader loader) {
        this(kb, Factory.createDefaultGraph(), pellet, loader);
    }

    public PelletInfGraph(Graph graph, PelletReasoner pellet, GraphLoader loader) {
        this((KnowledgeBase)new KnowledgeBaseImpl(), graph, pellet, loader);
    }

    private PelletInfGraph(KnowledgeBase kb, Graph graph, PelletReasoner pellet, GraphLoader loader) {
        super(graph, (Reasoner)pellet);
        this._kb = kb;
        this._loader = loader;
        this._extractor = new ModelExtractor(kb);
        this._extractor.setSelector(ModelExtractor.StatementType.ALL_PROPERTY_STATEMENTS);
        this._graphListener = new PelletGraphListener(graph, kb, this._autoDetectChanges);
        loader.setKB(kb);
        if (pellet.isFixedSchema()) {
            loader.load(Collections.singleton(this.getSchemaGraph()));
            loader.setLoadTBox(false);
        }
        this.rebind();
    }

    public GraphLoader attachTemporaryGraph(Graph tempGraph) {
        GraphLoader savedLoader = this._loader;
        SimpleUnion unionGraph = (SimpleUnion)savedLoader.getGraph();
        unionGraph.addGraph(tempGraph);
        this._loader = new DefaultGraphLoader();
        this._loader.setGraph((Graph)unionGraph);
        this._loader.setKB(this._kb);
        this._loader.preprocess();
        return savedLoader;
    }

    public void detachTemporaryGraph(Graph tempGraph, GraphLoader savedLoader) {
        SimpleUnion unionGraph = (SimpleUnion)this._loader.getGraph();
        unionGraph.removeGraph(tempGraph);
        this._loader = savedLoader;
    }

    public ExtendedIterator<Triple> find(Node subject, Node property, Node object, Graph param) {
        this.prepare();
        GraphLoader savedLoader = this.attachTemporaryGraph(param);
        ExtendedIterator result = this.graphBaseFind(subject, property, object);
        this.detachTemporaryGraph(param, savedLoader);
        return result;
    }

    public ExtendedIterator<Triple> findWithContinuation(TriplePattern pattern, Finder finder) {
        ATermAppl predicateTerm;
        this.prepare();
        Node subject = pattern.getSubject();
        Node predicate = pattern.getPredicate();
        Node object = pattern.getObject();
        ExtendedIterator i = GraphQueryHandler.findTriple(this._kb, this, subject, predicate, object);
        ATermAppl aTermAppl = predicateTerm = predicate.isURI() ? ATermUtils.makeTermAppl((String)predicate.getURI()) : null;
        if (finder != null && (predicateTerm == null || !this._kb.isObjectProperty((ATerm)predicateTerm) && !this._kb.isDatatypeProperty((ATerm)predicateTerm))) {
            TriplePattern tp = new TriplePattern(subject, predicate, object);
            i = i.andThen((Iterator)finder.find(tp));
        }
        return i.filterKeep((Predicate)new UniqueFilter());
    }

    public Graph getSchemaGraph() {
        return ((PelletReasoner)this.getReasoner()).getSchema();
    }

    public synchronized boolean isPrepared() {
        return super.isPrepared() && (!this._autoDetectChanges || !this._graphListener.isChanged());
    }

    private void load() {
        _logger.fine("Loading triples");
        Set<Graph> changedGraphs = this._graphListener.getChangedGraphs();
        if (changedGraphs == null) {
            this.reload();
        } else {
            this.load(changedGraphs);
        }
    }

    public void reload() {
        Graph schema;
        _logger.fine("Clearing the KB and reloading");
        this.clear();
        Set<Graph> graphs = this._graphListener.getLeafGraphs();
        if (this._loader.isLoadTBox() && (schema = this.getSchemaGraph()) != null) {
            graphs = new HashSet<Graph>(graphs);
            graphs.add(schema);
        }
        this.load(graphs);
    }

    private void load(Iterable<Graph> graphs) {
        this._loader.load(graphs);
        this._loader.setGraph((Graph)new SimpleUnion(this._graphListener.getLeafGraphs()));
        this._graphListener.reset();
        this._deductionsGraph = null;
    }

    public synchronized void prepare() {
        this.prepare(true);
    }

    public void prepare(boolean doConsistencyCheck) {
        if (this.isPrepared()) {
            return;
        }
        _logger.fine("Preparing PelletInfGraph...");
        this.load();
        this._kb.prepare();
        if (doConsistencyCheck) {
            this._kb.isConsistent();
        }
        _logger.fine("done.");
        super.prepare();
    }

    public boolean isConsistent() {
        this.prepare();
        return this._kb.isConsistent();
    }

    public boolean isClassified() {
        return super.isPrepared() && this._kb.isClassified();
    }

    public boolean isRealized() {
        return super.isPrepared() && this._kb.isRealized();
    }

    public void classify() {
        this.prepare();
        this._kb.classify();
    }

    public void realize() {
        this.prepare();
        this._kb.realize();
    }

    public Graph getDeductionsGraph() {
        if (!OpenlletOptions.RETURN_DEDUCTIONS_GRAPH) {
            return null;
        }
        this.classify();
        if (this._deductionsGraph == null) {
            _logger.fine("Realizing PelletInfGraph...");
            this._kb.realize();
            _logger.fine("Extract model...");
            Model extractedModel = this._extractor.extractModel();
            this._deductionsGraph = extractedModel.getGraph();
            _logger.fine("done.");
        }
        return this._deductionsGraph;
    }

    protected boolean graphBaseContains(Triple pattern) {
        if (this.getRawGraph().contains(pattern)) {
            return true;
        }
        return this.containsTriple(pattern);
    }

    public boolean entails(Triple pattern) {
        this.prepare();
        if (PelletInfGraph.isSyntaxTriple(pattern)) {
            return true;
        }
        if (PelletInfGraph.isBnodeTypeQuery(pattern)) {
            return !this.containsTriple(Triple.create((Node)pattern.getObject(), (Node)RDFS.subClassOf.asNode(), (Node)OWL.Nothing.asNode()));
        }
        return this.containsTriple(pattern);
    }

    public Model explainInconsistency() {
        return this.explainTriple(INCONCISTENCY_TRIPLE);
    }

    public Model explain(Statement stmt) {
        return this.explainTriple(stmt.asTriple());
    }

    public Model explain(Resource s, Property p, RDFNode o) {
        return this.explainTriple(Triple.create((Node)s.asNode(), (Node)p.asNode(), (Node)o.asNode()));
    }

    private Model explainTriple(Triple triple) {
        Graph explanation = this.explain(triple);
        return explanation == null ? null : ModelFactory.createModelForGraph((Graph)explanation);
    }

    public Graph explain(Triple pattern) {
        if (!pattern.equals((Object)INCONCISTENCY_TRIPLE)) {
            if (!pattern.isConcrete()) {
                _logger.warning(() -> "Triple patterns with variables cannot be explained: " + pattern);
                return null;
            }
            if (PelletInfGraph.isSyntaxTriple(pattern)) {
                _logger.warning(() -> "Syntax triples cannot be explained: " + pattern);
                return null;
            }
        }
        this.prepare();
        Graph explanationGraph = Factory.createDefaultGraph();
        _logger.fine(() -> "Explain " + pattern);
        if (PelletInfGraph.checkEntailment(this, pattern, true)) {
            Set explanation = this._kb.getExplanationSet();
            _logger.finer(() -> "Explanation " + PelletInfGraph.formatAxioms(explanation));
            Set<ATermAppl> prunedExplanation = this.pruneExplanation(pattern, explanation);
            _logger.finer(() -> "Pruned " + PelletInfGraph.formatAxioms(prunedExplanation));
            AxiomConverter converter = new AxiomConverter(this._kb, explanationGraph);
            for (ATermAppl axiom : prunedExplanation) {
                converter.convert(axiom);
            }
        }
        _logger.fine(() -> "Explanation " + explanationGraph);
        return explanationGraph;
    }

    private Set<ATermAppl> pruneExplanation(Triple pattern, Set<ATermAppl> explanation) {
        HashSet<ATermAppl> prunedExplanation = new HashSet<ATermAppl>(explanation);
        OntBuilder builder = new OntBuilder(this._kb);
        DefaultGraphLoader loader = new DefaultGraphLoader();
        for (ATermAppl axiom : explanation) {
            prunedExplanation.remove(axiom);
            KnowledgeBase copyKB = builder.build(prunedExplanation);
            PelletInfGraph copyGraph = new PelletInfGraph(copyKB, (PelletReasoner)this.getReasoner(), (GraphLoader)loader);
            if (!PelletInfGraph.checkEntailment(copyGraph, pattern, false)) {
                prunedExplanation.add(axiom);
                continue;
            }
            _logger.finer(() -> "Prune from explanation " + ATermUtils.toString((ATermAppl)axiom));
        }
        return prunedExplanation;
    }

    private static boolean checkEntailment(PelletInfGraph pellet, Triple pattern, boolean withExplanation) {
        boolean doExplanation = pellet.getKB().doExplanation();
        pellet.getKB().setDoExplanation(withExplanation);
        boolean entailed = false;
        entailed = pattern.equals((Object)INCONCISTENCY_TRIPLE) ? !pellet.isConsistent() : pellet.containsTriple(pattern);
        pellet.getKB().setDoExplanation(doExplanation);
        return entailed;
    }

    private static String formatAxioms(Set<ATermAppl> axioms) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (ATermAppl axiom : axioms) {
            sb.append(ATermUtils.toString((ATermAppl)axiom));
            sb.append(",");
        }
        if (axioms.isEmpty()) {
            sb.append(']');
        } else {
            sb.setCharAt(sb.length() - 1, ']');
        }
        return sb.toString();
    }

    protected boolean containsTriple(Triple pattern) {
        this.prepare();
        Node subject = pattern.getSubject();
        Node predicate = pattern.getPredicate();
        Node object = pattern.getObject();
        return GraphQueryHandler.containsTriple(this._kb, this._loader, subject, predicate, object);
    }

    private static boolean isSyntaxTriple(Triple t) {
        BuiltinTerm builtin = BuiltinTerm.find(t.getPredicate());
        if (builtin != null) {
            if (builtin.isSyntax()) {
                return true;
            }
            if (BuiltinTerm.isExpression(builtin) && (t.getSubject().isBlank() || t.getObject().isBlank())) {
                return true;
            }
            if (builtin.equals((Object)BuiltinTerm.RDF_type)) {
                builtin = BuiltinTerm.find(t.getObject());
                return builtin != null && builtin.isSyntax();
            }
        }
        return false;
    }

    private static boolean isBnodeTypeQuery(Triple t) {
        return t.getSubject().isBlank() && t.getPredicate().equals((Object)RDF.type.asNode()) && (BuiltinTerm.find(t.getObject()) == null || t.getObject().equals((Object)OWL.Thing.asNode()) || t.getObject().equals((Object)OWL.Nothing.asNode()));
    }

    public KnowledgeBase getKB() {
        return this._kb;
    }

    public KnowledgeBase getPreparedKB() {
        this.prepare();
        return this.getKB();
    }

    public synchronized void performAdd(Triple t) {
        this.fdata.getGraph().add(t);
        this.setPreparedState(false);
    }

    public void performDelete(Triple t) {
        this.fdata.getGraph().delete(t);
        this.setPreparedState(false);
    }

    public ValidityReport validate() {
        this.checkOpen();
        this.prepare();
        StandardValidityReport report = new StandardValidityReport();
        this._kb.setDoExplanation(true);
        boolean consistent = this._kb.isConsistent();
        this._kb.setDoExplanation(false);
        if (!consistent) {
            report.add(true, "KB is inconsistent!", this._kb.getExplanation());
        } else {
            for (ATermAppl c : this._kb.getUnsatisfiableClasses()) {
                String name = JenaUtils.makeGraphNode(c).toString();
                report.add(false, "Unsatisfiable class", name);
            }
        }
        return report;
    }

    public void clear() {
        if (this._loader.isLoadTBox()) {
            this._kb.clear();
        } else {
            this._kb.clearABox();
        }
        this._loader.clear();
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean recursive) {
        if (this.closed) {
            return;
        }
        if (recursive) {
            super.close();
        } else {
            this.closed = true;
        }
        if (this._deductionsGraph != null) {
            this._deductionsGraph.close();
            this._deductionsGraph = null;
        }
        this.clear();
        this._graphListener.dispose();
        this._kb.clear();
    }

    public GraphLoader getLoader() {
        return this._loader;
    }

    public boolean isAutoDetectChanges() {
        return this._autoDetectChanges;
    }

    public void setAutoDetectChanges(boolean autoDetectChanges) {
        this._autoDetectChanges = autoDetectChanges;
        this._graphListener.setEnabled(autoDetectChanges);
    }

    public boolean isSkipBuiltinPredicates() {
        return this._skipBuiltinPredicates;
    }

    public void setSkipBuiltinPredicates(boolean skipBuiltinPredicates) {
        this._skipBuiltinPredicates = skipBuiltinPredicates;
    }
}

