/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.jena;

import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.core.KnowledgeBase;
import openllet.core.exceptions.UnsupportedQueryException;
import openllet.jena.PelletInfGraph;
import openllet.query.sparqldl.jena.SparqlDLExecution;
import openllet.query.sparqldl.jena.SparqlDLStageGenerator;
import openllet.query.sparqldl.parser.ARQParser;
import openllet.shared.tools.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.Model;

public class SparqlDLExecutionFactory {
    private static final Logger _logger = Log.getLogger(SparqlDLExecutionFactory.class);

    public static QueryExecution create(Query query, Dataset dataset, QuerySolution initialBinding) {
        QueryEngineType engineType = QueryEngineType.ARQ;
        Graph graph = dataset.getDefaultModel().getGraph();
        if (graph instanceof PelletInfGraph) {
            if (dataset.listNames().hasNext() || query.isDescribeType()) {
                engineType = QueryEngineType.MIXED;
            } else {
                PelletInfGraph pelletInfGraph = (PelletInfGraph)graph;
                KnowledgeBase kb = pelletInfGraph.getKB();
                pelletInfGraph.prepare();
                ARQParser parser = new ARQParser();
                parser.setInitialBinding(initialBinding);
                try {
                    parser.parse(query, kb);
                    engineType = QueryEngineType.PELLET;
                }
                catch (UnsupportedQueryException e) {
                    _logger.log(Level.FINER, "", e);
                    engineType = QueryEngineType.MIXED;
                }
            }
        }
        return SparqlDLExecutionFactory.create(query, dataset, initialBinding, engineType);
    }

    public static QueryExecution create(Query query, Dataset dataset, QuerySolution initialBinding, QueryEngineType queryEngineType) {
        return SparqlDLExecutionFactory.create(query, dataset, initialBinding, queryEngineType, true);
    }

    public static QueryExecution create(Query query, Dataset dataset, QuerySolution initialBinding, QueryEngineType queryEngineType, boolean handleVariableSPO) throws QueryException {
        QueryExecution queryExec = null;
        switch (queryEngineType) {
            case PELLET: {
                queryExec = new SparqlDLExecution(query, dataset, handleVariableSPO);
                ((SparqlDLExecution)queryExec).setPurePelletQueryExec(true);
                break;
            }
            case ARQ: {
                queryExec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
                break;
            }
            case MIXED: {
                queryExec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
                queryExec.getContext().set(ARQ.stageGenerator, (Object)new SparqlDLStageGenerator(handleVariableSPO));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (initialBinding != null) {
            queryExec.setInitialBinding(initialBinding);
        }
        return queryExec;
    }

    public static QueryExecution create(Query query, Model model) {
        return SparqlDLExecutionFactory.create(query, model, null);
    }

    public static QueryExecution create(Query query, Dataset dataset) {
        return SparqlDLExecutionFactory.create(query, dataset, null);
    }

    public static QueryExecution create(Query query, Model model, QuerySolution initialBinding) {
        return SparqlDLExecutionFactory.create(query, DatasetFactory.create((Model)model), initialBinding);
    }

    public static QueryExecution createPelletExecution(Query query, Model model) {
        return SparqlDLExecutionFactory.create(query, DatasetFactory.create((Model)model), null, QueryEngineType.PELLET);
    }

    public static QueryExecution createPelletExecution(Query query, Model model, QuerySolution initialBinding) {
        return SparqlDLExecutionFactory.create(query, DatasetFactory.create((Model)model), initialBinding, QueryEngineType.PELLET);
    }

    public static QueryExecution createPelletExecution(Query query, Dataset dataset) {
        return SparqlDLExecutionFactory.create(query, dataset, null, QueryEngineType.PELLET);
    }

    public static QueryExecution createPelletExecution(Query query, Dataset dataset, QuerySolution initialBinding) {
        return SparqlDLExecutionFactory.create(query, dataset, initialBinding, QueryEngineType.PELLET);
    }

    @Deprecated
    public static QueryExecution createBasicExecution(Query query, Model model) {
        return SparqlDLExecutionFactory.createPelletExecution(query, model);
    }

    @Deprecated
    public static QueryExecution createBasicExecution(Query query, Dataset dataset) {
        return SparqlDLExecutionFactory.createPelletExecution(query, dataset);
    }

    public static enum QueryEngineType {
        ARQ,
        MIXED,
        PELLET;

    }
}

