/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.jena;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openllet.aterm.ATermAppl;
import openllet.jena.JenaUtils;
import openllet.query.sparqldl.model.QueryParameters;
import openllet.query.sparqldl.model.QueryResult;
import openllet.query.sparqldl.model.ResultBinding;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingHashMap;
import org.apache.jena.sparql.engine.binding.BindingMap;

public class SparqlDLResultSet
implements ResultSetRewindable {
    private final Model _model;
    private final List<ATermAppl> _resultVars;
    private final List<String> _resultVarsString;
    private final QueryResult _queryResult;
    private int _index;
    private Iterator<ResultBinding> _bindings;
    private final Binding _parent;
    private QueryParameters _parameters;

    public SparqlDLResultSet(QueryResult answers, Model model) {
        this(answers, model, null, null);
    }

    public SparqlDLResultSet(QueryResult answers, Model model, Binding parent) {
        this(answers, model, parent, null);
    }

    public SparqlDLResultSet(QueryResult answers, Model model, QueryParameters parameters) {
        this(answers, model, null, parameters);
    }

    public SparqlDLResultSet(QueryResult answers, Model model, Binding parent, QueryParameters parameters) {
        this._parent = parent;
        this._queryResult = answers;
        this._model = model;
        this._parameters = parameters;
        this._index = 0;
        this._bindings = answers.iterator();
        this._resultVars = new ArrayList<ATermAppl>();
        this._resultVarsString = new ArrayList<String>();
        for (ATermAppl var : this._queryResult.getResultVars()) {
            this._resultVars.add(var);
            this._resultVarsString.add(this.getVarName(var));
        }
        if (parameters == null) {
            this._parameters = new QueryParameters();
        }
    }

    protected String getVarName(ATermAppl term) {
        return ((ATermAppl)term.getArgument(0)).getName();
    }

    public QueryResult getQueryResult() {
        return this._queryResult;
    }

    public boolean hasNext() {
        return this._bindings.hasNext();
    }

    public Binding nextBinding() {
        ++this._index;
        ResultBinding binding = this._bindings.next();
        BindingHashMap result = this._parent == null ? new BindingHashMap() : new BindingHashMap(this._parent);
        for (ATermAppl var : this._resultVars) {
            if (!binding.isBound(var)) continue;
            String varName = this.getVarName(var);
            ATermAppl value = binding.getValue(var);
            if (value == null) continue;
            JenaUtils.makeGraphNode(value).ifPresent(arg_0 -> SparqlDLResultSet.lambda$nextBinding$0((BindingMap)result, varName, arg_0));
        }
        if (this._resultVars.size() == 0) {
            for (Map.Entry entry : this._parameters.entrySet()) {
                ATermAppl term = (ATermAppl)entry.getKey();
                String varName = this.getVarName(term);
                Var var = Var.alloc((String)varName);
                if (result.contains(var)) continue;
                JenaUtils.makeGraphNode((ATermAppl)entry.getValue()).ifPresent(arg_0 -> SparqlDLResultSet.lambda$nextBinding$1((BindingMap)result, var, arg_0));
            }
        }
        return result;
    }

    public QuerySolution nextSolution() {
        return new org.apache.jena.sparql.core.ResultBinding(this._model, this.nextBinding());
    }

    public QuerySolution next() {
        return this.nextSolution();
    }

    public boolean isDistinct() {
        return this._queryResult.isDistinct();
    }

    public boolean isOrdered() {
        return false;
    }

    public int getRowNumber() {
        return this._index;
    }

    public List<String> getResultVars() {
        return Collections.unmodifiableList(this._resultVarsString);
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Remove not supported");
    }

    public String toString() {
        return this._queryResult.toString();
    }

    public void reset() {
        this._index = 0;
        this._bindings = this._queryResult.iterator();
    }

    public int size() {
        return this._queryResult.size();
    }

    public Model getResourceModel() {
        return this._model;
    }

    private static /* synthetic */ void lambda$nextBinding$1(BindingMap result, Var var, Node node) {
        result.add(var, node);
    }

    private static /* synthetic */ void lambda$nextBinding$0(BindingMap result, String varName, Node node) {
        result.add(Var.alloc((String)varName), node);
    }
}

