/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import openllet.atom.OpenError;
import openllet.owlapi.OWLGroup;
import openllet.owlapi.OWLHelper;
import openllet.owlapi.OpenlletReasonerFactory;
import openllet.shared.tools.Log;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.StringDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class OWLGenericTools
implements OWLHelper {
    private static final Logger _logger = Log.getLogger(OWLGenericTools.class);
    protected volatile OWLOntology _ontology;
    protected final OWLGroup _group;
    private volatile Function<OWLOntology, OWLReasoner> _reasonerFactory = OpenlletReasonerFactory.getInstance()::createReasoner;
    protected boolean _isVolatile = true;
    private Optional<OWLReasoner> _reasoner = Optional.empty();

    public Logger getLogger() {
        return _logger;
    }

    @Override
    public OWLOntology getOntology() {
        return this._ontology;
    }

    @Override
    public OWLOntologyManager getManager() {
        return this._ontology.getOWLOntologyManager();
    }

    @Override
    public OWLGroup getGroup() {
        return this._group;
    }

    @Override
    public boolean isVolatile() {
        return this._isVolatile;
    }

    @Override
    public OWLDataFactory getFactory() {
        return this.getManager().getOWLDataFactory();
    }

    @Override
    public OWLReasoner getReasoner() {
        if (!this._reasoner.isPresent()) {
            try {
                OWLReasoner reasoner = this._reasonerFactory.apply(this.getOntology());
                reasoner.isConsistent();
                this._reasoner = Optional.of(reasoner);
            }
            catch (Exception e) {
                Log.error((Logger)_logger, (Throwable)e);
                throw new OpenError((Throwable)e);
            }
        }
        this._reasoner.get().flush();
        return this._reasoner.get();
    }

    public OWLGenericTools setReasonerFactory(Function<OWLOntology, OWLReasoner> reasonerFactory) {
        this._reasonerFactory = reasonerFactory;
        return this;
    }

    public OWLGenericTools(OWLGroup group, OWLOntologyID ontologyID) throws OWLOntologyCreationException {
        OWLOntologyManager manager;
        if (ontologyID.getOntologyIRI().toString().indexOf(32) != -1) {
            throw new OWLOntologyCreationException("Illegal character ' ' in name on [" + ontologyID.getOntologyIRI() + "]");
        }
        if (ontologyID.getVersionIRI() != null && ontologyID.getVersionIRI().toString().indexOf(32) != -1) {
            throw new OWLOntologyCreationException("Illegal character ' ' in version on [" + ontologyID.getVersionIRI() + "]");
        }
        this._group = group;
        if (group.getOntologiesDirectory().isPresent() && group.havePersistentManager()) {
            this._ontology = OWLGroup.getOntology(group.getPersistentManager(), ontologyID).orElse(null);
        }
        if (this._ontology != null) {
            manager = this._ontology.getOWLOntologyManager();
        } else {
            this._ontology = OWLGroup.getOntology(group.getVolatileManager(), ontologyID).orElse(null);
            if (this._ontology != null) {
                manager = this._ontology.getOWLOntologyManager();
            } else {
                manager = group.getOntologiesDirectory().isPresent() ? group.getPersistentManager() : group.getVolatileManager();
                File file = new File(group.ontology2filename(ontologyID));
                if (file.exists()) {
                    try {
                        this._ontology = manager.loadOntologyFromOntologyDocument(file);
                    }
                    catch (Exception e) {
                        _logger.log(Level.INFO, "Ontology " + ontologyID + " couldn't be load", e);
                    }
                }
                if (this._ontology == null) {
                    _logger.log(Level.FINE, "Ontology " + ontologyID + " will be create now");
                    this._ontology = manager.createOntology(ontologyID);
                }
            }
        }
        this._isVolatile = group.haveVolatileManager() && !group.havePersistentManager() ? true : (!group.haveVolatileManager() && group.havePersistentManager() ? false : manager == group.getVolatileManager());
        OWLHelper.setFormat(this._ontology);
    }

    public OWLGenericTools(OWLGroup group, OWLOntologyID ontologyID, boolean isVolatile) throws OWLOntologyCreationException {
        File file;
        if (ontologyID.getOntologyIRI().toString().indexOf(32) != -1) {
            throw new OWLOntologyCreationException("Illegal character ' ' in name on [" + ontologyID.getOntologyIRI() + "]");
        }
        if (ontologyID.getVersionIRI() != null && ontologyID.getVersionIRI().toString().indexOf(32) != -1) {
            throw new OWLOntologyCreationException("Illegal character ' ' in version on [" + ontologyID.getVersionIRI() + "]");
        }
        this._group = group;
        this._isVolatile = isVolatile;
        OWLOntologyManager manager = this._isVolatile ? group.getVolatileManager() : group.getPersistentManager();
        this._ontology = OWLGroup.getOntology(manager, ontologyID).orElse(null);
        if (this._ontology == null && !this._isVolatile && (file = new File(group.ontology2filename(ontologyID))).exists()) {
            try {
                this._ontology = manager.loadOntologyFromOntologyDocument(file);
            }
            catch (Exception e) {
                _logger.log(Level.INFO, "Ontology " + ontologyID + " couldn't be load", e);
            }
        }
        if (this._ontology == null) {
            _logger.log(Level.INFO, () -> "Ontology " + ontologyID + " will be create now");
            this._ontology = manager.createOntology(ontologyID);
        }
        OWLHelper.setFormat(this._ontology);
    }

    public OWLGenericTools(OWLGroup group, IRI ontologyIRI, double version) throws OWLOntologyCreationException {
        this(group, new OWLOntologyID(ontologyIRI, OWLHelper.buildVersion(ontologyIRI, version)));
    }

    public OWLGenericTools(OWLGroup group, IRI ontologyIRI, double version, boolean isVolatile) throws OWLOntologyCreationException {
        this(group, new OWLOntologyID(ontologyIRI, OWLHelper.buildVersion(ontologyIRI, version)), isVolatile);
    }

    public OWLGenericTools(OWLGroup group, IRI ontologyIRI, boolean isVolatile) throws OWLOntologyCreationException {
        this(group, ontologyIRI, 0.0, isVolatile);
    }

    public OWLGenericTools(OWLGroup group, InputStream is) throws OWLOntologyCreationException {
        this._group = group;
        this._ontology = group.getVolatileManager().loadOntologyFromOntologyDocument(is);
        this._isVolatile = true;
        OWLHelper.setFormat(this._ontology);
    }

    public OWLGenericTools(OWLGroup group, OWLOntology ontology, boolean isVolatile) {
        this._group = group;
        this._ontology = ontology;
        this._isVolatile = isVolatile;
        OWLHelper.setFormat(this._ontology);
        group.check(this.getManager());
    }

    public OWLGenericTools(OWLGroup group, OWLOntologyManager manager, OWLOntology ontology) {
        this._group = group;
        this._ontology = ontology;
        this._isVolatile = manager == group.getVolatileManager();
        OWLHelper.setFormat(this._ontology);
        group.check(this.getManager());
    }

    public OWLGenericTools(OWLGroup group, OWLOntologyManager manager, File file) throws OWLOntologyCreationException {
        this._group = group;
        this._ontology = manager.loadOntologyFromOntologyDocument(file);
        this._isVolatile = manager == group.getVolatileManager();
        OWLHelper.setFormat(this._ontology);
        group.check(this.getManager());
    }

    public OWLGenericTools(OWLGroup group, OWLOntology ontology, OWLOntologyManager manager, Map<String, String> namespaces) {
        this._group = group;
        this._ontology = ontology;
        if (!namespaces.isEmpty()) {
            this.getNamespaces().ifPresent(space -> namespaces.forEach((arg_0, arg_1) -> ((PrefixDocumentFormat)space).setPrefix(arg_0, arg_1)));
        }
        this._isVolatile = manager == group.getVolatileManager();
        OWLHelper.setFormat(this._ontology);
        group.check(this.getManager());
    }

    public OWLGenericTools(OWLGroup group, File file) throws Exception {
        this(group, group.getPersistentManager(), file);
    }

    public OWLGenericTools(OWLGroup group, String ontology, boolean isVolatile) throws Exception {
        this._group = group;
        this._ontology = (isVolatile ? this._group.getVolatileManager() : this._group.getPersistentManager()).loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)new StringDocumentSource(ontology));
        this._isVolatile = isVolatile;
        OWLHelper.setFormat(this._ontology);
    }

    public String toString() {
        return this.getOntology().axioms().map(Object::toString).sorted().collect(Collectors.joining("\n"));
    }

    @Override
    public void dispose() {
        this._reasoner.ifPresent(r -> r.dispose());
    }
}

