/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import openllet.aterm.ATermAppl;
import openllet.core.KnowledgeBase;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.utils.SetUtils;
import openllet.owlapi.OWLGroup;
import openllet.owlapi.PelletVisitor;
import openllet.owlapi.facet.FacetManagerOWL;
import openllet.shared.tools.Log;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitor;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SetOntologyID;

public class PelletLoader
implements FacetManagerOWL {
    public static Logger _logger = Log.getLogger(PelletLoader.class);
    private volatile KnowledgeBase _kb;
    private volatile OWLOntologyManager _manager;
    private final Set<OWLOntology> _ontologies = SetUtils.create();
    private volatile boolean _processImports;
    private final Set<OWLOntology> _notImported = SetUtils.create();
    private final Map<OWLOntology, Set<OWLOntology>> _importDependencies = new ConcurrentHashMap<OWLOntology, Set<OWLOntology>>();
    private final PelletVisitor _visitor;
    private final ChangeVisitor _changeVisitor = new ChangeVisitor();

    @Override
    public OWLOntologyManager getManager() {
        return this._manager;
    }

    public void setManager(OWLOntologyManager manager) {
        this._manager = manager;
    }

    @Override
    public OWLGroup getGroup() {
        return OWLGroup.fromVolatileManager(this._manager);
    }

    public PelletLoader(KnowledgeBase kb) {
        this._kb = kb;
        this._visitor = new PelletVisitor(kb);
        this._processImports = true;
    }

    @Deprecated
    public boolean loadImports() {
        return this.getProcessImports();
    }

    @Deprecated
    public void setLoadImports(boolean loadImports) {
        this.setProcessImports(loadImports);
    }

    public boolean getProcessImports() {
        return this._processImports;
    }

    public void setProcessImports(boolean processImports) {
        this._processImports = processImports;
    }

    public void clear() {
        this._visitor.clear();
        this._kb.clear();
        this._ontologies.clear();
        this._notImported.clear();
        this._importDependencies.clear();
    }

    public KnowledgeBase getKB() {
        return this._kb;
    }

    public void setKB(KnowledgeBase kb) {
        this._kb = kb;
    }

    public ATermAppl term(OWLObject d) {
        this._visitor.reset();
        this._visitor.setAddAxiom(false);
        d.accept((OWLObjectVisitor)this._visitor);
        ATermAppl a = this._visitor.result();
        if (a == null) {
            throw new InternalReasonerException("Cannot create ATerm from description " + d);
        }
        return a;
    }

    public void reload() {
        _logger.fine("Reloading the ontologies");
        HashSet<OWLOntology> notImportedOnts = new HashSet<OWLOntology>(this._notImported);
        this.clear();
        this.load(notImportedOnts);
    }

    public void load(Set<OWLOntology> ontologies) {
        Optional timer = this._kb.getTimers().startTimer("load");
        LinkedHashSet<OWLOntology> toBeLoaded = new LinkedHashSet<OWLOntology>();
        for (OWLOntology ontology : ontologies) {
            this.load(ontology, false, toBeLoaded);
        }
        this._visitor.reset();
        this._visitor.setAddAxiom(true);
        for (OWLOntology ontology : toBeLoaded) {
            ontology.accept((OWLObjectVisitor)this._visitor);
        }
        this._visitor.verify();
        timer.ifPresent(t -> t.stop());
    }

    private int load(OWLOntology ontology, boolean imported, Collection<OWLOntology> toBeLoaded) {
        boolean added;
        if (!imported) {
            this._notImported.add(ontology);
        }
        if (!(added = this._ontologies.add(ontology))) {
            return 0;
        }
        int axiomCount = ontology.getAxiomCount();
        toBeLoaded.add(ontology);
        if (this._processImports) {
            for (OWLOntology importedOnt : ontology.imports().collect(Collectors.toList())) {
                axiomCount += this.load(importedOnt, true, toBeLoaded);
                Set<OWLOntology> importees = this._importDependencies.get(importedOnt);
                if (importees == null) {
                    importees = new HashSet<OWLOntology>();
                    this._importDependencies.put(importedOnt, importees);
                }
                importees.add(ontology);
            }
        }
        return axiomCount;
    }

    public Set<OWLAxiom> getUnsupportedAxioms() {
        return this._visitor.getUnsupportedAxioms();
    }

    public void unload(Set<OWLOntology> ontologies) {
        ontologies.forEach(this::unload);
    }

    private void unload(OWLOntology ontology) {
        boolean removed = this._ontologies.remove(ontology);
        if (!removed) {
            return;
        }
        this._notImported.remove(ontology);
        if (this._processImports) {
            ontology.imports().forEach(importOnt -> {
                Set<OWLOntology> importees = this._importDependencies.get(importOnt);
                if (importees != null) {
                    importees.remove(ontology);
                    if (importees.isEmpty()) {
                        this._importDependencies.remove(importOnt);
                        if (!this._notImported.contains(importOnt)) {
                            this.unload((OWLOntology)importOnt);
                        }
                    }
                }
            });
        }
    }

    public Set<OWLOntology> getOntologies() {
        return Collections.unmodifiableSet(this._ontologies);
    }

    public boolean applyChanges(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!this._ontologies.contains(oWLOntologyChange.getOntology()) || this._changeVisitor.process(oWLOntologyChange)) continue;
            _logger.fine(() -> "Reload required by ontology change " + change);
            return false;
        }
        return true;
    }

    private class ChangeVisitor
    implements OWLOntologyChangeVisitor {
        private boolean _reloadRequired;

        private ChangeVisitor() {
        }

        public boolean isReloadRequired() {
            return this._reloadRequired;
        }

        public boolean process(OWLOntologyChange change) {
            this.reset();
            change.accept((OWLOntologyChangeVisitor)this);
            return !this.isReloadRequired();
        }

        public void reset() {
            PelletLoader.this._visitor.reset();
            this._reloadRequired = false;
        }

        public void visit(AddAxiom change) {
            PelletLoader.this._visitor.setAddAxiom(true);
            change.getAxiom().accept((OWLObjectVisitor)PelletLoader.this._visitor);
            this._reloadRequired = PelletLoader.this._visitor.isReloadRequired();
        }

        public void visit(RemoveAxiom change) {
            PelletLoader.this._visitor.setAddAxiom(false);
            change.getAxiom().accept((OWLObjectVisitor)PelletLoader.this._visitor);
            this._reloadRequired = PelletLoader.this._visitor.isReloadRequired();
        }

        public void visit(AddImport change) {
            this._reloadRequired = PelletLoader.this.getProcessImports();
        }

        public void visit(AddOntologyAnnotation change) {
        }

        public void visit(RemoveImport change) {
            this._reloadRequired = PelletLoader.this.getProcessImports();
        }

        public void visit(RemoveOntologyAnnotation change) {
        }

        public void visit(SetOntologyID change) {
        }
    }
}

