/*
 * Decompiled with CFR 0.152.
 */
package openllet.owlapi;

import openllet.core.utils.progress.ProgressMonitor;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;

public class ProgressAdapter
implements ProgressMonitor {
    private final ReasonerProgressMonitor _monitor;
    private int _length;
    private int _progress;
    private String _title;
    private volatile int _echo = 0;

    public int getLastEcho() {
        return this._echo;
    }

    public ProgressAdapter(ReasonerProgressMonitor monitor) {
        this._monitor = monitor;
        this._progress = 0;
        this._length = -1;
        this._title = "<untitled>";
    }

    public int getProgress() {
        return this._progress;
    }

    public int getProgressPercent() {
        return this._length > 0 ? this._progress * 100 / this._length : 0;
    }

    public void incrementProgress() {
        ++this._progress;
        if (this._length > 0) {
            this._monitor.reasonerTaskProgressChanged(this._progress, this._length);
        } else {
            this._monitor.reasonerTaskBusy();
        }
    }

    public boolean isCanceled() {
        return false;
    }

    public void setProgress(int value) {
        this._progress = value;
        if (this._length > 0) {
            this._monitor.reasonerTaskProgressChanged(this._progress, this._length);
        } else {
            this._monitor.reasonerTaskBusy();
        }
    }

    public void setProgressLength(int length) {
        this._length = length;
        if (length > 0) {
            this._monitor.reasonerTaskProgressChanged(this._progress, length);
        } else {
            this._monitor.reasonerTaskBusy();
        }
    }

    public void setProgressMessage(String message) {
    }

    public void setProgressTitle(String title) {
        this._title = title;
    }

    public void taskFinished() {
        this._monitor.reasonerTaskStopped();
    }

    public void taskStarted() {
        this._monitor.reasonerTaskStarted(this._title);
    }
}

