/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.engine;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.SetUtils;
import openllet.query.sparqldl.engine.CombinedQueryEngine;
import openllet.query.sparqldl.engine.QueryEngine;
import openllet.query.sparqldl.engine.QueryExec;
import openllet.query.sparqldl.model.Query;
import openllet.query.sparqldl.model.QueryAtom;
import openllet.query.sparqldl.model.QueryAtomFactory;
import openllet.query.sparqldl.model.QueryImpl;
import openllet.query.sparqldl.model.QueryResult;
import openllet.query.sparqldl.model.QueryResultImpl;
import openllet.query.sparqldl.model.ResultBinding;
import openllet.query.sparqldl.model.ResultBindingImpl;
import openllet.shared.tools.Log;

public abstract class AbstractABoxEngineWrapper
implements QueryExec {
    public static final Logger _logger = Log.getLogger(QueryEngine.class);
    public static final QueryExec distCombinedQueryExec = new CombinedQueryEngine();
    protected Query schemaQuery;
    protected Query aboxQuery;

    @Override
    public QueryResult exec(Query query) {
        QueryResult newResult;
        QueryResult result;
        boolean shouldHaveBinding;
        _logger.fine(() -> "Executing query " + query.getAtoms());
        this.partitionQuery(query);
        if (this.schemaQuery.getAtoms().isEmpty()) {
            shouldHaveBinding = false;
            result = new QueryResultImpl(query);
            result.add(new ResultBindingImpl());
        } else {
            _logger.fine(() -> "Executing TBox query: " + this.schemaQuery);
            result = distCombinedQueryExec.exec(this.schemaQuery);
            boolean bl = shouldHaveBinding = SetUtils.intersects(query.getDistVarsForType(Query.VarType.CLASS), query.getResultVars()) || SetUtils.intersects(query.getDistVarsForType(Query.VarType.PROPERTY), query.getResultVars());
        }
        if (shouldHaveBinding && result.isEmpty()) {
            return result;
        }
        _logger.fine(() -> "Partial _binding after schema query : " + result);
        if (this.aboxQuery.getAtoms().size() > 0) {
            newResult = new QueryResultImpl(query);
            for (ResultBinding binding : result) {
                Query query2 = this.aboxQuery.apply(binding);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Executing ABox query: " + query2);
                }
                QueryResult aboxResult = this.execABoxQuery(query2);
                for (ResultBinding newBinding : aboxResult) {
                    for (ATermAppl var : binding.getAllVariables()) {
                        newBinding.setValue(var, binding.getValue(var));
                    }
                    newResult.add(newBinding);
                }
            }
        } else {
            newResult = result;
            _logger.finer("ABox query empty ... returning.");
        }
        return newResult;
    }

    private final void partitionQuery(Query query) {
        this.schemaQuery = new QueryImpl(query);
        this.aboxQuery = new QueryImpl(query);
        for (QueryAtom atom : query.getAtoms()) {
            switch (atom.getPredicate()) {
                case Type: 
                case PropertyValue: {
                    this.aboxQuery.add(atom);
                    break;
                }
            }
        }
        ArrayList<QueryAtom> atoms = new ArrayList<QueryAtom>(query.getAtoms());
        atoms.removeAll(this.aboxQuery.getAtoms());
        for (QueryAtom atom : atoms) {
            this.schemaQuery.add(atom);
        }
        for (Query.VarType t : Query.VarType.values()) {
            for (ATermAppl a : query.getDistVarsForType(t)) {
                if (this.aboxQuery.getVars().contains(a)) {
                    this.aboxQuery.addDistVar(a, t);
                }
                if (!this.schemaQuery.getVars().contains(a)) continue;
                this.schemaQuery.addDistVar(a, t);
            }
        }
        for (ATermAppl a : query.getResultVars()) {
            if (this.aboxQuery.getVars().contains(a)) {
                this.aboxQuery.addResultVar(a);
            }
            if (!this.schemaQuery.getVars().contains(a)) continue;
            this.schemaQuery.addResultVar(a);
        }
        for (ATermAppl v : this.aboxQuery.getDistVarsForType(Query.VarType.CLASS)) {
            if (this.schemaQuery.getVars().contains(v)) continue;
            this.schemaQuery.add(QueryAtomFactory.SubClassOfAtom(v, ATermUtils.TOP));
        }
        for (ATermAppl v : this.aboxQuery.getDistVarsForType(Query.VarType.PROPERTY)) {
            if (this.schemaQuery.getVars().contains(v)) continue;
            this.schemaQuery.add(QueryAtomFactory.SubPropertyOfAtom(v, v));
        }
    }

    protected abstract QueryResult execABoxQuery(Query var1);
}

