/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import openllet.aterm.ATermAppl;
import openllet.core.KnowledgeBase;
import openllet.core.utils.ATermUtils;
import openllet.query.sparqldl.model.Query;
import openllet.query.sparqldl.model.QueryAtom;
import openllet.query.sparqldl.model.QueryPredicate;
import openllet.query.sparqldl.model.ResultBinding;

class LiteralIterator
implements Iterator<ResultBinding> {
    private final int[] _indices;
    private final ResultBinding _binding;
    private final Set<ATermAppl> _litVars;
    private final List<List<ATermAppl>> _litVarBindings = new ArrayList<List<ATermAppl>>();
    private boolean _more = true;

    public LiteralIterator(Query q, ResultBinding binding) {
        KnowledgeBase kb = q.getKB();
        this._binding = binding;
        this._litVars = q.getDistVarsForType(Query.VarType.LITERAL);
        this._indices = new int[this._litVars.size()];
        int index = 0;
        for (ATermAppl litVar : this._litVars) {
            ArrayList foundLiterals = new ArrayList();
            boolean first = true;
            for (QueryAtom atom : q.findAtoms(QueryPredicate.PropertyValue, null, null, litVar)) {
                ATermAppl subject = atom.getArguments().get(0);
                ATermAppl predicate = atom.getArguments().get(1);
                if (ATermUtils.isVar((ATermAppl)subject)) {
                    subject = binding.getValue(subject);
                }
                this._litVarBindings.add(index, new ArrayList());
                List act = kb.getDataPropertyValues(predicate, subject);
                if (first) {
                    foundLiterals.addAll(act);
                    continue;
                }
                foundLiterals.retainAll(act);
                first = false;
            }
            if (foundLiterals.size() > 0) {
                this._litVarBindings.get(index++).addAll(foundLiterals);
                continue;
            }
            this._more = false;
        }
    }

    private boolean incIndex(int index) {
        if (this._indices[index] + 1 >= this._litVarBindings.get(index).size()) {
            if (index == this._indices.length - 1) {
                return false;
            }
            this._indices[index] = 0;
            return this.incIndex(index + 1);
        }
        int n = index;
        this._indices[n] = this._indices[n] + 1;
        return true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removal from this iterator is not supported.");
    }

    @Override
    public boolean hasNext() {
        return this._more;
    }

    @Override
    public ResultBinding next() {
        if (!this._more) {
            return null;
        }
        ResultBinding next = this._binding.duplicate();
        int index = 0;
        for (ATermAppl o1 : this._litVars) {
            ATermAppl o2 = this._litVarBindings.get(index).get(this._indices[index++]);
            next.setValue(o1, o2);
        }
        this._more = this.incIndex(0);
        return next;
    }
}

