/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.core.KnowledgeBase;
import openllet.query.sparqldl.engine.AbstractABoxEngineWrapper;
import openllet.query.sparqldl.engine.LiteralIterator;
import openllet.query.sparqldl.engine.QueryEngine;
import openllet.query.sparqldl.model.Query;
import openllet.query.sparqldl.model.QueryResult;
import openllet.query.sparqldl.model.QueryResultImpl;
import openllet.query.sparqldl.model.ResultBinding;
import openllet.query.sparqldl.model.ResultBindingImpl;
import openllet.shared.tools.Log;

public class OptimizedQueryEngine3
extends AbstractABoxEngineWrapper {
    public static final Logger _logger = Log.getLogger(QueryEngine.class);

    @Override
    public boolean supports(Query q) {
        return true;
    }

    @Override
    public QueryResult execABoxQuery(Query q) {
        QueryResultImpl results = new QueryResultImpl(q);
        KnowledgeBase kb = q.getKB();
        long satCount = kb.getABox().getStats()._satisfiabilityCount;
        long consCount = kb.getABox().getStats()._consistencyCount;
        if (q.getDistVars().isEmpty()) {
            if (QueryEngine.execBooleanABoxQuery(q)) {
                results.add(new ResultBindingImpl());
            }
        } else {
            boolean hasLiterals;
            HashMap<ATermAppl, Set> varBindings = new HashMap<ATermAppl, Set>();
            for (ATermAppl currVar : q.getDistVarsForType(Query.VarType.INDIVIDUAL)) {
                ATermAppl rolledUpClass = q.rollUpTo(currVar, Collections.emptySet(), false);
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.finer("Rolled up class " + rolledUpClass);
                }
                varBindings.put(currVar, kb.getInstances(rolledUpClass));
            }
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("Var bindings: " + varBindings);
            }
            ArrayList varList = new ArrayList(varBindings.keySet());
            HashMap goodLists = new HashMap();
            ATermAppl first = (ATermAppl)varList.get(0);
            HashSet<ResultBindingImpl> c = new HashSet<ResultBindingImpl>();
            for (ATermAppl a : (Set)varBindings.get(first)) {
                ResultBindingImpl bind = new ResultBindingImpl();
                bind.setValue(first, a);
                c.add(bind);
            }
            goodLists.put(first, c);
            HashSet<ResultBinding> previous = (HashSet<ResultBinding>)goodLists.get(first);
            for (int i = 1; i < varList.size(); ++i) {
                ATermAppl next = (ATermAppl)varList.get(i);
                HashSet<ResultBinding> newBindings = new HashSet<ResultBinding>();
                for (ResultBinding binding : previous) {
                    for (ATermAppl testBind : (Set)varBindings.get(next)) {
                        ResultBinding bindingCandidate = binding.duplicate();
                        bindingCandidate.setValue(next, testBind);
                        boolean queryTrue = QueryEngine.execBooleanABoxQuery(q.apply(bindingCandidate));
                        if (queryTrue) {
                            newBindings.add(bindingCandidate);
                            if (!_logger.isLoggable(Level.FINER)) continue;
                            _logger.finer("Accepted binding: " + bindingCandidate);
                            continue;
                        }
                        if (!_logger.isLoggable(Level.FINER)) continue;
                        _logger.finer("Rejected binding: " + bindingCandidate);
                    }
                }
                previous = newBindings;
            }
            boolean bl = hasLiterals = !q.getDistVarsForType(Query.VarType.LITERAL).isEmpty();
            if (hasLiterals) {
                for (ResultBinding b : previous) {
                    LiteralIterator i = new LiteralIterator(q, b);
                    while (i.hasNext()) {
                        results.add((ResultBinding)i.next());
                    }
                }
            } else {
                for (ResultBinding b : previous) {
                    results.add(b);
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Results: " + results);
                _logger.fine("Total satisfiability operations: " + (kb.getABox().getStats()._satisfiabilityCount - satCount));
                _logger.fine("Total consistency operations: " + (kb.getABox().getStats()._consistencyCount - consCount));
            }
        }
        return results;
    }
}

