/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.engine;

import java.util.logging.Logger;
import openllet.core.OpenlletOptions;
import openllet.query.sparqldl.engine.CostBasedQueryPlanNew;
import openllet.query.sparqldl.engine.IncrementalQueryPlan;
import openllet.query.sparqldl.engine.NoReorderingQueryPlan;
import openllet.query.sparqldl.engine.QueryPlan;
import openllet.query.sparqldl.model.Query;
import openllet.shared.tools.Log;

public class QueryOptimizer {
    private static final Logger _logger = Log.getLogger(QueryOptimizer.class);

    public QueryPlan getExecutionPlan(Query query) {
        if (OpenlletOptions.SAMPLING_RATIO == 0.0) {
            return new NoReorderingQueryPlan(query);
        }
        if (query.getAtoms().size() > OpenlletOptions.STATIC_REORDERING_LIMIT) {
            _logger.fine("Using incremental query plan.");
            return new IncrementalQueryPlan(query);
        }
        _logger.fine("Using full query plan.");
        return new CostBasedQueryPlanNew(query);
    }
}

