/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.engine;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.core.KnowledgeBase;
import openllet.core.boxes.abox.ABoxStats;
import openllet.query.sparqldl.engine.AbstractABoxEngineWrapper;
import openllet.query.sparqldl.engine.BindingIterator;
import openllet.query.sparqldl.engine.LiteralIterator;
import openllet.query.sparqldl.engine.QueryEngine;
import openllet.query.sparqldl.model.Query;
import openllet.query.sparqldl.model.QueryResult;
import openllet.query.sparqldl.model.QueryResultImpl;
import openllet.query.sparqldl.model.ResultBinding;
import openllet.query.sparqldl.model.ResultBindingImpl;
import openllet.shared.tools.Log;

public class SimpleQueryEngine
extends AbstractABoxEngineWrapper {
    public static final Logger _logger = Log.getLogger(QueryEngine.class);

    @Override
    public boolean supports(Query q) {
        return true;
    }

    @Override
    public QueryResult execABoxQuery(Query q) {
        QueryResultImpl results = new QueryResultImpl(q);
        KnowledgeBase kb = q.getKB();
        ABoxStats stats = kb.getABox().getStats();
        long satCount = stats._satisfiabilityCount;
        long consCount = stats._consistencyCount;
        if (q.getDistVars().isEmpty()) {
            if (QueryEngine.execBooleanABoxQuery(q)) {
                results.add(new ResultBindingImpl());
            }
        } else {
            boolean hasLiterals;
            HashMap<ATermAppl, Set<ATermAppl>> varBindings = new HashMap<ATermAppl, Set<ATermAppl>>();
            for (ATermAppl currVar : q.getDistVarsForType(Query.VarType.INDIVIDUAL)) {
                ATermAppl rolledUpClass = q.rollUpTo(currVar, Collections.emptySet(), false);
                _logger.finer(() -> "Rolled up class " + rolledUpClass);
                Set inst = kb.getInstances(rolledUpClass);
                varBindings.put(currVar, inst);
            }
            _logger.finer(() -> "Var bindings: " + varBindings);
            BindingIterator i = new BindingIterator(varBindings);
            Set<ATermAppl> literalVars = q.getDistVarsForType(Query.VarType.LITERAL);
            Set<ATermAppl> individualVars = q.getDistVarsForType(Query.VarType.INDIVIDUAL);
            boolean bl = hasLiterals = !individualVars.containsAll(literalVars);
            if (hasLiterals) {
                while (i.hasNext()) {
                    ResultBinding b = (ResultBinding)i.next();
                    LiteralIterator l = new LiteralIterator(q, b);
                    while (l.hasNext()) {
                        ResultBinding mappy = (ResultBinding)l.next();
                        boolean queryTrue = QueryEngine.execBooleanABoxQuery(q.apply(mappy));
                        if (!queryTrue) continue;
                        results.add(mappy);
                    }
                }
            } else {
                while (i.hasNext()) {
                    ResultBinding b = (ResultBinding)i.next();
                    boolean queryTrue = q.getDistVarsForType(Query.VarType.INDIVIDUAL).size() == 1 || QueryEngine.execBooleanABoxQuery(q.apply(b));
                    if (!queryTrue) continue;
                    results.add(b);
                }
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Results: " + results);
            _logger.fine("Total satisfiability operations: " + (kb.getABox().getStats()._satisfiabilityCount - satCount));
            _logger.fine("Total consistency operations: " + (kb.getABox().getStats()._consistencyCount - consCount));
        }
        return results;
    }
}

