/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.model;

import openllet.atom.OpenError;
import openllet.query.sparqldl.model.Filter;
import openllet.query.sparqldl.model.ResultBinding;

public class MultiFilterWrapper
implements Filter {
    private final FilterType _type;
    private final Filter[] _filters;

    private MultiFilterWrapper(FilterType m, Filter ... filters) {
        this._type = m;
        this._filters = filters;
    }

    @Override
    public boolean accept(ResultBinding binding) {
        switch (this._type) {
            case AND: {
                for (Filter f : this._filters) {
                    if (f.accept(binding)) continue;
                    return false;
                }
                return true;
            }
            case OR: {
                for (Filter f : this._filters) {
                    if (!f.accept(binding)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new OpenError("Filter _type not supported : " + this._type);
    }

    public static Filter and(Filter ... filters) {
        return new MultiFilterWrapper(FilterType.AND, filters);
    }

    public static Filter or(Filter ... filters) {
        return new MultiFilterWrapper(FilterType.OR, filters);
    }

    private static enum FilterType {
        AND,
        OR;

    }
}

