/*
 * Decompiled with CFR 0.152.
 */
package openllet.query.sparqldl.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import openllet.aterm.ATermAppl;
import openllet.query.sparqldl.model.QueryAtom;
import openllet.query.sparqldl.model.QueryPredicate;
import openllet.query.sparqldl.model.ResultBinding;

public class NotKnownQueryAtom
implements QueryAtom {
    private final List<QueryAtom> _atoms;
    private boolean _isGround;
    private final List<ATermAppl> _args;

    public NotKnownQueryAtom(QueryAtom atom) {
        this(Collections.singletonList(atom));
    }

    public NotKnownQueryAtom(List<QueryAtom> atoms) {
        this._atoms = Collections.unmodifiableList(atoms);
        this._isGround = true;
        this._args = new ArrayList<ATermAppl>();
        for (QueryAtom atom : atoms) {
            this._args.addAll(atom.getArguments());
            if (!this._isGround || atom.isGround()) continue;
            this._isGround = false;
        }
    }

    @Override
    public QueryAtom apply(ResultBinding binding) {
        ArrayList<QueryAtom> newAtoms;
        if (this._atoms.size() == 1) {
            newAtoms = Collections.singletonList(this._atoms.get(0).apply(binding));
        } else {
            newAtoms = new ArrayList();
            for (QueryAtom atom : this._atoms) {
                newAtoms.add(atom.apply(binding));
            }
        }
        return new NotKnownQueryAtom(newAtoms);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NotKnownQueryAtom)) {
            return false;
        }
        return this._atoms.equals(((NotKnownQueryAtom)obj)._atoms);
    }

    @Override
    public List<ATermAppl> getArguments() {
        return this._args;
    }

    public List<QueryAtom> getAtoms() {
        return this._atoms;
    }

    @Override
    public QueryPredicate getPredicate() {
        return QueryPredicate.NotKnown;
    }

    public int hashCode() {
        return 17 * this._atoms.hashCode();
    }

    @Override
    public boolean isGround() {
        return this._isGround;
    }

    public String toString() {
        return "NotKnown" + this._atoms;
    }
}

