/*
 * Decompiled with CFR 0.152.
 */
package fr.ganfra.materialspinner;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Typeface;
import android.os.Build;
import android.support.v7.widget.AppCompatSpinner;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import fr.ganfra.materialspinner.R;

public class MaterialSpinner
extends AppCompatSpinner
implements ValueAnimator.AnimatorUpdateListener {
    public static final int DEFAULT_ARROW_WIDTH_DP = 12;
    private static final String TAG = MaterialSpinner.class.getSimpleName();
    private Paint paint;
    private TextPaint textPaint;
    private StaticLayout staticLayout;
    private Path selectorPath;
    private Point[] selectorPoints;
    private int innerPaddingLeft;
    private int innerPaddingRight;
    private int innerPaddingTop;
    private int innerPaddingBottom;
    private int extraPaddingTop;
    private int extraPaddingBottom;
    private int underlineTopSpacing;
    private int underlineBottomSpacing;
    private int errorLabelSpacing;
    private int floatingLabelTopSpacing;
    private int floatingLabelBottomSpacing;
    private int floatingLabelInsideSpacing;
    private int rightLeftSpinnerPadding;
    private int minContentHeight;
    private int lastPosition;
    private ObjectAnimator errorLabelAnimator;
    private int errorLabelPosX;
    private int minNbErrorLines;
    private float currentNbErrorLines;
    private float floatingLabelPercent;
    private ObjectAnimator floatingLabelAnimator;
    private boolean isSelected;
    private boolean floatingLabelVisible;
    private int baseAlpha;
    private int baseColor;
    private int highlightColor;
    private int errorColor;
    private int disabledColor;
    private CharSequence error;
    private CharSequence hint;
    private int hintColor;
    private float hintTextSize;
    private CharSequence floatingLabelText;
    private int floatingLabelColor;
    private boolean multiline;
    private Typeface typeface;
    private boolean alignLabels;
    private float thickness;
    private float thicknessError;
    private int arrowColor;
    private float arrowSize;
    private boolean enableErrorLabel;
    private boolean enableFloatingLabel;
    private boolean alwaysShowFloatingLabel;
    private boolean isRtl;
    private HintAdapter hintAdapter;
    private Integer mDropDownHintView;
    private Integer mHintView;

    public MaterialSpinner(Context context) {
        super(context);
        this.init(context, null);
    }

    public MaterialSpinner(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MaterialSpinner(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.initAttributes(context, attrs);
        this.initPaintObjects();
        this.initDimensions();
        this.initPadding();
        this.initFloatingLabelAnimator();
        this.initOnItemSelectedListener();
        this.setMinimumHeight(this.getPaddingTop() + this.getPaddingBottom() + this.minContentHeight);
        this.setBackgroundResource(R.drawable.my_background);
    }

    private void initAttributes(Context context, AttributeSet attrs) {
        TypedArray defaultArray = context.obtainStyledAttributes(new int[]{R.attr.colorControlNormal, R.attr.colorAccent});
        int defaultBaseColor = defaultArray.getColor(0, 0);
        int defaultHighlightColor = defaultArray.getColor(1, 0);
        int defaultErrorColor = context.getResources().getColor(R.color.error_color);
        defaultArray.recycle();
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.MaterialSpinner);
        this.baseColor = array.getColor(R.styleable.MaterialSpinner_ms_baseColor, defaultBaseColor);
        this.highlightColor = array.getColor(R.styleable.MaterialSpinner_ms_highlightColor, defaultHighlightColor);
        this.errorColor = array.getColor(R.styleable.MaterialSpinner_ms_errorColor, defaultErrorColor);
        this.disabledColor = context.getResources().getColor(R.color.disabled_color);
        this.error = array.getString(R.styleable.MaterialSpinner_ms_error);
        this.hint = array.getString(R.styleable.MaterialSpinner_ms_hint);
        this.hintColor = array.getColor(R.styleable.MaterialSpinner_ms_hintColor, this.baseColor);
        this.hintTextSize = array.getDimension(R.styleable.MaterialSpinner_ms_hintTextSize, -1.0f);
        this.floatingLabelText = array.getString(R.styleable.MaterialSpinner_ms_floatingLabelText);
        this.floatingLabelColor = array.getColor(R.styleable.MaterialSpinner_ms_floatingLabelColor, this.baseColor);
        this.multiline = array.getBoolean(R.styleable.MaterialSpinner_ms_multiline, true);
        this.minNbErrorLines = array.getInt(R.styleable.MaterialSpinner_ms_nbErrorLines, 1);
        this.alignLabels = array.getBoolean(R.styleable.MaterialSpinner_ms_alignLabels, true);
        this.thickness = array.getDimension(R.styleable.MaterialSpinner_ms_thickness, 1.0f);
        this.thicknessError = array.getDimension(R.styleable.MaterialSpinner_ms_thickness_error, 2.0f);
        this.arrowColor = array.getColor(R.styleable.MaterialSpinner_ms_arrowColor, this.baseColor);
        this.arrowSize = array.getDimension(R.styleable.MaterialSpinner_ms_arrowSize, (float)this.dpToPx(12.0f));
        this.enableErrorLabel = array.getBoolean(R.styleable.MaterialSpinner_ms_enableErrorLabel, true);
        this.enableFloatingLabel = array.getBoolean(R.styleable.MaterialSpinner_ms_enableFloatingLabel, true);
        this.alwaysShowFloatingLabel = array.getBoolean(R.styleable.MaterialSpinner_ms_alwaysShowFloatingLabel, false);
        this.isRtl = array.getBoolean(R.styleable.MaterialSpinner_ms_isRtl, false);
        this.mHintView = array.getResourceId(R.styleable.MaterialSpinner_ms_hintView, 17367048);
        this.mDropDownHintView = array.getResourceId(R.styleable.MaterialSpinner_ms_dropDownHintView, 0x1090009);
        String typefacePath = array.getString(R.styleable.MaterialSpinner_ms_typeface);
        if (typefacePath != null) {
            this.typeface = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)typefacePath);
        }
        array.recycle();
        this.floatingLabelPercent = 0.0f;
        this.errorLabelPosX = 0;
        this.isSelected = false;
        this.floatingLabelVisible = false;
        this.lastPosition = -1;
        this.currentNbErrorLines = this.minNbErrorLines;
    }

    public void setSelection(final int position) {
        this.post(new Runnable(){

            @Override
            public void run() {
                MaterialSpinner.super.setSelection(position);
            }
        });
    }

    private void initPaintObjects() {
        int labelTextSize = this.getResources().getDimensionPixelSize(R.dimen.label_text_size);
        this.paint = new Paint(1);
        this.textPaint = new TextPaint(1);
        this.textPaint.setTextSize((float)labelTextSize);
        if (this.typeface != null) {
            this.textPaint.setTypeface(this.typeface);
        }
        this.textPaint.setColor(this.baseColor);
        this.baseAlpha = this.textPaint.getAlpha();
        this.selectorPath = new Path();
        this.selectorPath.setFillType(Path.FillType.EVEN_ODD);
        this.selectorPoints = new Point[3];
        for (int i = 0; i < 3; ++i) {
            this.selectorPoints[i] = new Point();
        }
    }

    public int getSelectedItemPosition() {
        return super.getSelectedItemPosition();
    }

    public Object getSelectedItem() {
        return super.getItemAtPosition(this.getSelectedItemPosition() - 1);
    }

    private void initPadding() {
        this.innerPaddingTop = this.getPaddingTop();
        this.innerPaddingLeft = this.getPaddingLeft();
        this.innerPaddingRight = this.getPaddingRight();
        this.innerPaddingBottom = this.getPaddingBottom();
        this.extraPaddingTop = this.enableFloatingLabel ? this.floatingLabelTopSpacing + this.floatingLabelInsideSpacing + this.floatingLabelBottomSpacing : this.floatingLabelBottomSpacing;
        this.updateBottomPadding();
    }

    private void updateBottomPadding() {
        Paint.FontMetrics textMetrics = this.textPaint.getFontMetrics();
        this.extraPaddingBottom = this.underlineTopSpacing + this.underlineBottomSpacing;
        if (this.enableErrorLabel) {
            this.extraPaddingBottom += (int)((textMetrics.descent - textMetrics.ascent) * this.currentNbErrorLines);
        }
        this.updatePadding();
    }

    private void initDimensions() {
        this.underlineTopSpacing = this.getResources().getDimensionPixelSize(R.dimen.underline_top_spacing);
        this.underlineBottomSpacing = this.getResources().getDimensionPixelSize(R.dimen.underline_bottom_spacing);
        this.floatingLabelTopSpacing = this.getResources().getDimensionPixelSize(R.dimen.floating_label_top_spacing);
        this.floatingLabelBottomSpacing = this.getResources().getDimensionPixelSize(R.dimen.floating_label_bottom_spacing);
        this.rightLeftSpinnerPadding = this.alignLabels ? this.getResources().getDimensionPixelSize(R.dimen.right_left_spinner_padding) : 0;
        this.floatingLabelInsideSpacing = this.getResources().getDimensionPixelSize(R.dimen.floating_label_inside_spacing);
        this.errorLabelSpacing = (int)this.getResources().getDimension(R.dimen.error_label_spacing);
        this.minContentHeight = (int)this.getResources().getDimension(R.dimen.min_content_height);
    }

    private void initOnItemSelectedListener() {
        this.setOnItemSelectedListener(null);
    }

    private void initFloatingLabelAnimator() {
        if (this.floatingLabelAnimator == null) {
            this.floatingLabelAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"floatingLabelPercent", (float[])new float[]{0.0f, 1.0f});
            this.floatingLabelAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        }
    }

    public void showFloatingLabel() {
        if (this.floatingLabelAnimator != null) {
            this.floatingLabelVisible = true;
            if (this.floatingLabelAnimator.isRunning()) {
                this.floatingLabelAnimator.reverse();
            } else {
                this.floatingLabelAnimator.start();
            }
        }
    }

    public void hideFloatingLabel() {
        if (this.floatingLabelAnimator != null) {
            this.floatingLabelVisible = false;
            this.floatingLabelAnimator.reverse();
        }
    }

    private void startErrorScrollingAnimator() {
        int textWidth = Math.round(this.textPaint.measureText(this.error.toString()));
        if (this.errorLabelAnimator == null) {
            this.errorLabelAnimator = ObjectAnimator.ofInt((Object)((Object)this), (String)"errorLabelPosX", (int[])new int[]{0, textWidth + this.getWidth() / 2});
            this.errorLabelAnimator.setStartDelay(1000L);
            this.errorLabelAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.errorLabelAnimator.setDuration((long)(150 * this.error.length()));
            this.errorLabelAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
            this.errorLabelAnimator.setRepeatCount(-1);
        } else {
            this.errorLabelAnimator.setIntValues(new int[]{0, textWidth + this.getWidth() / 2});
        }
        this.errorLabelAnimator.start();
    }

    private void startErrorMultilineAnimator(float destLines) {
        if (this.errorLabelAnimator == null) {
            this.errorLabelAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"currentNbErrorLines", (float[])new float[]{destLines});
        } else {
            this.errorLabelAnimator.setFloatValues(new float[]{destLines});
        }
        this.errorLabelAnimator.start();
    }

    private int dpToPx(float dp) {
        DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
        float px = TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)displayMetrics);
        return Math.round(px);
    }

    private float pxToDp(float px) {
        DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
        return px * displayMetrics.density;
    }

    private void updatePadding() {
        int left = this.innerPaddingLeft;
        int top = this.innerPaddingTop + this.extraPaddingTop;
        int right = this.innerPaddingRight;
        int bottom = this.innerPaddingBottom + this.extraPaddingBottom;
        super.setPadding(left, top, right, bottom);
        this.setMinimumHeight(top + bottom + this.minContentHeight);
    }

    private boolean needScrollingAnimation() {
        if (this.error != null) {
            float screenWidth = this.getWidth() - this.rightLeftSpinnerPadding;
            float errorTextWidth = this.textPaint.measureText(this.error.toString(), 0, this.error.length());
            return errorTextWidth > screenWidth;
        }
        return false;
    }

    private int prepareBottomPadding() {
        int targetNbLines = this.minNbErrorLines;
        if (this.error != null) {
            this.staticLayout = new StaticLayout(this.error, this.textPaint, this.getWidth() - this.getPaddingRight() - this.getPaddingLeft(), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
            int nbErrorLines = this.staticLayout.getLineCount();
            targetNbLines = Math.max(this.minNbErrorLines, nbErrorLines);
        }
        return targetNbLines;
    }

    private boolean isSpinnerEmpty() {
        return this.hintAdapter.getCount() == 0 && this.hint == null || this.hintAdapter.getCount() == 1 && this.hint != null;
    }

    protected void onDraw(Canvas canvas) {
        int lineHeight;
        super.onDraw(canvas);
        int startX = 0;
        int endX = this.getWidth();
        int startYLine = this.getHeight() - this.getPaddingBottom() + this.underlineTopSpacing;
        int startYFloatingLabel = (int)((float)this.getPaddingTop() - this.floatingLabelPercent * (float)this.floatingLabelBottomSpacing);
        if (this.error != null && this.enableErrorLabel) {
            lineHeight = this.dpToPx(this.thicknessError);
            int startYErrorLabel = startYLine + this.errorLabelSpacing + lineHeight;
            this.paint.setColor(this.errorColor);
            this.textPaint.setColor(this.errorColor);
            if (this.multiline) {
                canvas.save();
                canvas.translate((float)(startX + this.rightLeftSpinnerPadding), (float)(startYErrorLabel - this.errorLabelSpacing));
                this.staticLayout.draw(canvas);
                canvas.restore();
            } else {
                canvas.drawText(this.error.toString(), (float)(startX + this.rightLeftSpinnerPadding - this.errorLabelPosX), (float)startYErrorLabel, (Paint)this.textPaint);
                if (this.errorLabelPosX > 0) {
                    canvas.save();
                    canvas.translate(this.textPaint.measureText(this.error.toString()) + (float)(this.getWidth() / 2), 0.0f);
                    canvas.drawText(this.error.toString(), (float)(startX + this.rightLeftSpinnerPadding - this.errorLabelPosX), (float)startYErrorLabel, (Paint)this.textPaint);
                    canvas.restore();
                }
            }
        } else {
            lineHeight = this.dpToPx(this.thickness);
            if (this.isSelected || this.hasFocus()) {
                this.paint.setColor(this.highlightColor);
            } else {
                this.paint.setColor(this.isEnabled() ? this.baseColor : this.disabledColor);
            }
        }
        canvas.drawRect((float)startX, (float)startYLine, (float)endX, (float)(startYLine + lineHeight), this.paint);
        if ((this.hint != null || this.floatingLabelText != null) && this.enableFloatingLabel) {
            String textToDraw;
            if (this.isSelected || this.hasFocus()) {
                this.textPaint.setColor(this.highlightColor);
            } else {
                this.textPaint.setColor(this.isEnabled() ? this.floatingLabelColor : this.disabledColor);
            }
            if (this.floatingLabelAnimator.isRunning() || !this.floatingLabelVisible) {
                this.textPaint.setAlpha((int)((0.8 * (double)this.floatingLabelPercent + 0.2) * (double)this.baseAlpha * (double)this.floatingLabelPercent));
            }
            String string = textToDraw = this.floatingLabelText != null ? this.floatingLabelText.toString() : this.hint.toString();
            if (this.isRtl) {
                canvas.drawText(textToDraw, (float)(this.getWidth() - this.rightLeftSpinnerPadding) - this.textPaint.measureText(textToDraw), (float)startYFloatingLabel, (Paint)this.textPaint);
            } else {
                canvas.drawText(textToDraw, (float)(startX + this.rightLeftSpinnerPadding), (float)startYFloatingLabel, (Paint)this.textPaint);
            }
        }
        this.drawSelector(canvas, this.getWidth() - this.rightLeftSpinnerPadding, this.getPaddingTop() + this.dpToPx(8.0f));
    }

    private void drawSelector(Canvas canvas, int posX, int posY) {
        if (this.isSelected || this.hasFocus()) {
            this.paint.setColor(this.highlightColor);
        } else {
            this.paint.setColor(this.isEnabled() ? this.arrowColor : this.disabledColor);
        }
        Point point1 = this.selectorPoints[0];
        Point point2 = this.selectorPoints[1];
        Point point3 = this.selectorPoints[2];
        point1.set(posX, posY);
        point2.set((int)((float)posX - this.arrowSize), posY);
        point3.set((int)((float)posX - this.arrowSize / 2.0f), (int)((float)posY + this.arrowSize / 2.0f));
        this.selectorPath.reset();
        this.selectorPath.moveTo((float)point1.x, (float)point1.y);
        this.selectorPath.lineTo((float)point2.x, (float)point2.y);
        this.selectorPath.lineTo((float)point3.x, (float)point3.y);
        this.selectorPath.close();
        canvas.drawPath(this.selectorPath, this.paint);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isEnabled()) {
            switch (event.getAction()) {
                case 0: {
                    this.isSelected = true;
                    break;
                }
                case 1: 
                case 3: {
                    this.isSelected = false;
                }
            }
            this.invalidate();
        }
        return super.onTouchEvent(event);
    }

    public void setOnItemSelectedListener(final AdapterView.OnItemSelectedListener listener) {
        AdapterView.OnItemSelectedListener onItemSelectedListener = new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                if (MaterialSpinner.this.hint != null || MaterialSpinner.this.floatingLabelText != null) {
                    if (!MaterialSpinner.this.floatingLabelVisible && position != 0) {
                        MaterialSpinner.this.showFloatingLabel();
                    } else if (MaterialSpinner.this.floatingLabelVisible && position == 0 && !MaterialSpinner.this.alwaysShowFloatingLabel) {
                        MaterialSpinner.this.hideFloatingLabel();
                    }
                }
                if (position != MaterialSpinner.this.lastPosition && MaterialSpinner.this.error != null) {
                    MaterialSpinner.this.setError(null);
                }
                MaterialSpinner.this.lastPosition = position;
                if (listener != null) {
                    position = MaterialSpinner.this.hint != null ? position - 1 : position;
                    listener.onItemSelected(parent, view, position, id);
                }
            }

            public void onNothingSelected(AdapterView<?> parent) {
                if (listener != null) {
                    listener.onNothingSelected(parent);
                }
            }
        };
        super.setOnItemSelectedListener(onItemSelectedListener);
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        this.invalidate();
    }

    public int getBaseColor() {
        return this.baseColor;
    }

    public void setBaseColor(int baseColor) {
        this.baseColor = baseColor;
        this.textPaint.setColor(baseColor);
        this.baseAlpha = this.textPaint.getAlpha();
        this.invalidate();
    }

    public int getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(int highlightColor) {
        this.highlightColor = highlightColor;
        this.invalidate();
    }

    public int getHintColor() {
        return this.hintColor;
    }

    public void setHintColor(int hintColor) {
        this.hintColor = hintColor;
        this.invalidate();
    }

    public float getHintTextSize() {
        return this.hintTextSize;
    }

    public void setHintTextSize(float hintTextSize) {
        this.hintTextSize = hintTextSize;
        this.invalidate();
    }

    public int getErrorColor() {
        return this.errorColor;
    }

    public void setErrorColor(int errorColor) {
        this.errorColor = errorColor;
        this.invalidate();
    }

    public int getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(int disabledColor) {
        this.disabledColor = disabledColor;
        this.invalidate();
    }

    public void setHint(CharSequence hint) {
        this.hint = hint;
        this.invalidate();
    }

    public void setHint(int resid) {
        String hint = this.getResources().getString(resid);
        this.setHint(hint);
    }

    public CharSequence getHint() {
        return this.hint;
    }

    public void setHintView(Integer resId) {
        this.mHintView = resId;
    }

    public void setDripDownHintView(Integer resId) {
        this.mDropDownHintView = resId;
    }

    public void setFloatingLabelText(CharSequence floatingLabelText) {
        this.floatingLabelText = floatingLabelText;
        this.invalidate();
    }

    public void setFloatingLabelText(int resid) {
        String floatingLabelText = this.getResources().getString(resid);
        this.setFloatingLabelText(floatingLabelText);
    }

    public CharSequence getFloatingLabelText() {
        return this.floatingLabelText;
    }

    public int getFloatingLabelColor() {
        return this.floatingLabelColor;
    }

    public void setFloatingLabelColor(int floatingLabelColor) {
        this.floatingLabelColor = floatingLabelColor;
        this.invalidate();
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
        this.invalidate();
    }

    public Typeface getTypeface() {
        return this.typeface;
    }

    public void setTypeface(Typeface typeface) {
        this.typeface = typeface;
        if (typeface != null) {
            this.textPaint.setTypeface(typeface);
        }
        this.invalidate();
    }

    public boolean isAlignLabels() {
        return this.alignLabels;
    }

    public void setAlignLabels(boolean alignLabels) {
        this.alignLabels = alignLabels;
        this.rightLeftSpinnerPadding = alignLabels ? this.getResources().getDimensionPixelSize(R.dimen.right_left_spinner_padding) : 0;
        this.invalidate();
    }

    public float getThickness() {
        return this.thickness;
    }

    public void setThickness(float thickness) {
        this.thickness = thickness;
        this.invalidate();
    }

    public float getThicknessError() {
        return this.thicknessError;
    }

    public void setThicknessError(float thicknessError) {
        this.thicknessError = thicknessError;
        this.invalidate();
    }

    public int getArrowColor() {
        return this.arrowColor;
    }

    public void setArrowColor(int arrowColor) {
        this.arrowColor = arrowColor;
        this.invalidate();
    }

    public float getArrowSize() {
        return this.arrowSize;
    }

    public void setArrowSize(float arrowSize) {
        this.arrowSize = arrowSize;
        this.invalidate();
    }

    public boolean isEnableErrorLabel() {
        return this.enableErrorLabel;
    }

    public void setEnableErrorLabel(boolean enableErrorLabel) {
        this.enableErrorLabel = enableErrorLabel;
        this.updateBottomPadding();
        this.invalidate();
    }

    public boolean isEnableFloatingLabel() {
        return this.enableFloatingLabel;
    }

    public void setEnableFloatingLabel(boolean enableFloatingLabel) {
        this.enableFloatingLabel = enableFloatingLabel;
        this.extraPaddingTop = enableFloatingLabel ? this.floatingLabelTopSpacing + this.floatingLabelInsideSpacing + this.floatingLabelBottomSpacing : this.floatingLabelBottomSpacing;
        this.updateBottomPadding();
        this.invalidate();
    }

    public void setError(CharSequence error) {
        this.error = error;
        if (this.errorLabelAnimator != null) {
            this.errorLabelAnimator.end();
        }
        if (this.multiline) {
            this.startErrorMultilineAnimator(this.prepareBottomPadding());
        } else if (this.needScrollingAnimation()) {
            this.startErrorScrollingAnimator();
        }
        this.requestLayout();
    }

    public void setError(int resid) {
        String error = this.getResources().getString(resid);
        this.setError(error);
    }

    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.isSelected = false;
            this.invalidate();
        }
        super.setEnabled(enabled);
    }

    public CharSequence getError() {
        return this.error;
    }

    public void setRtl() {
        this.isRtl = true;
        this.invalidate();
    }

    public boolean isRtl() {
        return this.isRtl;
    }

    @Deprecated
    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
    }

    public void setPaddingSafe(int left, int top, int right, int bottom) {
        this.innerPaddingRight = right;
        this.innerPaddingLeft = left;
        this.innerPaddingTop = top;
        this.innerPaddingBottom = bottom;
        this.updatePadding();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void setAdapter(SpinnerAdapter adapter) {
        if (adapter instanceof HintAdapter) {
            super.setAdapter(adapter);
        } else {
            this.hintAdapter = new HintAdapter(adapter, this.getContext());
            super.setAdapter((SpinnerAdapter)this.hintAdapter);
        }
    }

    public SpinnerAdapter getAdapter() {
        return this.hintAdapter != null ? this.hintAdapter.getWrappedAdapter() : null;
    }

    private float getFloatingLabelPercent() {
        return this.floatingLabelPercent;
    }

    private void setFloatingLabelPercent(float floatingLabelPercent) {
        this.floatingLabelPercent = floatingLabelPercent;
    }

    private int getErrorLabelPosX() {
        return this.errorLabelPosX;
    }

    private void setErrorLabelPosX(int errorLabelPosX) {
        this.errorLabelPosX = errorLabelPosX;
    }

    private float getCurrentNbErrorLines() {
        return this.currentNbErrorLines;
    }

    private void setCurrentNbErrorLines(float currentNbErrorLines) {
        this.currentNbErrorLines = currentNbErrorLines;
        this.updateBottomPadding();
    }

    public Object getItemAtPosition(int position) {
        if (this.hint != null) {
            ++position;
        }
        return this.hintAdapter == null || position < 0 ? null : this.hintAdapter.getItem(position);
    }

    public long getItemIdAtPosition(int position) {
        if (this.hint != null) {
            ++position;
        }
        return this.hintAdapter == null || position < 0 ? Long.MIN_VALUE : this.hintAdapter.getItemId(position);
    }

    private class HintAdapter
    extends BaseAdapter {
        private static final int HINT_TYPE = -1;
        private SpinnerAdapter mSpinnerAdapter;
        private Context mContext;

        public HintAdapter(SpinnerAdapter spinnerAdapter, Context context) {
            this.mSpinnerAdapter = spinnerAdapter;
            this.mContext = context;
        }

        public int getViewTypeCount() {
            if (Build.VERSION.SDK_INT >= 21) {
                return 1;
            }
            int viewTypeCount = this.mSpinnerAdapter.getViewTypeCount();
            return viewTypeCount;
        }

        public int getItemViewType(int position) {
            position = MaterialSpinner.this.hint != null ? position - 1 : position;
            return position == -1 ? -1 : this.mSpinnerAdapter.getItemViewType(position);
        }

        public int getCount() {
            int count = this.mSpinnerAdapter.getCount();
            return MaterialSpinner.this.hint != null ? count + 1 : count;
        }

        public Object getItem(int position) {
            position = MaterialSpinner.this.hint != null ? position - 1 : position;
            return position == -1 ? MaterialSpinner.this.hint : this.mSpinnerAdapter.getItem(position);
        }

        public long getItemId(int position) {
            position = MaterialSpinner.this.hint != null ? position - 1 : position;
            return position == -1 ? 0L : this.mSpinnerAdapter.getItemId(position);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            return this.buildView(position, convertView, parent, false);
        }

        public View getDropDownView(int position, View convertView, ViewGroup parent) {
            return this.buildView(position, convertView, parent, true);
        }

        private View buildView(int position, View convertView, ViewGroup parent, boolean isDropDownView) {
            if (this.getItemViewType(position) == -1) {
                return this.getHintView(convertView, parent, isDropDownView);
            }
            if (convertView != null) {
                convertView = convertView.getTag() != null && convertView.getTag() instanceof Integer && (Integer)convertView.getTag() != -1 ? convertView : null;
            }
            position = MaterialSpinner.this.hint != null ? position - 1 : position;
            return isDropDownView ? this.mSpinnerAdapter.getDropDownView(position, convertView, parent) : this.mSpinnerAdapter.getView(position, convertView, parent);
        }

        private View getHintView(View convertView, ViewGroup parent, boolean isDropDownView) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
            int resid = isDropDownView ? MaterialSpinner.this.mDropDownHintView : MaterialSpinner.this.mHintView;
            TextView textView = (TextView)inflater.inflate(resid, parent, false);
            textView.setText(MaterialSpinner.this.hint);
            textView.setTextColor(MaterialSpinner.this.isEnabled() ? MaterialSpinner.this.hintColor : MaterialSpinner.this.disabledColor);
            textView.setTag((Object)-1);
            if (MaterialSpinner.this.hintTextSize != -1.0f) {
                textView.setTextSize(0, MaterialSpinner.this.hintTextSize);
            }
            return textView;
        }

        private SpinnerAdapter getWrappedAdapter() {
            return this.mSpinnerAdapter;
        }
    }
}

