/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugins.enforcer.EnforcerDescriptor;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ExternalRules
implements EnforcerRule {
    private static final String LOCATION_PREFIX_CLASSPATH = "classpath:";
    String location;

    public ExternalRules() {
    }

    public ExternalRules(String location) {
        this.location = location;
    }

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        EnforcerDescriptor enforcerDescriptor = this.getEnforcerDescriptor(helper);
        for (EnforcerRule rule : enforcerDescriptor.getRules()) {
            rule.execute(helper);
        }
    }

    EnforcerDescriptor getEnforcerDescriptor(EnforcerRuleHelper helper) throws EnforcerRuleException {
        EnforcerDescriptor enforcerDescriptor;
        block9: {
            InputStream descriptorStream = this.resolveDescriptor(helper);
            try {
                EnforcerDescriptor descriptor = new EnforcerDescriptor();
                ComponentConfigurator configurator = (ComponentConfigurator)helper.getComponent(ComponentConfigurator.class, "basic");
                configurator.configureComponent((Object)descriptor, ExternalRules.toPlexusConfiguration(descriptorStream), (ExpressionEvaluator)helper, this.getClassRealm(helper));
                enforcerDescriptor = descriptor;
                if (descriptorStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (descriptorStream != null) {
                        try {
                            descriptorStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (EnforcerRuleException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new EnforcerRuleException("Error while enforcing rules", e);
                }
            }
            descriptorStream.close();
        }
        return enforcerDescriptor;
    }

    private InputStream resolveDescriptor(EnforcerRuleHelper helper) throws ComponentLookupException, EnforcerRuleException {
        InputStream descriptorStream;
        if (this.location != null) {
            if (this.location.startsWith(LOCATION_PREFIX_CLASSPATH)) {
                String classpathLocation = this.location.substring(LOCATION_PREFIX_CLASSPATH.length());
                ClassRealm classRealm = this.getClassRealm(helper);
                descriptorStream = classRealm.getResourceAsStream(classpathLocation);
                if (descriptorStream == null) {
                    throw new EnforcerRuleException("Location '" + classpathLocation + "' not found in classpath");
                }
            } else {
                File descriptorFile = helper.alignToBaseDirectory(new File(this.location));
                try {
                    descriptorStream = Files.newInputStream(descriptorFile.toPath(), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new EnforcerRuleException("Could not read descriptor in " + descriptorFile, (Exception)e);
                }
            }
        } else {
            throw new EnforcerRuleException("No location provided");
        }
        return descriptorStream;
    }

    private static PlexusConfiguration toPlexusConfiguration(InputStream descriptorStream) throws XmlPullParserException, IOException {
        Xpp3Dom dom = Xpp3DomBuilder.build((InputStream)descriptorStream, (String)"UTF-8");
        return new XmlPlexusConfiguration(dom);
    }

    private ClassRealm getClassRealm(EnforcerRuleHelper helper) throws ComponentLookupException {
        return ((MojoExecution)helper.getComponent(MojoExecution.class)).getMojoDescriptor().getRealm();
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule enforcerRule) {
        return false;
    }

    public String getCacheId() {
        return this.location;
    }
}

