/*
 * Decompiled with CFR 0.152.
 */
package com.github.gastaldi.git;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="git-checkout")
public class GitCheckoutMojo
extends AbstractMojo {
    @Parameter(property="outputDirectory", defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(property="repository", required=true)
    private String repository;
    @Parameter(property="branch", defaultValue="master")
    private String branch;
    @Parameter(property="paths", required=true)
    private List<String> paths;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.outputDirectory.mkdirs();
            Path pathToGitDirectory = this.outputDirectory.toPath().resolve(".git");
            if (Files.exists(pathToGitDirectory, new LinkOption[0])) {
                throw new MojoExecutionException("Cannot execute mojo in a directory that already contains a .git directory");
            }
            this.executeCommand(this.outputDirectory, "git", "init");
            this.executeCommand(this.outputDirectory, "git", "remote", "add", "origin", this.repository);
            this.executeCommand(this.outputDirectory, "git", "config", "core.sparseCheckout", "true");
            Path sparseCheckoutFile = this.outputDirectory.toPath().resolve(".git/info/sparse-checkout");
            Files.write(sparseCheckoutFile, this.paths, new OpenOption[0]);
            this.executeCommand(this.outputDirectory, "git", "pull", "origin", this.branch);
            FileUtils.forceDelete((File)pathToGitDirectory.toFile());
            this.getLog().info((CharSequence)("Files were checked out in: " + this.outputDirectory));
        }
        catch (IOException e) {
            throw new MojoFailureException("Caught IOException in mojo", (Throwable)e);
        }
    }

    private final int executeCommand(File directory, String ... command) throws IOException {
        Process process = new ProcessBuilder(new String[0]).directory(directory).command(command).inheritIO().start();
        try {
            return process.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

