/*
 * Decompiled with CFR 0.152.
 */
package com.github.gcacace.signaturepad.utils;

import com.github.gcacace.signaturepad.utils.TimedPoint;

public class Bezier {
    public TimedPoint startPoint;
    public TimedPoint control1;
    public TimedPoint control2;
    public TimedPoint endPoint;

    public Bezier set(TimedPoint startPoint, TimedPoint control1, TimedPoint control2, TimedPoint endPoint) {
        this.startPoint = startPoint;
        this.control1 = control1;
        this.control2 = control2;
        this.endPoint = endPoint;
        return this;
    }

    public float length() {
        int steps = 10;
        float length = 0.0f;
        double px = 0.0;
        double py = 0.0;
        for (int i = 0; i <= steps; ++i) {
            float t = (float)i / (float)steps;
            double cx = this.point(t, this.startPoint.x, this.control1.x, this.control2.x, this.endPoint.x);
            double cy = this.point(t, this.startPoint.y, this.control1.y, this.control2.y, this.endPoint.y);
            if (i > 0) {
                double xDiff = cx - px;
                double yDiff = cy - py;
                length = (float)((double)length + Math.sqrt(xDiff * xDiff + yDiff * yDiff));
            }
            px = cx;
            py = cy;
        }
        return length;
    }

    public double point(float t, float start, float c1, float c2, float end) {
        return (double)start * (1.0 - (double)t) * (1.0 - (double)t) * (1.0 - (double)t) + 3.0 * (double)c1 * (1.0 - (double)t) * (1.0 - (double)t) * (double)t + 3.0 * (double)c2 * (1.0 - (double)t) * (double)t * (double)t + (double)(end * t * t * t);
    }
}

