/*
 * Decompiled with CFR 0.152.
 */
package com.github.gcacace.signaturepad.views;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import com.github.gcacace.signaturepad.R;
import com.github.gcacace.signaturepad.utils.Bezier;
import com.github.gcacace.signaturepad.utils.ControlTimedPoints;
import com.github.gcacace.signaturepad.utils.SvgBuilder;
import com.github.gcacace.signaturepad.utils.TimedPoint;
import com.github.gcacace.signaturepad.view.ViewCompat;
import com.github.gcacace.signaturepad.view.ViewTreeObserverCompat;
import java.util.ArrayList;
import java.util.List;

public class SignaturePad
extends View {
    private List<TimedPoint> mPoints;
    private boolean mIsEmpty;
    private Boolean mHasEditState;
    private float mLastTouchX;
    private float mLastTouchY;
    private float mLastVelocity;
    private float mLastWidth;
    private RectF mDirtyRect;
    private Bitmap mBitmapSavedState;
    private final SvgBuilder mSvgBuilder = new SvgBuilder();
    private List<TimedPoint> mPointsCache = new ArrayList<TimedPoint>();
    private ControlTimedPoints mControlTimedPointsCached = new ControlTimedPoints();
    private Bezier mBezierCached = new Bezier();
    private int mMinWidth;
    private int mMaxWidth;
    private float mVelocityFilterWeight;
    private OnSignedListener mOnSignedListener;
    private boolean mClearOnDoubleClick;
    private long mFirstClick;
    private int mCountClick;
    private static final int DOUBLE_CLICK_DELAY_MS = 200;
    private final int DEFAULT_ATTR_PEN_MIN_WIDTH_PX = 3;
    private final int DEFAULT_ATTR_PEN_MAX_WIDTH_PX = 7;
    private final int DEFAULT_ATTR_PEN_COLOR = -16777216;
    private final float DEFAULT_ATTR_VELOCITY_FILTER_WEIGHT = 0.9f;
    private final boolean DEFAULT_ATTR_CLEAR_ON_DOUBLE_CLICK = false;
    private Paint mPaint = new Paint();
    private Bitmap mSignatureBitmap = null;
    private Canvas mSignatureBitmapCanvas = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignaturePad(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SignaturePad, 0, 0);
        try {
            this.mMinWidth = a.getDimensionPixelSize(R.styleable.SignaturePad_penMinWidth, this.convertDpToPx(3.0f));
            this.mMaxWidth = a.getDimensionPixelSize(R.styleable.SignaturePad_penMaxWidth, this.convertDpToPx(7.0f));
            this.mPaint.setColor(a.getColor(R.styleable.SignaturePad_penColor, -16777216));
            this.mVelocityFilterWeight = a.getFloat(R.styleable.SignaturePad_velocityFilterWeight, 0.9f);
            this.mClearOnDoubleClick = a.getBoolean(R.styleable.SignaturePad_clearOnDoubleClick, false);
        }
        finally {
            a.recycle();
        }
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mDirtyRect = new RectF();
        this.clearView();
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("superState", super.onSaveInstanceState());
        if (this.mHasEditState == null || this.mHasEditState.booleanValue()) {
            this.mBitmapSavedState = this.getTransparentSignatureBitmap();
        }
        bundle.putParcelable("signatureBitmap", (Parcelable)this.mBitmapSavedState);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.setSignatureBitmap((Bitmap)bundle.getParcelable("signatureBitmap"));
            this.mBitmapSavedState = (Bitmap)bundle.getParcelable("signatureBitmap");
            state = bundle.getParcelable("superState");
        }
        this.mHasEditState = false;
        super.onRestoreInstanceState(state);
    }

    public void setPenColorRes(int colorRes) {
        try {
            this.setPenColor(this.getResources().getColor(colorRes));
        }
        catch (Resources.NotFoundException ex) {
            this.setPenColor(Color.parseColor((String)"#000000"));
        }
    }

    public void setPenColor(int color) {
        this.mPaint.setColor(color);
    }

    public void setMinWidth(float minWidth) {
        this.mMinWidth = this.convertDpToPx(minWidth);
    }

    public void setMaxWidth(float maxWidth) {
        this.mMaxWidth = this.convertDpToPx(maxWidth);
    }

    public void setVelocityFilterWeight(float velocityFilterWeight) {
        this.mVelocityFilterWeight = velocityFilterWeight;
    }

    public void clearView() {
        this.mSvgBuilder.clear();
        this.mPoints = new ArrayList<TimedPoint>();
        this.mLastVelocity = 0.0f;
        this.mLastWidth = (this.mMinWidth + this.mMaxWidth) / 2;
        if (this.mSignatureBitmap != null) {
            this.mSignatureBitmap = null;
            this.ensureSignatureBitmap();
        }
        this.setIsEmpty(true);
        this.invalidate();
    }

    public void clear() {
        this.clearView();
        this.mHasEditState = true;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        float eventX = event.getX();
        float eventY = event.getY();
        switch (event.getAction()) {
            case 0: {
                this.getParent().requestDisallowInterceptTouchEvent(true);
                this.mPoints.clear();
                if (this.isDoubleClick()) break;
                this.mLastTouchX = eventX;
                this.mLastTouchY = eventY;
                this.addPoint(this.getNewPoint(eventX, eventY));
                if (this.mOnSignedListener != null) {
                    this.mOnSignedListener.onStartSigning();
                }
            }
            case 2: {
                this.resetDirtyRect(eventX, eventY);
                this.addPoint(this.getNewPoint(eventX, eventY));
                this.setIsEmpty(false);
                break;
            }
            case 1: {
                this.resetDirtyRect(eventX, eventY);
                this.addPoint(this.getNewPoint(eventX, eventY));
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            default: {
                return false;
            }
        }
        this.invalidate((int)(this.mDirtyRect.left - (float)this.mMaxWidth), (int)(this.mDirtyRect.top - (float)this.mMaxWidth), (int)(this.mDirtyRect.right + (float)this.mMaxWidth), (int)(this.mDirtyRect.bottom + (float)this.mMaxWidth));
        return true;
    }

    protected void onDraw(Canvas canvas) {
        if (this.mSignatureBitmap != null) {
            canvas.drawBitmap(this.mSignatureBitmap, 0.0f, 0.0f, this.mPaint);
        }
    }

    public void setOnSignedListener(OnSignedListener listener) {
        this.mOnSignedListener = listener;
    }

    public boolean isEmpty() {
        return this.mIsEmpty;
    }

    public String getSignatureSvg() {
        int width = this.getTransparentSignatureBitmap().getWidth();
        int height = this.getTransparentSignatureBitmap().getHeight();
        return this.mSvgBuilder.build(width, height);
    }

    public Bitmap getSignatureBitmap() {
        Bitmap originalBitmap = this.getTransparentSignatureBitmap();
        Bitmap whiteBgBitmap = Bitmap.createBitmap((int)originalBitmap.getWidth(), (int)originalBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(whiteBgBitmap);
        canvas.drawColor(-1);
        canvas.drawBitmap(originalBitmap, 0.0f, 0.0f, null);
        return whiteBgBitmap;
    }

    public void setSignatureBitmap(final Bitmap signature) {
        if (ViewCompat.isLaidOut(this)) {
            this.clearView();
            this.ensureSignatureBitmap();
            RectF tempSrc = new RectF();
            RectF tempDst = new RectF();
            int dWidth = signature.getWidth();
            int dHeight = signature.getHeight();
            int vWidth = this.getWidth();
            int vHeight = this.getHeight();
            tempSrc.set(0.0f, 0.0f, (float)dWidth, (float)dHeight);
            tempDst.set(0.0f, 0.0f, (float)vWidth, (float)vHeight);
            Matrix drawMatrix = new Matrix();
            drawMatrix.setRectToRect(tempSrc, tempDst, Matrix.ScaleToFit.CENTER);
            Canvas canvas = new Canvas(this.mSignatureBitmap);
            canvas.drawBitmap(signature, drawMatrix, null);
            this.setIsEmpty(false);
            this.invalidate();
        } else {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    ViewTreeObserverCompat.removeOnGlobalLayoutListener(SignaturePad.this.getViewTreeObserver(), this);
                    SignaturePad.this.setSignatureBitmap(signature);
                }
            });
        }
    }

    public Bitmap getTransparentSignatureBitmap() {
        this.ensureSignatureBitmap();
        return this.mSignatureBitmap;
    }

    public Bitmap getTransparentSignatureBitmap(boolean trimBlankSpace) {
        int x;
        int y;
        int y2;
        boolean stop;
        int x2;
        if (!trimBlankSpace) {
            return this.getTransparentSignatureBitmap();
        }
        this.ensureSignatureBitmap();
        int imgHeight = this.mSignatureBitmap.getHeight();
        int imgWidth = this.mSignatureBitmap.getWidth();
        int backgroundColor = 0;
        int xMin = Integer.MAX_VALUE;
        int xMax = Integer.MIN_VALUE;
        int yMin = Integer.MAX_VALUE;
        int yMax = Integer.MIN_VALUE;
        boolean foundPixel = false;
        for (x2 = 0; x2 < imgWidth; ++x2) {
            stop = false;
            for (y2 = 0; y2 < imgHeight; ++y2) {
                if (this.mSignatureBitmap.getPixel(x2, y2) == backgroundColor) continue;
                xMin = x2;
                stop = true;
                foundPixel = true;
                break;
            }
            if (stop) break;
        }
        if (!foundPixel) {
            return null;
        }
        for (y = 0; y < imgHeight; ++y) {
            stop = false;
            for (x = xMin; x < imgWidth; ++x) {
                if (this.mSignatureBitmap.getPixel(x, y) == backgroundColor) continue;
                yMin = y;
                stop = true;
                break;
            }
            if (stop) break;
        }
        for (x2 = imgWidth - 1; x2 >= xMin; --x2) {
            stop = false;
            for (y2 = yMin; y2 < imgHeight; ++y2) {
                if (this.mSignatureBitmap.getPixel(x2, y2) == backgroundColor) continue;
                xMax = x2;
                stop = true;
                break;
            }
            if (stop) break;
        }
        for (y = imgHeight - 1; y >= yMin; --y) {
            stop = false;
            for (x = xMin; x <= xMax; ++x) {
                if (this.mSignatureBitmap.getPixel(x, y) == backgroundColor) continue;
                yMax = y;
                stop = true;
                break;
            }
            if (stop) break;
        }
        return Bitmap.createBitmap((Bitmap)this.mSignatureBitmap, (int)xMin, (int)yMin, (int)(xMax - xMin), (int)(yMax - yMin));
    }

    private boolean isDoubleClick() {
        if (this.mClearOnDoubleClick) {
            long lastClick;
            if (this.mFirstClick != 0L && System.currentTimeMillis() - this.mFirstClick > 200L) {
                this.mCountClick = 0;
            }
            ++this.mCountClick;
            if (this.mCountClick == 1) {
                this.mFirstClick = System.currentTimeMillis();
            } else if (this.mCountClick == 2 && (lastClick = System.currentTimeMillis()) - this.mFirstClick < 200L) {
                this.clearView();
                return true;
            }
        }
        return false;
    }

    private TimedPoint getNewPoint(float x, float y) {
        int mCacheSize = this.mPointsCache.size();
        TimedPoint timedPoint = mCacheSize == 0 ? new TimedPoint() : this.mPointsCache.remove(mCacheSize - 1);
        return timedPoint.set(x, y);
    }

    private void recyclePoint(TimedPoint point) {
        this.mPointsCache.add(point);
    }

    private void addPoint(TimedPoint newPoint) {
        this.mPoints.add(newPoint);
        int pointsCount = this.mPoints.size();
        if (pointsCount > 3) {
            ControlTimedPoints tmp = this.calculateCurveControlPoints(this.mPoints.get(0), this.mPoints.get(1), this.mPoints.get(2));
            TimedPoint c2 = tmp.c2;
            this.recyclePoint(tmp.c1);
            tmp = this.calculateCurveControlPoints(this.mPoints.get(1), this.mPoints.get(2), this.mPoints.get(3));
            TimedPoint c3 = tmp.c1;
            this.recyclePoint(tmp.c2);
            Bezier curve = this.mBezierCached.set(this.mPoints.get(1), c2, c3, this.mPoints.get(2));
            TimedPoint startPoint = curve.startPoint;
            TimedPoint endPoint = curve.endPoint;
            float velocity = endPoint.velocityFrom(startPoint);
            velocity = Float.isNaN(velocity) ? 0.0f : velocity;
            velocity = this.mVelocityFilterWeight * velocity + (1.0f - this.mVelocityFilterWeight) * this.mLastVelocity;
            float newWidth = this.strokeWidth(velocity);
            this.addBezier(curve, this.mLastWidth, newWidth);
            this.mLastVelocity = velocity;
            this.mLastWidth = newWidth;
            this.recyclePoint(this.mPoints.remove(0));
            this.recyclePoint(c2);
            this.recyclePoint(c3);
        } else if (pointsCount == 1) {
            TimedPoint firstPoint = this.mPoints.get(0);
            this.mPoints.add(this.getNewPoint(firstPoint.x, firstPoint.y));
        }
        this.mHasEditState = true;
    }

    private void addBezier(Bezier curve, float startWidth, float endWidth) {
        this.mSvgBuilder.append(curve, (startWidth + endWidth) / 2.0f);
        this.ensureSignatureBitmap();
        float originalWidth = this.mPaint.getStrokeWidth();
        float widthDelta = endWidth - startWidth;
        float drawSteps = (float)Math.ceil(curve.length());
        int i = 0;
        while ((float)i < drawSteps) {
            float t = (float)i / drawSteps;
            float tt = t * t;
            float ttt = tt * t;
            float u = 1.0f - t;
            float uu = u * u;
            float uuu = uu * u;
            float x = uuu * curve.startPoint.x;
            x += 3.0f * uu * t * curve.control1.x;
            x += 3.0f * u * tt * curve.control2.x;
            float y = uuu * curve.startPoint.y;
            y += 3.0f * uu * t * curve.control1.y;
            y += 3.0f * u * tt * curve.control2.y;
            this.mPaint.setStrokeWidth(startWidth + ttt * widthDelta);
            this.mSignatureBitmapCanvas.drawPoint(x += ttt * curve.endPoint.x, y += ttt * curve.endPoint.y, this.mPaint);
            this.expandDirtyRect(x, y);
            ++i;
        }
        this.mPaint.setStrokeWidth(originalWidth);
    }

    private ControlTimedPoints calculateCurveControlPoints(TimedPoint s1, TimedPoint s2, TimedPoint s3) {
        float dx1 = s1.x - s2.x;
        float dy1 = s1.y - s2.y;
        float dx2 = s2.x - s3.x;
        float dy2 = s2.y - s3.y;
        float m1X = (s1.x + s2.x) / 2.0f;
        float m1Y = (s1.y + s2.y) / 2.0f;
        float m2X = (s2.x + s3.x) / 2.0f;
        float m2Y = (s2.y + s3.y) / 2.0f;
        float l1 = (float)Math.sqrt(dx1 * dx1 + dy1 * dy1);
        float l2 = (float)Math.sqrt(dx2 * dx2 + dy2 * dy2);
        float dxm = m1X - m2X;
        float dym = m1Y - m2Y;
        float k = l2 / (l1 + l2);
        if (Float.isNaN(k)) {
            k = 0.0f;
        }
        float cmX = m2X + dxm * k;
        float cmY = m2Y + dym * k;
        float tx = s2.x - cmX;
        float ty = s2.y - cmY;
        return this.mControlTimedPointsCached.set(this.getNewPoint(m1X + tx, m1Y + ty), this.getNewPoint(m2X + tx, m2Y + ty));
    }

    private float strokeWidth(float velocity) {
        return Math.max((float)this.mMaxWidth / (velocity + 1.0f), (float)this.mMinWidth);
    }

    private void expandDirtyRect(float historicalX, float historicalY) {
        if (historicalX < this.mDirtyRect.left) {
            this.mDirtyRect.left = historicalX;
        } else if (historicalX > this.mDirtyRect.right) {
            this.mDirtyRect.right = historicalX;
        }
        if (historicalY < this.mDirtyRect.top) {
            this.mDirtyRect.top = historicalY;
        } else if (historicalY > this.mDirtyRect.bottom) {
            this.mDirtyRect.bottom = historicalY;
        }
    }

    private void resetDirtyRect(float eventX, float eventY) {
        this.mDirtyRect.left = Math.min(this.mLastTouchX, eventX);
        this.mDirtyRect.right = Math.max(this.mLastTouchX, eventX);
        this.mDirtyRect.top = Math.min(this.mLastTouchY, eventY);
        this.mDirtyRect.bottom = Math.max(this.mLastTouchY, eventY);
    }

    private void setIsEmpty(boolean newValue) {
        this.mIsEmpty = newValue;
        if (this.mOnSignedListener != null) {
            if (this.mIsEmpty) {
                this.mOnSignedListener.onClear();
            } else {
                this.mOnSignedListener.onSigned();
            }
        }
    }

    private void ensureSignatureBitmap() {
        if (this.mSignatureBitmap == null) {
            this.mSignatureBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mSignatureBitmapCanvas = new Canvas(this.mSignatureBitmap);
        }
    }

    private int convertDpToPx(float dp) {
        return Math.round(this.getContext().getResources().getDisplayMetrics().density * dp);
    }

    public List<TimedPoint> getPoints() {
        return this.mPoints;
    }

    public static interface OnSignedListener {
        public void onStartSigning();

        public void onSigned();

        public void onClear();
    }
}

