/*
 * Decompiled with CFR 0.152.
 */
package com.github.gekomad.scalacompress;

import com.github.gekomad.scalacompress.CompressionStats;
import com.github.gekomad.scalacompress.CompressionStats$;
import com.github.gekomad.scalacompress.Compressors;
import com.github.gekomad.scalacompress.Compressors$StreamableCompressor$;
import com.github.gekomad.scalacompress.DecompressionStats;
import com.github.gekomad.scalacompress.DecompressionStats$;
import com.github.gekomad.scalacompress.SevenZip$;
import com.github.gekomad.scalacompress.Util$;
import com.github.gekomad.scalacompress.Zip$;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.jpountz.lz4.LZ4FrameInputStream;
import net.jpountz.lz4.LZ4FrameOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorInputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorOutputStream;
import org.apache.commons.compress.compressors.lzma.LZMACompressorInputStream;
import org.apache.commons.compress.compressors.lzma.LZMACompressorOutputStream;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorInputStream;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorOutputStream;
import org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorInputStream;
import org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorOutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

public final class Compressors$ {
    public static final Compressors$ MODULE$ = new Compressors$();
    private static final Compressors.CompressionMethod deflateMethod = new Compressors.CompressionMethod("Deflate", ".deflate", (Option<String>)new Some((Object)"deflate"));
    private static final Compressors.CompressionMethod bz2Method;
    private static final Compressors.CompressionMethod gzMethod;
    private static final Compressors.CompressionMethod parckMethod;
    private static final Compressors.CompressionMethod XZMethod;
    private static final Compressors.CompressionMethod zstandardMethod;
    private static final Compressors.CompressionMethod lzmaMethod;
    private static final Compressors.CompressionMethod tarMethod;
    private static final Compressors.CompressionMethod zipMethod;
    private static final Compressors.CompressionMethod lz4Method;
    private static final Compressors.CompressionMethod snappyMethod;
    private static final Compressors.CompressionMethod sevenZipMethod;
    private static final Compressors.CompressionMethod arMethod;
    private static final Compressors.CompressionMethod cpioMethod;
    private static volatile int bitmap$init$0;

    static {
        bitmap$init$0 |= 4;
        bz2Method = new Compressors.CompressionMethod("Bz2", ".bz2", (Option<String>)new Some((Object)"bzip2"));
        bitmap$init$0 |= 8;
        gzMethod = new Compressors.CompressionMethod("GZ", ".gz", (Option<String>)new Some((Object)"gz"));
        bitmap$init$0 |= 0x10;
        parckMethod = new Compressors.CompressionMethod("Pack", ".pack", (Option<String>)new Some((Object)"pack200"));
        bitmap$init$0 |= 0x20;
        XZMethod = new Compressors.CompressionMethod("XZ", ".xz", (Option<String>)new Some((Object)"xz"));
        bitmap$init$0 |= 0x40;
        zstandardMethod = new Compressors.CompressionMethod("Zstandard", ".zst", (Option<String>)new Some((Object)"zstd"));
        bitmap$init$0 |= 0x80;
        lzmaMethod = new Compressors.CompressionMethod("Lzma", ".lzma", (Option<String>)new Some((Object)"lzma"));
        bitmap$init$0 |= 0x100;
        tarMethod = new Compressors.CompressionMethod("Tar", ".tar", (Option<String>)None$.MODULE$);
        bitmap$init$0 |= 0x200;
        zipMethod = new Compressors.CompressionMethod("Zip", ".zip", (Option<String>)None$.MODULE$);
        bitmap$init$0 |= 0x400;
        lz4Method = new Compressors.CompressionMethod("Lz4", ".lz4", (Option<String>)None$.MODULE$);
        bitmap$init$0 |= 0x800;
        snappyMethod = new Compressors.CompressionMethod("Snappy", ".sz", (Option<String>)None$.MODULE$);
        bitmap$init$0 |= 0x1000;
        sevenZipMethod = new Compressors.CompressionMethod("7z", ".7z", (Option<String>)None$.MODULE$);
        bitmap$init$0 |= 0x2000;
        arMethod = new Compressors.CompressionMethod("Ar", ".ar", (Option<String>)None$.MODULE$);
        bitmap$init$0 |= 0x4000;
        cpioMethod = new Compressors.CompressionMethod("Cpio", ".cpio", (Option<String>)None$.MODULE$);
        bitmap$init$0 |= 0x8000;
    }

    public Compressors.CompressionMethod deflateMethod() {
        if ((bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /store/workspace/scala/scala-compress/src/main/scala/com/github/gekomad/scalacompress/Compressors.scala: 56");
        }
        return deflateMethod;
    }

    public Compressors.CompressionMethod bz2Method() {
        if ((bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /store/workspace/scala/scala-compress/src/main/scala/com/github/gekomad/scalacompress/Compressors.scala: 58");
        }
        return bz2Method;
    }

    public Compressors.CompressionMethod gzMethod() {
        if ((bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /store/workspace/scala/scala-compress/src/main/scala/com/github/gekomad/scalacompress/Compressors.scala: 59");
        }
        return gzMethod;
    }

    public Compressors.CompressionMethod parckMethod() {
        if ((bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /store/workspace/scala/scala-compress/src/main/scala/com/github/gekomad/scalacompress/Compressors.scala: 60");
        }
        return parckMethod;
    }

    public Compressors.CompressionMethod XZMethod() {
        if ((bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /store/workspace/scala/scala-compress/src/main/scala/com/github/gekomad/scalacompress/Compressors.scala: 61");
        }
        return XZMethod;
    }

    public Compressors.CompressionMethod zstandardMethod() {
        if ((bitmap$init$0 & 0x80) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /store/workspace/scala/scala-compress/src/main/scala/com/github/gekomad/scalacompress/Compressors.scala: 62");
        }
        return zstandardMethod;
    }

    public Compressors.CompressionMethod lzmaMethod() {
        if ((bitmap$init$0 & 0x100) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /store/workspace/scala/scala-compress/src/main/scala/com/github/gekomad/scalacompress/Compressors.scala: 64");
        }
        return lzmaMethod;
    }

    public Compressors.CompressionMethod tarMethod() {
        if ((bitmap$init$0 & 0x200) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /store/workspace/scala/scala-compress/src/main/scala/com/github/gekomad/scalacompress/Compressors.scala: 65");
        }
        return tarMethod;
    }

    public Compressors.CompressionMethod zipMethod() {
        if ((bitmap$init$0 & 0x400) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /store/workspace/scala/scala-compress/src/main/scala/com/github/gekomad/scalacompress/Compressors.scala: 66");
        }
        return zipMethod;
    }

    public Compressors.CompressionMethod lz4Method() {
        if ((bitmap$init$0 & 0x800) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /store/workspace/scala/scala-compress/src/main/scala/com/github/gekomad/scalacompress/Compressors.scala: 67");
        }
        return lz4Method;
    }

    public Compressors.CompressionMethod snappyMethod() {
        if ((bitmap$init$0 & 0x1000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /store/workspace/scala/scala-compress/src/main/scala/com/github/gekomad/scalacompress/Compressors.scala: 68");
        }
        return snappyMethod;
    }

    public Compressors.CompressionMethod sevenZipMethod() {
        if ((bitmap$init$0 & 0x2000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /store/workspace/scala/scala-compress/src/main/scala/com/github/gekomad/scalacompress/Compressors.scala: 69");
        }
        return sevenZipMethod;
    }

    public Compressors.CompressionMethod arMethod() {
        if ((bitmap$init$0 & 0x4000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /store/workspace/scala/scala-compress/src/main/scala/com/github/gekomad/scalacompress/Compressors.scala: 70");
        }
        return arMethod;
    }

    public Compressors.CompressionMethod cpioMethod() {
        if ((bitmap$init$0 & 0x8000) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /store/workspace/scala/scala-compress/src/main/scala/com/github/gekomad/scalacompress/Compressors.scala: 71");
        }
        return cpioMethod;
    }

    public Try<DecompressionStats> lzmaDecompress(String src, String dest) {
        return this.decompress2(src, dest, this.lzmaMethod());
    }

    public Try<CompressionStats> lzmaCompress(String src, String dest) {
        return this.compress2(src, dest, this.lzmaMethod());
    }

    public Try<DecompressionStats> lz4Decompress(String src, String dest) {
        return this.decompress(src, dest, this.lz4Method(), (Function2<BufferedInputStream, String, BoxedUnit>)(Function2 & Serializable)(b, i) -> {
            Util$.MODULE$.autoClose(new LZ4FrameInputStream((InputStream)b), (Function1 & Serializable)zOut -> Compressors$.MODULE$.writeStreamToFile((InputStream)zOut, i));
            return BoxedUnit.UNIT;
        });
    }

    public Try<CompressionStats> lz4Compress(String src, String dest) {
        return this.compress(src, dest, this.lz4Method(), (Function2<BufferedOutputStream, InputStream, BoxedUnit>)(Function2 & Serializable)(b, i) -> {
            Util$.MODULE$.autoClose(new LZ4FrameOutputStream((OutputStream)b), (Function1 & Serializable)zOut -> BoxesRunTime.boxToLong((long)Compressors$.$anonfun$lz4Compress$2(i, zOut)));
            return BoxedUnit.UNIT;
        });
    }

    public Try<DecompressionStats> tarDecompress(String src2, String dest, Option<List<String>> entries) {
        return this.decompress3(this.tarMethod().name(), src2, dest, entries, (Function1<String, ArchiveInputStream>)(Function1 & Serializable)src -> new TarArchiveInputStream(Files.newInputStream(Paths.get(src, new String[0]), new OpenOption[0])));
    }

    public Option<List<String>> tarDecompress$default$3() {
        return None$.MODULE$;
    }

    public Try<CompressionStats> tarCompress(List<String> src, String dest) {
        Try try_;
        Option<List<String>> option = Util$.MODULE$.fileAccess(src);
        if (option instanceof Some) {
            Some some = (Some)option;
            List e = (List)some.value();
            try_ = new Failure((Throwable)new Exception(e.mkString(",")));
        } else if (None$.MODULE$.equals(option)) {
            try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> src.flatMap((Function1 & Serializable)z -> (List)Util$.MODULE$.getListOfFiles(new File((String)z)).get())).flatMap((Function1 & Serializable)ll -> MODULE$.compress3(MODULE$.tarMethod().name(), (List<Tuple2<File, Object>>)ll, dest, (Function1<OutputStream, ArchiveOutputStream>)(Function1 & Serializable)out -> Compressors$.f$1(out), (Function2<File, String, ArchiveEntry>)(Function2 & Serializable)(f, s) -> Compressors$.g$1(f, s)));
        } else {
            throw new MatchError(option);
        }
        return try_;
    }

    public Try<CompressionStats> zipCompress(List<String> src, String dest) {
        return Zip$.MODULE$.zipCompress(src, dest);
    }

    public Try<byte[]> zipString(String src, String charSetName) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> (byte[])Util$.MODULE$.autoClose(new ByteArrayOutputStream(), (Function1 & Serializable)arrayOutputStream -> {
            Util$.MODULE$.autoClose(new GZIPOutputStream((OutputStream)arrayOutputStream), (Function1 & Serializable)outputStream -> {
                outputStream.write(src.getBytes(charSetName));
                return BoxedUnit.UNIT;
            });
            return arrayOutputStream.toByteArray();
        }));
    }

    public String zipString$default$2() {
        return "UTF-8";
    }

    public Try<byte[]> unzipString(byte[] src, int bufferSize) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            byte[] readBuffer = new byte[bufferSize];
            return (byte[])Util$.MODULE$.autoClose(new GZIPInputStream(new ByteArrayInputStream(src)), (Function1 & Serializable)inputStream -> {
                int read = inputStream.read(readBuffer, 0, readBuffer.length);
                return Arrays.copyOf(readBuffer, read);
            });
        });
    }

    public int unzipString$default$2() {
        return 256;
    }

    public Try<List<ZipEntry>> zipEntries(String src) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> (List)Util$.MODULE$.autoClose(new ZipFile(src), (Function1 & Serializable)a -> Util$.MODULE$.javaIteratorToList(a.entries().asIterator())));
    }

    public Try<DecompressionStats> zipDecompress(String src, String dest) {
        return Zip$.MODULE$.zipDecompress(src, dest);
    }

    public Try<byte[]> zipDecompressEntry(String src, String entryName) {
        return Zip$.MODULE$.zipDecompressEntry(src, entryName, Zip$.MODULE$.zipDecompressEntry$default$3());
    }

    public Try<DecompressionStats> sevenZipDecompress(String src, String dest, Option<List<String>> entries) {
        return this.checkSrcPath((List<String>)((List)new .colon.colon((Object)src, (List)Nil$.MODULE$)), dest, (Function0 & Serializable)() -> {
            long start = System.currentTimeMillis();
            return SevenZip$.MODULE$.sevenZipDecompress(src, dest, entries, SevenZip$.MODULE$.sevenZipDecompress$default$4()).flatMap((Function1 & Serializable)filesOut -> DecompressionStats$.MODULE$.apply(MODULE$.sevenZipMethod().name(), src, (List<String>)filesOut, System.currentTimeMillis() - start));
        }).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Option<List<String>> sevenZipDecompress$default$3() {
        return None$.MODULE$;
    }

    private Try<DecompressionStats> decompress3(String name, String src, String dest, Option<List<String>> entries, Function1<String, ArchiveInputStream> f) {
        long start = System.currentTimeMillis();
        return Try$.MODULE$.apply((Function0 & Serializable)() -> (List)Util$.MODULE$.autoClose((AutoCloseable)f.apply((Object)src), (Function1 & Serializable)in -> Util$.MODULE$.extractEntries((ArchiveInputStream)in, dest, entries, Util$.MODULE$.extractEntries$default$4()))).flatMap((Function1 & Serializable)filesOut -> DecompressionStats$.MODULE$.apply(name, src, (List<String>)filesOut, System.currentTimeMillis() - start).map((Function1 & Serializable)stat -> stat));
    }

    public Try<DecompressionStats> arDecompress(String src2, String dest, Option<List<String>> entries) {
        return this.decompress3(this.arMethod().name(), src2, dest, entries, (Function1<String, ArchiveInputStream>)(Function1 & Serializable)src -> new ArArchiveInputStream(Files.newInputStream(Paths.get(src, new String[0]), new OpenOption[0])));
    }

    public Option<List<String>> arDecompress$default$3() {
        return None$.MODULE$;
    }

    public Try<DecompressionStats> cpioDecompress(String src2, String dest, Option<List<String>> entries) {
        return this.decompress3(this.cpioMethod().name(), src2, dest, entries, (Function1<String, ArchiveInputStream>)(Function1 & Serializable)src -> new CpioArchiveInputStream(Files.newInputStream(Paths.get(src, new String[0]), new OpenOption[0])));
    }

    public Option<List<String>> cpioDecompress$default$3() {
        return None$.MODULE$;
    }

    public Try<DecompressionStats> deflateDecompress(String src, String dest) {
        return this.decompress2(src, dest, this.deflateMethod());
    }

    public Try<DecompressionStats> bzip2Decompress(String src, String dest) {
        return this.decompress2(src, dest, this.bz2Method());
    }

    public Try<DecompressionStats> gzDecompress(String src, String dest) {
        return this.decompress2(src, dest, this.gzMethod());
    }

    public Try<BoxedUnit> compressStream(Enumeration.Value compressorName, InputStream in, OutputStream out) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DeflateCompressorOutputStream deflateCompressorOutputStream;
            Enumeration.Value value = compressorName;
            Enumeration.Value value2 = Compressors$StreamableCompressor$.MODULE$.DEFLATE();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                deflateCompressorOutputStream = new DeflateCompressorOutputStream(out);
            } else {
                Enumeration.Value value4 = Compressors$StreamableCompressor$.MODULE$.BZ2();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    deflateCompressorOutputStream = new BZip2CompressorOutputStream(out);
                } else {
                    Enumeration.Value value6 = Compressors$StreamableCompressor$.MODULE$.GZ();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        deflateCompressorOutputStream = new GzipCompressorOutputStream(out);
                    } else {
                        Enumeration.Value value8 = Compressors$StreamableCompressor$.MODULE$.PACK200();
                        Enumeration.Value value9 = value;
                        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                            deflateCompressorOutputStream = new Pack200CompressorOutputStream(out);
                        } else {
                            Enumeration.Value value10 = Compressors$StreamableCompressor$.MODULE$.XZ();
                            Enumeration.Value value11 = value;
                            if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                                deflateCompressorOutputStream = new XZCompressorOutputStream(out);
                            } else {
                                Enumeration.Value value12 = Compressors$StreamableCompressor$.MODULE$.ZSTANDARD();
                                Enumeration.Value value13 = value;
                                if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                    deflateCompressorOutputStream = new ZstdCompressorOutputStream(out);
                                } else {
                                    Enumeration.Value value14 = Compressors$StreamableCompressor$.MODULE$.LZMA();
                                    Enumeration.Value value15 = value;
                                    if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                                        deflateCompressorOutputStream = new LZMACompressorOutputStream(out);
                                    } else {
                                        Enumeration.Value value16 = Compressors$StreamableCompressor$.MODULE$.LZ4();
                                        Enumeration.Value value17 = value;
                                        if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
                                            deflateCompressorOutputStream = new FramedLZ4CompressorOutputStream(out);
                                        } else {
                                            Enumeration.Value value18 = Compressors$StreamableCompressor$.MODULE$.SNAPPY();
                                            Enumeration.Value value19 = value;
                                            if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
                                                deflateCompressorOutputStream = new FramedSnappyCompressorOutputStream(out);
                                            } else {
                                                throw new MatchError((Object)value);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            DeflateCompressorOutputStream zStream2 = deflateCompressorOutputStream;
            Util$.MODULE$.autoClose(zStream2, (Function1 & Serializable)zStream -> BoxesRunTime.boxToLong((long)Compressors$.$anonfun$compressStream$2(in, zStream)));
        });
    }

    public Try<BoxedUnit> decompressStream(Enumeration.Value compressorName, InputStream in, OutputStream out) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DeflateCompressorInputStream deflateCompressorInputStream;
            Enumeration.Value value = compressorName;
            Enumeration.Value value2 = Compressors$StreamableCompressor$.MODULE$.DEFLATE();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                deflateCompressorInputStream = new DeflateCompressorInputStream(in);
            } else {
                Enumeration.Value value4 = Compressors$StreamableCompressor$.MODULE$.BZ2();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    deflateCompressorInputStream = new BZip2CompressorInputStream(in);
                } else {
                    Enumeration.Value value6 = Compressors$StreamableCompressor$.MODULE$.GZ();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        deflateCompressorInputStream = new GzipCompressorInputStream(in);
                    } else {
                        Enumeration.Value value8 = Compressors$StreamableCompressor$.MODULE$.PACK200();
                        Enumeration.Value value9 = value;
                        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                            deflateCompressorInputStream = new Pack200CompressorInputStream(in);
                        } else {
                            Enumeration.Value value10 = Compressors$StreamableCompressor$.MODULE$.XZ();
                            Enumeration.Value value11 = value;
                            if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                                deflateCompressorInputStream = new XZCompressorInputStream(in);
                            } else {
                                Enumeration.Value value12 = Compressors$StreamableCompressor$.MODULE$.ZSTANDARD();
                                Enumeration.Value value13 = value;
                                if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                    deflateCompressorInputStream = new ZstdCompressorInputStream(in);
                                } else {
                                    Enumeration.Value value14 = Compressors$StreamableCompressor$.MODULE$.LZMA();
                                    Enumeration.Value value15 = value;
                                    if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                                        deflateCompressorInputStream = new LZMACompressorInputStream(in);
                                    } else {
                                        Enumeration.Value value16 = Compressors$StreamableCompressor$.MODULE$.LZ4();
                                        Enumeration.Value value17 = value;
                                        if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
                                            deflateCompressorInputStream = new FramedLZ4CompressorInputStream(in);
                                        } else {
                                            Enumeration.Value value18 = Compressors$StreamableCompressor$.MODULE$.SNAPPY();
                                            Enumeration.Value value19 = value;
                                            if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
                                                deflateCompressorInputStream = new FramedSnappyCompressorInputStream(in);
                                            } else {
                                                throw new MatchError((Object)value);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            DeflateCompressorInputStream zStream2 = deflateCompressorInputStream;
            Util$.MODULE$.autoClose(zStream2, (Function1 & Serializable)zStream -> BoxesRunTime.boxToLong((long)Compressors$.$anonfun$decompressStream$2(out, zStream)));
        });
    }

    public Try<CompressionStats> gzCompress(String src, String dest) {
        return this.compress2(src, dest, this.gzMethod());
    }

    public Try<DecompressionStats> xzDecompress(String src, String dest) {
        return this.decompress2(src, dest, this.XZMethod());
    }

    private Try<BoxedUnit> checkExtAndDestPath(String src, String dest, String ext, Function0<BoxedUnit> f) {
        return !Util$.MODULE$.isWritableDirectory(dest) ? new Failure((Throwable)new Exception(new StringBuilder(28).append(dest).append(" is not a writable directory").toString())) : (!src.toLowerCase().endsWith(ext) ? new Failure((Throwable)new Exception(new StringBuilder(16).append(src).append(": unknown suffix").toString())) : Try$.MODULE$.apply(f));
    }

    public Try<DecompressionStats> snappyDecompress(String src, String dest) {
        return this.decompress(src, dest, this.snappyMethod(), (Function2<BufferedInputStream, String, BoxedUnit>)(Function2 & Serializable)(b, i) -> {
            Util$.MODULE$.autoClose(new FramedSnappyCompressorInputStream((InputStream)b), (Function1 & Serializable)zOut -> Compressors$.MODULE$.writeStreamToFile((InputStream)zOut, i));
            return BoxedUnit.UNIT;
        });
    }

    private <A> Try<A> checkSrcPath(List<String> src, String dest, Function0<A> f) {
        Failure failure;
        Option<List<String>> option = Util$.MODULE$.fileAccess(src);
        if (option instanceof Some) {
            Some some = (Some)option;
            List e = (List)some.value();
            failure = new Failure((Throwable)new Exception(e.mkString(",")));
        } else if (None$.MODULE$.equals(option)) {
            failure = !Util$.MODULE$.isWritableDirectory(dest) ? new Failure((Throwable)new Exception(new StringBuilder(28).append(dest).append(" is not a writable directory").toString())) : Try$.MODULE$.apply(f);
        } else {
            throw new MatchError(option);
        }
        return failure;
    }

    public Try<BoxedUnit> writeStreamToFile(InputStream in, String dest) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Util$.MODULE$.autoClose(Files.newOutputStream(Paths.get(dest, new String[0]), new OpenOption[0]), (Function1 & Serializable)out -> BoxesRunTime.boxToLong((long)Compressors$.$anonfun$writeStreamToFile$2(in, out))));
    }

    public Try<DecompressionStats> pack200Decompress(String src, String dest) {
        return this.decompress2(src, dest, this.parckMethod());
    }

    public Try<DecompressionStats> zStandardDecompress(String src, String dest) {
        return this.decompress2(src, dest, this.zstandardMethod());
    }

    public Try<CompressionStats> deflateCompress(String src, String dest) {
        return this.compress2(src, dest, this.deflateMethod());
    }

    public Try<CompressionStats> bzip2Compress(String src, String dest) {
        return this.compress2(src, dest, this.bz2Method());
    }

    public Try<CompressionStats> xzCompress(String src, String dest) {
        return this.compress2(src, dest, this.XZMethod());
    }

    public Try<CompressionStats> snappyCompress(String src, String dest) {
        return this.compress(src, dest, this.snappyMethod(), (Function2<BufferedOutputStream, InputStream, BoxedUnit>)(Function2 & Serializable)(b, i) -> {
            Util$.MODULE$.autoClose(new FramedSnappyCompressorOutputStream((OutputStream)b), (Function1 & Serializable)zOut -> BoxesRunTime.boxToLong((long)Compressors$.$anonfun$snappyCompress$2(i, zOut)));
            return BoxedUnit.UNIT;
        });
    }

    public Try<CompressionStats> zStandardCompress(String src, String dest) {
        return this.compress2(src, dest, this.zstandardMethod());
    }

    public Try<CompressionStats> pack200Compress(String src, String dest) {
        return this.compress2(src, dest, this.parckMethod());
    }

    public Try<CompressionStats> sevenZipCompress(List<String> src, String dest) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> src.flatMap((Function1 & Serializable)z -> (List)Util$.MODULE$.getListOfFiles(new File((String)z)).get())).flatMap((Function1 & Serializable)ll -> SevenZip$.MODULE$.sevenZipCompress((List<Tuple2<File, Object>>)ll, dest, SevenZip$.MODULE$.sevenZipCompress$default$3()));
    }

    public Try<CompressionStats> arCompress(List<String> src, String dest) {
        Try try_;
        Option<List<String>> option = Util$.MODULE$.fileAccess(src);
        if (option instanceof Some) {
            Some some = (Some)option;
            List e = (List)some.value();
            try_ = new Failure((Throwable)new Exception(e.mkString(",")));
        } else if (None$.MODULE$.equals(option)) {
            try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> src.flatMap((Function1 & Serializable)z -> (List)Util$.MODULE$.getListOfFiles(new File((String)z)).get())).flatMap((Function1 & Serializable)ll -> MODULE$.compress3(MODULE$.arMethod().name(), (List<Tuple2<File, Object>>)ll, dest, (Function1<OutputStream, ArchiveOutputStream>)(Function1 & Serializable)out -> Compressors$.f$3(out), (Function2<File, String, ArchiveEntry>)(Function2 & Serializable)(f, s) -> Compressors$.g$2(f, s)));
        } else {
            throw new MatchError(option);
        }
        return try_;
    }

    public Try<CompressionStats> cpioCompress(List<String> src, String dest) {
        Try try_;
        Option<List<String>> option = Util$.MODULE$.fileAccess(src);
        if (option instanceof Some) {
            Some some = (Some)option;
            List e = (List)some.value();
            try_ = new Failure((Throwable)new Exception(e.mkString(",")));
        } else if (None$.MODULE$.equals(option)) {
            try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> src.flatMap((Function1 & Serializable)z -> (List)Util$.MODULE$.getListOfFiles(new File((String)z)).get())).flatMap((Function1 & Serializable)ll -> MODULE$.compress3(MODULE$.cpioMethod().name(), (List<Tuple2<File, Object>>)ll, dest, (Function1<OutputStream, ArchiveOutputStream>)(Function1 & Serializable)out -> Compressors$.f$4(out), (Function2<File, String, ArchiveEntry>)(Function2 & Serializable)(f, s) -> Compressors$.g$3(f, s)));
        } else {
            throw new MatchError(option);
        }
        return try_;
    }

    public Try<DecompressionStats> decompress(String src, String dest, Compressors.CompressionMethod method, Function2<BufferedInputStream, String, BoxedUnit> ff) {
        long start = System.currentTimeMillis();
        String fileOut = new StringBuilder(0).append(dest).append(Util$.MODULE$.SEP()).append(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(new File(src).getName()), method.ext().length())).toString();
        return this.checkExtAndDestPath(src, dest, method.ext(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> Util$.MODULE$.autoClose(new BufferedInputStream(Files.newInputStream(Paths.get(src, new String[0]), new OpenOption[0])), (Function1 & Serializable)x -> {
            ff.apply((Object)x, (Object)fileOut);
            return BoxedUnit.UNIT;
        })).flatMap((Function1 & Serializable)x$1 -> DecompressionStats$.MODULE$.apply(method.name(), src, (List<String>)((List)new .colon.colon((Object)fileOut, (List)Nil$.MODULE$)), System.currentTimeMillis() - start));
    }

    public Try<DecompressionStats> decompress2(String src, String dest, Compressors.CompressionMethod method) {
        long start = System.currentTimeMillis();
        String fileOut = new StringBuilder(0).append(dest).append(Util$.MODULE$.SEP()).append(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(new File(src).getName()), method.ext().length())).toString();
        return this.checkExtAndDestPath(src, dest, method.ext(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> Util$.MODULE$.autoClose(Files.newInputStream(new File(src).toPath(), new OpenOption[0]), (Function1 & Serializable)is -> BoxesRunTime.boxToLong((long)Compressors$.$anonfun$decompress2$2(method, fileOut, is)))).flatMap((Function1 & Serializable)x$2 -> DecompressionStats$.MODULE$.apply(method.name(), src, (List<String>)((List)new .colon.colon((Object)fileOut, (List)Nil$.MODULE$)), System.currentTimeMillis() - start));
    }

    public Try<CompressionStats> compress2(String src, String dest, Compressors.CompressionMethod method) {
        long start = System.currentTimeMillis();
        return this.checkSrcPath((List<String>)((List)new .colon.colon((Object)src, (List)Nil$.MODULE$)), dest, (Function0 & Serializable)() -> {
            String zFile = new StringBuilder(0).append(dest).append(Util$.MODULE$.SEP()).append(new File(src).getName()).append(method.ext()).toString();
            return (String)Util$.MODULE$.autoClose(Files.newOutputStream(new File(zFile).toPath(), new OpenOption[0]), (Function1 & Serializable)out -> (String)Util$.MODULE$.autoClose(new CompressorStreamFactory().createCompressorOutputStream((String)method.factory().get(), out), (Function1 & Serializable)cos -> {
                InputStream in = Files.newInputStream(new File(src).toPath(), new OpenOption[0]);
                IOUtils.copy((InputStream)in, (OutputStream)cos);
                return zFile;
            }));
        }).flatMap((Function1 & Serializable)zFile -> CompressionStats$.MODULE$.apply(method.name(), (List<String>)((List)new .colon.colon((Object)src, (List)Nil$.MODULE$)), (String)zFile, System.currentTimeMillis() - start));
    }

    public Try<CompressionStats> compress3(String name, List<Tuple2<File, Object>> src, String outDir2, Function1<OutputStream, ArchiveOutputStream> ar, Function2<File, String, ArchiveEntry> entryf) {
        long start = System.currentTimeMillis();
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            List ll = src.map((Function1 & Serializable)d -> new Tuple2(d._1(), (Object)((File)d._1()).getAbsolutePath().substring(d._2$mcI$sp() + 1)));
            List<String> list = Util$.MODULE$.duplicate((List<String>)ll.map((Function1 & Serializable)x$3 -> (String)x$3._2()));
            if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                String x = (String)colon2.head();
                List xs = colon2.next$access$1();
                String string = x;
                throw new Exception(new StringBuilder(17).append("Duplicate files: ").append(xs.$colon$colon((Object)string).mkString(",")).toString());
            }
            String string = (String)Util$.MODULE$.autoClose(new FileOutputStream(new File(outDir2)), (Function1 & Serializable)out -> {
                Util$.MODULE$.autoClose((AutoCloseable)ar.apply(out), (Function1 & Serializable)arOutput -> {
                    ll.foreach((Function1 & Serializable)file -> {
                        Compressors$.$anonfun$compress3$6(entryf$1, arOutput, file);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                return outDir2;
            });
            return string;
        }).flatMap((Function1 & Serializable)outDir -> CompressionStats$.MODULE$.apply(name, (List<String>)src.map((Function1 & Serializable)x$4 -> ((File)x$4._1()).getAbsolutePath()), (String)outDir, System.currentTimeMillis() - start));
    }

    public Try<CompressionStats> compress(String src, String dest, Compressors.CompressionMethod method, Function2<BufferedOutputStream, InputStream, BoxedUnit> compressor) {
        long start = System.currentTimeMillis();
        return this.checkSrcPath((List<String>)((List)new .colon.colon((Object)src, (List)Nil$.MODULE$)), dest, (Function0 & Serializable)() -> {
            String zFile = new StringBuilder(0).append(dest).append(Util$.MODULE$.SEP()).append(new File(src).getName()).append(method.ext()).toString();
            return (String)Util$.MODULE$.autoClose(Files.newInputStream(Paths.get(src, new String[0]), new OpenOption[0]), (Function1 & Serializable)in -> (String)Util$.MODULE$.autoClose(Files.newOutputStream(Paths.get(zFile, new String[0]), new OpenOption[0]), (Function1 & Serializable)fout -> {
                Util$.MODULE$.autoClose(new BufferedOutputStream((OutputStream)fout), (Function1 & Serializable)out -> {
                    compressor.apply((Object)out, (Object)in);
                    return BoxedUnit.UNIT;
                });
                return zFile;
            }));
        }).flatMap((Function1 & Serializable)zFile -> CompressionStats$.MODULE$.apply(method.name(), (List<String>)((List)new .colon.colon((Object)src, (List)Nil$.MODULE$)), (String)zFile, System.currentTimeMillis() - start));
    }

    public static final /* synthetic */ long $anonfun$lz4Compress$2(InputStream i$2, LZ4FrameOutputStream zOut) {
        return IOUtils.copy((InputStream)i$2, (OutputStream)zOut);
    }

    /*
     * WARNING - void declaration
     */
    private static final TarArchiveOutputStream f$1(OutputStream out) {
        void var1_1;
        TarArchiveOutputStream ar = new TarArchiveOutputStream(out);
        ar.setLongFileMode(3);
        return var1_1;
    }

    private static final TarArchiveEntry g$1(File f, String s) {
        return new TarArchiveEntry(f, s);
    }

    public static final /* synthetic */ long $anonfun$compressStream$2(InputStream in$1, CompressorOutputStream zStream) {
        return IOUtils.copy((InputStream)in$1, (OutputStream)zStream);
    }

    public static final /* synthetic */ long $anonfun$decompressStream$2(OutputStream out$2, CompressorInputStream zStream) {
        return IOUtils.copy((InputStream)zStream, (OutputStream)out$2);
    }

    public static final /* synthetic */ long $anonfun$writeStreamToFile$2(InputStream in$3, OutputStream out) {
        return IOUtils.copy((InputStream)in$3, (OutputStream)out);
    }

    public static final /* synthetic */ long $anonfun$snappyCompress$2(InputStream i$4, FramedSnappyCompressorOutputStream zOut) {
        return IOUtils.copy((InputStream)i$4, (OutputStream)zOut);
    }

    private static final ArArchiveOutputStream f$3(OutputStream out) {
        return new ArArchiveOutputStream(out);
    }

    private static final ArArchiveEntry g$2(File f, String s) {
        return new ArArchiveEntry(f, s);
    }

    private static final CpioArchiveOutputStream f$4(OutputStream out) {
        return new CpioArchiveOutputStream(out);
    }

    private static final CpioArchiveEntry g$3(File f, String s) {
        return new CpioArchiveEntry(f, s);
    }

    public static final /* synthetic */ long $anonfun$decompress2$3(String fileOut$2, CompressorInputStream in) {
        return IOUtils.copy((InputStream)in, (OutputStream)Files.newOutputStream(new File(fileOut$2).toPath(), new OpenOption[0]));
    }

    public static final /* synthetic */ long $anonfun$decompress2$2(Compressors.CompressionMethod method$2, String fileOut$2, InputStream is) {
        return BoxesRunTime.unboxToLong(Util$.MODULE$.autoClose(new CompressorStreamFactory().createCompressorInputStream((String)method$2.factory().get(), is), (Function1 & Serializable)in -> BoxesRunTime.boxToLong((long)Compressors$.$anonfun$decompress2$3(fileOut$2, in))));
    }

    public static final /* synthetic */ long $anonfun$compress3$7(ArchiveOutputStream arOutput$1, FileInputStream ii) {
        return IOUtils.copy((InputStream)ii, (OutputStream)arOutput$1);
    }

    public static final /* synthetic */ void $anonfun$compress3$6(Function2 entryf$1, ArchiveOutputStream arOutput$1, Tuple2 file) {
        ArchiveEntry entry = (ArchiveEntry)entryf$1.apply(file._1(), file._2());
        arOutput$1.putArchiveEntry(entry);
        Object object = !((File)file._1()).isDirectory() ? Util$.MODULE$.autoClose(new FileInputStream((File)file._1()), (Function1 & Serializable)ii -> BoxesRunTime.boxToLong((long)Compressors$.$anonfun$compress3$7(arOutput$1, ii))) : BoxedUnit.UNIT;
        arOutput$1.closeArchiveEntry();
    }

    private Compressors$() {
    }
}

