/*
 * Decompiled with CFR 0.152.
 */
package com.github.gekomad.scalacompress;

import com.github.gekomad.scalacompress.CompressionStats;
import com.github.gekomad.scalacompress.CompressionStats$;
import com.github.gekomad.scalacompress.Compressors$;
import com.github.gekomad.scalacompress.DecompressionStats;
import com.github.gekomad.scalacompress.DecompressionStats$;
import com.github.gekomad.scalacompress.Util$;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Zip$ {
    public static final Zip$ MODULE$ = new Zip$();

    public Try<byte[]> zipDecompressEntry(String zipFileName, String entryName, int bufferSize) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> (byte[])Util$.MODULE$.autoClose(new ZipFile(zipFileName), (Function1 & Serializable)zipFile -> {
            ZipEntry entry = zipFile.getEntry(entryName);
            InputStream inputStream = zipFile.getInputStream(entry);
            byte[] readBuffer = new byte[bufferSize];
            int read = inputStream.read(readBuffer, 0, readBuffer.length);
            inputStream.close();
            return Arrays.copyOf(readBuffer, read);
        }));
    }

    public Try<CompressionStats> zipCompress(List<String> src, String dest) {
        Failure failure;
        Option<List<String>> option = Util$.MODULE$.fileAccess(src);
        if (option instanceof Some) {
            Some some = (Some)option;
            List e = (List)some.value();
            failure = new Failure((Throwable)new Exception(e.mkString(",")));
        } else if (None$.MODULE$.equals(option)) {
            File file = new File(dest);
            Object object = Util$.MODULE$.isWritableDirectory(dest) ? (src.size() == 1 ? new Success((Object)new StringBuilder(0).append(dest).append(Util$.MODULE$.SEP()).append(new File((String)src.head()).getName()).append(Compressors$.MODULE$.zipMethod().ext()).toString()) : new Success((Object)new StringBuilder(0).append(dest).append(Util$.MODULE$.SEP()).append(file.getName()).append(Compressors$.MODULE$.zipMethod().ext()).toString())) : (Util$.MODULE$.isWritableDirectory(file.getParent()) ? new Success((Object)file.getAbsolutePath()) : new Failure((Throwable)new Exception(new StringBuilder(11).append("file error ").append(dest).toString())));
            Success a = object;
            failure = a.flatMap((Function1 & Serializable)fileOut -> {
                long start = System.currentTimeMillis();
                Try b = Try$.MODULE$.apply((Function0 & Serializable)() -> src.flatMap((Function1 & Serializable)z -> (List)Util$.MODULE$.getListOfFiles(new File((String)z)).get())).flatMap((Function1 & Serializable)ll -> Compressors$.MODULE$.compress3(Compressors$.MODULE$.zipMethod().name().toString(), (List<Tuple2<File, Object>>)ll, (String)fileOut, (Function1<OutputStream, ArchiveOutputStream>)(Function1 & Serializable)out -> Zip$.f$1(out), (Function2<File, String, ArchiveEntry>)(Function2 & Serializable)(f, s) -> Zip$.g$1(f, s)));
                return b.flatMap((Function1 & Serializable)x$1 -> CompressionStats$.MODULE$.apply(Compressors$.MODULE$.zipMethod().name().toString(), src, (String)fileOut, System.currentTimeMillis() - start));
            });
        } else {
            throw new MatchError(option);
        }
        return failure;
    }

    public Try<DecompressionStats> zipDecompress(String src, String dest) {
        long start = System.currentTimeMillis();
        return Try$.MODULE$.apply((Function0 & Serializable)() -> (List)Util$.MODULE$.autoClose(new ZipFile(src), (Function1 & Serializable)zipFile -> {
            List filesOut = Util$.MODULE$.javaIteratorToList(zipFile.entries().asIterator()).map((Function1 & Serializable)f -> {
                ZipEntry entry = zipFile.getEntry(f.getName());
                InputStream content = zipFile.getInputStream(entry);
                String fileOut = new StringBuilder(0).append(dest).append(Util$.MODULE$.SEP()).append(f.getName()).toString();
                File fo = new File(fileOut);
                Files.createDirectories(fo.getParentFile().toPath(), new FileAttribute[0]);
                Comparable<Path> comparable = entry.isDirectory() ? Files.createDirectories(fo.toPath(), new FileAttribute[0]) : BoxesRunTime.boxToLong((long)Files.copy(content, Paths.get(fileOut, new String[0]), StandardCopyOption.REPLACE_EXISTING));
                return fileOut;
            });
            return filesOut.toList();
        })).flatMap((Function1 & Serializable)filesOut -> DecompressionStats$.MODULE$.apply(Compressors$.MODULE$.zipMethod().name().toString(), src, (List<String>)filesOut, System.currentTimeMillis() - start));
    }

    public int zipDecompressEntry$default$3() {
        return 4096;
    }

    private static final ArchiveOutputStream f$1(OutputStream out) {
        return new ArchiveStreamFactory().createArchiveOutputStream("zip", out);
    }

    private static final ZipArchiveEntry g$1(File f, String s) {
        return new ZipArchiveEntry(f, s);
    }

    private Zip$() {
    }
}

