/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.hocon;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigValue;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.github.gestalt.config.entity.ConfigNodeContainer;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.loader.ConfigLoader;
import org.github.gestalt.config.node.ArrayNode;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.utils.PathUtil;
import org.github.gestalt.config.utils.ValidateOf;

public class HoconLoader
implements ConfigLoader {
    private final ConfigParseOptions configParseOptions;

    public HoconLoader() {
        this.configParseOptions = ConfigParseOptions.defaults();
    }

    public HoconLoader(ConfigParseOptions configParseOptions) {
        this.configParseOptions = configParseOptions;
    }

    public String name() {
        return "HoconLoader";
    }

    public boolean accepts(String format) {
        return "conf".equals(format);
    }

    public ValidateOf<List<ConfigNodeContainer>> loadSource(ConfigSource source) throws GestaltException {
        if (source.hasStream()) {
            try {
                Config config = ConfigFactory.parseReader((Reader)new InputStreamReader(source.loadStream(), StandardCharsets.UTF_8), (ConfigParseOptions)this.configParseOptions);
                config = config.resolve();
                if (config == null) {
                    throw new GestaltException("Exception loading source: " + source.name() + " no hocon found");
                }
                ValidateOf<ConfigNode> node = this.buildConfigTree("", (ConfigValue)config.root());
                if (node.hasResults()) {
                    return ValidateOf.validateOf(List.of(new ConfigNodeContainer((ConfigNode)node.results(), source)), (List)node.getErrors());
                }
                return ValidateOf.inValid((List)node.getErrors());
            }
            catch (ConfigException | NullPointerException e) {
                throw new GestaltException("Exception loading source: " + source.name(), (Exception)e);
            }
        }
        throw new GestaltException("HOCON Config source: " + source.name() + " does not have a stream to load.");
    }

    private ValidateOf<ConfigNode> buildConfigTree(String path, ConfigValue configObject) {
        switch (configObject.valueType()) {
            case LIST: {
                return this.buildArrayConfigTree(path, (ConfigList)configObject);
            }
            case OBJECT: {
                return this.buildObjectConfigTree(path, (ConfigObject)configObject);
            }
            case STRING: 
            case BOOLEAN: 
            case NUMBER: {
                return ValidateOf.valid((Object)new LeafNode(configObject.unwrapped().toString()));
            }
            case NULL: {
                return ValidateOf.inValid((ValidationError)new ValidationError.NoResultsFoundForPath(path));
            }
        }
        return ValidateOf.inValid((ValidationError)new ValidationError.UnknownNodeTypeDuringLoad(path, configObject.valueType().name()));
    }

    private String normalizeSentence(String sentence) {
        return sentence.toLowerCase();
    }

    private ValidateOf<ConfigNode> buildArrayConfigTree(String path, ConfigList configList) {
        ArrayList errors = new ArrayList();
        ArrayList array = new ArrayList();
        AtomicInteger index = new AtomicInteger(0);
        configList.forEach(it -> {
            String currentPath = PathUtil.pathForIndex((String)path, (int)index.getAndIncrement());
            ValidateOf<ConfigNode> node = this.buildConfigTree(currentPath, (ConfigValue)it);
            errors.addAll(node.getErrors());
            if (!node.hasResults()) {
                errors.add(new ValidationError.NoResultsFoundForPath(currentPath));
            } else {
                array.add((ConfigNode)node.results());
            }
        });
        ArrayNode arrayNode = new ArrayNode(array);
        return ValidateOf.validateOf((Object)arrayNode, errors);
    }

    private ValidateOf<ConfigNode> buildObjectConfigTree(String path, ConfigObject configObject) {
        ArrayList errors = new ArrayList();
        HashMap mapNode = new HashMap();
        configObject.forEach((key, value) -> {
            String newPath = this.normalizeSentence((String)key);
            String currentPath = PathUtil.pathForKey((String)path, (String)key);
            ValidateOf<ConfigNode> node = this.buildConfigTree(currentPath, (ConfigValue)value);
            errors.addAll(node.getErrors());
            if (!node.hasResults()) {
                errors.add(new ValidationError.NoResultsFoundForPath(currentPath));
            } else {
                mapNode.put(newPath, (ConfigNode)node.results());
            }
        });
        MapNode mapConfigNode = new MapNode(mapNode);
        return ValidateOf.validateOf((Object)mapConfigNode, errors);
    }
}

