/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.aws.s3;

import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.Pair;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;

public class S3ConfigSource
implements ConfigSource {
    private final S3Client s3;
    private final String keyName;
    private final String bucketName;
    private final UUID id = UUID.randomUUID();
    private final Tags tags;

    public S3ConfigSource(S3Client s3, String bucketName, String keyName) throws GestaltException {
        this(s3, bucketName, keyName, Tags.of());
    }

    public S3ConfigSource(S3Client s3, String bucketName, String keyName, Tags tags) throws GestaltException {
        if (s3 == null) {
            throw new GestaltException("S3 client can not be null");
        }
        if (bucketName == null) {
            throw new GestaltException("S3 bucketName can not be null");
        }
        if (keyName == null) {
            throw new GestaltException("S3 keyName can not be null");
        }
        this.s3 = s3;
        this.keyName = keyName;
        this.bucketName = bucketName;
        this.tags = tags;
    }

    public boolean hasStream() {
        return true;
    }

    public InputStream loadStream() throws GestaltException {
        try {
            GetObjectRequest objectRequest = (GetObjectRequest)GetObjectRequest.builder().key(this.keyName).bucket(this.bucketName).build();
            ResponseBytes objectBytes = this.s3.getObjectAsBytes(objectRequest);
            return objectBytes.asInputStream();
        }
        catch (S3Exception e) {
            throw new GestaltException("Exception loading S3 key: " + this.keyName + ", bucket: " + this.bucketName + ", with error:" + e.awsErrorDetails().errorMessage(), (Exception)((Object)e));
        }
    }

    public boolean hasList() {
        return false;
    }

    public List<Pair<String, String>> loadList() throws GestaltException {
        throw new GestaltException("Unsupported operation loadList on an S3ConfigSource");
    }

    public String format() {
        return this.format(this.keyName);
    }

    protected String format(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index > 0) {
            return fileName.substring(index + 1);
        }
        return "";
    }

    public String name() {
        return "S3 Config Source key: " + this.keyName + ", bucket: " + this.bucketName;
    }

    public UUID id() {
        return this.id;
    }

    public Tags getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof S3ConfigSource)) {
            return false;
        }
        S3ConfigSource that = (S3ConfigSource)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

