/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.toml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.toml.TomlFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.github.gestalt.config.entity.ConfigNodeContainer;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.loader.ConfigLoader;
import org.github.gestalt.config.node.ArrayNode;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.utils.PathUtil;
import org.github.gestalt.config.utils.ValidateOf;

public class TomlLoader
implements ConfigLoader {
    private final ObjectMapper objectMapper;

    public TomlLoader(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public TomlLoader() {
        this.objectMapper = new ObjectMapper((JsonFactory)new TomlFactory());
        this.objectMapper.findAndRegisterModules();
    }

    public String name() {
        return "tomlLoader";
    }

    public boolean accepts(String format) {
        return "toml".equals(format);
    }

    public ValidateOf<List<ConfigNodeContainer>> loadSource(ConfigSource source) throws GestaltException {
        if (source.hasStream()) {
            try {
                JsonNode jsonNode = this.objectMapper.readTree(source.loadStream());
                if (jsonNode == null || jsonNode.isNull()) {
                    throw new GestaltException("Exception loading source: " + source.name() + " no yaml found");
                }
                ValidateOf<ConfigNode> node = this.buildConfigTree("", jsonNode);
                if (node.hasResults()) {
                    return ValidateOf.validateOf(List.of(new ConfigNodeContainer((ConfigNode)node.results(), source)), (List)node.getErrors());
                }
                return ValidateOf.inValid((List)node.getErrors());
            }
            catch (IOException | NullPointerException e) {
                throw new GestaltException("Exception loading source: " + source.name(), e);
            }
        }
        throw new GestaltException("Config source: " + source.name() + " does not have a stream to load.");
    }

    private ValidateOf<ConfigNode> buildConfigTree(String path, JsonNode jsonNode) {
        switch (jsonNode.getNodeType()) {
            case ARRAY: {
                return this.buildArrayConfigTree(path, jsonNode);
            }
            case OBJECT: 
            case POJO: {
                return this.buildObjectConfigTree(path, jsonNode);
            }
            case STRING: 
            case BINARY: 
            case BOOLEAN: 
            case NUMBER: {
                return ValidateOf.valid((Object)new LeafNode(jsonNode.asText()));
            }
            case MISSING: 
            case NULL: {
                return ValidateOf.inValid((ValidationError)new ValidationError.NoResultsFoundForPath(path));
            }
        }
        return ValidateOf.inValid((ValidationError)new ValidationError.UnknownNodeTypeDuringLoad(path, jsonNode.getNodeType().name()));
    }

    private String normalizeSentence(String sentence) {
        return sentence.toLowerCase();
    }

    private ValidateOf<ConfigNode> buildArrayConfigTree(String path, JsonNode jsonNode) {
        ArrayList<ValidationError.NoResultsFoundForPath> errors = new ArrayList<ValidationError.NoResultsFoundForPath>();
        ArrayList<ConfigNode> array = new ArrayList<ConfigNode>();
        int arraySize = jsonNode.size();
        for (int i = 0; i < arraySize; ++i) {
            String currentPath = PathUtil.pathForIndex((String)path, (int)i);
            JsonNode arrayNodes = jsonNode.get(i);
            ValidateOf<ConfigNode> node = this.buildConfigTree(currentPath, arrayNodes);
            errors.addAll(node.getErrors());
            if (!node.hasResults()) {
                errors.add(new ValidationError.NoResultsFoundForPath(currentPath));
                continue;
            }
            array.add((ConfigNode)node.results());
        }
        ArrayNode arrayNode = new ArrayNode(array);
        return ValidateOf.validateOf((Object)arrayNode, errors);
    }

    private ValidateOf<ConfigNode> buildObjectConfigTree(String path, JsonNode jsonNode) {
        ArrayList<ValidationError.NoResultsFoundForPath> errors = new ArrayList<ValidationError.NoResultsFoundForPath>();
        HashMap<String, ConfigNode> mapNode = new HashMap<String, ConfigNode>();
        Iterator it = jsonNode.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String key = this.normalizeSentence((String)entry.getKey());
            JsonNode jsonValue = (JsonNode)entry.getValue();
            String currentPath = PathUtil.pathForKey((String)path, (String)key);
            ValidateOf<ConfigNode> node = this.buildConfigTree(currentPath, jsonValue);
            errors.addAll(node.getErrors());
            if (!node.hasResults()) {
                errors.add(new ValidationError.NoResultsFoundForPath(currentPath));
                continue;
            }
            mapNode.put(key, (ConfigNode)node.results());
        }
        MapNode mapConfigNode = new MapNode(mapNode);
        return ValidateOf.validateOf((Object)mapConfigNode, errors);
    }
}

