/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.toml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.toml.TomlFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.github.gestalt.config.entity.ConfigNodeContainer;
import org.github.gestalt.config.entity.GestaltConfig;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.lexer.PathLexer;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.loader.ConfigLoader;
import org.github.gestalt.config.node.ArrayNode;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.source.ConfigSourcePackage;
import org.github.gestalt.config.toml.TomlModuleConfig;
import org.github.gestalt.config.utils.GResultOf;
import org.github.gestalt.config.utils.PathUtil;

public final class TomlLoader
implements ConfigLoader {
    private final boolean isDefault;
    private ObjectMapper objectMapper;
    private SentenceLexer lexer;

    public TomlLoader() {
        this(new ObjectMapper((JsonFactory)new TomlFactory()).findAndRegisterModules(), (SentenceLexer)new PathLexer(), true);
    }

    public TomlLoader(ObjectMapper objectMapper, SentenceLexer lexer) {
        this(objectMapper, lexer, false);
    }

    private TomlLoader(ObjectMapper objectMapper, SentenceLexer lexer, boolean isDefault) {
        Objects.requireNonNull(lexer, "TomlLoader SentenceLexer should not be null");
        Objects.requireNonNull(objectMapper, "TomlLoader ObjectMapper should not be null");
        this.objectMapper = objectMapper;
        this.lexer = lexer;
        this.isDefault = isDefault;
    }

    public void applyConfig(GestaltConfig config) {
        TomlModuleConfig moduleConfig = (TomlModuleConfig)config.getModuleConfig(TomlModuleConfig.class);
        if (this.isDefault) {
            this.lexer = moduleConfig != null && moduleConfig.getLexer() != null ? moduleConfig.getLexer() : config.getSentenceLexer();
        }
        if (this.isDefault && moduleConfig != null && moduleConfig.getObjectMapper() != null) {
            this.objectMapper = moduleConfig.getObjectMapper();
        }
    }

    public String name() {
        return "tomlLoader";
    }

    public boolean accepts(String format) {
        return "toml".equals(format);
    }

    public GResultOf<List<ConfigNodeContainer>> loadSource(ConfigSourcePackage sourcePackage) throws GestaltException {
        ConfigSource source = sourcePackage.getConfigSource();
        if (source.hasStream()) {
            GResultOf gResultOf;
            block10: {
                InputStream is = source.loadStream();
                try {
                    JsonNode jsonNode = this.objectMapper.readTree(is);
                    if (jsonNode == null || jsonNode.isNull()) {
                        throw new GestaltException("Exception loading source: " + source.name() + " no yaml found");
                    }
                    GResultOf<ConfigNode> node = this.buildConfigTree("", jsonNode);
                    gResultOf = node.mapWithError(result -> List.of(new ConfigNodeContainer(result, source, sourcePackage.getTags())));
                    if (is == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | NullPointerException e) {
                        throw new GestaltException("Exception loading source: " + source.name(), e);
                    }
                }
                is.close();
            }
            return gResultOf;
        }
        throw new GestaltException("Config source: " + source.name() + " does not have a stream to load.");
    }

    private GResultOf<ConfigNode> buildConfigTree(String path, JsonNode jsonNode) {
        switch (jsonNode.getNodeType()) {
            case ARRAY: {
                return this.buildArrayConfigTree(path, jsonNode);
            }
            case OBJECT: 
            case POJO: {
                return this.buildObjectConfigTree(path, jsonNode);
            }
            case STRING: 
            case BINARY: 
            case BOOLEAN: 
            case NUMBER: {
                return GResultOf.result((Object)new LeafNode(jsonNode.asText()));
            }
            case MISSING: 
            case NULL: {
                return GResultOf.errors((ValidationError)new ValidationError.NoResultsFoundForPath(path));
            }
        }
        return GResultOf.errors((ValidationError)new ValidationError.UnknownNodeTypeDuringLoad(path, jsonNode.getNodeType().name()));
    }

    private String normalizeSentence(String sentence) {
        return this.lexer.normalizeSentence(sentence);
    }

    private List<String> tokenizer(String sentence) {
        return this.lexer.tokenizer(sentence);
    }

    private GResultOf<ConfigNode> buildArrayConfigTree(String path, JsonNode jsonNode) {
        ArrayList<ValidationError.NoResultsFoundForPath> errors = new ArrayList<ValidationError.NoResultsFoundForPath>();
        ArrayList<ConfigNode> array = new ArrayList<ConfigNode>();
        int arraySize = jsonNode.size();
        for (int i = 0; i < arraySize; ++i) {
            String currentPath = PathUtil.pathForIndex((SentenceLexer)this.lexer, (String)path, (int)i);
            JsonNode arrayNodes = jsonNode.get(i);
            GResultOf<ConfigNode> node = this.buildConfigTree(currentPath, arrayNodes);
            errors.addAll(node.getErrors());
            if (!node.hasResults()) {
                errors.add(new ValidationError.NoResultsFoundForPath(currentPath));
                continue;
            }
            array.add((ConfigNode)node.results());
        }
        ArrayNode arrayNode = new ArrayNode(array);
        return GResultOf.resultOf((Object)arrayNode, errors);
    }

    private GResultOf<ConfigNode> buildObjectConfigTree(String path, JsonNode jsonNode) {
        ArrayList<ValidationError.NoResultsFoundForPath> errors = new ArrayList<ValidationError.NoResultsFoundForPath>();
        HashMap<String, ConfigNode> mapNode = new HashMap<String, ConfigNode>();
        Iterator it = jsonNode.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            List<String> tokenList = this.tokenizer((String)entry.getKey());
            tokenList = tokenList.stream().map(this::normalizeSentence).collect(Collectors.toList());
            String currentPath = PathUtil.pathForKey((SentenceLexer)this.lexer, (String)path, tokenList);
            JsonNode jsonValue = (JsonNode)entry.getValue();
            GResultOf<ConfigNode> node = this.buildConfigTree(currentPath, jsonValue);
            errors.addAll(node.getErrors());
            if (!node.hasResults()) {
                errors.add(new ValidationError.NoResultsFoundForPath(currentPath));
                continue;
            }
            ConfigNode currentNode = (ConfigNode)node.results();
            for (int i = tokenList.size() - 1; i > 0; --i) {
                HashMap<String, ConfigNode> nextMapNode = new HashMap<String, ConfigNode>();
                nextMapNode.put(tokenList.get(i), currentNode);
                currentNode = new MapNode(nextMapNode);
            }
            mapNode.put(tokenList.get(0), currentNode);
        }
        MapNode mapConfigNode = new MapNode(mapNode);
        return GResultOf.resultOf((Object)mapConfigNode, errors);
    }
}

