/*
 * Decompiled with CFR 0.152.
 */
package caliban.validation;

import caliban.CalibanError;
import caliban.Rendering$;
import caliban.introspection.adt.__DeprecatedArgs;
import caliban.introspection.adt.__Field;
import caliban.introspection.adt.__Type;
import caliban.introspection.adt.__TypeKind;
import caliban.introspection.adt.__TypeKind$INTERFACE$;
import caliban.introspection.adt.__TypeKind$OBJECT$;
import caliban.introspection.adt.__TypeKind$UNION$;
import caliban.parsing.adt.Document;
import caliban.parsing.adt.ExecutableDefinition;
import caliban.parsing.adt.OperationType;
import caliban.parsing.adt.OperationType$Mutation$;
import caliban.parsing.adt.OperationType$Query$;
import caliban.parsing.adt.OperationType$Subscription$;
import caliban.parsing.adt.Selection;
import caliban.parsing.adt.Type;
import caliban.schema.RootType;
import caliban.schema.Types$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.TraversableLike;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import zio.IO$;
import zio.ZIO;

public final class Validator$ {
    public static Validator$ MODULE$;

    static {
        new Validator$();
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validate(Document document, RootType rootType) {
        List<ExecutableDefinition.OperationDefinition> operations = this.collectOperations(document);
        return this.validateOperationNameUniqueness(operations).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.validateLoneAnonymousOperation(operations).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.validateSubscriptionOperation(operations).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> {
            Map<String, __Type> typesForFragments = MODULE$.collectTypesValidForFragments(rootType);
            return MODULE$.validateDocumentFields(document, rootType, typesForFragments);
        })));
    }

    private List<ExecutableDefinition.OperationDefinition> collectOperations(Document document) {
        return (List)document.definitions().collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ExecutableDefinition, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object = x1 instanceof ExecutableDefinition.OperationDefinition ? (ExecutableDefinition.OperationDefinition)x1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(ExecutableDefinition x1) {
                boolean bl = x1 instanceof ExecutableDefinition.OperationDefinition;
                return bl;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    private Map<String, __Type> collectTypesValidForFragments(RootType rootType) {
        return (Map)rootType.types().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$collectTypesValidForFragments$1(x0$1)));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateDocumentFields(Document document, RootType rootType, Map<String, __Type> typesForFragments) {
        return IO$.MODULE$.foreach(document.definitions(), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ZIO zIO;
            if (x0$1 instanceof ExecutableDefinition.OperationDefinition) {
                ZIO zIO2;
                ExecutableDefinition.OperationDefinition operationDefinition = (ExecutableDefinition.OperationDefinition)x0$1;
                OperationType opType = operationDefinition.operationType();
                List<Selection> selectionSet = operationDefinition.selectionSet();
                if (OperationType$Query$.MODULE$.equals(opType)) {
                    zIO2 = MODULE$.validateFields(selectionSet, rootType.queryType());
                } else if (OperationType$Mutation$.MODULE$.equals(opType)) {
                    zIO2 = (ZIO)rootType.mutationType().fold((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.fail((Object)new CalibanError.ValidationError("Mutation operations are not supported on this schema.", "")), (Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.validateFields(selectionSet, (__Type)x$3));
                } else if (OperationType$Subscription$.MODULE$.equals(opType)) {
                    zIO2 = (ZIO)rootType.subscriptionType().fold((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.fail((Object)new CalibanError.ValidationError("Subscription operations are not supported on this schema.", "")), (Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.validateFields(selectionSet, (__Type)x$4));
                } else {
                    throw new MatchError((Object)opType);
                }
                zIO = zIO2;
            } else if (x0$1 instanceof ExecutableDefinition.FragmentDefinition) {
                ExecutableDefinition.FragmentDefinition fragmentDefinition = (ExecutableDefinition.FragmentDefinition)x0$1;
                String name = fragmentDefinition.name();
                Type.NamedType typeCondition = fragmentDefinition.typeCondition();
                List<Selection> selectionSet = fragmentDefinition.selectionSet();
                zIO = (ZIO)typesForFragments.get((Object)typeCondition.name()).map((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.validateFields(selectionSet, (__Type)x$5)).getOrElse((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(40).append("Fragment '").append(name).append("' targets an invalid type: '").append(typeCondition.name()).append("'.").toString(), "Fragments must be specified on types that exist in the schema. This applies for both named and inline fragments. If they are not defined in the schema, the query does not validate.")));
            } else {
                throw new MatchError(x0$1);
            }
            return zIO;
        }).unit();
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateFields(List<Selection> selectionSet, __Type currentType) {
        return IO$.MODULE$.foreach(selectionSet, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ZIO<Object, CalibanError.ValidationError, BoxedUnit> zIO;
            if (x0$1 instanceof Selection.Field) {
                Selection.Field field = (Selection.Field)x0$1;
                zIO = MODULE$.validateField(field, currentType);
            } else if (x0$1 instanceof Selection.FragmentSpread) {
                zIO = IO$.MODULE$.unit();
            } else if (x0$1 instanceof Selection.InlineFragment) {
                Selection.InlineFragment inlineFragment = (Selection.InlineFragment)x0$1;
                Option<Type.NamedType> typeCondition = inlineFragment.typeCondition();
                List<Selection> selectionSet = inlineFragment.selectionSet();
                zIO = MODULE$.validateFields(selectionSet, (__Type)typeCondition.flatMap((Function1 & Serializable & scala.Serializable)onType -> ((LinearSeqOptimized)currentType.possibleTypes().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateFields$4(onType, x$6)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> currentType));
            } else {
                throw new MatchError(x0$1);
            }
            return zIO;
        }).unit();
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateField(Selection.Field field, __Type currentType) {
        String string = field.name();
        String string2 = "__typename";
        return IO$.MODULE$.when(string == null || !string.equals(string2), IO$.MODULE$.fromOption((Function0 & Serializable & scala.Serializable)() -> ((LinearSeqOptimized)((Option)currentType.fields().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateField$3(field, x$7)))).mapError((Function1 & Serializable & scala.Serializable)x$8 -> new CalibanError.ValidationError(new StringBuilder(35).append("Field '").append(field.name()).append("' does not exist on type '").append(Rendering$.MODULE$.renderTypeName(currentType)).append("'.").toString(), "The target field of a field selection must be defined on the scoped type of the selection set. There are no limitations on alias names.")).flatMap((Function1 & Serializable & scala.Serializable)f -> MODULE$.validateFields(field.selectionSet(), Types$.MODULE$.innerType((__Type)f.type().apply()))));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateOperationNameUniqueness(List<ExecutableDefinition.OperationDefinition> operations) {
        Iterable repeatedNames = (Iterable)((TraversableLike)operations.flatMap((Function1 & Serializable & scala.Serializable)x$9 -> Option$.MODULE$.option2Iterable(x$9.name()), List$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, List<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    String name = (String)x1._1();
                    if (((List)x1._2()).length() > 1) {
                        object = name;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, List<String>> x1) {
                boolean bl = x1 != null && ((List)x1._2()).length() > 1;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        return IO$.MODULE$.when(repeatedNames.nonEmpty(), IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(41).append("Multiple operations have the same name: ").append(repeatedNames.mkString(", ")).append(".").toString(), "Each named operation definition must be unique within a document when referred to by its name.")));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateLoneAnonymousOperation(List<ExecutableDefinition.OperationDefinition> operations) {
        List anonymous = (List)operations.filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateLoneAnonymousOperation$1(x$10)));
        return IO$.MODULE$.when(operations.length() > 1 && anonymous.nonEmpty(), IO$.MODULE$.fail((Object)new CalibanError.ValidationError("Found both anonymous and named operations.", "GraphQL allows a short\u2010hand form for defining query operations when only that one operation exists in the document.")));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateSubscriptionOperation(List<ExecutableDefinition.OperationDefinition> operations) {
        List subscriptions = (List)operations.filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateSubscriptionOperation$1(x$11)));
        return IO$.MODULE$.fromOption((Function0 & Serializable & scala.Serializable)() -> subscriptions.find((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateSubscriptionOperation$3(x$12)))).map((Function1 & Serializable & scala.Serializable)op -> new CalibanError.ValidationError(new StringBuilder(43).append("Subscription ").append(op.name().map((Function1 & Serializable & scala.Serializable)n -> new StringBuilder(2).append("'").append((String)n).append("'").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(" has more than one root field.").toString(), "Subscription operations must have exactly one root field.")).flip();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$collectTypesValidForFragments$1(Tuple2 x0$1) {
        if (x0$1 == null) throw new MatchError(null);
        __Type t = (__Type)x0$1._2();
        __TypeKind __TypeKind2 = t.kind();
        __TypeKind$OBJECT$ __TypeKind$OBJECT$2 = __TypeKind$OBJECT$.MODULE$;
        if (__TypeKind2 == null) {
            if (__TypeKind$OBJECT$2 == null) return true;
        } else if (__TypeKind2.equals(__TypeKind$OBJECT$2)) return true;
        __TypeKind __TypeKind3 = t.kind();
        __TypeKind$INTERFACE$ __TypeKind$INTERFACE$2 = __TypeKind$INTERFACE$.MODULE$;
        if (__TypeKind3 == null) {
            if (__TypeKind$INTERFACE$2 == null) return true;
        } else if (__TypeKind3.equals(__TypeKind$INTERFACE$2)) return true;
        __TypeKind __TypeKind4 = t.kind();
        __TypeKind$UNION$ __TypeKind$UNION$2 = __TypeKind$UNION$.MODULE$;
        if (__TypeKind4 != null) {
            if (!__TypeKind4.equals(__TypeKind$UNION$2)) return false;
            return true;
        }
        if (__TypeKind$UNION$2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$validateFields$4(Type.NamedType onType$1, __Type x$6) {
        return x$6.name().contains((Object)onType$1.name());
    }

    public static final /* synthetic */ boolean $anonfun$validateField$3(Selection.Field field$1, __Field x$7) {
        String string = x$7.name();
        String string2 = field$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateLoneAnonymousOperation$1(ExecutableDefinition.OperationDefinition x$10) {
        return x$10.name().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateSubscriptionOperation$1(ExecutableDefinition.OperationDefinition x$11) {
        OperationType operationType = x$11.operationType();
        OperationType$Subscription$ operationType$Subscription$ = OperationType$Subscription$.MODULE$;
        return !(operationType != null ? !operationType.equals(operationType$Subscription$) : operationType$Subscription$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateSubscriptionOperation$3(ExecutableDefinition.OperationDefinition x$12) {
        return x$12.selectionSet().length() > 1;
    }

    private Validator$() {
        MODULE$ = this;
    }
}

