/*
 * Decompiled with CFR 0.152.
 */
package caliban.validation;

import caliban.CalibanError;
import caliban.Rendering$;
import caliban.execution.Executor$;
import caliban.introspection.Introspector$;
import caliban.introspection.adt.__DeprecatedArgs;
import caliban.introspection.adt.__Field;
import caliban.introspection.adt.__InputValue;
import caliban.introspection.adt.__Type;
import caliban.introspection.adt.__TypeKind;
import caliban.introspection.adt.__TypeKind$ENUM$;
import caliban.introspection.adt.__TypeKind$INTERFACE$;
import caliban.introspection.adt.__TypeKind$NON_NULL$;
import caliban.introspection.adt.__TypeKind$OBJECT$;
import caliban.introspection.adt.__TypeKind$SCALAR$;
import caliban.introspection.adt.__TypeKind$UNION$;
import caliban.parsing.adt.Directive;
import caliban.parsing.adt.Document;
import caliban.parsing.adt.ExecutableDefinition;
import caliban.parsing.adt.OperationType;
import caliban.parsing.adt.OperationType$Mutation$;
import caliban.parsing.adt.OperationType$Query$;
import caliban.parsing.adt.OperationType$Subscription$;
import caliban.parsing.adt.Selection;
import caliban.parsing.adt.Type;
import caliban.parsing.adt.Type$;
import caliban.parsing.adt.Value;
import caliban.parsing.adt.Value$NullValue$;
import caliban.parsing.adt.VariableDefinition;
import caliban.schema.RootType;
import caliban.schema.Types$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import zio.IO$;
import zio.ZIO;

public final class Validator$ {
    public static Validator$ MODULE$;

    static {
        new Validator$();
    }

    /*
     * WARNING - void declaration
     */
    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validate(Document document, RootType rootType) {
        void var5_5;
        void var4_4;
        Tuple2<List<ExecutableDefinition.OperationDefinition>, List<ExecutableDefinition.FragmentDefinition>> tuple2 = this.collectOperationsAndFragments(document);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        List operations = (List)tuple2._1();
        List fragments = (List)tuple2._2();
        void operations2 = var4_4;
        void fragments2 = var5_5;
        return this.validateOperationNameUniqueness((List<ExecutableDefinition.OperationDefinition>)operations2).flatMap(arg_0 -> Validator$.$anonfun$validate$1((List)operations2, (List)fragments2, rootType, document, arg_0));
    }

    private Tuple2<List<ExecutableDefinition.OperationDefinition>, List<ExecutableDefinition.FragmentDefinition>> collectOperationsAndFragments(Document document) {
        return (Tuple2)document.definitions().foldLeft((Object)new Tuple2((Object)List$.MODULE$.empty(), (Object)List$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            Tuple2 tuple22 = x0$1;
            ExecutableDefinition o = x1$1;
            if (tuple22 != null) {
                List operations = (List)tuple22._1();
                List fragments = (List)tuple22._2();
                if (o instanceof ExecutableDefinition.OperationDefinition) {
                    ExecutableDefinition.OperationDefinition operationDefinition = (ExecutableDefinition.OperationDefinition)o;
                    return new Tuple2((Object)operations.$colon$colon((Object)operationDefinition), (Object)fragments);
                }
            }
            Tuple2 tuple23 = x0$1;
            ExecutableDefinition f = x1$1;
            if (tuple23 == null) throw new MatchError((Object)tuple2);
            List operations = (List)tuple23._1();
            List fragments = (List)tuple23._2();
            if (!(f instanceof ExecutableDefinition.FragmentDefinition)) throw new MatchError((Object)tuple2);
            ExecutableDefinition.FragmentDefinition fragmentDefinition = (ExecutableDefinition.FragmentDefinition)f;
            return new Tuple2((Object)operations, (Object)fragments.$colon$colon((Object)fragmentDefinition));
        });
    }

    private Map<String, __Type> collectTypesValidForFragments(RootType rootType) {
        return (Map)rootType.types().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$collectTypesValidForFragments$1(x0$1)));
    }

    private Set<String> collectVariablesUsed(List<Selection> selectionSet, List<ExecutableDefinition.FragmentDefinition> fragments) {
        return ((TraversableOnce)Validator$.collectValues$1(selectionSet, fragments).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Value, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object = x1 instanceof Value.VariableValue ? ((Value.VariableValue)x1).name() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Value x1) {
                boolean bl = x1 instanceof Value.VariableValue;
                return bl;
            }
        }, List$.MODULE$.canBuildFrom())).toSet();
    }

    private List<Selection> collectSelectionSets(List<Selection> selectionSet) {
        return (List)selectionSet.$plus$plus((GenTraversableOnce)selectionSet.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            List<Selection> list2;
            if (x0$1 instanceof Selection.FragmentSpread) {
                list2 = Nil$.MODULE$;
            } else if (x0$1 instanceof Selection.Field) {
                List<Selection> selectionSet = ((Selection.Field)x0$1).selectionSet();
                list2 = MODULE$.collectSelectionSets(selectionSet);
            } else if (x0$1 instanceof Selection.InlineFragment) {
                List<Selection> selectionSet = ((Selection.InlineFragment)x0$1).selectionSet();
                list2 = MODULE$.collectSelectionSets(selectionSet);
            } else {
                throw new MatchError(x0$1);
            }
            return list2;
        }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
    }

    private List<Directive> collectDirectives(List<Selection> selectionSet) {
        return (List)selectionSet.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            List<Directive> list2;
            if (x0$1 instanceof Selection.FragmentSpread) {
                list2 = ((Selection.FragmentSpread)x0$1).directives();
            } else if (x0$1 instanceof Selection.Field) {
                list2 = ((Selection.Field)x0$1).directives();
            } else if (x0$1 instanceof Selection.InlineFragment) {
                list2 = ((Selection.InlineFragment)x0$1).dirs();
            } else {
                throw new MatchError(x0$1);
            }
            return list2;
        }, List$.MODULE$.canBuildFrom());
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateDirectives(List<Selection> selectionSet) {
        List<Directive> directives = this.collectDirectives(selectionSet);
        Set supportedDirectives = ((TraversableOnce)Introspector$.MODULE$.directives().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.name(), List$.MODULE$.canBuildFrom())).toSet();
        return IO$.MODULE$.foreach(directives, (Function1 & Serializable & scala.Serializable)d -> IO$.MODULE$.when(!supportedDirectives.contains((Object)d.name()), IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(30).append("Directive '").append(d.name()).append("' is not supported.").toString(), "GraphQL servers define what directives they support. For each usage of a directive, the directive must be available on that server.")))).unit();
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateVariables(List<ExecutableDefinition.OperationDefinition> definitions, List<ExecutableDefinition.FragmentDefinition> fragments, RootType rootType) {
        return IO$.MODULE$.foreach(definitions, (Function1 & Serializable & scala.Serializable)op -> IO$.MODULE$.foreach((Iterable)op.variableDefinitions().groupBy((Function1 & Serializable & scala.Serializable)x$15 -> x$15.name()), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$1._1();
            List variables = (List)x0$1._2();
            ZIO zIO = IO$.MODULE$.when(variables.length() > 1, IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(38).append("Variable '").append(name).append("' is defined more than once.").toString(), "If any operation defines more than one variable with the same name, it is ambiguous and invalid. It is invalid even if the type of the duplicate variable is the same.")));
            return zIO;
        }).$times$greater((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.foreach(op.variableDefinitions(), (Function1 & Serializable & scala.Serializable)v -> {
            String t = Type$.MODULE$.innerType(v.variableType());
            return IO$.MODULE$.whenCase((Object)rootType.types().get((Object)t).map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.kind()), (PartialFunction)new scala.Serializable((VariableDefinition)v){
                public static final long serialVersionUID = 0L;
                private final VariableDefinition v$1;

                public final <A1 extends Option<__TypeKind>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    __TypeKind __TypeKind2;
                    __TypeKind __TypeKind3;
                    __TypeKind __TypeKind4;
                    boolean bl = x1 instanceof Some && __TypeKind$OBJECT$.MODULE$.equals(__TypeKind4 = (__TypeKind)((Some)x1).value()) ? true : (x1 instanceof Some && __TypeKind$UNION$.MODULE$.equals(__TypeKind3 = (__TypeKind)((Some)x1).value()) ? true : x1 instanceof Some && __TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2 = (__TypeKind)((Some)x1).value()));
                    Object object = bl ? IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(46).append("Type of variable '").append(this.v$1.name()).append("' is not a valid input type.").toString(), "Variables can only be input types. Objects, unions, and interfaces cannot be used as inputs.")) : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Option<__TypeKind> x1) {
                    __TypeKind __TypeKind2;
                    __TypeKind __TypeKind3;
                    __TypeKind __TypeKind4;
                    boolean bl = x1 instanceof Some && __TypeKind$OBJECT$.MODULE$.equals(__TypeKind4 = (__TypeKind)((Some)x1).value()) ? true : (x1 instanceof Some && __TypeKind$UNION$.MODULE$.equals(__TypeKind3 = (__TypeKind)((Some)x1).value()) ? true : x1 instanceof Some && __TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2 = (__TypeKind)((Some)x1).value()));
                    boolean bl2 = bl;
                    return bl2;
                }
                {
                    this.v$1 = v$1;
                }
            });
        })).$times$greater((Function0 & Serializable & scala.Serializable)() -> {
            Set<String> variableUsages = MODULE$.collectVariablesUsed(op.selectionSet(), fragments);
            return IO$.MODULE$.foreach(variableUsages, (Function1 & Serializable & scala.Serializable)v -> IO$.MODULE$.when(!op.variableDefinitions().exists((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateVariables$9(v, x$17))), IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(27).append("Variable '").append((String)v).append("' is not defined.").toString(), "Variables are scoped on a per\u2010operation basis. That means that any variable used within the context of an operation must be defined at the top level of that operation")))).$times$greater((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.foreach(op.variableDefinitions(), (Function1 & Serializable & scala.Serializable)v -> IO$.MODULE$.when(!variableUsages.contains((Object)v.name()), IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(24).append("Variable '").append(v.name()).append("' is not used.").toString(), "All variables defined by an operation must be used in that operation or a fragment transitively included by that operation. Unused variables cause a validation error.")))));
        })).unit();
    }

    private List<Selection.FragmentSpread> collectFragmentSpreads(List<Selection> selectionSet) {
        return (List)selectionSet.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Selection, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object = x1 instanceof Selection.FragmentSpread ? (Selection.FragmentSpread)x1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Selection x1) {
                boolean bl = x1 instanceof Selection.FragmentSpread;
                return bl;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateFragmentSpreads(List<Selection> selectionSets, List<ExecutableDefinition.FragmentDefinition> fragments) {
        Set spreadNames = ((TraversableOnce)this.collectFragmentSpreads(selectionSets).map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.name(), List$.MODULE$.canBuildFrom())).toSet();
        Set fragmentNames = ((TraversableOnce)fragments.map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.name(), List$.MODULE$.canBuildFrom())).toSet();
        return IO$.MODULE$.foreach(fragments, (Function1 & Serializable & scala.Serializable)f -> {
            if (!spreadNames.contains((Object)f.name())) {
                return IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(38).append("Fragment '").append(f.name()).append("' is not used in any spread.").toString(), "Defined fragments must be used within a document."));
            }
            if (MODULE$.detectCycles((ExecutableDefinition.FragmentDefinition)f, fragments, MODULE$.detectCycles$default$3())) {
                return IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(26).append("Fragment '").append(f.name()).append("' forms a cycle.").toString(), "The graph of fragment spreads must not form any cycles including spreading itself. Otherwise an operation could infinitely spread or infinitely execute on cycles in the underlying data."));
            }
            return IO$.MODULE$.unit();
        }).$times$greater((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.foreach((Iterable)spreadNames, (Function1 & Serializable & scala.Serializable)spread -> IO$.MODULE$.when(!fragmentNames.contains(spread), IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(34).append("Fragment spread '").append((String)spread).append("' is not defined.").toString(), "Named fragment spreads must refer to fragments defined within the document. It is a validation error if the target of a spread is not defined.")))).unit());
    }

    private boolean detectCycles(ExecutableDefinition.FragmentDefinition fragment, List<ExecutableDefinition.FragmentDefinition> fragments, Set<String> visited) {
        List<Selection> selectionSets = this.collectSelectionSets(fragment.selectionSet());
        return this.collectFragmentSpreads(selectionSets).exists((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$detectCycles$1(visited, fragments, s)));
    }

    private Set<String> detectCycles$default$3() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateDocumentFields(Document document, RootType rootType, Map<String, __Type> typesForFragments) {
        return IO$.MODULE$.foreach(document.definitions(), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ZIO zIO;
            if (x0$1 instanceof ExecutableDefinition.OperationDefinition) {
                ZIO zIO2;
                ExecutableDefinition.OperationDefinition operationDefinition = (ExecutableDefinition.OperationDefinition)x0$1;
                OperationType opType = operationDefinition.operationType();
                List<Selection> selectionSet = operationDefinition.selectionSet();
                if (OperationType$Query$.MODULE$.equals(opType)) {
                    zIO2 = MODULE$.validateFields(selectionSet, rootType.queryType());
                } else if (OperationType$Mutation$.MODULE$.equals(opType)) {
                    zIO2 = (ZIO)rootType.mutationType().fold((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.fail((Object)new CalibanError.ValidationError("Mutation operations are not supported on this schema.", "")), (Function1 & Serializable & scala.Serializable)x$21 -> MODULE$.validateFields(selectionSet, (__Type)x$21));
                } else if (OperationType$Subscription$.MODULE$.equals(opType)) {
                    zIO2 = (ZIO)rootType.subscriptionType().fold((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.fail((Object)new CalibanError.ValidationError("Subscription operations are not supported on this schema.", "")), (Function1 & Serializable & scala.Serializable)x$22 -> MODULE$.validateFields(selectionSet, (__Type)x$22));
                } else {
                    throw new MatchError((Object)opType);
                }
                zIO = zIO2;
            } else if (x0$1 instanceof ExecutableDefinition.FragmentDefinition) {
                ExecutableDefinition.FragmentDefinition fragmentDefinition = (ExecutableDefinition.FragmentDefinition)x0$1;
                String name = fragmentDefinition.name();
                Type.NamedType typeCondition = fragmentDefinition.typeCondition();
                List<Selection> selectionSet = fragmentDefinition.selectionSet();
                zIO = IO$.MODULE$.fromOption((Function0 & Serializable & scala.Serializable)() -> typesForFragments.get((Object)typeCondition.name())).mapError((Function1 & Serializable & scala.Serializable)x$23 -> new CalibanError.ValidationError(new StringBuilder(40).append("Fragment '").append(name).append("' targets an invalid type: '").append(typeCondition.name()).append("'.").toString(), "Fragments must be specified on types that exist in the schema. This applies for both named and inline fragments. If they are not defined in the schema, the query does not validate.")).flatMap((Function1 & Serializable & scala.Serializable)t -> MODULE$.validateFields(selectionSet, (__Type)t).$times$greater((Function0 & Serializable & scala.Serializable)() -> MODULE$.validateFragmentType((Option<String>)new Some((Object)name), (__Type)t)));
            } else {
                throw new MatchError(x0$1);
            }
            return zIO;
        }).unit();
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateFields(List<Selection> selectionSet, __Type currentType) {
        return IO$.MODULE$.foreach(selectionSet, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ZIO zIO;
            if (x0$1 instanceof Selection.Field) {
                Selection.Field field = (Selection.Field)x0$1;
                zIO = MODULE$.validateField(field, currentType);
            } else if (x0$1 instanceof Selection.FragmentSpread) {
                zIO = IO$.MODULE$.unit();
            } else if (x0$1 instanceof Selection.InlineFragment) {
                ZIO zIO2;
                Selection.InlineFragment inlineFragment = (Selection.InlineFragment)x0$1;
                Option<Type.NamedType> typeCondition = inlineFragment.typeCondition();
                List<Selection> selectionSet = inlineFragment.selectionSet();
                if (typeCondition instanceof Some) {
                    Type.NamedType onType = (Type.NamedType)((Some)typeCondition).value();
                    zIO2 = IO$.MODULE$.fromOption((Function0 & Serializable & scala.Serializable)() -> ((LinearSeqOptimized)currentType.possibleTypes().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).find((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateFields$4(onType, x$24)))).mapError((Function1 & Serializable & scala.Serializable)x$25 -> new CalibanError.ValidationError(new StringBuilder(35).append("Inline Fragment on invalid type '").append(onType.name()).append("'.").toString(), ""));
                } else if (None$.MODULE$.equals(typeCondition)) {
                    zIO2 = IO$.MODULE$.succeed((Object)currentType);
                } else {
                    throw new MatchError(typeCondition);
                }
                zIO = zIO2.flatMap((Function1 & Serializable & scala.Serializable)t -> MODULE$.validateFields(selectionSet, (__Type)t).$times$greater((Function0 & Serializable & scala.Serializable)() -> MODULE$.validateFragmentType((Option<String>)None$.MODULE$, (__Type)t)));
            } else {
                throw new MatchError(x0$1);
            }
            return zIO;
        }).$times$greater((Function0 & Serializable & scala.Serializable)() -> MODULE$.validateLeafFieldSelection(selectionSet, currentType));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateField(Selection.Field field, __Type currentType) {
        String string = field.name();
        String string2 = "__typename";
        return IO$.MODULE$.when(string == null || !string.equals(string2), IO$.MODULE$.fromOption((Function0 & Serializable & scala.Serializable)() -> ((LinearSeqOptimized)((Option)currentType.fields().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).find((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateField$3(field, x$26)))).mapError((Function1 & Serializable & scala.Serializable)x$27 -> new CalibanError.ValidationError(new StringBuilder(35).append("Field '").append(field.name()).append("' does not exist on type '").append(Rendering$.MODULE$.renderTypeName(currentType)).append("'.").toString(), "The target field of a field selection must be defined on the scoped type of the selection set. There are no limitations on alias names.")).flatMap((Function1 & Serializable & scala.Serializable)f -> MODULE$.validateFields(field.selectionSet(), Types$.MODULE$.innerType((__Type)f.type().apply())).$times$greater((Function0 & Serializable & scala.Serializable)() -> MODULE$.validateArguments(field, (__Field)f, currentType))));
    }

    private ZIO<Object, CalibanError.ValidationError, List<BoxedUnit>> validateArguments(Selection.Field field, __Field f, __Type currentType) {
        return IO$.MODULE$.foreach(field.arguments().keys(), (Function1 & Serializable & scala.Serializable)arg -> IO$.MODULE$.when(!f.args().exists((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateArguments$2(arg, x$28))), IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(50).append("Argument '").append((String)arg).append("' is not defined on field '").append(field.name()).append("' of type '").append(currentType.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("'.").toString(), "Every argument provided to a field or directive must be defined in the set of possible arguments of that field or directive.")))).$times$greater((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.foreach((Iterable)f.args().filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateArguments$5(a))), (Function1 & Serializable & scala.Serializable)arg -> IO$.MODULE$.when(field.arguments().get((Object)arg.name()).forall((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateArguments$7(x$29))), IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(63).append("Required argument '").append(arg.name()).append("' is null or missing on field '").append(field.name()).append("' of type '").append(currentType.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("'.").toString(), "Arguments can be required. An argument is required if the argument type is non\u2010null and does not have a default value. Otherwise, the argument is optional.")))));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateLeafFieldSelection(List<Selection> selections, __Type currentType) {
        return IO$.MODULE$.whenCase((Object)currentType.kind(), (PartialFunction)new scala.Serializable(selections, currentType){
            public static final long serialVersionUID = 0L;
            private final List selections$1;
            private final __Type currentType$4;

            public final <A1 extends __TypeKind, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                boolean bl = __TypeKind$SCALAR$.MODULE$.equals(x1) ? true : __TypeKind$ENUM$.MODULE$.equals(x1);
                if (bl && this.selections$1.nonEmpty()) {
                    object = IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(41).append("Field selection is impossible on type '").append(this.currentType$4.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("'.").toString(), "Field selections on scalars or enums are never allowed, because they are the leaf nodes of any GraphQL query."));
                } else {
                    boolean bl2 = __TypeKind$INTERFACE$.MODULE$.equals(x1) ? true : (__TypeKind$UNION$.MODULE$.equals(x1) ? true : __TypeKind$OBJECT$.MODULE$.equals(x1));
                    object = bl2 && this.selections$1.isEmpty() ? IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(40).append("Field selection is mandatory on type '").append(this.currentType$4.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("'.").toString(), "Leaf selections on objects, interfaces, and unions without subfields are disallowed.")) : function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(__TypeKind x1) {
                boolean bl;
                boolean bl2 = __TypeKind$SCALAR$.MODULE$.equals(x1) ? true : __TypeKind$ENUM$.MODULE$.equals(x1);
                if (bl2 && this.selections$1.nonEmpty()) {
                    bl = true;
                } else {
                    boolean bl3 = __TypeKind$INTERFACE$.MODULE$.equals(x1) ? true : (__TypeKind$UNION$.MODULE$.equals(x1) ? true : __TypeKind$OBJECT$.MODULE$.equals(x1));
                    bl = bl3 && this.selections$1.isEmpty();
                }
                return bl;
            }
            {
                this.selections$1 = selections$1;
                this.currentType$4 = currentType$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(), $anonfun$applyOrElse$2()}, serializedLambda);
            }
        });
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateOperationNameUniqueness(List<ExecutableDefinition.OperationDefinition> operations) {
        scala.collection.immutable.Iterable repeatedNames = (scala.collection.immutable.Iterable)((TraversableLike)operations.flatMap((Function1 & Serializable & scala.Serializable)x$30 -> Option$.MODULE$.option2Iterable(x$30.name()), List$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, List<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    String name = (String)x1._1();
                    if (((List)x1._2()).length() > 1) {
                        object = name;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, List<String>> x1) {
                boolean bl = x1 != null && ((List)x1._2()).length() > 1;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        return IO$.MODULE$.when(repeatedNames.nonEmpty(), IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(41).append("Multiple operations have the same name: ").append(repeatedNames.mkString(", ")).append(".").toString(), "Each named operation definition must be unique within a document when referred to by its name.")));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateLoneAnonymousOperation(List<ExecutableDefinition.OperationDefinition> operations) {
        List anonymous = (List)operations.filter((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateLoneAnonymousOperation$1(x$31)));
        return IO$.MODULE$.when(operations.length() > 1 && anonymous.nonEmpty(), IO$.MODULE$.fail((Object)new CalibanError.ValidationError("Found both anonymous and named operations.", "GraphQL allows a short\u2010hand form for defining query operations when only that one operation exists in the document.")));
    }

    private ZIO<Object, CalibanError.ValidationError, Map<String, ExecutableDefinition.FragmentDefinition>> validateFragments(List<ExecutableDefinition.FragmentDefinition> fragments) {
        return IO$.MODULE$.foldLeft(fragments, (Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Map fragmentMap = x0$1;
            ExecutableDefinition.FragmentDefinition fragment = x1$1;
            if (fragmentMap.contains((Object)fragment.name())) {
                return IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(38).append("Fragment '").append(fragment.name()).append("' is defined more than once.").toString(), "Fragment definitions are referenced in fragment spreads by name. To avoid ambiguity, each fragment\u2019s name must be unique within a document."));
            }
            return IO$.MODULE$.succeed((Object)fragmentMap.updated((Object)fragment.name(), (Object)fragment));
        });
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateSubscriptionOperation(List<ExecutableDefinition.OperationDefinition> operations, Map<String, ExecutableDefinition.FragmentDefinition> fragments) {
        return IO$.MODULE$.fromOption((Function0 & Serializable & scala.Serializable)() -> ((LinearSeqOptimized)operations.filter((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateSubscriptionOperation$2(x$32)))).find((Function1 & Serializable & scala.Serializable)op -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateSubscriptionOperation$3(fragments, op)))).map((Function1 & Serializable & scala.Serializable)op -> new CalibanError.ValidationError(new StringBuilder(43).append("Subscription ").append(op.name().map((Function1 & Serializable & scala.Serializable)n -> new StringBuilder(2).append("'").append((String)n).append("'").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(" has more than one root field.").toString(), "Subscription operations must have exactly one root field.")).flip();
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateFragmentType(Option<String> name, __Type targetType) {
        __TypeKind __TypeKind2 = targetType.kind();
        boolean bl = __TypeKind$UNION$.MODULE$.equals(__TypeKind2) ? true : (__TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$OBJECT$.MODULE$.equals(__TypeKind2));
        ZIO zIO = bl ? IO$.MODULE$.unit() : IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(41).append("Fragment '").append(name.getOrElse((Function0 & Serializable & scala.Serializable)() -> "inline")).append("' is defined on invalid type '").append(targetType.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("'").toString(), "Fragments can only be declared on unions, interfaces, and objects. They are invalid on scalars. They can only be applied on non\u2010leaf fields. This rule applies to both inline and named fragments."));
        return zIO;
    }

    public static final /* synthetic */ ZIO $anonfun$validate$1(List operations$1, List fragments$1, RootType rootType$1, Document document$1, BoxedUnit _2) {
        return MODULE$.validateLoneAnonymousOperation((List<ExecutableDefinition.OperationDefinition>)operations$1).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.validateFragments((List<ExecutableDefinition.FragmentDefinition>)fragments$1).flatMap((Function1 & Serializable & scala.Serializable)fragmentMap -> {
            List<Selection> selectionSets = MODULE$.collectSelectionSets((List<Selection>)((List)((List)operations$1.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.selectionSet(), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)fragments$1.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.selectionSet(), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())));
            return MODULE$.validateDirectives(selectionSets).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.validateFragmentSpreads(selectionSets, (List<ExecutableDefinition.FragmentDefinition>)fragments$1).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.validateVariables((List<ExecutableDefinition.OperationDefinition>)operations$1, (List<ExecutableDefinition.FragmentDefinition>)fragments$1, rootType$1).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.validateSubscriptionOperation((List<ExecutableDefinition.OperationDefinition>)operations$1, (Map<String, ExecutableDefinition.FragmentDefinition>)fragmentMap).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
                Map<String, __Type> typesForFragments = MODULE$.collectTypesValidForFragments(rootType$1);
                return MODULE$.validateDocumentFields(document$1, rootType$1, typesForFragments);
            }))));
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$collectTypesValidForFragments$1(Tuple2 x0$1) {
        if (x0$1 == null) throw new MatchError(null);
        __Type t = (__Type)x0$1._2();
        __TypeKind __TypeKind2 = t.kind();
        __TypeKind$OBJECT$ __TypeKind$OBJECT$2 = __TypeKind$OBJECT$.MODULE$;
        if (__TypeKind2 == null) {
            if (__TypeKind$OBJECT$2 == null) return true;
        } else if (__TypeKind2.equals(__TypeKind$OBJECT$2)) return true;
        __TypeKind __TypeKind3 = t.kind();
        __TypeKind$INTERFACE$ __TypeKind$INTERFACE$2 = __TypeKind$INTERFACE$.MODULE$;
        if (__TypeKind3 == null) {
            if (__TypeKind$INTERFACE$2 == null) return true;
        } else if (__TypeKind3.equals(__TypeKind$INTERFACE$2)) return true;
        __TypeKind __TypeKind4 = t.kind();
        __TypeKind$UNION$ __TypeKind$UNION$2 = __TypeKind$UNION$.MODULE$;
        if (__TypeKind4 != null) {
            if (!__TypeKind4.equals(__TypeKind$UNION$2)) return false;
            return true;
        }
        if (__TypeKind$UNION$2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$collectVariablesUsed$3(String name$1, ExecutableDefinition.FragmentDefinition x$10) {
        String string = x$10.name();
        return !(string != null ? !string.equals(name$1) : name$1 != null);
    }

    private static final List collectValues$1(List selectionSet, List fragments$2) {
        return (List)selectionSet.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Iterable iterable;
            if (x0$1 instanceof Selection.FragmentSpread) {
                Selection.FragmentSpread fragmentSpread = (Selection.FragmentSpread)x0$1;
                String name = fragmentSpread.name();
                iterable = (Iterable)((List)fragmentSpread.directives().flatMap((Function1 & Serializable & scala.Serializable)x$9 -> x$9.arguments().values(), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)fragments$2.find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$collectVariablesUsed$3(name, x$10))).map((Function1 & Serializable & scala.Serializable)f -> (List)((List)f.directives().flatMap((Function1 & Serializable & scala.Serializable)x$11 -> x$11.arguments().values(), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Validator$.collectValues$1(f.selectionSet(), fragments$2), List$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), List$.MODULE$.canBuildFrom());
            } else if (x0$1 instanceof Selection.Field) {
                Selection.Field field = (Selection.Field)x0$1;
                Map<String, Value> arguments = field.arguments();
                List<Directive> directives = field.directives();
                List<Selection> selectionSet = field.selectionSet();
                iterable = (Iterable)((TraversableLike)arguments.values().$plus$plus((GenTraversableOnce)directives.flatMap((Function1 & Serializable & scala.Serializable)x$12 -> x$12.arguments().values(), List$.MODULE$.canBuildFrom()), scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Validator$.collectValues$1(selectionSet, fragments$2), scala.collection.Iterable$.MODULE$.canBuildFrom());
            } else if (x0$1 instanceof Selection.InlineFragment) {
                Selection.InlineFragment inlineFragment = (Selection.InlineFragment)x0$1;
                List<Directive> directives = inlineFragment.dirs();
                List<Selection> selectionSet = inlineFragment.selectionSet();
                iterable = (Iterable)((List)directives.flatMap((Function1 & Serializable & scala.Serializable)x$13 -> x$13.arguments().values(), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Validator$.collectValues$1(selectionSet, fragments$2), List$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError(x0$1);
            }
            return iterable;
        }, List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$validateVariables$9(String v$2, VariableDefinition x$17) {
        String string = x$17.name();
        return !(string != null ? !string.equals(v$2) : v$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$detectCycles$2(Selection.FragmentSpread s$1, ExecutableDefinition.FragmentDefinition x$20) {
        String string = x$20.name();
        String string2 = s$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$detectCycles$1(Set visited$1, List fragments$5, Selection.FragmentSpread s) {
        return visited$1.contains((Object)s.name()) || BoxesRunTime.unboxToBoolean((Object)fragments$5.find((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$detectCycles$2(s, x$20))).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)Validator$.MODULE$.detectCycles(f, (List<ExecutableDefinition.FragmentDefinition>)fragments$5, (Set<String>)((Set)visited$1.$plus((Object)s.name()))))));
    }

    public static final /* synthetic */ boolean $anonfun$validateFields$4(Type.NamedType onType$1, __Type x$24) {
        return x$24.name().contains((Object)onType$1.name());
    }

    public static final /* synthetic */ boolean $anonfun$validateField$3(Selection.Field field$1, __Field x$26) {
        String string = x$26.name();
        String string2 = field$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateArguments$2(String arg$1, __InputValue x$28) {
        String string = x$28.name();
        return !(string != null ? !string.equals(arg$1) : arg$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateArguments$5(__InputValue a) {
        __TypeKind __TypeKind2 = ((__Type)a.type().apply()).kind();
        __TypeKind$NON_NULL$ __TypeKind$NON_NULL$2 = __TypeKind$NON_NULL$.MODULE$;
        return !(__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$NON_NULL$2) : __TypeKind$NON_NULL$2 != null) && a.defaultValue().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateArguments$7(Value x$29) {
        Value value = x$29;
        Value$NullValue$ value$NullValue$ = Value$NullValue$.MODULE$;
        return !(value != null ? !value.equals(value$NullValue$) : value$NullValue$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateLoneAnonymousOperation$1(ExecutableDefinition.OperationDefinition x$31) {
        return x$31.name().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateSubscriptionOperation$2(ExecutableDefinition.OperationDefinition x$32) {
        OperationType operationType = x$32.operationType();
        OperationType$Subscription$ operationType$Subscription$ = OperationType$Subscription$.MODULE$;
        return !(operationType != null ? !operationType.equals(operationType$Subscription$) : operationType$Subscription$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateSubscriptionOperation$3(Map fragments$6, ExecutableDefinition.OperationDefinition op) {
        return Executor$.MODULE$.mergeSelectionSet(op.selectionSet(), "", (Map<String, ExecutableDefinition.FragmentDefinition>)fragments$6, (Map<String, Value>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$))).length() > 1;
    }

    private Validator$() {
        MODULE$ = this;
    }
}

