/*
 * Decompiled with CFR 0.152.
 */
package caliban.validation;

import caliban.CalibanError;
import caliban.InputValue;
import caliban.Rendering$;
import caliban.Value$NullValue$;
import caliban.execution.Field$;
import caliban.introspection.Introspector$;
import caliban.introspection.adt.__DeprecatedArgs;
import caliban.introspection.adt.__Directive;
import caliban.introspection.adt.__DirectiveLocation;
import caliban.introspection.adt.__DirectiveLocation$FIELD$;
import caliban.introspection.adt.__DirectiveLocation$FRAGMENT_DEFINITION$;
import caliban.introspection.adt.__DirectiveLocation$FRAGMENT_SPREAD$;
import caliban.introspection.adt.__DirectiveLocation$INLINE_FRAGMENT$;
import caliban.introspection.adt.__DirectiveLocation$MUTATION$;
import caliban.introspection.adt.__DirectiveLocation$QUERY$;
import caliban.introspection.adt.__DirectiveLocation$SUBSCRIPTION$;
import caliban.introspection.adt.__Field;
import caliban.introspection.adt.__InputValue;
import caliban.introspection.adt.__Type;
import caliban.introspection.adt.__TypeKind;
import caliban.introspection.adt.__TypeKind$ENUM$;
import caliban.introspection.adt.__TypeKind$INTERFACE$;
import caliban.introspection.adt.__TypeKind$NON_NULL$;
import caliban.introspection.adt.__TypeKind$OBJECT$;
import caliban.introspection.adt.__TypeKind$SCALAR$;
import caliban.introspection.adt.__TypeKind$UNION$;
import caliban.parsing.adt.Directive;
import caliban.parsing.adt.Document;
import caliban.parsing.adt.ExecutableDefinition;
import caliban.parsing.adt.OperationType;
import caliban.parsing.adt.OperationType$Mutation$;
import caliban.parsing.adt.OperationType$Query$;
import caliban.parsing.adt.OperationType$Subscription$;
import caliban.parsing.adt.Selection;
import caliban.parsing.adt.Type;
import caliban.parsing.adt.Type$;
import caliban.parsing.adt.VariableDefinition;
import caliban.schema.RootType;
import caliban.schema.Types$;
import caliban.validation.Validator;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import zio.CanFail$;
import zio.IO$;
import zio.ZIO;

public final class Validator$ {
    public static Validator$ MODULE$;

    static {
        new Validator$();
    }

    /*
     * WARNING - void declaration
     */
    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validate(Document document, RootType rootType) {
        void var5_5;
        void var4_4;
        Tuple2<List<ExecutableDefinition.OperationDefinition>, List<ExecutableDefinition.FragmentDefinition>> tuple2 = this.collectOperationsAndFragments(document);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        List operations = (List)tuple2._1();
        List fragments = (List)tuple2._2();
        void operations2 = var4_4;
        void fragments2 = var5_5;
        return this.validateFragments((List<ExecutableDefinition.FragmentDefinition>)fragments2).flatMap(arg_0 -> Validator$.$anonfun$validate$1((List)operations2, (List)fragments2, document, rootType, arg_0));
    }

    private Tuple2<List<ExecutableDefinition.OperationDefinition>, List<ExecutableDefinition.FragmentDefinition>> collectOperationsAndFragments(Document document) {
        return (Tuple2)document.definitions().foldLeft((Object)new Tuple2((Object)List$.MODULE$.empty(), (Object)List$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            Tuple2 tuple22 = x0$1;
            ExecutableDefinition o = x1$1;
            if (tuple22 != null) {
                List operations = (List)tuple22._1();
                List fragments = (List)tuple22._2();
                if (o instanceof ExecutableDefinition.OperationDefinition) {
                    ExecutableDefinition.OperationDefinition operationDefinition = (ExecutableDefinition.OperationDefinition)o;
                    return new Tuple2((Object)operations.$colon$colon((Object)operationDefinition), (Object)fragments);
                }
            }
            Tuple2 tuple23 = x0$1;
            ExecutableDefinition f = x1$1;
            if (tuple23 == null) throw new MatchError((Object)tuple2);
            List operations = (List)tuple23._1();
            List fragments = (List)tuple23._2();
            if (!(f instanceof ExecutableDefinition.FragmentDefinition)) throw new MatchError((Object)tuple2);
            ExecutableDefinition.FragmentDefinition fragmentDefinition = (ExecutableDefinition.FragmentDefinition)f;
            return new Tuple2((Object)operations, (Object)fragments.$colon$colon((Object)fragmentDefinition));
        });
    }

    private Set<String> collectVariablesUsed(Validator.Context context, List<Selection> selectionSet) {
        return ((TraversableOnce)Validator$.collectValues$1(selectionSet, context).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends InputValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object = x1 instanceof InputValue.VariableValue ? ((InputValue.VariableValue)x1).name() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(InputValue x1) {
                boolean bl = x1 instanceof InputValue.VariableValue;
                return bl;
            }
        }, List$.MODULE$.canBuildFrom())).toSet();
    }

    private List<Selection> collectSelectionSets(List<Selection> selectionSet) {
        return (List)selectionSet.$plus$plus((GenTraversableOnce)selectionSet.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            List<Selection> list2;
            if (x0$1 instanceof Selection.FragmentSpread) {
                list2 = Nil$.MODULE$;
            } else if (x0$1 instanceof Selection.Field) {
                List<Selection> selectionSet = ((Selection.Field)x0$1).selectionSet();
                list2 = MODULE$.collectSelectionSets(selectionSet);
            } else if (x0$1 instanceof Selection.InlineFragment) {
                List<Selection> selectionSet = ((Selection.InlineFragment)x0$1).selectionSet();
                list2 = MODULE$.collectSelectionSets(selectionSet);
            } else {
                throw new MatchError(x0$1);
            }
            return list2;
        }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
    }

    private ZIO<Object, CalibanError.ValidationError, List<Tuple2<Directive, __DirectiveLocation>>> collectAllDirectives(Validator.Context context) {
        return IO$.MODULE$.foreach(context.operations(), (Function1 & Serializable & scala.Serializable)op -> MODULE$.checkDirectivesUniqueness(op.directives()).as((Function0 & Serializable & scala.Serializable)() -> {
            List list2;
            OperationType operationType = op.operationType();
            if (OperationType$Query$.MODULE$.equals(operationType)) {
                list2 = (List)op.directives().map((Function1 & Serializable & scala.Serializable)x$11 -> new Tuple2(x$11, (Object)__DirectiveLocation$QUERY$.MODULE$), List$.MODULE$.canBuildFrom());
            } else if (OperationType$Mutation$.MODULE$.equals(operationType)) {
                list2 = (List)op.directives().map((Function1 & Serializable & scala.Serializable)x$12 -> new Tuple2(x$12, (Object)__DirectiveLocation$MUTATION$.MODULE$), List$.MODULE$.canBuildFrom());
            } else if (OperationType$Subscription$.MODULE$.equals(operationType)) {
                list2 = (List)op.directives().map((Function1 & Serializable & scala.Serializable)x$13 -> new Tuple2(x$13, (Object)__DirectiveLocation$SUBSCRIPTION$.MODULE$), List$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError((Object)operationType);
            }
            return list2;
        })).flatMap((Function1 & Serializable & scala.Serializable)opDirectives -> IO$.MODULE$.foreach(context.fragments().values(), (Function1 & Serializable & scala.Serializable)fragment -> MODULE$.checkDirectivesUniqueness(fragment.directives()).as((Function0 & Serializable & scala.Serializable)() -> (List)fragment.directives().map((Function1 & Serializable & scala.Serializable)x$14 -> new Tuple2(x$14, (Object)__DirectiveLocation$FRAGMENT_DEFINITION$.MODULE$), List$.MODULE$.canBuildFrom()))).flatMap((Function1 & Serializable & scala.Serializable)fragmentDirectives -> MODULE$.collectDirectives(context.selectionSets()).map((Function1 & Serializable & scala.Serializable)selectionDirectives -> (List)((List)((List)opDirectives.flatten((Function1)Predef$.MODULE$.$conforms())).$plus$plus((GenTraversableOnce)fragmentDirectives.flatten((Function1)Predef$.MODULE$.$conforms()), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)selectionDirectives, List$.MODULE$.canBuildFrom()))));
    }

    private ZIO<Object, CalibanError.ValidationError, List<Tuple2<Directive, __DirectiveLocation>>> collectDirectives(List<Selection> selectionSet) {
        return IO$.MODULE$.foreach(selectionSet, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ZIO zIO;
            if (x0$1 instanceof Selection.FragmentSpread) {
                List<Directive> directives = ((Selection.FragmentSpread)x0$1).directives();
                zIO = MODULE$.checkDirectivesUniqueness(directives).as((Function0 & Serializable & scala.Serializable)() -> (List)directives.map((Function1 & Serializable & scala.Serializable)x$15 -> new Tuple2(x$15, (Object)__DirectiveLocation$FRAGMENT_SPREAD$.MODULE$), List$.MODULE$.canBuildFrom()));
            } else if (x0$1 instanceof Selection.Field) {
                Selection.Field field = (Selection.Field)x0$1;
                List<Directive> directives = field.directives();
                List<Selection> selectionSet = field.selectionSet();
                zIO = MODULE$.checkDirectivesUniqueness(directives).$times$greater((Function0 & Serializable & scala.Serializable)() -> MODULE$.collectDirectives(selectionSet).map((Function1 & Serializable & scala.Serializable)x$17 -> (List)((List)directives.map((Function1 & Serializable & scala.Serializable)x$16 -> new Tuple2(x$16, (Object)__DirectiveLocation$FIELD$.MODULE$), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)x$17, List$.MODULE$.canBuildFrom())));
            } else if (x0$1 instanceof Selection.InlineFragment) {
                Selection.InlineFragment inlineFragment = (Selection.InlineFragment)x0$1;
                List<Directive> directives = inlineFragment.dirs();
                List<Selection> selectionSet = inlineFragment.selectionSet();
                zIO = MODULE$.checkDirectivesUniqueness(directives).$times$greater((Function0 & Serializable & scala.Serializable)() -> MODULE$.collectDirectives(selectionSet).map((Function1 & Serializable & scala.Serializable)x$19 -> (List)((List)directives.map((Function1 & Serializable & scala.Serializable)x$18 -> new Tuple2(x$18, (Object)__DirectiveLocation$INLINE_FRAGMENT$.MODULE$), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)x$19, List$.MODULE$.canBuildFrom())));
            } else {
                throw new MatchError(x0$1);
            }
            return zIO;
        }).map((Function1 & Serializable & scala.Serializable)x$20 -> (List)x$20.flatten((Function1)Predef$.MODULE$.$conforms()));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> checkDirectivesUniqueness(List<Directive> directives) {
        return IO$.MODULE$.whenCase((Object)directives.groupBy((Function1 & Serializable & scala.Serializable)x$21 -> x$21.name()).find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$checkDirectivesUniqueness$2(x0$1))), (PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Option<Tuple2<String, List<Directive>>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                Tuple2 tuple2;
                if (x1 instanceof Some && (tuple2 = (Tuple2)((Some)x1).value()) != null) {
                    String name = (String)tuple2._1();
                    object = IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(30).append("Directive '").append(name).append("' is defined twice.").toString(), "Directives are used to describe some metadata or behavioral change on the definition they apply to. When more than one directive of the same name is used, the expected metadata or behavior becomes ambiguous, therefore only one of each directive is allowed per location."));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Option<Tuple2<String, List<Directive>>> x1) {
                boolean bl = x1 instanceof Some && (Tuple2)((Some)x1).value() != null;
                return bl;
            }
        });
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateDirectives(Validator.Context context) {
        return this.collectAllDirectives(context).flatMap((Function1 & Serializable & scala.Serializable)directives -> IO$.MODULE$.foreach((Iterable)directives, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) throw new MatchError(null);
            Directive d = (Directive)x0$1._1();
            __DirectiveLocation location = (__DirectiveLocation)x0$1._2();
            Option option2 = Introspector$.MODULE$.directives().find((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateDirectives$3(d, x$22)));
            if (None$.MODULE$.equals(option2)) {
                return IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(30).append("Directive '").append(d.name()).append("' is not supported.").toString(), "GraphQL servers define what directives they support. For each usage of a directive, the directive must be available on that server."));
            }
            if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
            __Directive directive = (__Directive)((Some)option2).value();
            return IO$.MODULE$.when(!directive.locations().contains((Object)location), IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(44).append("Directive '").append(d.name()).append("' is used in invalid location '").append(location).append("'.").toString(), "GraphQL servers define what directives they support and where they support them. For each usage of a directive, the directive must be used in a location that the server has declared support for.")));
        }).map((Function1 & Serializable & scala.Serializable)_ -> {
            Validator$.$anonfun$validateDirectives$4(_);
            return BoxedUnit.UNIT;
        }));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateVariables(Validator.Context context) {
        return IO$.MODULE$.foreach(context.operations(), (Function1 & Serializable & scala.Serializable)op -> IO$.MODULE$.foreach((Iterable)op.variableDefinitions().groupBy((Function1 & Serializable & scala.Serializable)x$23 -> x$23.name()), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$1._1();
            List variables = (List)x0$1._2();
            ZIO zIO = IO$.MODULE$.when(variables.length() > 1, IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(38).append("Variable '").append(name).append("' is defined more than once.").toString(), "If any operation defines more than one variable with the same name, it is ambiguous and invalid. It is invalid even if the type of the duplicate variable is the same.")));
            return zIO;
        }).$times$greater((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.foreach(op.variableDefinitions(), (Function1 & Serializable & scala.Serializable)v -> {
            String t = Type$.MODULE$.innerType(v.variableType());
            return IO$.MODULE$.whenCase((Object)context.rootType().types().get((Object)t).map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.kind()), (PartialFunction)new scala.Serializable((VariableDefinition)v){
                public static final long serialVersionUID = 0L;
                private final VariableDefinition v$1;

                public final <A1 extends Option<__TypeKind>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    __TypeKind __TypeKind2;
                    __TypeKind __TypeKind3;
                    __TypeKind __TypeKind4;
                    boolean bl = x1 instanceof Some && __TypeKind$OBJECT$.MODULE$.equals(__TypeKind4 = (__TypeKind)((Some)x1).value()) ? true : (x1 instanceof Some && __TypeKind$UNION$.MODULE$.equals(__TypeKind3 = (__TypeKind)((Some)x1).value()) ? true : x1 instanceof Some && __TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2 = (__TypeKind)((Some)x1).value()));
                    Object object = bl ? IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(46).append("Type of variable '").append(this.v$1.name()).append("' is not a valid input type.").toString(), "Variables can only be input types. Objects, unions, and interfaces cannot be used as inputs.")) : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Option<__TypeKind> x1) {
                    __TypeKind __TypeKind2;
                    __TypeKind __TypeKind3;
                    __TypeKind __TypeKind4;
                    boolean bl = x1 instanceof Some && __TypeKind$OBJECT$.MODULE$.equals(__TypeKind4 = (__TypeKind)((Some)x1).value()) ? true : (x1 instanceof Some && __TypeKind$UNION$.MODULE$.equals(__TypeKind3 = (__TypeKind)((Some)x1).value()) ? true : x1 instanceof Some && __TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2 = (__TypeKind)((Some)x1).value()));
                    boolean bl2 = bl;
                    return bl2;
                }
                {
                    this.v$1 = v$1;
                }
            });
        })).$times$greater((Function0 & Serializable & scala.Serializable)() -> {
            Set<String> variableUsages = MODULE$.collectVariablesUsed(context, op.selectionSet());
            return IO$.MODULE$.foreach(variableUsages, (Function1 & Serializable & scala.Serializable)v -> IO$.MODULE$.when(!op.variableDefinitions().exists((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateVariables$9(v, x$25))), IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(27).append("Variable '").append((String)v).append("' is not defined.").toString(), "Variables are scoped on a per\u2010operation basis. That means that any variable used within the context of an operation must be defined at the top level of that operation")))).$times$greater((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.foreach(op.variableDefinitions(), (Function1 & Serializable & scala.Serializable)v -> IO$.MODULE$.when(!variableUsages.contains((Object)v.name()), IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(24).append("Variable '").append(v.name()).append("' is not used.").toString(), "All variables defined by an operation must be used in that operation or a fragment transitively included by that operation. Unused variables cause a validation error.")))));
        })).unit();
    }

    private List<Selection.FragmentSpread> collectFragmentSpreads(List<Selection> selectionSet) {
        return (List)selectionSet.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Selection, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object = x1 instanceof Selection.FragmentSpread ? (Selection.FragmentSpread)x1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Selection x1) {
                boolean bl = x1 instanceof Selection.FragmentSpread;
                return bl;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateFragmentSpreads(Validator.Context context) {
        Set spreadNames = ((TraversableOnce)this.collectFragmentSpreads(context.selectionSets()).map((Function1 & Serializable & scala.Serializable)x$26 -> x$26.name(), List$.MODULE$.canBuildFrom())).toSet();
        return IO$.MODULE$.foreach(context.fragments().values(), (Function1 & Serializable & scala.Serializable)f -> {
            if (!spreadNames.contains((Object)f.name())) {
                return IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(38).append("Fragment '").append(f.name()).append("' is not used in any spread.").toString(), "Defined fragments must be used within a document."));
            }
            if (MODULE$.detectCycles(context, (ExecutableDefinition.FragmentDefinition)f, MODULE$.detectCycles$default$3())) {
                return IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(26).append("Fragment '").append(f.name()).append("' forms a cycle.").toString(), "The graph of fragment spreads must not form any cycles including spreading itself. Otherwise an operation could infinitely spread or infinitely execute on cycles in the underlying data."));
            }
            return IO$.MODULE$.unit();
        }).unit();
    }

    private boolean detectCycles(Validator.Context context, ExecutableDefinition.FragmentDefinition fragment, Set<String> visited) {
        List<Selection> selectionSets = this.collectSelectionSets(fragment.selectionSet());
        return this.collectFragmentSpreads(selectionSets).exists((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$detectCycles$1(visited, context, s)));
    }

    private Set<String> detectCycles$default$3() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateDocumentFields(Validator.Context context) {
        return IO$.MODULE$.foreach(context.document().definitions(), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ZIO zIO;
            if (x0$1 instanceof ExecutableDefinition.OperationDefinition) {
                ZIO zIO2;
                ExecutableDefinition.OperationDefinition operationDefinition = (ExecutableDefinition.OperationDefinition)x0$1;
                OperationType opType = operationDefinition.operationType();
                List<Selection> selectionSet = operationDefinition.selectionSet();
                if (OperationType$Query$.MODULE$.equals(opType)) {
                    zIO2 = MODULE$.validateFields(context, selectionSet, context.rootType().queryType());
                } else if (OperationType$Mutation$.MODULE$.equals(opType)) {
                    zIO2 = (ZIO)context.rootType().mutationType().fold((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.fail((Object)new CalibanError.ValidationError("Mutation operations are not supported on this schema.", "")), (Function1 & Serializable & scala.Serializable)x$27 -> MODULE$.validateFields(context, selectionSet, (__Type)x$27));
                } else if (OperationType$Subscription$.MODULE$.equals(opType)) {
                    zIO2 = (ZIO)context.rootType().subscriptionType().fold((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.fail((Object)new CalibanError.ValidationError("Subscription operations are not supported on this schema.", "")), (Function1 & Serializable & scala.Serializable)x$28 -> MODULE$.validateFields(context, selectionSet, (__Type)x$28));
                } else {
                    throw new MatchError((Object)opType);
                }
                zIO = zIO2;
            } else if (x0$1 instanceof ExecutableDefinition.FragmentDefinition) {
                zIO = IO$.MODULE$.unit();
            } else {
                throw new MatchError(x0$1);
            }
            return zIO;
        }).unit();
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateFields(Validator.Context context, List<Selection> selectionSet, __Type currentType) {
        return IO$.MODULE$.foreach(selectionSet, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ZIO<Object, CalibanError.ValidationError, BoxedUnit> zIO;
            if (x0$1 instanceof Selection.Field) {
                Selection.Field field = (Selection.Field)x0$1;
                zIO = MODULE$.validateField(context, field, currentType);
            } else if (x0$1 instanceof Selection.FragmentSpread) {
                ZIO<Object, CalibanError.ValidationError, BoxedUnit> zIO2;
                String name = ((Selection.FragmentSpread)x0$1).name();
                Option option2 = context.fragments().get((Object)name);
                if (None$.MODULE$.equals(option2)) {
                    zIO2 = IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(34).append("Fragment spread '").append(name).append("' is not defined.").toString(), "Named fragment spreads must refer to fragments defined within the document. It is a validation error if the target of a spread is not defined."));
                } else if (option2 instanceof Some) {
                    ExecutableDefinition.FragmentDefinition fragment = (ExecutableDefinition.FragmentDefinition)((Some)option2).value();
                    zIO2 = MODULE$.validateSpread(context, (Option<String>)new Some((Object)name), currentType, (Option<Type.NamedType>)new Some((Object)fragment.typeCondition()), fragment.selectionSet());
                } else {
                    throw new MatchError((Object)option2);
                }
                zIO = zIO2;
            } else if (x0$1 instanceof Selection.InlineFragment) {
                Selection.InlineFragment inlineFragment = (Selection.InlineFragment)x0$1;
                Option<Type.NamedType> typeCondition = inlineFragment.typeCondition();
                List<Selection> selectionSet = inlineFragment.selectionSet();
                zIO = MODULE$.validateSpread(context, (Option<String>)None$.MODULE$, currentType, typeCondition, selectionSet);
            } else {
                throw new MatchError(x0$1);
            }
            return zIO;
        }).$times$greater((Function0 & Serializable & scala.Serializable)() -> MODULE$.validateLeafFieldSelection(selectionSet, currentType));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateSpread(Validator.Context context, Option<String> name, __Type currentType, Option<Type.NamedType> typeCondition, List<Selection> selectionSet) {
        ZIO zIO;
        Option option2 = (Option)typeCondition.fold((Function0 & Serializable & scala.Serializable)() -> new Some((Object)currentType), (Function1 & Serializable & scala.Serializable)t -> context.rootType().types().get((Object)t.name()));
        if (option2 instanceof Some) {
            __Type fragmentType = (__Type)((Some)option2).value();
            zIO = this.validateFragmentType(name, fragmentType).$times$greater((Function0 & Serializable & scala.Serializable)() -> {
                List possibleTypes = (List)MODULE$.getPossibleTypes(currentType).flatMap((Function1 & Serializable & scala.Serializable)x$29 -> Option$.MODULE$.option2Iterable(x$29.name()), List$.MODULE$.canBuildFrom());
                List possibleFragmentTypes = (List)MODULE$.getPossibleTypes(fragmentType).flatMap((Function1 & Serializable & scala.Serializable)x$30 -> Option$.MODULE$.option2Iterable(x$30.name()), List$.MODULE$.canBuildFrom());
                List applicableTypes = (List)possibleTypes.intersect((GenSeq)possibleFragmentTypes);
                return IO$.MODULE$.when(applicableTypes.isEmpty(), IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(75).append(name.fold((Function0 & Serializable & scala.Serializable)() -> "Inline fragment spread", (Function1 & Serializable & scala.Serializable)n -> new StringBuilder(18).append("Fragment spread '").append((String)n).append("'").toString())).append(" is not possible: possible types are '").append(possibleTypes.mkString(", ")).append("' and possible fragment types are '").append(possibleFragmentTypes.mkString(", ")).append("'.").toString(), "Fragments are declared on a type and will only apply when the runtime object type matches the type condition. They also are spread within the context of a parent type. A fragment spread is only valid if its type condition could ever apply within the parent type."))).$times$greater((Function0 & Serializable & scala.Serializable)() -> MODULE$.validateFields(context, selectionSet, fragmentType));
            });
        } else if (None$.MODULE$.equals(option2)) {
            zIO = IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(29).append(name.fold((Function0 & Serializable & scala.Serializable)() -> "Inline fragment spread", (Function1 & Serializable & scala.Serializable)n -> new StringBuilder(18).append("Fragment spread '").append((String)n).append("'").toString())).append(" targets an invalid type: '").append(typeCondition.map((Function1 & Serializable & scala.Serializable)x$31 -> x$31.name()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "?")).append("'.").toString(), "Fragments must be specified on types that exist in the schema. This applies for both named and inline fragments. If they are not defined in the schema, the query does not validate."));
        } else {
            throw new MatchError((Object)option2);
        }
        return zIO;
    }

    private List<__Type> getPossibleTypes(__Type t) {
        Object object;
        __TypeKind __TypeKind2 = t.kind();
        if (__TypeKind$OBJECT$.MODULE$.equals(__TypeKind2)) {
            object = new .colon.colon((Object)t, (List)Nil$.MODULE$);
        } else {
            boolean bl = __TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$UNION$.MODULE$.equals(__TypeKind2);
            object = bl ? (List)t.possibleTypes().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$) : Nil$.MODULE$;
        }
        return object;
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateField(Validator.Context context, Selection.Field field, __Type currentType) {
        String string = field.name();
        String string2 = "__typename";
        return IO$.MODULE$.when(string == null || !string.equals(string2), IO$.MODULE$.fromOption((Function0 & Serializable & scala.Serializable)() -> ((LinearSeqOptimized)((Option)currentType.fields().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).find((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateField$3(field, x$32)))).mapError((Function1 & Serializable & scala.Serializable)x$33 -> new CalibanError.ValidationError(new StringBuilder(35).append("Field '").append(field.name()).append("' does not exist on type '").append(Rendering$.MODULE$.renderTypeName(currentType)).append("'.").toString(), "The target field of a field selection must be defined on the scoped type of the selection set. There are no limitations on alias names."), CanFail$.MODULE$.canFail()).flatMap((Function1 & Serializable & scala.Serializable)f -> MODULE$.validateFields(context, field.selectionSet(), Types$.MODULE$.innerType((__Type)f.type().apply())).$times$greater((Function0 & Serializable & scala.Serializable)() -> MODULE$.validateArguments(field, (__Field)f, currentType))));
    }

    private ZIO<Object, CalibanError.ValidationError, List<BoxedUnit>> validateArguments(Selection.Field field, __Field f, __Type currentType) {
        return IO$.MODULE$.foreach(field.arguments(), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) throw new MatchError(null);
            String arg = (String)x0$1._1();
            InputValue argValue = (InputValue)x0$1._2();
            Option option2 = f.args().find((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateArguments$2(arg, x$34)));
            if (None$.MODULE$.equals(option2)) {
                return IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(50).append("Argument '").append(arg).append("' is not defined on field '").append(field.name()).append("' of type '").append(currentType.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("'.").toString(), "Every argument provided to a field or directive must be defined in the set of possible arguments of that field or directive."));
            }
            if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
            __InputValue inputValue = (__InputValue)((Some)option2).value();
            return MODULE$.validateInputValues(inputValue, argValue);
        }).$times$greater((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.foreach((Iterable)f.args().filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateArguments$5(a))), (Function1 & Serializable & scala.Serializable)arg -> IO$.MODULE$.when(field.arguments().get((Object)arg.name()).forall((Function1 & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateArguments$7(x$35))), IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(63).append("Required argument '").append(arg.name()).append("' is null or missing on field '").append(field.name()).append("' of type '").append(currentType.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("'.").toString(), "Arguments can be required. An argument is required if the argument type is non\u2010null and does not have a default value. Otherwise, the argument is optional.")))));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateInputValues(__InputValue inputValue, InputValue argValue) {
        ZIO zIO;
        __Type t = (__Type)inputValue.type().apply();
        __TypeKind __TypeKind2 = t.kind();
        __TypeKind$NON_NULL$ __TypeKind$NON_NULL$2 = __TypeKind$NON_NULL$.MODULE$;
        __Type inputType = !(__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$NON_NULL$2) : __TypeKind$NON_NULL$2 != null) ? (__Type)t.ofType().getOrElse((Function0 & Serializable & scala.Serializable)() -> t) : t;
        List inputFields = (List)inputType.inputFields().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        if (argValue instanceof InputValue.ObjectValue) {
            Map<String, InputValue> fields = ((InputValue.ObjectValue)argValue).fields();
            zIO = IO$.MODULE$.foreach(fields, (Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) throw new MatchError(null);
                String k = (String)x0$1._1();
                InputValue v = (InputValue)x0$1._2();
                Option option2 = inputFields.find((Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateInputValues$4(k, x$36)));
                if (None$.MODULE$.equals(option2)) {
                    return IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(41).append("Input field '").append(k).append("' is not defined on type '").append(inputType.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "?")).append("'.").toString(), "Every input field provided in an input object value must be defined in the set of possible fields of that input object\u2019s expected type."));
                }
                if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                __InputValue value = (__InputValue)((Some)option2).value();
                return MODULE$.validateInputValues(value, v);
            }).$times$greater((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.foreach((Iterable)inputFields, (Function1 & Serializable & scala.Serializable)inputField -> {
                boolean bl;
                if (inputField.defaultValue().isEmpty()) {
                    __TypeKind __TypeKind2 = ((__Type)inputField.type().apply()).kind();
                    __TypeKind$NON_NULL$ __TypeKind$NON_NULL$2 = __TypeKind$NON_NULL$.MODULE$;
                    if (!(__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$NON_NULL$2) : __TypeKind$NON_NULL$2 != null) && !fields.contains((Object)inputField.name())) {
                        bl = true;
                        return IO$.MODULE$.when(bl, IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(48).append("Required field '").append(inputField.name()).append("' on object '").append(inputType.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "?")).append("' was not provided.").toString(), "Input object fields may be required. Much like a field may have required arguments, an input object may have required fields. An input field is required if it has a non\u2010null type and does not have a default value. Otherwise, the input object field is optional.")));
                    }
                }
                bl = false;
                return IO$.MODULE$.when(bl, IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(48).append("Required field '").append(inputField.name()).append("' on object '").append(inputType.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "?")).append("' was not provided.").toString(), "Input object fields may be required. Much like a field may have required arguments, an input object may have required fields. An input field is required if it has a non\u2010null type and does not have a default value. Otherwise, the input object field is optional.")));
            }).unit());
        } else {
            zIO = IO$.MODULE$.unit();
        }
        return zIO;
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateLeafFieldSelection(List<Selection> selections, __Type currentType) {
        return IO$.MODULE$.whenCase((Object)currentType.kind(), (PartialFunction)new scala.Serializable(selections, currentType){
            public static final long serialVersionUID = 0L;
            private final List selections$1;
            private final __Type currentType$5;

            public final <A1 extends __TypeKind, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                boolean bl = __TypeKind$SCALAR$.MODULE$.equals(x1) ? true : __TypeKind$ENUM$.MODULE$.equals(x1);
                if (bl && this.selections$1.nonEmpty()) {
                    object = IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(41).append("Field selection is impossible on type '").append(this.currentType$5.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("'.").toString(), "Field selections on scalars or enums are never allowed, because they are the leaf nodes of any GraphQL query."));
                } else {
                    boolean bl2 = __TypeKind$INTERFACE$.MODULE$.equals(x1) ? true : (__TypeKind$UNION$.MODULE$.equals(x1) ? true : __TypeKind$OBJECT$.MODULE$.equals(x1));
                    object = bl2 && this.selections$1.isEmpty() ? IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(40).append("Field selection is mandatory on type '").append(this.currentType$5.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("'.").toString(), "Leaf selections on objects, interfaces, and unions without subfields are disallowed.")) : function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(__TypeKind x1) {
                boolean bl;
                boolean bl2 = __TypeKind$SCALAR$.MODULE$.equals(x1) ? true : __TypeKind$ENUM$.MODULE$.equals(x1);
                if (bl2 && this.selections$1.nonEmpty()) {
                    bl = true;
                } else {
                    boolean bl3 = __TypeKind$INTERFACE$.MODULE$.equals(x1) ? true : (__TypeKind$UNION$.MODULE$.equals(x1) ? true : __TypeKind$OBJECT$.MODULE$.equals(x1));
                    bl = bl3 && this.selections$1.isEmpty();
                }
                return bl;
            }
            {
                this.selections$1 = selections$1;
                this.currentType$5 = currentType$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(), $anonfun$applyOrElse$2()}, serializedLambda);
            }
        });
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateOperationNameUniqueness(List<ExecutableDefinition.OperationDefinition> operations) {
        scala.collection.immutable.Iterable repeatedNames = (scala.collection.immutable.Iterable)((TraversableLike)operations.flatMap((Function1 & Serializable & scala.Serializable)x$37 -> Option$.MODULE$.option2Iterable(x$37.name()), List$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, List<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    String name = (String)x1._1();
                    if (((List)x1._2()).length() > 1) {
                        object = name;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, List<String>> x1) {
                boolean bl = x1 != null && ((List)x1._2()).length() > 1;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        return IO$.MODULE$.when(repeatedNames.nonEmpty(), IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(41).append("Multiple operations have the same name: ").append(repeatedNames.mkString(", ")).append(".").toString(), "Each named operation definition must be unique within a document when referred to by its name.")));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateLoneAnonymousOperation(List<ExecutableDefinition.OperationDefinition> operations) {
        List anonymous = (List)operations.filter((Function1 & Serializable & scala.Serializable)x$38 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateLoneAnonymousOperation$1(x$38)));
        return IO$.MODULE$.when(operations.length() > 1 && anonymous.nonEmpty(), IO$.MODULE$.fail((Object)new CalibanError.ValidationError("Found both anonymous and named operations.", "GraphQL allows a short\u2010hand form for defining query operations when only that one operation exists in the document.")));
    }

    private ZIO<Object, CalibanError.ValidationError, Map<String, ExecutableDefinition.FragmentDefinition>> validateFragments(List<ExecutableDefinition.FragmentDefinition> fragments) {
        return IO$.MODULE$.foldLeft(fragments, (Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Map fragmentMap = x0$1;
            ExecutableDefinition.FragmentDefinition fragment = x1$1;
            if (fragmentMap.contains((Object)fragment.name())) {
                return IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(38).append("Fragment '").append(fragment.name()).append("' is defined more than once.").toString(), "Fragment definitions are referenced in fragment spreads by name. To avoid ambiguity, each fragment\u2019s name must be unique within a document."));
            }
            return IO$.MODULE$.succeed((Object)fragmentMap.updated((Object)fragment.name(), (Object)fragment));
        });
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateSubscriptionOperation(Validator.Context context) {
        return IO$.MODULE$.fromOption((Function0 & Serializable & scala.Serializable)() -> context.rootType().subscriptionType().flatMap((Function1 & Serializable & scala.Serializable)t -> ((LinearSeqOptimized)context.operations().filter((Function1 & Serializable & scala.Serializable)x$39 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateSubscriptionOperation$3(x$39)))).find((Function1 & Serializable & scala.Serializable)op -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateSubscriptionOperation$4(context, t, op))))).map((Function1 & Serializable & scala.Serializable)op -> new CalibanError.ValidationError(new StringBuilder(43).append("Subscription ").append(op.name().map((Function1 & Serializable & scala.Serializable)n -> new StringBuilder(2).append("'").append((String)n).append("'").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(" has more than one root field.").toString(), "Subscription operations must have exactly one root field.")).flip();
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateFragmentType(Option<String> name, __Type targetType) {
        __TypeKind __TypeKind2 = targetType.kind();
        boolean bl = __TypeKind$UNION$.MODULE$.equals(__TypeKind2) ? true : (__TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$OBJECT$.MODULE$.equals(__TypeKind2));
        ZIO zIO = bl ? IO$.MODULE$.unit() : IO$.MODULE$.fail((Object)new CalibanError.ValidationError(new StringBuilder(30).append(name.fold((Function0 & Serializable & scala.Serializable)() -> "Inline fragment", (Function1 & Serializable & scala.Serializable)n -> new StringBuilder(11).append("Fragment '").append((String)n).append("'").toString())).append(" is defined on invalid type '").append(targetType.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("'").toString(), "Fragments can only be declared on unions, interfaces, and objects. They are invalid on scalars. They can only be applied on non\u2010leaf fields. This rule applies to both inline and named fragments."));
        return zIO;
    }

    public static final /* synthetic */ ZIO $anonfun$validate$1(List operations$1, List fragments$1, Document document$1, RootType rootType$1, Map fragmentMap) {
        List<Selection> selectionSets = MODULE$.collectSelectionSets((List<Selection>)((List)((List)operations$1.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.selectionSet(), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)fragments$1.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.selectionSet(), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())));
        Validator.Context context = new Validator.Context(document$1, rootType$1, (List<ExecutableDefinition.OperationDefinition>)operations$1, (Map<String, ExecutableDefinition.FragmentDefinition>)fragmentMap, selectionSets);
        return MODULE$.validateOperationNameUniqueness((List<ExecutableDefinition.OperationDefinition>)operations$1).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.validateLoneAnonymousOperation((List<ExecutableDefinition.OperationDefinition>)operations$1).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.validateDirectives(context).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.validateFragmentSpreads(context).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.validateVariables(context).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.validateSubscriptionOperation(context).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.validateDocumentFields(context)))))));
    }

    private static final List collectValues$1(List selectionSet, Validator.Context context$2) {
        return (List)selectionSet.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Iterable iterable;
            if (x0$1 instanceof Selection.FragmentSpread) {
                Selection.FragmentSpread fragmentSpread = (Selection.FragmentSpread)x0$1;
                String name = fragmentSpread.name();
                iterable = (Iterable)((List)fragmentSpread.directives().flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.arguments().values(), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)context$2.fragments().get((Object)name).map((Function1 & Serializable & scala.Serializable)f -> (List)((List)f.directives().flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.arguments().values(), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Validator$.collectValues$1(f.selectionSet(), context$2), List$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), List$.MODULE$.canBuildFrom());
            } else if (x0$1 instanceof Selection.Field) {
                Selection.Field field = (Selection.Field)x0$1;
                Map<String, InputValue> arguments = field.arguments();
                List<Directive> directives = field.directives();
                List<Selection> selectionSet = field.selectionSet();
                iterable = (Iterable)((TraversableLike)arguments.values().$plus$plus((GenTraversableOnce)directives.flatMap((Function1 & Serializable & scala.Serializable)x$9 -> x$9.arguments().values(), List$.MODULE$.canBuildFrom()), scala.collection.Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Validator$.collectValues$1(selectionSet, context$2), scala.collection.Iterable$.MODULE$.canBuildFrom());
            } else if (x0$1 instanceof Selection.InlineFragment) {
                Selection.InlineFragment inlineFragment = (Selection.InlineFragment)x0$1;
                List<Directive> directives = inlineFragment.dirs();
                List<Selection> selectionSet = inlineFragment.selectionSet();
                iterable = (Iterable)((List)directives.flatMap((Function1 & Serializable & scala.Serializable)x$10 -> x$10.arguments().values(), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Validator$.collectValues$1(selectionSet, context$2), List$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError(x0$1);
            }
            return iterable;
        }, List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$checkDirectivesUniqueness$2(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((List)x0$1._2()).length() > 1;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$validateDirectives$3(Directive d$1, __Directive x$22) {
        String string = x$22.name();
        String string2 = d$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$validateDirectives$4(List _) {
    }

    public static final /* synthetic */ boolean $anonfun$validateVariables$9(String v$2, VariableDefinition x$25) {
        String string = x$25.name();
        return !(string != null ? !string.equals(v$2) : v$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$detectCycles$1(Set visited$1, Validator.Context context$6, Selection.FragmentSpread s) {
        return visited$1.contains((Object)s.name()) || BoxesRunTime.unboxToBoolean((Object)context$6.fragments().get((Object)s.name()).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)Validator$.MODULE$.detectCycles(context$6, f, (Set<String>)((Set)visited$1.$plus((Object)s.name()))))));
    }

    public static final /* synthetic */ boolean $anonfun$validateField$3(Selection.Field field$1, __Field x$32) {
        String string = x$32.name();
        String string2 = field$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateArguments$2(String arg$1, __InputValue x$34) {
        String string = x$34.name();
        return !(string != null ? !string.equals(arg$1) : arg$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateArguments$5(__InputValue a) {
        __TypeKind __TypeKind2 = ((__Type)a.type().apply()).kind();
        __TypeKind$NON_NULL$ __TypeKind$NON_NULL$2 = __TypeKind$NON_NULL$.MODULE$;
        return !(__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$NON_NULL$2) : __TypeKind$NON_NULL$2 != null) && a.defaultValue().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateArguments$7(InputValue x$35) {
        InputValue inputValue = x$35;
        Value$NullValue$ value$NullValue$ = Value$NullValue$.MODULE$;
        return !(inputValue != null ? !inputValue.equals(value$NullValue$) : value$NullValue$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateInputValues$4(String k$1, __InputValue x$36) {
        String string = x$36.name();
        return !(string != null ? !string.equals(k$1) : k$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateLoneAnonymousOperation$1(ExecutableDefinition.OperationDefinition x$38) {
        return x$38.name().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateSubscriptionOperation$3(ExecutableDefinition.OperationDefinition x$39) {
        OperationType operationType = x$39.operationType();
        OperationType$Subscription$ operationType$Subscription$ = OperationType$Subscription$.MODULE$;
        return !(operationType != null ? !operationType.equals(operationType$Subscription$) : operationType$Subscription$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateSubscriptionOperation$4(Validator.Context context$11, __Type t$2, ExecutableDefinition.OperationDefinition op) {
        return Field$.MODULE$.apply(op.selectionSet(), context$11.fragments(), (Map<String, InputValue>)Predef$.MODULE$.Map().empty(), t$2).fields().length() > 1;
    }

    private Validator$() {
        MODULE$ = this;
    }
}

