/*
 * Decompiled with CFR 0.152.
 */
package caliban.validation;

import caliban.CalibanError;
import caliban.CalibanError$ValidationError$;
import caliban.InputValue;
import caliban.Rendering$;
import caliban.Value;
import caliban.Value$NullValue$;
import caliban.execution.ExecutionRequest;
import caliban.execution.Field$;
import caliban.introspection.Introspector$;
import caliban.introspection.adt.__DeprecatedArgs;
import caliban.introspection.adt.__Directive;
import caliban.introspection.adt.__DirectiveLocation;
import caliban.introspection.adt.__DirectiveLocation$FIELD$;
import caliban.introspection.adt.__DirectiveLocation$FRAGMENT_DEFINITION$;
import caliban.introspection.adt.__DirectiveLocation$FRAGMENT_SPREAD$;
import caliban.introspection.adt.__DirectiveLocation$INLINE_FRAGMENT$;
import caliban.introspection.adt.__DirectiveLocation$MUTATION$;
import caliban.introspection.adt.__DirectiveLocation$QUERY$;
import caliban.introspection.adt.__DirectiveLocation$SUBSCRIPTION$;
import caliban.introspection.adt.__Field;
import caliban.introspection.adt.__InputValue;
import caliban.introspection.adt.__Type;
import caliban.introspection.adt.__TypeKind;
import caliban.introspection.adt.__TypeKind$;
import caliban.introspection.adt.__TypeKind$ENUM$;
import caliban.introspection.adt.__TypeKind$INPUT_OBJECT$;
import caliban.introspection.adt.__TypeKind$INTERFACE$;
import caliban.introspection.adt.__TypeKind$LIST$;
import caliban.introspection.adt.__TypeKind$NON_NULL$;
import caliban.introspection.adt.__TypeKind$OBJECT$;
import caliban.introspection.adt.__TypeKind$SCALAR$;
import caliban.introspection.adt.__TypeKind$UNION$;
import caliban.parsing.SourceMapper$;
import caliban.parsing.adt.Definition;
import caliban.parsing.adt.Directive;
import caliban.parsing.adt.Document;
import caliban.parsing.adt.OperationType;
import caliban.parsing.adt.OperationType$Mutation$;
import caliban.parsing.adt.OperationType$Query$;
import caliban.parsing.adt.OperationType$Subscription$;
import caliban.parsing.adt.Selection;
import caliban.parsing.adt.Type;
import caliban.parsing.adt.Type$;
import caliban.parsing.adt.VariableDefinition;
import caliban.schema.Operation;
import caliban.schema.RootSchema;
import caliban.schema.RootSchemaBuilder;
import caliban.schema.RootType;
import caliban.schema.Types$;
import caliban.validation.FragmentValidator$;
import caliban.validation.Utils$;
import caliban.validation.Validator$$anonfun$;
import caliban.validation.Validator$$anonfun$$nestedInanonfun$validateObject$9$1$;
import caliban.validation.ValueValidator$;
import caliban.validation.package;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenSeq;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.CanFail$;
import zio.IO$;
import zio.ZIO;

public final class Validator$ {
    public static Validator$ MODULE$;

    static {
        new Validator$();
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validate(Document document, RootType rootType) {
        return this.check(document, rootType, (Map<String, InputValue>)Predef$.MODULE$.Map().empty()).unit();
    }

    public <R> ZIO<Object, CalibanError.ValidationError, RootSchema<R>> validateSchema(RootSchemaBuilder<R> schema) {
        List<__Type> types = schema.types();
        return IO$.MODULE$.foreach_((Iterable)types.sorted(__TypeKind$.MODULE$.typeOrdering()), (Function1 & Serializable & scala.Serializable)t -> MODULE$.validateType((__Type)t)).$times$greater((Function0 & Serializable & scala.Serializable)() -> MODULE$.validateClashingTypes(types)).$times$greater((Function0 & Serializable & scala.Serializable)() -> MODULE$.validateDirectives(types)).$times$greater((Function0 & Serializable & scala.Serializable)() -> MODULE$.validateRootQuery(schema));
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateType(__Type t) {
        __TypeKind __TypeKind2 = t.kind();
        ZIO<Object, CalibanError.ValidationError, BoxedUnit> zIO = __TypeKind$ENUM$.MODULE$.equals(__TypeKind2) ? this.validateEnum(t) : (__TypeKind$UNION$.MODULE$.equals(__TypeKind2) ? this.validateUnion(t) : (__TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2) ? this.validateInterface(t) : (__TypeKind$INPUT_OBJECT$.MODULE$.equals(__TypeKind2) ? this.validateInputObject(t) : (__TypeKind$OBJECT$.MODULE$.equals(__TypeKind2) ? this.validateObject(t) : IO$.MODULE$.unit()))));
        return zIO;
    }

    public <T> ZIO<Object, CalibanError.ValidationError, T> failValidation(String msg, String explanatoryText) {
        return IO$.MODULE$.fail((Function0 & Serializable & scala.Serializable)() -> new CalibanError.ValidationError(msg, explanatoryText, CalibanError$ValidationError$.MODULE$.apply$default$3(), CalibanError$ValidationError$.MODULE$.apply$default$4()));
    }

    public <R> ZIO<Object, CalibanError.ValidationError, ExecutionRequest> prepare(Document document, RootType rootType, RootSchema<R> rootSchema, Option<String> operationName, Map<String, InputValue> variables, boolean skipValidation) {
        return (skipValidation ? IO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> (Map)((LinearSeqOptimized)MODULE$.collectDefinitions(document)._2()).foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Map m = x0$1;
            Definition.ExecutableDefinition.FragmentDefinition f = x1$1;
            return m.updated((Object)f.name(), (Object)f);
        })) : this.check(document, rootType, variables)).flatMap(arg_0 -> Validator$.$anonfun$prepare$3(operationName, document, rootSchema, variables, rootType, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private ZIO<Object, CalibanError.ValidationError, Map<String, Definition.ExecutableDefinition.FragmentDefinition>> check(Document document, RootType rootType, Map<String, InputValue> variables) {
        void var6_6;
        void var5_5;
        Tuple4<List<Definition.ExecutableDefinition.OperationDefinition>, List<Definition.ExecutableDefinition.FragmentDefinition>, List<Definition.TypeSystemDefinition>, List<Definition.TypeSystemExtension>> tuple4 = this.collectDefinitions(document);
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        List operations = (List)tuple4._1();
        List fragments = (List)tuple4._2();
        void operations2 = var5_5;
        void fragments2 = var6_6;
        return this.validateFragments((List<Definition.ExecutableDefinition.FragmentDefinition>)fragments2).map(arg_0 -> Validator$.$anonfun$check$1((List)operations2, (List)fragments2, document, rootType, variables, arg_0)).flatMap(arg_0 -> Validator$.$anonfun$check$4((List)operations2, arg_0));
    }

    private Tuple4<List<Definition.ExecutableDefinition.OperationDefinition>, List<Definition.ExecutableDefinition.FragmentDefinition>, List<Definition.TypeSystemDefinition>, List<Definition.TypeSystemExtension>> collectDefinitions(Document document) {
        return (Tuple4)document.definitions().foldLeft((Object)new Tuple4((Object)List$.MODULE$.empty(), (Object)List$.MODULE$.empty(), (Object)List$.MODULE$.empty(), (Object)List$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (x0$1 != null) {
                List operations = (List)x0$1._1();
                List fragments = (List)x0$1._2();
                List types = (List)x0$1._3();
                List extensions = (List)x0$1._4();
                if (x1$1 instanceof Definition.ExecutableDefinition.OperationDefinition) {
                    Definition.ExecutableDefinition.OperationDefinition operationDefinition = (Definition.ExecutableDefinition.OperationDefinition)x1$1;
                    return new Tuple4((Object)operations.$colon$colon((Object)operationDefinition), (Object)fragments, (Object)types, (Object)extensions);
                }
            }
            if (x0$1 != null) {
                List operations = (List)x0$1._1();
                List fragments = (List)x0$1._2();
                List types = (List)x0$1._3();
                List extensions = (List)x0$1._4();
                if (x1$1 instanceof Definition.ExecutableDefinition.FragmentDefinition) {
                    Definition.ExecutableDefinition.FragmentDefinition fragmentDefinition = (Definition.ExecutableDefinition.FragmentDefinition)x1$1;
                    return new Tuple4((Object)operations, (Object)fragments.$colon$colon((Object)fragmentDefinition), (Object)types, (Object)extensions);
                }
            }
            if (x0$1 != null) {
                List operations = (List)x0$1._1();
                List fragments = (List)x0$1._2();
                List types = (List)x0$1._3();
                List extensions = (List)x0$1._4();
                if (x1$1 instanceof Definition.TypeSystemDefinition) {
                    Definition.TypeSystemDefinition typeSystemDefinition = (Definition.TypeSystemDefinition)x1$1;
                    return new Tuple4((Object)operations, (Object)fragments, (Object)types.$colon$colon((Object)typeSystemDefinition), (Object)extensions);
                }
            }
            if (x0$1 == null) throw new MatchError((Object)tuple2);
            List operations = (List)x0$1._1();
            List fragments = (List)x0$1._2();
            List types = (List)x0$1._3();
            List extensions = (List)x0$1._4();
            if (!(x1$1 instanceof Definition.TypeSystemExtension)) throw new MatchError((Object)tuple2);
            Definition.TypeSystemExtension typeSystemExtension = (Definition.TypeSystemExtension)x1$1;
            return new Tuple4((Object)operations, (Object)fragments, (Object)types, (Object)extensions.$colon$colon((Object)typeSystemExtension));
        });
    }

    private scala.collection.immutable.Set<String> collectVariablesUsed(package.Context context, List<Selection> selectionSet) {
        return ((TraversableOnce)Validator$.collectVariableValues$1(Validator$.collectValues$1(selectionSet, context)).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.name(), List$.MODULE$.canBuildFrom())).toSet();
    }

    private List<Selection> collectSelectionSets(List<Selection> selectionSet) {
        Builder sets = List$.MODULE$.newBuilder();
        Validator$.loop$1(selectionSet, sets);
        return (List)sets.result();
    }

    private ZIO<Object, CalibanError.ValidationError, List<Tuple2<Directive, __DirectiveLocation>>> collectAllDirectives(package.Context context) {
        return IO$.MODULE$.foreach(context.operations(), (Function1 & Serializable & scala.Serializable)op -> MODULE$.checkDirectivesUniqueness(op.directives()).as((Function0 & Serializable & scala.Serializable)() -> {
            List list2;
            OperationType operationType = op.operationType();
            if (OperationType$Query$.MODULE$.equals(operationType)) {
                list2 = (List)op.directives().map((Function1 & Serializable & scala.Serializable)x$14 -> new Tuple2(x$14, (Object)__DirectiveLocation$QUERY$.MODULE$), List$.MODULE$.canBuildFrom());
            } else if (OperationType$Mutation$.MODULE$.equals(operationType)) {
                list2 = (List)op.directives().map((Function1 & Serializable & scala.Serializable)x$15 -> new Tuple2(x$15, (Object)__DirectiveLocation$MUTATION$.MODULE$), List$.MODULE$.canBuildFrom());
            } else if (OperationType$Subscription$.MODULE$.equals(operationType)) {
                list2 = (List)op.directives().map((Function1 & Serializable & scala.Serializable)x$16 -> new Tuple2(x$16, (Object)__DirectiveLocation$SUBSCRIPTION$.MODULE$), List$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError((Object)operationType);
            }
            return list2;
        }), List$.MODULE$.canBuildFrom()).flatMap((Function1 & Serializable & scala.Serializable)opDirectives -> IO$.MODULE$.foreach(context.fragments().values(), (Function1 & Serializable & scala.Serializable)fragment -> MODULE$.checkDirectivesUniqueness(fragment.directives()).as((Function0 & Serializable & scala.Serializable)() -> (List)fragment.directives().map((Function1 & Serializable & scala.Serializable)x$17 -> new Tuple2(x$17, (Object)__DirectiveLocation$FRAGMENT_DEFINITION$.MODULE$), List$.MODULE$.canBuildFrom())), scala.collection.Iterable$.MODULE$.canBuildFrom()).flatMap((Function1 & Serializable & scala.Serializable)fragmentDirectives -> MODULE$.collectDirectives(context.selectionSets()).map((Function1 & Serializable & scala.Serializable)selectionDirectives -> (List)((List)((List)opDirectives.flatten((Function1)Predef$.MODULE$.$conforms())).$plus$plus((GenTraversableOnce)fragmentDirectives.flatten((Function1)Predef$.MODULE$.$conforms()), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)selectionDirectives, List$.MODULE$.canBuildFrom()))));
    }

    private ZIO<Object, CalibanError.ValidationError, List<Tuple2<Directive, __DirectiveLocation>>> collectDirectives(List<Selection> selectionSet) {
        return IO$.MODULE$.foreach(selectionSet, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ZIO zIO;
            if (x0$1 instanceof Selection.FragmentSpread) {
                List<Directive> directives = ((Selection.FragmentSpread)x0$1).directives();
                zIO = MODULE$.checkDirectivesUniqueness(directives).as((Function0 & Serializable & scala.Serializable)() -> (List)directives.map((Function1 & Serializable & scala.Serializable)x$18 -> new Tuple2(x$18, (Object)__DirectiveLocation$FRAGMENT_SPREAD$.MODULE$), List$.MODULE$.canBuildFrom()));
            } else if (x0$1 instanceof Selection.Field) {
                Selection.Field field = (Selection.Field)x0$1;
                List<Directive> directives = field.directives();
                List<Selection> selectionSet = field.selectionSet();
                zIO = MODULE$.checkDirectivesUniqueness(directives).$times$greater((Function0 & Serializable & scala.Serializable)() -> MODULE$.collectDirectives(selectionSet).map((Function1 & Serializable & scala.Serializable)x$20 -> (List)((List)directives.map((Function1 & Serializable & scala.Serializable)x$19 -> new Tuple2(x$19, (Object)__DirectiveLocation$FIELD$.MODULE$), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)x$20, List$.MODULE$.canBuildFrom())));
            } else if (x0$1 instanceof Selection.InlineFragment) {
                Selection.InlineFragment inlineFragment = (Selection.InlineFragment)x0$1;
                List<Directive> directives = inlineFragment.dirs();
                List<Selection> selectionSet = inlineFragment.selectionSet();
                zIO = MODULE$.checkDirectivesUniqueness(directives).$times$greater((Function0 & Serializable & scala.Serializable)() -> MODULE$.collectDirectives(selectionSet).map((Function1 & Serializable & scala.Serializable)x$22 -> (List)((List)directives.map((Function1 & Serializable & scala.Serializable)x$21 -> new Tuple2(x$21, (Object)__DirectiveLocation$INLINE_FRAGMENT$.MODULE$), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)x$22, List$.MODULE$.canBuildFrom())));
            } else {
                throw new MatchError(x0$1);
            }
            return zIO;
        }, List$.MODULE$.canBuildFrom()).map((Function1 & Serializable & scala.Serializable)x$23 -> (List)x$23.flatten((Function1)Predef$.MODULE$.$conforms()));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> checkDirectivesUniqueness(List<Directive> directives) {
        return IO$.MODULE$.whenCase((Function0 & Serializable & scala.Serializable)() -> directives.groupBy((Function1 & Serializable & scala.Serializable)x$24 -> x$24.name()).find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$checkDirectivesUniqueness$3(x0$1))), (PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Option<Tuple2<String, List<Directive>>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ZIO<Object, CalibanError.ValidationError, T> zIO;
                Tuple2 tuple2;
                if (x1 instanceof Some && (tuple2 = (Tuple2)((Some)x1).value()) != null) {
                    String name = (String)tuple2._1();
                    zIO = Validator$.MODULE$.failValidation(new StringBuilder(30).append("Directive '").append(name).append("' is defined twice.").toString(), "Directives are used to describe some metadata or behavioral change on the definition they apply to. When more than one directive of the same name is used, the expected metadata or behavior becomes ambiguous, therefore only one of each directive is allowed per location.");
                } else {
                    zIO = function1.apply(x1);
                }
                return (B1)zIO;
            }

            public final boolean isDefinedAt(Option<Tuple2<String, List<Directive>>> x1) {
                boolean bl = x1 instanceof Some && (Tuple2)((Some)x1).value() != null;
                return bl;
            }
        });
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateDirectives(package.Context context) {
        return this.collectAllDirectives(context).flatMap((Function1 & Serializable & scala.Serializable)directives -> IO$.MODULE$.foreach_((Iterable)directives, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) throw new MatchError(null);
            Directive d = (Directive)x0$1._1();
            __DirectiveLocation location = (__DirectiveLocation)x0$1._2();
            Option option2 = ((LinearSeqOptimized)Introspector$.MODULE$.directives().$plus$plus(context.rootType().additionalDirectives(), List$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateDirectives$3(d, x$25)));
            if (None$.MODULE$.equals(option2)) {
                return MODULE$.failValidation(new StringBuilder(30).append("Directive '").append(d.name()).append("' is not supported.").toString(), "GraphQL servers define what directives they support. For each usage of a directive, the directive must be available on that server.");
            }
            if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
            __Directive directive = (__Directive)((Some)option2).value();
            return IO$.MODULE$.foreach_(d.arguments(), (Function1 & Serializable & scala.Serializable)x0$2 -> {
                void var5_10;
                if (x0$2 == null) throw new MatchError(null);
                String arg = (String)x0$2._1();
                InputValue argValue = (InputValue)x0$2._2();
                Option option2 = directive.args().find((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateDirectives$5(arg, x$26)));
                if (None$.MODULE$.equals(option2)) {
                    ZIO zIO = MODULE$.failValidation(new StringBuilder(46).append("Argument '").append(arg).append("' is not defined on directive '").append(d.name()).append("' (").append(location).append(").").toString(), "Every argument provided to a field or directive must be defined in the set of possible arguments of that field or directive.");
                    return var5_10;
                } else {
                    if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                    __InputValue inputValue = (__InputValue)((Some)option2).value();
                    ZIO<Object, CalibanError.ValidationError, BoxedUnit> zIO = MODULE$.validateInputValues(inputValue, argValue, context, new StringBuilder(29).append("InputValue '").append(inputValue.name()).append("' of Directive '").append(d.name()).append("'").toString());
                }
                return var5_10;
            }).$times$greater((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !directive.locations().contains((Object)location), (Function0 & Serializable & scala.Serializable)() -> MODULE$.failValidation(new StringBuilder(44).append("Directive '").append(d.name()).append("' is used in invalid location '").append(location).append("'.").toString(), "GraphQL servers define what directives they support and where they support them. For each usage of a directive, the directive must be used in a location that the server has declared support for.")));
        }).map((Function1 & Serializable & scala.Serializable)_ -> {
            Validator$.$anonfun$validateDirectives$9(_);
            return BoxedUnit.UNIT;
        }));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateVariables(package.Context context) {
        return IO$.MODULE$.foreach_(context.operations(), (Function1 & Serializable & scala.Serializable)op -> IO$.MODULE$.foreach_((Iterable)op.variableDefinitions().groupBy((Function1 & Serializable & scala.Serializable)x$27 -> x$27.name()), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$1._1();
            List variables = (List)x0$1._2();
            ZIO zIO = IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> variables.length() > 1, (Function0 & Serializable & scala.Serializable)() -> MODULE$.failValidation(new StringBuilder(38).append("Variable '").append(name).append("' is defined more than once.").toString(), "If any operation defines more than one variable with the same name, it is ambiguous and invalid. It is invalid even if the type of the duplicate variable is the same."));
            return zIO;
        }).$times$greater((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.foreach_(op.variableDefinitions(), (Function1 & Serializable & scala.Serializable)v -> {
            String t = Type$.MODULE$.innerType(v.variableType());
            return IO$.MODULE$.whenCase((Function0 & Serializable & scala.Serializable)() -> context.rootType().types().get((Object)t).map((Function1 & Serializable & scala.Serializable)x$28 -> x$28.kind()), (PartialFunction)new scala.Serializable((VariableDefinition)v){
                public static final long serialVersionUID = 0L;
                private final VariableDefinition v$1;

                public final <A1 extends Option<__TypeKind>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    __TypeKind __TypeKind2;
                    __TypeKind __TypeKind3;
                    __TypeKind __TypeKind4;
                    boolean bl = x1 instanceof Some && __TypeKind$OBJECT$.MODULE$.equals(__TypeKind4 = (__TypeKind)((Some)x1).value()) ? true : (x1 instanceof Some && __TypeKind$UNION$.MODULE$.equals(__TypeKind3 = (__TypeKind)((Some)x1).value()) ? true : x1 instanceof Some && __TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2 = (__TypeKind)((Some)x1).value()));
                    ZIO<Object, CalibanError.ValidationError, T> zIO = bl ? Validator$.MODULE$.failValidation(new StringBuilder(46).append("Type of variable '").append(this.v$1.name()).append("' is not a valid input type.").toString(), "Variables can only be input types. Objects, unions, and interfaces cannot be used as inputs.") : function1.apply(x1);
                    return (B1)zIO;
                }

                public final boolean isDefinedAt(Option<__TypeKind> x1) {
                    __TypeKind __TypeKind2;
                    __TypeKind __TypeKind3;
                    __TypeKind __TypeKind4;
                    boolean bl = x1 instanceof Some && __TypeKind$OBJECT$.MODULE$.equals(__TypeKind4 = (__TypeKind)((Some)x1).value()) ? true : (x1 instanceof Some && __TypeKind$UNION$.MODULE$.equals(__TypeKind3 = (__TypeKind)((Some)x1).value()) ? true : x1 instanceof Some && __TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2 = (__TypeKind)((Some)x1).value()));
                    boolean bl2 = bl;
                    return bl2;
                }
                {
                    this.v$1 = v$1;
                }
            });
        })).$times$greater((Function0 & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Set<String> variableUsages = MODULE$.collectVariablesUsed(context, op.selectionSet());
            return IO$.MODULE$.foreach_(variableUsages, (Function1 & Serializable & scala.Serializable)v -> IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !op.variableDefinitions().exists((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateVariables$13(v, x$29))), (Function0 & Serializable & scala.Serializable)() -> MODULE$.failValidation(new StringBuilder(27).append("Variable '").append((String)v).append("' is not defined.").toString(), "Variables are scoped on a per\u2010operation basis. That means that any variable used within the context of an operation must be defined at the top level of that operation"))).$times$greater((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.foreach_(op.variableDefinitions(), (Function1 & Serializable & scala.Serializable)v -> IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !variableUsages.contains((Object)v.name()), (Function0 & Serializable & scala.Serializable)() -> MODULE$.failValidation(new StringBuilder(24).append("Variable '").append(v.name()).append("' is not used.").toString(), "All variables defined by an operation must be used in that operation or a fragment transitively included by that operation. Unused variables cause a validation error."))));
        }));
    }

    private List<Selection.FragmentSpread> collectFragmentSpreads(List<Selection> selectionSet) {
        return (List)selectionSet.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Selection, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object = x1 instanceof Selection.FragmentSpread ? (Selection.FragmentSpread)x1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Selection x1) {
                boolean bl = x1 instanceof Selection.FragmentSpread;
                return bl;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateFragmentSpreads(package.Context context) {
        scala.collection.immutable.Set spreadNames = ((TraversableOnce)this.collectFragmentSpreads(context.selectionSets()).map((Function1 & Serializable & scala.Serializable)x$30 -> x$30.name(), List$.MODULE$.canBuildFrom())).toSet();
        return IO$.MODULE$.foreach_(context.fragments().values(), (Function1 & Serializable & scala.Serializable)f -> {
            if (!spreadNames.contains((Object)f.name())) {
                return MODULE$.failValidation(new StringBuilder(38).append("Fragment '").append(f.name()).append("' is not used in any spread.").toString(), "Defined fragments must be used within a document.");
            }
            return MODULE$.failValidation(new StringBuilder(26).append("Fragment '").append(f.name()).append("' forms a cycle.").toString(), "The graph of fragment spreads must not form any cycles including spreading itself. Otherwise an operation could infinitely spread or infinitely execute on cycles in the underlying data.").when((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> MODULE$.detectCycles(context, (Definition.ExecutableDefinition.FragmentDefinition)f, MODULE$.detectCycles$default$3()));
        });
    }

    private boolean detectCycles(package.Context context, Definition.ExecutableDefinition.FragmentDefinition fragment, scala.collection.immutable.Set<String> visited) {
        List<Selection> selectionSets = this.collectSelectionSets(fragment.selectionSet());
        return this.collectFragmentSpreads(selectionSets).exists((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$detectCycles$1(visited, context, s)));
    }

    private scala.collection.immutable.Set<String> detectCycles$default$3() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateDocumentFields(package.Context context) {
        return IO$.MODULE$.foreach_(context.document().definitions(), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ZIO zIO;
            if (x0$1 instanceof Definition.ExecutableDefinition.OperationDefinition) {
                ZIO zIO2;
                Definition.ExecutableDefinition.OperationDefinition operationDefinition = (Definition.ExecutableDefinition.OperationDefinition)x0$1;
                OperationType opType = operationDefinition.operationType();
                List<Selection> selectionSet = operationDefinition.selectionSet();
                if (OperationType$Query$.MODULE$.equals(opType)) {
                    zIO2 = MODULE$.validateSelectionSet(context, selectionSet, context.rootType().queryType());
                } else if (OperationType$Mutation$.MODULE$.equals(opType)) {
                    zIO2 = (ZIO)context.rootType().mutationType().fold((Function0 & Serializable & scala.Serializable)() -> MODULE$.failValidation("Mutation operations are not supported on this schema.", ""), (Function1 & Serializable & scala.Serializable)x$31 -> MODULE$.validateSelectionSet(context, selectionSet, (__Type)x$31));
                } else if (OperationType$Subscription$.MODULE$.equals(opType)) {
                    zIO2 = (ZIO)context.rootType().subscriptionType().fold((Function0 & Serializable & scala.Serializable)() -> MODULE$.failValidation("Subscription operations are not supported on this schema.", ""), (Function1 & Serializable & scala.Serializable)x$32 -> MODULE$.validateSelectionSet(context, selectionSet, (__Type)x$32));
                } else {
                    throw new MatchError((Object)opType);
                }
                zIO = zIO2;
            } else if (x0$1 instanceof Definition.ExecutableDefinition.FragmentDefinition) {
                zIO = IO$.MODULE$.unit();
            } else if (x0$1 instanceof Definition.TypeSystemDefinition) {
                zIO = IO$.MODULE$.unit();
            } else if (x0$1 instanceof Definition.TypeSystemExtension) {
                zIO = IO$.MODULE$.unit();
            } else {
                throw new MatchError(x0$1);
            }
            return zIO;
        });
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateSelectionSet(package.Context context, List<Selection> selectionSet, __Type currentType) {
        return this.validateFields(context, selectionSet, currentType).$times$greater((Function0 & Serializable & scala.Serializable)() -> FragmentValidator$.MODULE$.findConflictsWithinSelectionSet(context, context.rootType().queryType(), selectionSet));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateFields(package.Context context, List<Selection> selectionSet, __Type currentType) {
        return IO$.MODULE$.foreach_(selectionSet, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            if (x0$1 instanceof Selection.Field) {
                Selection.Field field = (Selection.Field)x0$1;
                object = MODULE$.validateField(context, field, currentType);
            } else if (x0$1 instanceof Selection.FragmentSpread) {
                Object object2;
                String name = ((Selection.FragmentSpread)x0$1).name();
                Option option2 = context.fragments().get((Object)name);
                if (None$.MODULE$.equals(option2)) {
                    object2 = MODULE$.failValidation(new StringBuilder(34).append("Fragment spread '").append(name).append("' is not defined.").toString(), "Named fragment spreads must refer to fragments defined within the document. It is a validation error if the target of a spread is not defined.");
                } else if (option2 instanceof Some) {
                    Definition.ExecutableDefinition.FragmentDefinition fragment = (Definition.ExecutableDefinition.FragmentDefinition)((Some)option2).value();
                    object2 = MODULE$.validateSpread(context, (Option<String>)new Some((Object)name), currentType, (Option<Type.NamedType>)new Some((Object)fragment.typeCondition()), fragment.selectionSet());
                } else {
                    throw new MatchError((Object)option2);
                }
                object = object2;
            } else if (x0$1 instanceof Selection.InlineFragment) {
                Selection.InlineFragment inlineFragment = (Selection.InlineFragment)x0$1;
                Option<Type.NamedType> typeCondition = inlineFragment.typeCondition();
                List<Selection> selectionSet = inlineFragment.selectionSet();
                object = MODULE$.validateSpread(context, (Option<String>)None$.MODULE$, currentType, typeCondition, selectionSet);
            } else {
                throw new MatchError(x0$1);
            }
            return object;
        }).$times$greater((Function0 & Serializable & scala.Serializable)() -> MODULE$.validateLeafFieldSelection(selectionSet, currentType));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateSpread(package.Context context, Option<String> name, __Type currentType, Option<Type.NamedType> typeCondition, List<Selection> selectionSet) {
        ZIO zIO;
        Option option2 = (Option)typeCondition.fold((Function0 & Serializable & scala.Serializable)() -> new Some((Object)currentType), (Function1 & Serializable & scala.Serializable)t -> context.rootType().types().get((Object)t.name()));
        if (option2 instanceof Some) {
            __Type fragmentType = (__Type)((Some)option2).value();
            zIO = this.validateFragmentType(name, fragmentType).$times$greater((Function0 & Serializable & scala.Serializable)() -> {
                List possibleTypes = (List)MODULE$.getPossibleTypes(currentType).flatMap((Function1 & Serializable & scala.Serializable)x$33 -> Option$.MODULE$.option2Iterable(x$33.name()), List$.MODULE$.canBuildFrom());
                List possibleFragmentTypes = (List)MODULE$.getPossibleTypes(fragmentType).flatMap((Function1 & Serializable & scala.Serializable)x$34 -> Option$.MODULE$.option2Iterable(x$34.name()), List$.MODULE$.canBuildFrom());
                List applicableTypes = (List)possibleTypes.intersect((GenSeq)possibleFragmentTypes);
                return IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> applicableTypes.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.failValidation(new StringBuilder(75).append(name.fold((Function0 & Serializable & scala.Serializable)() -> "Inline fragment spread", (Function1 & Serializable & scala.Serializable)n -> new StringBuilder(18).append("Fragment spread '").append((String)n).append("'").toString())).append(" is not possible: possible types are '").append(possibleTypes.mkString(", ")).append("' and possible fragment types are '").append(possibleFragmentTypes.mkString(", ")).append("'.").toString(), "Fragments are declared on a type and will only apply when the runtime object type matches the type condition. They also are spread within the context of a parent type. A fragment spread is only valid if its type condition could ever apply within the parent type.")).$times$greater((Function0 & Serializable & scala.Serializable)() -> MODULE$.validateFields(context, selectionSet, fragmentType));
            });
        } else if (None$.MODULE$.equals(option2)) {
            LazyRef typeConditionName$lzy = new LazyRef();
            zIO = this.failValidation(new StringBuilder(29).append(name.fold((Function0 & Serializable & scala.Serializable)() -> "Inline fragment spread", (Function1 & Serializable & scala.Serializable)n -> new StringBuilder(18).append("Fragment spread '").append((String)n).append("'").toString())).append(" targets an invalid type: '").append(Validator$.typeConditionName$1(typeConditionName$lzy, typeCondition)).append("'.").toString(), "Fragments must be specified on types that exist in the schema. This applies for both named and inline fragments. If they are not defined in the schema, the query does not validate.");
        } else {
            throw new MatchError((Object)option2);
        }
        return zIO;
    }

    private List<__Type> getPossibleTypes(__Type t) {
        Object object;
        __TypeKind __TypeKind2 = t.kind();
        if (__TypeKind$OBJECT$.MODULE$.equals(__TypeKind2)) {
            object = new .colon.colon((Object)t, (List)Nil$.MODULE$);
        } else {
            boolean bl = __TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$UNION$.MODULE$.equals(__TypeKind2);
            object = bl ? (List)t.possibleTypes().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$) : Nil$.MODULE$;
        }
        return object;
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateField(package.Context context, Selection.Field field, __Type currentType) {
        return IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string2 = field.name();
            String string3 = "__typename";
            return string2 == null || !string2.equals(string3);
        }, (Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.fromOption((Function0 & Serializable & scala.Serializable)() -> ((LinearSeqOptimized)((Option)currentType.fields().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).find((Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateField$5(field, x$36)))).orElseFail((Function0 & Serializable & scala.Serializable)() -> new CalibanError.ValidationError(new StringBuilder(35).append("Field '").append(field.name()).append("' does not exist on type '").append(Rendering$.MODULE$.renderTypeName(currentType)).append("'.").toString(), "The target field of a field selection must be defined on the scoped type of the selection set. There are no limitations on alias names.", CalibanError$ValidationError$.MODULE$.apply$default$3(), CalibanError$ValidationError$.MODULE$.apply$default$4()), CanFail$.MODULE$.canFail()).flatMap((Function1 & Serializable & scala.Serializable)f -> MODULE$.validateFields(context, field.selectionSet(), Types$.MODULE$.innerType((__Type)f.type().apply())).$times$greater((Function0 & Serializable & scala.Serializable)() -> MODULE$.validateArguments(field, (__Field)f, currentType, context))));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateArguments(Selection.Field field, __Field f, __Type currentType, package.Context context) {
        return IO$.MODULE$.foreach_((Iterable)f.args().filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateArguments$1(a))), (Function1 & Serializable & scala.Serializable)arg -> {
            InputValue inputValue;
            InputValue inputValue2;
            Option option2 = field.arguments().get((Object)arg.name());
            Option<String> option3 = arg.defaultValue();
            boolean bl = None$.MODULE$.equals(option3) && None$.MODULE$.equals(option2) ? true : None$.MODULE$.equals(option3) && option2 instanceof Some && Value$NullValue$.MODULE$.equals(inputValue2 = (InputValue)((Some)option2).value());
            ZIO zIO = bl ? MODULE$.failValidation(new StringBuilder(63).append("Required argument '").append(arg.name()).append("' is null or missing on field '").append(field.name()).append("' of type '").append(currentType.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("'.").toString(), "Arguments can be required. An argument is required if the argument type is non\u2010null and does not have a default value. Otherwise, the argument is optional.") : (option3 instanceof Some && option2 instanceof Some && Value$NullValue$.MODULE$.equals(inputValue = (InputValue)((Some)option2).value()) ? MODULE$.failValidation(new StringBuilder(46).append("Required argument '").append(arg.name()).append("' is null on '").append(field.name()).append("' of type '").append(currentType.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("'.").toString(), "Arguments can be required. An argument is required if the argument type is non\u2010null and does not have a default value. Otherwise, the argument is optional.") : IO$.MODULE$.unit());
            return zIO;
        }).$times$greater((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.foreach_(field.arguments(), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            void var5_10;
            if (x0$1 == null) throw new MatchError(null);
            String arg = (String)x0$1._1();
            InputValue argValue = (InputValue)x0$1._2();
            Option option2 = f.args().find((Function1 & Serializable & scala.Serializable)x$37 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateArguments$7(arg, x$37)));
            if (None$.MODULE$.equals(option2)) {
                ZIO zIO = MODULE$.failValidation(new StringBuilder(50).append("Argument '").append(arg).append("' is not defined on field '").append(field.name()).append("' of type '").append(currentType.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("'.").toString(), "Every argument provided to a field or directive must be defined in the set of possible arguments of that field or directive.");
                return var5_10;
            } else {
                if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                __InputValue inputValue = (__InputValue)((Some)option2).value();
                ZIO<Object, CalibanError.ValidationError, BoxedUnit> zIO = MODULE$.validateInputValues(inputValue, argValue, context, new StringBuilder(25).append("InputValue '").append(inputValue.name()).append("' of Field '").append(field.name()).append("'").toString());
            }
            return var5_10;
        }));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateInputValues(__InputValue inputValue, InputValue argValue, package.Context context, String errorContext) {
        void var6_17;
        ZIO zIO;
        __Type t = (__Type)inputValue.type().apply();
        __TypeKind __TypeKind2 = t.kind();
        __TypeKind$NON_NULL$ __TypeKind$NON_NULL$2 = __TypeKind$NON_NULL$.MODULE$;
        __Type inputType = !(__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$NON_NULL$2) : __TypeKind$NON_NULL$2 != null) ? (__Type)t.ofType().getOrElse((Function0 & Serializable & scala.Serializable)() -> t) : t;
        List inputFields = (List)inputType.inputFields().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        if (argValue instanceof InputValue.ObjectValue) {
            Map<String, InputValue> fields = ((InputValue.ObjectValue)argValue).fields();
            __TypeKind __TypeKind3 = inputType.kind();
            __TypeKind$INPUT_OBJECT$ __TypeKind$INPUT_OBJECT$2 = __TypeKind$INPUT_OBJECT$.MODULE$;
            if (!(__TypeKind3 != null ? !__TypeKind3.equals(__TypeKind$INPUT_OBJECT$2) : __TypeKind$INPUT_OBJECT$2 != null)) {
                zIO = IO$.MODULE$.foreach_(fields, (Function1 & Serializable & scala.Serializable)x0$1 -> {
                    void var6_11;
                    if (x0$1 == null) throw new MatchError(null);
                    String k = (String)x0$1._1();
                    InputValue v = (InputValue)x0$1._2();
                    Option option2 = inputFields.find((Function1 & Serializable & scala.Serializable)x$38 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateInputValues$4(k, x$38)));
                    if (None$.MODULE$.equals(option2)) {
                        ZIO zIO = MODULE$.failValidation(new StringBuilder(41).append("Input field '").append(k).append("' is not defined on type '").append(inputType.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "?")).append("'.").toString(), "Every input field provided in an input object value must be defined in the set of possible fields of that input object\u2019s expected type.");
                        return var6_11;
                    } else {
                        if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                        __InputValue value = (__InputValue)((Some)option2).value();
                        ZIO<Object, CalibanError.ValidationError, BoxedUnit> zIO = MODULE$.validateInputValues(value, v, context, new StringBuilder(43).append("InputValue '").append(inputValue.name()).append("' of Field '").append(k).append("' of InputObject '").append(t.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("'").toString());
                    }
                    return var6_11;
                }).$times$greater((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.foreach_((Iterable)inputFields, (Function1 & Serializable & scala.Serializable)inputField -> IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                    if (inputField.defaultValue().isEmpty()) {
                        __TypeKind __TypeKind2 = ((__Type)inputField.type().apply()).kind();
                        __TypeKind$NON_NULL$ __TypeKind$NON_NULL$2 = __TypeKind$NON_NULL$.MODULE$;
                        if (!(__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$NON_NULL$2) : __TypeKind$NON_NULL$2 != null)) {
                            Object object = fields.getOrElse((Object)inputField.name(), (Function0 & Serializable & scala.Serializable)() -> Value$NullValue$.MODULE$);
                            Value$NullValue$ value$NullValue$ = Value$NullValue$.MODULE$;
                            if (!(object != null ? !object.equals(value$NullValue$) : value$NullValue$ != null)) {
                                return true;
                            }
                        }
                    }
                    return false;
                }, (Function0 & Serializable & scala.Serializable)() -> MODULE$.failValidation(new StringBuilder(48).append("Required field '").append(inputField.name()).append("' on object '").append(inputType.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "?")).append("' was not provided.").toString(), "Input object fields may be required. Much like a field may have required arguments, an input object may have required fields. An input field is required if it has a non\u2010null type and does not have a default value. Otherwise, the input object field is optional."))));
                return zIO.$times$greater((Function0 & Serializable & scala.Serializable)() -> ValueValidator$.MODULE$.validateInputTypes(inputValue, argValue, context, errorContext));
            }
        }
        if (!(argValue instanceof InputValue.VariableValue)) {
            zIO = IO$.MODULE$.unit();
            return zIO.$times$greater((Function0 & Serializable & scala.Serializable)() -> ValueValidator$.MODULE$.validateInputTypes(inputValue, argValue, context, errorContext));
        }
        String variableName = ((InputValue.VariableValue)argValue).name();
        Option option2 = context.variableDefinitions().get((Object)variableName);
        if (option2 instanceof Some) {
            VariableDefinition variableDefinition = (VariableDefinition)((Some)option2).value();
            ZIO<Object, CalibanError.ValidationError, BoxedUnit> zIO2 = this.checkVariableUsageAllowed(variableDefinition, inputValue);
        } else {
            if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
            ZIO zIO3 = this.failValidation(new StringBuilder(27).append("Variable '").append(variableName).append("' is not defined.").toString(), "Variables are scoped on a per\u2010operation basis. That means that any variable used within the context of an operation must be defined at the top level of that operation");
        }
        zIO = var6_17;
        return zIO.$times$greater((Function0 & Serializable & scala.Serializable)() -> ValueValidator$.MODULE$.validateInputTypes(inputValue, argValue, context, errorContext));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> checkVariableUsageAllowed(VariableDefinition variableDefinition, __InputValue inputValue) {
        __Type locationType = (__Type)inputValue.type().apply();
        Type variableType = variableDefinition.variableType();
        if (!locationType.isNullable() && !variableType.nonNull()) {
            boolean hasNonNullVariableDefaultValue = variableDefinition.defaultValue().exists((Function1 & Serializable & scala.Serializable)x$39 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$checkVariableUsageAllowed$1(x$39)));
            boolean hasLocationDefaultValue = inputValue.defaultValue().nonEmpty();
            if (!hasNonNullVariableDefaultValue && !hasLocationDefaultValue) {
                return this.failValidation(new StringBuilder(89).append("Variable '").append(variableDefinition.name()).append("' usage is not allowed because it is nullable and doesn't have a default value.").toString(), "Variable usages must be compatible with the arguments they are passed to.");
            }
            __Type nullableLocationType = (__Type)locationType.ofType().getOrElse((Function0 & Serializable & scala.Serializable)() -> locationType);
            return this.checkTypesCompatible(variableDefinition.name(), variableType, nullableLocationType);
        }
        return this.checkTypesCompatible(variableDefinition.name(), variableType, locationType);
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> checkTypesCompatible(String variableName, Type variableType, __Type locationType) {
        ZIO zIO;
        String explanation;
        block8: {
            block9: {
                while (true) {
                    __Type itemLocationType;
                    explanation = "Variable usages must be compatible with the arguments they are passed to.";
                    if (!locationType.isNullable()) {
                        if (variableType.nullable()) {
                            return this.failValidation(new StringBuilder(76).append("Variable '").append(variableName).append("' usage is not allowed because it is nullable but it shouldn't be.").toString(), explanation);
                        }
                        __Type nullableLocationType = (__Type)locationType.ofType().getOrElse((Function0 & Serializable & scala.Serializable)() -> locationType);
                        Type nullableVariableType = variableType.toNullable();
                        locationType = nullableLocationType;
                        variableType = nullableVariableType;
                        continue;
                    }
                    if (variableType.nonNull()) {
                        Type nullableVariableType;
                        variableType = nullableVariableType = variableType.toNullable();
                        continue;
                    }
                    __TypeKind __TypeKind2 = locationType.kind();
                    __TypeKind$LIST$ __TypeKind$LIST$2 = __TypeKind$LIST$.MODULE$;
                    if (__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$LIST$2) : __TypeKind$LIST$2 != null) break block8;
                    if (variableType instanceof Type.NamedType) break block9;
                    if (!(variableType instanceof Type.ListType)) break;
                    Type ofType = ((Type.ListType)variableType).ofType();
                    locationType = itemLocationType = (__Type)locationType.ofType().getOrElse((Function0 & Serializable & scala.Serializable)() -> locationType);
                    variableType = ofType;
                }
                throw new MatchError((Object)variableType);
            }
            ZIO zIO2 = this.failValidation(new StringBuilder(77).append("Variable '").append(variableName).append("' usage is not allowed because it is a not a list but it should be.").toString(), explanation);
            return zIO2;
        }
        if (variableType instanceof Type.ListType) {
            zIO = this.failValidation(new StringBuilder(75).append("Variable '").append(variableName).append("' usage is not allowed because it is a list but it should not be.").toString(), explanation);
        } else if (variableType instanceof Type.NamedType) {
            String name = ((Type.NamedType)variableType).name();
            zIO = IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !locationType.name().contains((Object)name), (Function0 & Serializable & scala.Serializable)() -> MODULE$.failValidation(new StringBuilder(90).append("Variable '").append(variableName).append("' usage is not allowed because its type doesn't match the schema (").append(name).append(" instead of ").append(locationType.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(").").toString(), explanation));
        } else {
            throw new MatchError((Object)variableType);
        }
        return zIO;
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateLeafFieldSelection(List<Selection> selections, __Type currentType) {
        return IO$.MODULE$.whenCase((Function0 & Serializable & scala.Serializable)() -> currentType.kind(), (PartialFunction)new scala.Serializable(selections, currentType){
            public static final long serialVersionUID = 0L;
            private final List selections$1;
            private final __Type currentType$5;

            public final <A1 extends __TypeKind, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ZIO<Object, CalibanError.ValidationError, T> zIO;
                boolean bl = __TypeKind$SCALAR$.MODULE$.equals(x1) ? true : __TypeKind$ENUM$.MODULE$.equals(x1);
                if (bl && this.selections$1.nonEmpty()) {
                    zIO = Validator$.MODULE$.failValidation(new StringBuilder(41).append("Field selection is impossible on type '").append(this.currentType$5.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("'.").toString(), "Field selections on scalars or enums are never allowed, because they are the leaf nodes of any GraphQL query.");
                } else {
                    boolean bl2 = __TypeKind$INTERFACE$.MODULE$.equals(x1) ? true : (__TypeKind$UNION$.MODULE$.equals(x1) ? true : __TypeKind$OBJECT$.MODULE$.equals(x1));
                    zIO = bl2 && this.selections$1.isEmpty() ? Validator$.MODULE$.failValidation(new StringBuilder(40).append("Field selection is mandatory on type '").append(this.currentType$5.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("'.").toString(), "Leaf selections on objects, interfaces, and unions without subfields are disallowed.") : function1.apply(x1);
                }
                return (B1)zIO;
            }

            public final boolean isDefinedAt(__TypeKind x1) {
                boolean bl;
                boolean bl2 = __TypeKind$SCALAR$.MODULE$.equals(x1) ? true : __TypeKind$ENUM$.MODULE$.equals(x1);
                if (bl2 && this.selections$1.nonEmpty()) {
                    bl = true;
                } else {
                    boolean bl3 = __TypeKind$INTERFACE$.MODULE$.equals(x1) ? true : (__TypeKind$UNION$.MODULE$.equals(x1) ? true : __TypeKind$OBJECT$.MODULE$.equals(x1));
                    bl = bl3 && this.selections$1.isEmpty();
                }
                return bl;
            }
            {
                this.selections$1 = selections$1;
                this.currentType$5 = currentType$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(), $anonfun$applyOrElse$2()}, serializedLambda);
            }
        });
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateOperationNameUniqueness(List<Definition.ExecutableDefinition.OperationDefinition> operations) {
        scala.collection.immutable.Iterable repeatedNames = (scala.collection.immutable.Iterable)((TraversableLike)operations.flatMap((Function1 & Serializable & scala.Serializable)x$40 -> Option$.MODULE$.option2Iterable(x$40.name()), List$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, List<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    String name = (String)x1._1();
                    if (((List)x1._2()).length() > 1) {
                        object = name;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, List<String>> x1) {
                boolean bl = x1 != null && ((List)x1._2()).length() > 1;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        return IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> repeatedNames.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.failValidation(new StringBuilder(41).append("Multiple operations have the same name: ").append(repeatedNames.mkString(", ")).append(".").toString(), "Each named operation definition must be unique within a document when referred to by its name."));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateLoneAnonymousOperation(List<Definition.ExecutableDefinition.OperationDefinition> operations) {
        List anonymous = (List)operations.filter((Function1 & Serializable & scala.Serializable)x$41 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateLoneAnonymousOperation$1(x$41)));
        return IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> operations.length() > 1 && anonymous.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.failValidation("Found both anonymous and named operations.", "GraphQL allows a short\u2010hand form for defining query operations when only that one operation exists in the document."));
    }

    private ZIO<Object, CalibanError.ValidationError, Map<String, Definition.ExecutableDefinition.FragmentDefinition>> validateFragments(List<Definition.ExecutableDefinition.FragmentDefinition> fragments) {
        return IO$.MODULE$.foldLeft(fragments, (Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Map fragmentMap = x0$1;
            Definition.ExecutableDefinition.FragmentDefinition fragment = x1$1;
            if (fragmentMap.contains((Object)fragment.name())) {
                return MODULE$.failValidation(new StringBuilder(38).append("Fragment '").append(fragment.name()).append("' is defined more than once.").toString(), "Fragment definitions are referenced in fragment spreads by name. To avoid ambiguity, each fragment\u2019s name must be unique within a document.");
            }
            return IO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> fragmentMap.updated((Object)fragment.name(), (Object)fragment));
        });
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateSubscriptionOperation(package.Context context) {
        return IO$.MODULE$.fromOption((Function0 & Serializable & scala.Serializable)() -> context.rootType().subscriptionType().flatMap((Function1 & Serializable & scala.Serializable)t -> ((LinearSeqOptimized)context.operations().filter((Function1 & Serializable & scala.Serializable)x$42 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateSubscriptionOperation$3(x$42)))).find((Function1 & Serializable & scala.Serializable)op -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateSubscriptionOperation$4(context, t, op))).map((Function1 & Serializable & scala.Serializable)op -> op))).map((Function1 & Serializable & scala.Serializable)op -> {
            String subscription = (String)op.name().fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)n -> new StringBuilder(2).append("'").append((String)n).append("'").toString());
            return new CalibanError.ValidationError(new StringBuilder(43).append("Subscription ").append(subscription).append(" has more than one root field.").toString(), "Subscription operations must have exactly one root field.", CalibanError$ValidationError$.MODULE$.apply$default$3(), CalibanError$ValidationError$.MODULE$.apply$default$4());
        }).flip().unit();
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateFragmentType(Option<String> name, __Type targetType) {
        ZIO zIO;
        __TypeKind __TypeKind2 = targetType.kind();
        boolean bl = __TypeKind$UNION$.MODULE$.equals(__TypeKind2) ? true : (__TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$OBJECT$.MODULE$.equals(__TypeKind2));
        if (bl) {
            zIO = IO$.MODULE$.unit();
        } else {
            String targetTypeName = (String)targetType.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            zIO = this.failValidation(new StringBuilder(30).append(name.fold((Function0 & Serializable & scala.Serializable)() -> "Inline fragment", (Function1 & Serializable & scala.Serializable)n -> new StringBuilder(11).append("Fragment '").append((String)n).append("'").toString())).append(" is defined on invalid type '").append(targetTypeName).append("'").toString(), "Fragments can only be declared on unions, interfaces, and objects. They are invalid on scalars. They can only be applied on non\u2010leaf fields. This rule applies to both inline and named fragments.");
        }
        return zIO;
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateEnum(__Type t) {
        Option option2 = (Option)t.enumValues().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))));
        ZIO zIO = option2 instanceof Some && (List)((Some)option2).value() instanceof .colon.colon ? IO$.MODULE$.unit() : this.failValidation(new StringBuilder(32).append("Enum ").append(t.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(" doesn't contain any values").toString(), "An Enum type must define one or more unique enum values.");
        return zIO;
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateUnion(__Type t2) {
        List types;
        List list2;
        Option<List<__Type>> option2 = t2.possibleTypes();
        boolean bl = None$.MODULE$.equals(option2) ? true : option2 instanceof Some && Nil$.MODULE$.equals(list2 = (List)((Some)option2).value());
        ZIO zIO = bl ? this.failValidation(new StringBuilder(32).append("Union ").append(t2.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(" doesn't contain any type.").toString(), "A Union type must include one or more unique member types.") : (option2 instanceof Some && !(types = (List)((Some)option2).value()).forall((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.isObjectType(t))) ? this.failValidation(new StringBuilder(48).append("Union ").append(t2.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(" contains the following non Object types: ").append(((TraversableOnce)((TraversableLike)((List)types.filterNot((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.isObjectType(t)))).map((Function1 & Serializable & scala.Serializable)x$43 -> (String)x$43.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), List$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$44 -> BoxesRunTime.boxToBoolean((boolean)x$44.isEmpty()))).mkString("", ", ", ".")).toString(), "The member types of a Union type must all be Object base types.") : IO$.MODULE$.unit());
        return zIO;
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateInputObject(__Type t) {
        ZIO zIO;
        List list2;
        String inputObjectContext = new StringBuilder(14).append("InputObject '").append(t.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("'").toString();
        Option<List<__InputValue>> option2 = t.inputFields();
        boolean bl = None$.MODULE$.equals(option2) ? true : option2 instanceof Some && Nil$.MODULE$.equals(list2 = (List)((Some)option2).value());
        if (bl) {
            zIO = this.failValidation(new StringBuilder(21).append(inputObjectContext).append(" does not have fields").toString(), "An Input Object type must define one or more input fields");
        } else if (option2 instanceof Some) {
            List fields = (List)((Some)option2).value();
            zIO = this.validateFields$1(fields, inputObjectContext);
        } else {
            throw new MatchError(option2);
        }
        return zIO;
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateInputValue(__InputValue inputValue, String errorContext) {
        String fieldContext = new StringBuilder(17).append("InputValue '").append(inputValue.name()).append("' of ").append(errorContext).toString();
        return ValueValidator$.MODULE$.validateDefaultValue(inputValue, fieldContext).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.doesNotStartWithUnderscore(inputValue, fieldContext).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.onlyInputType((__Type)inputValue.type().apply(), fieldContext).map((Function1 & Serializable & scala.Serializable)_ -> {
            Validator$.$anonfun$validateInputValue$3(_);
            return BoxedUnit.UNIT;
        })));
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateInterface(__Type t) {
        Object object;
        List list2;
        String interfaceContext = new StringBuilder(12).append("Interface '").append(t.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("'").toString();
        Option option2 = (Option)t.fields().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))));
        boolean bl = None$.MODULE$.equals(option2) ? true : option2 instanceof Some && Nil$.MODULE$.equals(list2 = (List)((Some)option2).value());
        if (bl) {
            object = this.failValidation(new StringBuilder(21).append(interfaceContext).append(" does not have fields").toString(), "An Interface type must define one or more fields");
        } else if (option2 instanceof Some) {
            List fields = (List)((Some)option2).value();
            object = this.validateFields((List<__Field>)fields, interfaceContext);
        } else {
            throw new MatchError((Object)option2);
        }
        return object;
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateObject(__Type obj) {
        ZIO zIO;
        List list2;
        String objectContext = new StringBuilder(9).append("Object '").append(obj.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("'").toString();
        Option option2 = (Option)obj.fields().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))));
        boolean bl = None$.MODULE$.equals(option2) ? true : option2 instanceof Some && Nil$.MODULE$.equals(list2 = (List)((Some)option2).value());
        if (bl) {
            zIO = this.failValidation(new StringBuilder(21).append(objectContext).append(" does not have fields").toString(), "An Object type must define one or more fields");
        } else if (option2 instanceof Some) {
            List fields = (List)((Some)option2).value();
            zIO = this.validateFields((List<__Field>)fields, objectContext).$times$greater((Function0 & Serializable & scala.Serializable)() -> Validator$.validateInterfaceFields$1(obj, objectContext));
        } else {
            throw new MatchError((Object)option2);
        }
        return zIO;
    }

    public boolean caliban$validation$Validator$$isListField(__Field field) {
        __TypeKind __TypeKind2 = ((__Type)field.type().apply()).kind();
        __TypeKind$LIST$ __TypeKind$LIST$2 = __TypeKind$LIST$.MODULE$;
        return !(__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$LIST$2) : __TypeKind$LIST$2 != null);
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> onlyInputType(__Type type, String errorContext) {
        return IO$.MODULE$.whenCase((Function0 & Serializable & scala.Serializable)() -> Validator$.isInputType$1(type), (PartialFunction)new scala.Serializable(errorContext){
            public static final long serialVersionUID = 0L;
            private final String errorContext$3;

            public final <A1 extends Either<__Type, BoxedUnit>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ZIO<Object, CalibanError.ValidationError, T> zIO;
                if (x1 instanceof Left) {
                    __Type errorType = (__Type)((Left)x1).value();
                    zIO = Validator$.MODULE$.failValidation(new StringBuilder(38).append(errorType.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(" of ").append(this.errorContext$3).append(" is of kind ").append(errorType.kind()).append(", must be an InputType").toString(), "The input field must accept a type where IsInputType(type) returns true, https://spec.graphql.org/June2018/#IsInputType()");
                } else {
                    zIO = function1.apply(x1);
                }
                return (B1)zIO;
            }

            public final boolean isDefinedAt(Either<__Type, BoxedUnit> x1) {
                boolean bl = x1 instanceof Left;
                return bl;
            }
            {
                this.errorContext$3 = errorContext$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$15()}, serializedLambda);
            }
        });
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateFields(List<__Field> fields, String context) {
        return this.noDuplicateFieldName(fields, context).$less$times((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.foreach_((Iterable)fields, (Function1 & Serializable & scala.Serializable)field -> {
            String fieldContext = new StringBuilder(12).append("Field '").append(field.name()).append("' of ").append(context).toString();
            return MODULE$.doesNotStartWithUnderscore((__Field)field, fieldContext).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.onlyOutputType((__Type)field.type().apply(), fieldContext).flatMap((Function1 & Serializable & scala.Serializable)_2 -> IO$.MODULE$.foreach_(field.args(), (Function1 & Serializable & scala.Serializable)x$54 -> MODULE$.validateInputValue((__InputValue)x$54, fieldContext)).map((Function1 & Serializable & scala.Serializable)_ -> {
                Validator$.$anonfun$validateFields$8(_);
                return BoxedUnit.UNIT;
            })));
        }));
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> noDuplicateFieldName(List<__Field> fields, String errorContext) {
        Function1 & Serializable & scala.Serializable messageBuilder = (Function1 & Serializable & scala.Serializable)f -> new StringBuilder(22).append(errorContext).append(" has repeated fields: ").append(f.name()).toString();
        String explanatory = "The field must have a unique name within that Interface type; no two fields may share the same name";
        return this.noDuplicateName(fields, (Function1 & Serializable & scala.Serializable)x$55 -> x$55.name(), messageBuilder, explanatory);
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> onlyOutputType(__Type type, String errorContext) {
        return IO$.MODULE$.whenCase((Function0 & Serializable & scala.Serializable)() -> Validator$.isOutputType$1(type), (PartialFunction)new scala.Serializable(errorContext){
            public static final long serialVersionUID = 0L;
            private final String errorContext$5;

            public final <A1 extends Either<__Type, BoxedUnit>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ZIO<Object, CalibanError.ValidationError, T> zIO;
                if (x1 instanceof Left) {
                    __Type errorType = (__Type)((Left)x1).value();
                    zIO = Validator$.MODULE$.failValidation(new StringBuilder(39).append(errorType.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(" of ").append(this.errorContext$5).append(" is of kind ").append(errorType.kind()).append(", must be an OutputType").toString(), "The input field must accept a type where IsOutputType(type) returns true, https://spec.graphql.org/June2018/#IsInputType()");
                } else {
                    zIO = function1.apply(x1);
                }
                return (B1)zIO;
            }

            public final boolean isDefinedAt(Either<__Type, BoxedUnit> x1) {
                boolean bl = x1 instanceof Left;
                return bl;
            }
            {
                this.errorContext$5 = errorContext$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$16()}, serializedLambda);
            }
        });
    }

    public <T> ZIO<Object, CalibanError.ValidationError, BoxedUnit> noDuplicateName(List<T> listOfNamed, Function1<T, String> nameExtractor, Function1<T, String> messageBuilder, String explanatoryText) {
        return (ZIO)listOfNamed.groupBy((Function1 & Serializable & scala.Serializable)x$56 -> (String)nameExtractor.apply(x$56)).collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, List<T>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                List list2;
                if (x1 != null && (list2 = (List)x1._2()) instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list2;
                    Object f = colon2.head();
                    if (colon2.tl$access$1() instanceof .colon.colon) {
                        object = f;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, List<T>> x1) {
                List list2;
                boolean bl = x1 != null && (list2 = (List)x1._2()) instanceof .colon.colon && ((.colon.colon)list2).tl$access$1() instanceof .colon.colon;
                return bl;
            }
        }).fold((Function0 & Serializable & scala.Serializable)() -> IO$.MODULE$.unit(), (Function1 & Serializable & scala.Serializable)duplicate -> MODULE$.failValidation((String)messageBuilder.apply(duplicate), explanatoryText));
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> doesNotStartWithUnderscore(__Field field, String errorContext) {
        String explanatory = "The field must not have a name which begins with the characters {\"__\"} (two underscores)";
        return this.doesNotStartWithUnderscore(field, (Function1 & Serializable & scala.Serializable)x$57 -> x$57.name(), errorContext, explanatory);
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> doesNotStartWithUnderscore(__InputValue inputValue, String errorContext) {
        String explanatory = "The input field must not have a name which begins with the characters \"__\" (two underscores)";
        return this.doesNotStartWithUnderscore(inputValue, (Function1 & Serializable & scala.Serializable)x$58 -> x$58.name(), errorContext, explanatory);
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> doesNotStartWithUnderscore(Directive directive, String errorContext) {
        String explanatory = "The directive must not have a name which begins with the characters \"__\" (two underscores)";
        return this.doesNotStartWithUnderscore(directive, (Function1 & Serializable & scala.Serializable)x$59 -> x$59.name(), errorContext, explanatory);
    }

    public <T> ZIO<Object, CalibanError.ValidationError, BoxedUnit> doesNotStartWithUnderscore(T t, Function1<T, String> nameExtractor, String errorContext, String explanatoryText) {
        return IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((String)nameExtractor.apply(t)).startsWith("__"), (Function0 & Serializable & scala.Serializable)() -> MODULE$.failValidation(new StringBuilder(22).append(errorContext).append(" can't start with '__'").toString(), explanatoryText));
    }

    public <R> ZIO<Object, CalibanError.ValidationError, RootSchema<R>> validateRootQuery(RootSchemaBuilder<R> schema) {
        ZIO zIO;
        Option<Operation<R>> option2 = schema.query();
        if (None$.MODULE$.equals(option2)) {
            zIO = this.failValidation("The query root operation is missing.", "The query root operation type must be provided and must be an Object type.");
        } else if (option2 instanceof Some) {
            Operation query = (Operation)((Some)option2).value();
            zIO = IO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> new RootSchema(query, schema.mutation(), schema.subscription()));
        } else {
            throw new MatchError(option2);
        }
        return zIO;
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateClashingTypes(List<__Type> types) {
        Option check = types.groupBy((Function1 & Serializable & scala.Serializable)x$60 -> x$60.name()).collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Option<String>, List<__Type>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    Option option2 = (Option)x1._1();
                    List v = (List)x1._2();
                    if (option2 instanceof Some) {
                        String name = (String)((Some)option2).value();
                        if (v.size() > 1) {
                            object = new Tuple2((Object)name, (Object)v);
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<Option<String>, List<__Type>> x1) {
                if (x1 == null) return false;
                Option option2 = (Option)x1._1();
                List v = (List)x1._2();
                if (!(option2 instanceof Some)) return false;
                if (v.size() <= 1) return false;
                return true;
            }
        });
        return IO$.MODULE$.whenCase((Function0 & Serializable & scala.Serializable)() -> check, (PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Option<Tuple2<String, List<__Type>>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                ZIO<Object, CalibanError.ValidationError, T> zIO;
                Tuple2 tuple2;
                if (x2 instanceof Some && (tuple2 = (Tuple2)((Some)x2).value()) != null) {
                    String name = (String)tuple2._1();
                    List values = (List)tuple2._2();
                    zIO = Validator$.MODULE$.failValidation(new StringBuilder(37).append("Type '").append(name).append("' is defined multiple times (").append(((TraversableOnce)((List)values.sortBy((Function1 & Serializable & scala.Serializable)v -> (String)v.origin().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)v -> new StringBuilder(0).append(v.kind()).append(v.origin().fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)a -> new StringBuilder(4).append(" in ").append((String)a).toString())).toString(), List$.MODULE$.canBuildFrom())).mkString(", ")).append(").").toString(), "Each type must be defined only once.");
                } else {
                    zIO = function1.apply(x2);
                }
                return (B1)zIO;
            }

            public final boolean isDefinedAt(Option<Tuple2<String, List<__Type>>> x2) {
                boolean bl = x2 instanceof Some && (Tuple2)((Some)x2).value() != null;
                return bl;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$17(caliban.introspection.adt.__Type ), $anonfun$applyOrElse$19(caliban.introspection.adt.__Type ), $anonfun$applyOrElse$18(), $anonfun$applyOrElse$20(), $anonfun$applyOrElse$21(java.lang.String )}, serializedLambda);
            }
        });
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateDirectives(List<__Type> types) {
        return IO$.MODULE$.foreach_(types, (Function1 & Serializable & scala.Serializable)t -> {
            String typeErrorContext = new StringBuilder(7).append("Type '").append(t.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("'").toString();
            return this.validateDirectives$1(t.directives(), typeErrorContext).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.validateInputValueDirectives$1((List)t.inputFields().getOrElse((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty()), typeErrorContext).flatMap((Function1 & Serializable & scala.Serializable)_2 -> IO$.MODULE$.foreach_((Iterable)((Option)t.fields().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))))).getOrElse((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty()), (Function1 & Serializable & scala.Serializable)x$62 -> this.validateFieldDirectives$1((__Field)x$62, typeErrorContext)).map((Function1 & Serializable & scala.Serializable)_ -> {
                Validator$.$anonfun$validateDirectives$26(_);
                return BoxedUnit.UNIT;
            })));
        });
    }

    public static final /* synthetic */ String $anonfun$prepare$4(String name$1) {
        return new StringBuilder(19).append("Unknown operation ").append(name$1).append(".").toString();
    }

    public static final /* synthetic */ Operation $anonfun$prepare$5(RootSchema rootSchema$1) {
        return rootSchema$1.query();
    }

    public static final /* synthetic */ Operation $anonfun$prepare$6(Operation m$1) {
        return m$1;
    }

    public static final /* synthetic */ Operation $anonfun$prepare$7(Operation m$2) {
        return m$2;
    }

    public static final /* synthetic */ ExecutionRequest $anonfun$prepare$8(Definition.ExecutableDefinition.OperationDefinition op$1, Map fragments$1, Map variables$1, Document document$1, RootType rootType$1, Operation operation) {
        return new ExecutionRequest(Field$.MODULE$.apply(op$1.selectionSet(), (Map<String, Definition.ExecutableDefinition.FragmentDefinition>)fragments$1, (Map<String, InputValue>)variables$1, op$1.variableDefinitions(), operation.opType(), document$1.sourceMapper(), op$1.directives(), rootType$1), op$1.operationType());
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ ZIO $anonfun$prepare$3(Option operationName$1, Document document$1, RootSchema rootSchema$1, Map variables$1, RootType rootType$1, Map fragments) {
        block21: {
            block22: {
                block20: {
                    if (!(operationName$1 instanceof Some)) break block20;
                    name = (String)((Some)operationName$1).value();
                    var10_7 = document$1.definitions().collectFirst((PartialFunction)new scala.Serializable(name){
                        public static final long serialVersionUID = 0L;
                        private final String name$1;

                        public final <A1 extends Definition, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Definition.ExecutableDefinition.OperationDefinition operationDefinition;
                            Object object = x1 instanceof Definition.ExecutableDefinition.OperationDefinition && (operationDefinition = (Definition.ExecutableDefinition.OperationDefinition)x1).name().contains((Object)this.name$1) ? operationDefinition : function1.apply(x1);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Definition x1) {
                            boolean bl = x1 instanceof Definition.ExecutableDefinition.OperationDefinition && ((Definition.ExecutableDefinition.OperationDefinition)x1).name().contains((Object)this.name$1);
                            return bl;
                        }
                        {
                            this.name$1 = name$1;
                        }
                    }).toRight((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$prepare$4(java.lang.String ), ()Ljava/lang/String;)((String)name));
                    break block21;
                }
                if (!None$.MODULE$.equals(operationName$1)) break block22;
                var13_8 = (List)document$1.definitions().collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Definition, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object = x2 instanceof Definition.ExecutableDefinition.OperationDefinition ? (Definition.ExecutableDefinition.OperationDefinition)x2 : function1.apply(x2);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Definition x2) {
                        boolean bl = x2 instanceof Definition.ExecutableDefinition.OperationDefinition;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom());
                if (!(var13_8 instanceof .colon.colon)) ** GOTO lbl-1000
                var14_9 = (.colon.colon)var13_8;
                head = (Definition.ExecutableDefinition.OperationDefinition)var14_9.head();
                var16_11 = var14_9.tl$access$1();
                if (Nil$.MODULE$.equals(var16_11)) {
                    var11_12 = package$.MODULE$.Right().apply((Object)head);
                } else lbl-1000:
                // 2 sources

                {
                    var11_12 = package$.MODULE$.Left().apply((Object)"Operation name is required.");
                }
                var10_7 = var11_12;
                break block21;
            }
            throw new MatchError((Object)operationName$1);
        }
        if (var10_7 instanceof Left) {
            error = (String)((Left)var10_7).value();
            var6_14 = Validator$.MODULE$.failValidation(error, "");
        } else if (var10_7 instanceof Right) {
            op = (Definition.ExecutableDefinition.OperationDefinition)((Right)var10_7).value();
            var19_16 = op.operationType();
            if (OperationType$Query$.MODULE$.equals(var19_16)) {
                var7_17 = IO$.MODULE$.succeed((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$prepare$5(caliban.schema.RootSchema ), ()Lcaliban/schema/Operation;)((RootSchema)rootSchema$1));
            } else if (OperationType$Mutation$.MODULE$.equals(var19_16)) {
                var20_18 = rootSchema$1.mutation();
                if (var20_18 instanceof Some) {
                    m = (Operation)((Some)var20_18).value();
                    var9_20 = IO$.MODULE$.succeed((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$prepare$6(caliban.schema.Operation ), ()Lcaliban/schema/Operation;)((Operation)m));
                } else if (None$.MODULE$.equals(var20_18)) {
                    var9_20 = Validator$.MODULE$.failValidation("Mutations are not supported on this schema", "");
                } else {
                    throw new MatchError(var20_18);
                }
                var7_17 = var9_20;
            } else if (OperationType$Subscription$.MODULE$.equals(var19_16)) {
                var22_21 = rootSchema$1.subscription();
                if (var22_21 instanceof Some) {
                    m = (Operation)((Some)var22_21).value();
                    var8_23 = IO$.MODULE$.succeed((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$prepare$7(caliban.schema.Operation ), ()Lcaliban/schema/Operation;)((Operation)m));
                } else if (None$.MODULE$.equals(var22_21)) {
                    var8_23 = Validator$.MODULE$.failValidation("Subscriptions are not supported on this schema", "");
                } else {
                    throw new MatchError(var22_21);
                }
                var7_17 = var8_23;
            } else {
                throw new MatchError((Object)var19_16);
            }
            var6_14 = var7_17.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$prepare$8(caliban.parsing.adt.Definition$ExecutableDefinition$OperationDefinition scala.collection.immutable.Map scala.collection.immutable.Map caliban.parsing.adt.Document caliban.schema.RootType caliban.schema.Operation ), (Lcaliban/schema/Operation;)Lcaliban/execution/ExecutionRequest;)((Definition.ExecutableDefinition.OperationDefinition)op, (Map)fragments, (Map)variables$1, (Document)document$1, (RootType)rootType$1));
        } else {
            throw new MatchError((Object)var10_7);
        }
        return var6_14;
    }

    public static final /* synthetic */ Tuple3 $anonfun$check$1(List operations$1, List fragments$2, Document document$2, RootType rootType$2, Map variables$2, Map fragmentMap) {
        List<Selection> selectionSets = MODULE$.collectSelectionSets((List<Selection>)((List)((List)operations$1.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.selectionSet(), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)fragments$2.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.selectionSet(), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())));
        package.Context context = new package.Context(document$2, rootType$2, (List<Definition.ExecutableDefinition.OperationDefinition>)operations$1, (Map<String, Definition.ExecutableDefinition.FragmentDefinition>)fragmentMap, selectionSets, (Map<String, InputValue>)variables$2);
        return new Tuple3((Object)fragmentMap, selectionSets, (Object)context);
    }

    public static final /* synthetic */ ZIO $anonfun$check$4(List operations$1, Tuple3 x$4) {
        if (x$4 == null) {
            throw new MatchError(null);
        }
        Map fragmentMap = (Map)x$4._1();
        package.Context context = (package.Context)x$4._3();
        ZIO zIO = MODULE$.validateOperationNameUniqueness((List<Definition.ExecutableDefinition.OperationDefinition>)operations$1).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.validateLoneAnonymousOperation((List<Definition.ExecutableDefinition.OperationDefinition>)operations$1).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.validateDirectives(context).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.validateFragmentSpreads(context).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.validateVariables(context).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.validateSubscriptionOperation(context).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.validateDocumentFields(context).map((Function1 & Serializable & scala.Serializable)_ -> fragmentMap)))))));
        return zIO;
    }

    private static final List collectValues$1(List selectionSet, package.Context context$2) {
        Builder inputValues = List$.MODULE$.newBuilder();
        selectionSet.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            if (x0$1 instanceof Selection.FragmentSpread) {
                Selection.FragmentSpread fragmentSpread = (Selection.FragmentSpread)x0$1;
                String name = fragmentSpread.name();
                fragmentSpread.directives().foreach((Function1 & Serializable & scala.Serializable)x$9 -> (Builder)inputValues.$plus$plus$eq((TraversableOnce)x$9.arguments().values()));
                context$2.fragments().get((Object)name).foreach((Function1 & Serializable & scala.Serializable)f -> {
                    f.directives().foreach((Function1 & Serializable & scala.Serializable)x$10 -> (Builder)inputValues.$plus$plus$eq((TraversableOnce)x$10.arguments().values()));
                    return (Builder)inputValues.$plus$plus$eq((TraversableOnce)Validator$.collectValues$1(f.selectionSet(), context$2));
                });
                boxedUnit = BoxedUnit.UNIT;
            } else if (x0$1 instanceof Selection.Field) {
                Selection.Field field = (Selection.Field)x0$1;
                Map<String, InputValue> arguments = field.arguments();
                List<Directive> directives = field.directives();
                List<Selection> selectionSet = field.selectionSet();
                inputValues.$plus$plus$eq((TraversableOnce)arguments.values());
                directives.foreach((Function1 & Serializable & scala.Serializable)x$11 -> (Builder)inputValues.$plus$plus$eq((TraversableOnce)x$11.arguments().values()));
                boxedUnit = inputValues.$plus$plus$eq((TraversableOnce)Validator$.collectValues$1(selectionSet, context$2));
            } else if (x0$1 instanceof Selection.InlineFragment) {
                Selection.InlineFragment inlineFragment = (Selection.InlineFragment)x0$1;
                List<Directive> directives = inlineFragment.dirs();
                List<Selection> selectionSet = inlineFragment.selectionSet();
                directives.foreach((Function1 & Serializable & scala.Serializable)x$12 -> (Builder)inputValues.$plus$plus$eq((TraversableOnce)x$12.arguments().values()));
                boxedUnit = inputValues.$plus$plus$eq((TraversableOnce)Validator$.collectValues$1(selectionSet, context$2));
            } else {
                throw new MatchError(x0$1);
            }
            return boxedUnit;
        });
        return (List)inputValues.result();
    }

    private static final List collectVariableValues$1(List values) {
        return (List)values.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            List list2;
            if (x0$1 instanceof InputValue.ListValue) {
                list2 = Validator$.collectVariableValues$1(((InputValue.ListValue)x0$1).values());
            } else if (x0$1 instanceof InputValue.ObjectValue) {
                list2 = Validator$.collectVariableValues$1(((InputValue.ObjectValue)x0$1).fields().values().toList());
            } else if (x0$1 instanceof InputValue.VariableValue) {
                InputValue.VariableValue variableValue = (InputValue.VariableValue)x0$1;
                list2 = new .colon.colon((Object)variableValue, (List)Nil$.MODULE$);
            } else if (x0$1 instanceof Value) {
                list2 = Nil$.MODULE$;
            } else {
                throw new MatchError(x0$1);
            }
            return list2;
        }, List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$collectSelectionSets$1(Builder sets$1, Selection x0$1) {
        if (x0$1 instanceof Selection.Field) {
            Validator$.loop$1(((Selection.Field)x0$1).selectionSet(), sets$1);
            return;
        }
        if (x0$1 instanceof Selection.InlineFragment) {
            Validator$.loop$1(((Selection.InlineFragment)x0$1).selectionSet(), sets$1);
            return;
        }
        if (x0$1 instanceof Selection.FragmentSpread) {
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    private static final void loop$1(List selectionSet, Builder sets$1) {
        sets$1.$plus$plus$eq((TraversableOnce)selectionSet);
        selectionSet.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Validator$.$anonfun$collectSelectionSets$1(sets$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkDirectivesUniqueness$3(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((List)x0$1._2()).length() > 1;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$validateDirectives$3(Directive d$1, __Directive x$25) {
        String string2 = x$25.name();
        String string3 = d$1.name();
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateDirectives$5(String arg$1, __InputValue x$26) {
        String string2 = x$26.name();
        return !(string2 != null ? !string2.equals(arg$1) : arg$1 != null);
    }

    public static final /* synthetic */ void $anonfun$validateDirectives$9(BoxedUnit _) {
    }

    public static final /* synthetic */ boolean $anonfun$validateVariables$13(String v$2, VariableDefinition x$29) {
        String string2 = x$29.name();
        return !(string2 != null ? !string2.equals(v$2) : v$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$detectCycles$1(scala.collection.immutable.Set visited$1, package.Context context$7, Selection.FragmentSpread s) {
        return visited$1.contains((Object)s.name()) || BoxesRunTime.unboxToBoolean((Object)context$7.fragments().get((Object)s.name()).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)Validator$.MODULE$.detectCycles(context$7, f, (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)visited$1.$plus((Object)s.name()))))));
    }

    private static final /* synthetic */ String typeConditionName$lzycompute$1(LazyRef typeConditionName$lzy$1, Option typeCondition$1) {
        synchronized (typeConditionName$lzy$1) {
            String string2 = typeConditionName$lzy$1.initialized() ? (String)typeConditionName$lzy$1.value() : (String)typeConditionName$lzy$1.initialize(typeCondition$1.fold((Function0 & Serializable & scala.Serializable)() -> "?", (Function1 & Serializable & scala.Serializable)x$35 -> x$35.name()));
            return string2;
        }
    }

    private static final String typeConditionName$1(LazyRef typeConditionName$lzy$1, Option typeCondition$1) {
        if (typeConditionName$lzy$1.initialized()) {
            return (String)typeConditionName$lzy$1.value();
        }
        return Validator$.typeConditionName$lzycompute$1(typeConditionName$lzy$1, typeCondition$1);
    }

    public static final /* synthetic */ boolean $anonfun$validateField$5(Selection.Field field$1, __Field x$36) {
        String string2 = x$36.name();
        String string3 = field$1.name();
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateArguments$1(__InputValue a) {
        __TypeKind __TypeKind2 = ((__Type)a.type().apply()).kind();
        __TypeKind$NON_NULL$ __TypeKind$NON_NULL$2 = __TypeKind$NON_NULL$.MODULE$;
        return !(__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$NON_NULL$2) : __TypeKind$NON_NULL$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateArguments$7(String arg$2, __InputValue x$37) {
        String string2 = x$37.name();
        return !(string2 != null ? !string2.equals(arg$2) : arg$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateInputValues$4(String k$1, __InputValue x$38) {
        String string2 = x$38.name();
        return !(string2 != null ? !string2.equals(k$1) : k$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkVariableUsageAllowed$1(InputValue x$39) {
        InputValue inputValue = x$39;
        Value$NullValue$ value$NullValue$ = Value$NullValue$.MODULE$;
        return inputValue == null ? value$NullValue$ != null : !inputValue.equals(value$NullValue$);
    }

    public static final /* synthetic */ boolean $anonfun$validateLoneAnonymousOperation$1(Definition.ExecutableDefinition.OperationDefinition x$41) {
        return x$41.name().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateSubscriptionOperation$3(Definition.ExecutableDefinition.OperationDefinition x$42) {
        OperationType operationType = x$42.operationType();
        OperationType$Subscription$ operationType$Subscription$ = OperationType$Subscription$.MODULE$;
        return !(operationType != null ? !operationType.equals(operationType$Subscription$) : operationType$Subscription$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateSubscriptionOperation$4(package.Context context$15, __Type t$3, Definition.ExecutableDefinition.OperationDefinition op) {
        return Field$.MODULE$.apply(op.selectionSet(), context$15.fragments(), (Map<String, InputValue>)Predef$.MODULE$.Map().empty(), (List<VariableDefinition>)List$.MODULE$.empty(), t$3, SourceMapper$.MODULE$.empty(), (List<Directive>)Nil$.MODULE$, context$15.rootType()).fields().length() > 1;
    }

    private final ZIO noDuplicateInputValueName$1(List inputValues, String errorContext) {
        Function1 & Serializable & scala.Serializable messageBuilder = (Function1 & Serializable & scala.Serializable)i -> new StringBuilder(22).append(errorContext).append(" has repeated fields: ").append(i.name()).toString();
        String explanatory = "The input field must have a unique name within that Input Object type; no two input fields may share the same name";
        return this.noDuplicateName(inputValues, (Function1 & Serializable & scala.Serializable)x$45 -> x$45.name(), messageBuilder, explanatory);
    }

    private final ZIO validateFields$1(List fields, String inputObjectContext$1) {
        return IO$.MODULE$.foreach_((Iterable)fields, (Function1 & Serializable & scala.Serializable)x$46 -> MODULE$.validateInputValue((__InputValue)x$46, inputObjectContext$1)).$times$greater((Function0 & Serializable & scala.Serializable)() -> this.noDuplicateInputValueName$1(fields, inputObjectContext$1));
    }

    public static final /* synthetic */ void $anonfun$validateInputValue$3(BoxedUnit _) {
    }

    private static final List fields$3(__Type t) {
        return (List)((Option)t.fields().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))))).toList().flatten((Function1)Predef$.MODULE$.$conforms());
    }

    private static final scala.collection.immutable.Set fieldNames$1(__Type t) {
        return ((TraversableOnce)Validator$.fields$3(t).map((Function1 & Serializable & scala.Serializable)x$47 -> x$47.name(), List$.MODULE$.canBuildFrom())).toSet();
    }

    private static final ZIO checkForMissingFields$1(__Type obj$1, List supertype$1, String objectContext$1) {
        scala.collection.immutable.Set objectFieldNames = Validator$.fieldNames$1(obj$1);
        scala.collection.immutable.Set interfaceFieldNames = (scala.collection.immutable.Set)((TraversableOnce)supertype$1.map((Function1 & Serializable & scala.Serializable)t -> Validator$.fieldNames$1(t), List$.MODULE$.canBuildFrom())).toSet().flatten((Function1)Predef$.MODULE$.$conforms());
        Set set = objectFieldNames.union((GenSet)interfaceFieldNames);
        boolean isMissingFields = set == null || !set.equals(objectFieldNames);
        return IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> interfaceFieldNames.nonEmpty() && isMissingFields, (Function0 & Serializable & scala.Serializable)() -> {
            List missingFields = (List)interfaceFieldNames.diff((GenSet)objectFieldNames).toList().sorted((Ordering)Ordering.String$.MODULE$);
            return MODULE$.failValidation(new StringBuilder(22).append(objectContext$1).append(" is missing field(s): ").append(missingFields.mkString(", ")).toString(), "An Object type must include a field of the same name for every field defined in an interface");
        });
    }

    private static final boolean isNonNullableSubtype$1(__Type supertypeFieldType, __Type objectFieldType) {
        __TypeKind __TypeKind2 = objectFieldType.kind();
        boolean bl = __TypeKind$NON_NULL$.MODULE$.equals(__TypeKind2) ? objectFieldType.ofType().exists((Function1 & Serializable & scala.Serializable)x$48 -> BoxesRunTime.boxToBoolean((boolean)Types$.MODULE$.same(supertypeFieldType, x$48))) : false;
        return bl;
    }

    public static final boolean caliban$validation$Validator$$isValidSubtype$1(__Type supertypeFieldType, __Type objectFieldType) {
        List supertypePossibleTypes = (List)supertypeFieldType.possibleTypes().toList().flatten((Function1)Predef$.MODULE$.$conforms());
        return Types$.MODULE$.same(supertypeFieldType, objectFieldType) || supertypePossibleTypes.exists((Function1 & Serializable & scala.Serializable)x$49 -> BoxesRunTime.boxToBoolean((boolean)Types$.MODULE$.same(x$49, objectFieldType))) || Validator$.isNonNullableSubtype$1(supertypeFieldType, objectFieldType);
    }

    public static final /* synthetic */ boolean $anonfun$validateObject$11(__Field objField$1, __Field x$50) {
        String string2 = x$50.name();
        String string3 = objField$1.name();
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    private static final ZIO checkForInvalidSubtypeFields$1(__Type obj$1, List supertype$1, String objectContext$1) {
        List objectFields = Validator$.fields$3(obj$1);
        List supertypeFields = (List)supertype$1.flatMap((Function1 & Serializable & scala.Serializable)t -> Validator$.fields$3(t), List$.MODULE$.canBuildFrom());
        return IO$.MODULE$.foreach_((Iterable)objectFields, (Function1 & Serializable & scala.Serializable)objField -> {
            String fieldContext = new StringBuilder(8).append("Field '").append(objField.name()).append("'").toString();
            return IO$.MODULE$.whenCase((Function0 & Serializable & scala.Serializable)() -> supertypeFields.find((Function1 & Serializable & scala.Serializable)x$50 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateObject$11(objField, x$50))), (PartialFunction)new scala.Serializable((__Field)objField, fieldContext, objectContext$1){
                public static final long serialVersionUID = 0L;
                private final __Field objField$1;
                public final String fieldContext$2;
                public final String objectContext$1;

                public final <A1 extends Option<__Field>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    if (x1 instanceof Some) {
                        __Field superField = (__Field)((Some)x1).value();
                        Map superArgs = ((TraversableOnce)superField.args().map((Function1 & Serializable & scala.Serializable)arg -> new Tuple2((Object)arg.name(), arg), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                        List extraArgs = (List)this.objField$1.args().filter((Function1 & Serializable & scala.Serializable)arg -> BoxesRunTime.boxToBoolean((boolean)anonfun$$nestedInanonfun$validateObject$9$1.$anonfun$applyOrElse$4(superArgs, arg)));
                        object = IO$.MODULE$.whenCase((Function0 & Serializable & scala.Serializable)() -> new Tuple2.mcZZ.sp(this.fieldTypeIsValid$1(superField), Validator$.MODULE$.caliban$validation$Validator$$isListField(superField)), (PartialFunction)new scala.Serializable(this, extraArgs, superField){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$$nestedInanonfun$validateObject$9$1 $outer;
                            private final List extraArgs$1;
                            private final __Field superField$1;

                            /*
                             * Enabled aggressive block sorting
                             */
                            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                ZIO<Object, CalibanError.ValidationError, T> zIO;
                                boolean bl;
                                if (x1 != null && (bl = x1._2$mcZ$sp()) && !this.$outer.caliban$validation$Validator$$nestedInanonfun$$nestedInanonfun$validateObject$9$1$$listItemTypeIsValid$1(this.superField$1)) {
                                    zIO = Validator$.MODULE$.failValidation(new StringBuilder(36).append(this.$outer.fieldContext$2).append(" in ").append(this.$outer.objectContext$1).append(" is an invalid list item subtype").toString(), "An object list item field type must be equal to or a possible type of the interface list item field type.");
                                    return (B1)zIO;
                                }
                                if (x1 != null) {
                                    boolean bl2 = x1._1$mcZ$sp();
                                    boolean bl3 = x1._2$mcZ$sp();
                                    if (!bl2 && !bl3) {
                                        zIO = Validator$.MODULE$.failValidation(new StringBuilder(26).append(this.$outer.fieldContext$2).append(" in ").append(this.$outer.objectContext$1).append(" is an invalid subtype").toString(), "An object field type must be equal to or a possible type of the interface field type.");
                                        return (B1)zIO;
                                    }
                                }
                                if (!anonfun$$nestedInanonfun$validateObject$9$1.caliban$validation$Validator$$nestedInanonfun$$nestedInanonfun$validateObject$9$1$$extraArgsAreValid$1(this.extraArgs$1)) {
                                    String argNames = ((TraversableOnce)((List)this.extraArgs$1.filter((Function1 & Serializable & scala.Serializable)x$52 -> BoxesRunTime.boxToBoolean((boolean)anonfun$$nestedInanonfun$validateObject$9$1$$anonfun$applyOrElse$12.$anonfun$applyOrElse$13(x$52)))).map((Function1 & Serializable & scala.Serializable)x$53 -> x$53.name(), List$.MODULE$.canBuildFrom())).mkString(", ");
                                    zIO = Validator$.MODULE$.failValidation(new StringBuilder(49).append(this.$outer.fieldContext$2).append(" with extra non-nullable arg(s) '").append(argNames).append("' in ").append(this.$outer.objectContext$1).append(" is invalid").toString(), "Any additional field arguments must not be of a non-nullable type.");
                                    return (B1)zIO;
                                }
                                zIO = function1.apply(x1);
                                return (B1)zIO;
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                                boolean bl;
                                if (x1 != null && (bl = x1._2$mcZ$sp()) && !this.$outer.caliban$validation$Validator$$nestedInanonfun$$nestedInanonfun$validateObject$9$1$$listItemTypeIsValid$1(this.superField$1)) {
                                    return true;
                                }
                                if (x1 != null) {
                                    boolean bl2 = x1._1$mcZ$sp();
                                    boolean bl3 = x1._2$mcZ$sp();
                                    if (!bl2 && !bl3) {
                                        return true;
                                    }
                                }
                                if (anonfun$$nestedInanonfun$validateObject$9$1.caliban$validation$Validator$$nestedInanonfun$$nestedInanonfun$validateObject$9$1$$extraArgsAreValid$1(this.extraArgs$1)) return false;
                                return true;
                            }

                            public static final /* synthetic */ boolean $anonfun$applyOrElse$13(__InputValue x$52) {
                                __TypeKind __TypeKind2 = ((__Type)x$52.type().apply()).kind();
                                __TypeKind$NON_NULL$ __TypeKind$NON_NULL$2 = __TypeKind$NON_NULL$.MODULE$;
                                return !(__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$NON_NULL$2) : __TypeKind$NON_NULL$2 != null);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.extraArgs$1 = extraArgs$1;
                                this.superField$1 = superField$1;
                            }

                            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$13$adapted(caliban.introspection.adt.__InputValue ), $anonfun$applyOrElse$14(caliban.introspection.adt.__InputValue )}, serializedLambda);
                            }
                        });
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Option<__Field> x1) {
                    boolean bl = x1 instanceof Some;
                    return bl;
                }

                public static final /* synthetic */ boolean $anonfun$applyOrElse$6(__InputValue arg$3, __InputValue superArg) {
                    return !Types$.MODULE$.same((__Type)arg$3.type().apply(), (__Type)superArg.type().apply());
                }

                public static final /* synthetic */ boolean $anonfun$applyOrElse$4(Map superArgs$1, __InputValue arg) {
                    return BoxesRunTime.unboxToBoolean((Object)superArgs$1.get((Object)arg.name()).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true, (Function1 & Serializable & scala.Serializable)superArg -> BoxesRunTime.boxToBoolean((boolean)anonfun$$nestedInanonfun$validateObject$9$1.$anonfun$applyOrElse$6(arg, superArg))));
                }

                private final boolean fieldTypeIsValid$1(__Field superField$1) {
                    return Validator$.caliban$validation$Validator$$isValidSubtype$1((__Type)superField$1.type().apply(), (__Type)this.objField$1.type().apply());
                }

                public static final /* synthetic */ boolean $anonfun$applyOrElse$8(__Type superListItemType$1, __Type objListItemType) {
                    return Validator$.caliban$validation$Validator$$isValidSubtype$1(superListItemType$1, objListItemType);
                }

                public final boolean caliban$validation$Validator$$nestedInanonfun$$nestedInanonfun$validateObject$9$1$$listItemTypeIsValid$1(__Field superField$1) {
                    return Validator$.MODULE$.caliban$validation$Validator$$isListField(superField$1) && Validator$.MODULE$.caliban$validation$Validator$$isListField(this.objField$1) && BoxesRunTime.unboxToBoolean((Object)((__Type)superField$1.type().apply()).ofType().flatMap((Function1 & Serializable & scala.Serializable)superListItemType -> ((__Type)$this.objField$1.type().apply()).ofType().map((Function1 & Serializable & scala.Serializable)objListItemType -> BoxesRunTime.boxToBoolean((boolean)anonfun$$nestedInanonfun$validateObject$9$1.$anonfun$applyOrElse$8(superListItemType, objListItemType)))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
                }

                public static final /* synthetic */ boolean $anonfun$applyOrElse$10(__InputValue x$51) {
                    __TypeKind __TypeKind2 = ((__Type)x$51.type().apply()).kind();
                    __TypeKind$NON_NULL$ __TypeKind$NON_NULL$2 = __TypeKind$NON_NULL$.MODULE$;
                    return !(__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$NON_NULL$2) : __TypeKind$NON_NULL$2 != null);
                }

                public static final boolean caliban$validation$Validator$$nestedInanonfun$$nestedInanonfun$validateObject$9$1$$extraArgsAreValid$1(List extraArgs$1) {
                    return !extraArgs$1.exists((Function1 & Serializable & scala.Serializable)x$51 -> BoxesRunTime.boxToBoolean((boolean)anonfun$$nestedInanonfun$validateObject$9$1.$anonfun$applyOrElse$10(x$51)));
                }
                {
                    this.objField$1 = objField$1;
                    this.fieldContext$2 = fieldContext$2;
                    this.objectContext$1 = objectContext$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(caliban.introspection.adt.__InputValue ), $anonfun$applyOrElse$4$adapted(scala.collection.immutable.Map caliban.introspection.adt.__InputValue ), $anonfun$applyOrElse$11(caliban.validation.Validator$$anonfun$$nestedInanonfun$validateObject$9$1 caliban.introspection.adt.__Field ), $anonfun$applyOrElse$5(), $anonfun$applyOrElse$6$adapted(caliban.introspection.adt.__InputValue caliban.introspection.adt.__InputValue ), $anonfun$applyOrElse$8$adapted(caliban.introspection.adt.__Type caliban.introspection.adt.__Type ), $anonfun$applyOrElse$7(caliban.validation.Validator$$anonfun$$nestedInanonfun$validateObject$9$1 caliban.introspection.adt.__Type ), $anonfun$applyOrElse$9(), $anonfun$applyOrElse$10$adapted(caliban.introspection.adt.__InputValue )}, serializedLambda);
                }
            });
        });
    }

    public static final /* synthetic */ void $anonfun$validateObject$13(BoxedUnit _) {
    }

    private static final ZIO validateInterfaceFields$1(__Type obj, String objectContext$1) {
        List supertype = (List)((Option)obj.interfaces().apply()).toList().flatten((Function1)Predef$.MODULE$.$conforms());
        return Validator$.checkForMissingFields$1(obj, supertype, objectContext$1).flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validator$.checkForInvalidSubtypeFields$1(obj, supertype, objectContext$1).map((Function1 & Serializable & scala.Serializable)_ -> {
            Validator$.$anonfun$validateObject$13(_);
            return BoxedUnit.UNIT;
        }));
    }

    private static final Either isInputType$1(__Type t2) {
        Object object;
        __TypeKind __TypeKind2 = t2.kind();
        boolean bl = __TypeKind$LIST$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$NON_NULL$.MODULE$.equals(__TypeKind2);
        if (bl) {
            object = (Either)t2.ofType().fold((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Left().apply((Object)t2), (Function1 & Serializable & scala.Serializable)t -> Validator$.isInputType$1(t));
        } else {
            boolean bl2 = __TypeKind$SCALAR$.MODULE$.equals(__TypeKind2) ? true : (__TypeKind$ENUM$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$INPUT_OBJECT$.MODULE$.equals(__TypeKind2));
            object = bl2 ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)t2);
        }
        return object;
    }

    public static final /* synthetic */ void $anonfun$validateFields$8(BoxedUnit _) {
    }

    private static final Either isOutputType$1(__Type t2) {
        Object object;
        __TypeKind __TypeKind2 = t2.kind();
        boolean bl = __TypeKind$LIST$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$NON_NULL$.MODULE$.equals(__TypeKind2);
        if (bl) {
            object = (Either)t2.ofType().fold((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Left().apply((Object)t2), (Function1 & Serializable & scala.Serializable)t -> Validator$.isOutputType$1(t));
        } else {
            boolean bl2 = __TypeKind$SCALAR$.MODULE$.equals(__TypeKind2) ? true : (__TypeKind$OBJECT$.MODULE$.equals(__TypeKind2) ? true : (__TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2) ? true : (__TypeKind$UNION$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$ENUM$.MODULE$.equals(__TypeKind2))));
            object = bl2 ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)t2);
        }
        return object;
    }

    private static final ZIO validateArguments$1(Map args, String errorContext) {
        String explanatoryText = "The directive argument must not have a name which begins with the characters \"__\" (two underscores)";
        Function1 & Serializable & scala.Serializable argumentErrorContextBuilder = (Function1 & Serializable & scala.Serializable)name -> new StringBuilder(15).append("Argument '").append((String)name).append("' of ").append(errorContext).toString();
        return IO$.MODULE$.foreach_(args.keys(), (Function1 & Serializable & scala.Serializable)argName -> MODULE$.doesNotStartWithUnderscore(argName, (Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x), (String)argumentErrorContextBuilder.apply(argName), explanatoryText));
    }

    private final ZIO validateDirective$1(Directive directive, String errorContext) {
        String directiveErrorContext = new StringBuilder(16).append("Directive '").append(directive.name()).append("' of ").append(errorContext).toString();
        return this.doesNotStartWithUnderscore(directive, directiveErrorContext).$times$greater((Function0 & Serializable & scala.Serializable)() -> Validator$.validateArguments$1(directive.arguments(), directiveErrorContext));
    }

    private final ZIO validateDirectives$1(Option directives, String errorContext) {
        return IO$.MODULE$.foreach_((Iterable)directives.getOrElse((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty()), (Function1 & Serializable & scala.Serializable)x$61 -> this.validateDirective$1((Directive)x$61, errorContext));
    }

    private final ZIO validateInputValueDirectives$1(List inputValues, String errorContext) {
        Function1 & Serializable & scala.Serializable inputValueErrorContextBuilder = (Function1 & Serializable & scala.Serializable)name -> new StringBuilder(17).append("InputValue '").append((String)name).append("' of ").append(errorContext).toString();
        return IO$.MODULE$.foreach_((Iterable)inputValues, (Function1 & Serializable & scala.Serializable)iv -> this.validateDirectives$1(iv.directives(), (String)inputValueErrorContextBuilder.apply((Object)iv.name())));
    }

    private final ZIO validateFieldDirectives$1(__Field field, String errorContext) {
        String fieldErrorContext = new StringBuilder(12).append("Field '").append(field.name()).append("' of ").append(errorContext).toString();
        return this.validateDirectives$1(field.directives(), fieldErrorContext).$times$greater((Function0 & Serializable & scala.Serializable)() -> this.validateInputValueDirectives$1(field.args(), fieldErrorContext));
    }

    public static final /* synthetic */ void $anonfun$validateDirectives$26(BoxedUnit _) {
    }

    private Validator$() {
        MODULE$ = this;
    }
}

