/*
 * Decompiled with CFR 0.152.
 */
package caliban.validation;

import caliban.CalibanError;
import caliban.CalibanError$ValidationError$;
import caliban.InputValue;
import caliban.Value;
import caliban.Value$NullValue$;
import caliban.introspection.adt.__DeprecatedArgs;
import caliban.introspection.adt.__InputValue;
import caliban.introspection.adt.__Type;
import caliban.introspection.adt.__TypeKind;
import caliban.introspection.adt.__TypeKind$ENUM$;
import caliban.introspection.adt.__TypeKind$INPUT_OBJECT$;
import caliban.introspection.adt.__TypeKind$LIST$;
import caliban.introspection.adt.__TypeKind$NON_NULL$;
import caliban.introspection.adt.__TypeKind$SCALAR$;
import caliban.parsing.Parser$;
import caliban.validation.Validator$;
import caliban.validation.package;
import caliban.validation.package$Context$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import zio.CanFail$;
import zio.prelude.Covariant;
import zio.prelude.IdentityBoth;
import zio.prelude.Invariant$;
import zio.prelude.fx.ZPure;
import zio.prelude.fx.ZPure$;
import zio.prelude.package$;

public final class ValueValidator$ {
    public static ValueValidator$ MODULE$;

    static {
        new ValueValidator$();
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateDefaultValue(__InputValue field, Function0<String> errorContext) {
        Option<String> option2 = field.defaultValue();
        if (option2 instanceof Some) {
            String v = (String)((Some)option2).value();
            return ZPure$.MODULE$.fromEither(Parser$.MODULE$.parseInputValue(v)).mapError((Function1 & Serializable & scala.Serializable)e -> new CalibanError.ValidationError(new StringBuilder(32).append(errorContext.apply()).append(" failed to parse default value: ").append(e.msg()).toString(), "The default value for a field must be written using GraphQL input syntax.", CalibanError$ValidationError$.MODULE$.apply$default$3(), CalibanError$ValidationError$.MODULE$.apply$default$4()), CanFail$.MODULE$.canFail()).flatMap((Function1 & Serializable & scala.Serializable)value -> Validator$.MODULE$.validateInputValues(field, (InputValue)value, package$Context$.MODULE$.empty(), errorContext).map((Function1 & Serializable & scala.Serializable)_ -> {
                ValueValidator$.$anonfun$validateDefaultValue$3(_);
                return BoxedUnit.UNIT;
            }));
        }
        if (None$.MODULE$.equals(option2)) {
            return ZPure$.MODULE$.when(!((__Type)field.type().apply()).isNullable() && field.isDeprecated(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.failValidation(new StringBuilder(50).append(errorContext.apply()).append(" has no default value, is non-null and deprecated.").toString(), "If input field type is Non-Null and a default value is not defined, the `@deprecated` directive must not be applied to this input field.")).unit();
        }
        throw new MatchError(option2);
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateInputTypes(__InputValue inputValue, InputValue argValue, package.Context context, Function0<String> errorContext) {
        return this.validateType(inputValue._type(), argValue, context, errorContext);
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateType(__Type inputType, InputValue argValue, package.Context context, Function0<String> errorContext) {
        __TypeKind __TypeKind2;
        while (true) {
            if (argValue instanceof InputValue.VariableValue) {
                InputValue value;
                InputValue.VariableValue variableValue = (InputValue.VariableValue)argValue;
                argValue = value = (InputValue)context.variables().getOrElse((Object)variableValue.name(), (Function0 & Serializable & scala.Serializable)() -> (InputValue)context.variableDefinitions().get((Object)variableValue.name()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.defaultValue()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Value$NullValue$.MODULE$));
                continue;
            }
            __TypeKind2 = inputType.kind();
            if (__TypeKind$NON_NULL$.MODULE$.equals(__TypeKind2)) {
                if (Value$NullValue$.MODULE$.equals(argValue)) {
                    return this.failValidation(new StringBuilder(8).append(errorContext.apply()).append(" is null").toString(), "Input field was null but was supposed to be non-null.");
                }
                inputType = (__Type)inputType.ofType().getOrElse((Function0 & Serializable & scala.Serializable)() -> inputType);
                continue;
            }
            if (!__TypeKind$LIST$.MODULE$.equals(__TypeKind2)) break;
            if (argValue instanceof InputValue.ListValue) {
                List<InputValue> values = ((InputValue.ListValue)argValue).values();
                return (ZPure)package$.MODULE$.ForEachOps(values).forEach_((Function1 & Serializable & scala.Serializable)v -> MODULE$.validateType((__Type)inputType.ofType().getOrElse((Function0 & Serializable & scala.Serializable)() -> inputType), (InputValue)v, context, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("List item in ").append(errorContext.apply()).toString()), (IdentityBoth)ZPure$.MODULE$.ZPureCovariantIdentityBoth(), (Covariant)ZPure$.MODULE$.ZPureCovariantIdentityBoth(), Invariant$.MODULE$.ListForEach());
            }
            if (Value$NullValue$.MODULE$.equals(argValue)) {
                return ZPure$.MODULE$.unit();
            }
            errorContext = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("List item in ").append(errorContext.apply()).toString();
            inputType = (__Type)inputType.ofType().getOrElse((Function0 & Serializable & scala.Serializable)() -> inputType);
        }
        if (__TypeKind$INPUT_OBJECT$.MODULE$.equals(__TypeKind2)) {
            if (argValue instanceof InputValue.ObjectValue) {
                Map<String, InputValue> fields = ((InputValue.ObjectValue)argValue).fields();
                return (ZPure)package$.MODULE$.ForEachOps(inputType.allInputFields()).forEach_((Function1 & Serializable & scala.Serializable)f -> {
                    Option option2 = fields.collectFirst((PartialFunction)new scala.Serializable((__InputValue)f){
                        public static final long serialVersionUID = 0L;
                        private final __InputValue f$1;

                        public final <A1 extends Tuple2<String, InputValue>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            if (x1 != null) {
                                String name = (String)x1._1();
                                InputValue fieldValue = (InputValue)x1._2();
                                String string2 = name;
                                String string3 = this.f$1.name();
                                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                                    return (B1)fieldValue;
                                }
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Tuple2<String, InputValue> x1) {
                            if (x1 != null) {
                                String string2 = (String)x1._1();
                                String string3 = this.f$1.name();
                                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                                    return true;
                                }
                            }
                            return false;
                        }
                        {
                            this.f$1 = f$1;
                        }
                    });
                    if (option2 instanceof Some) {
                        InputValue value = (InputValue)((Some)option2).value();
                        return MODULE$.validateType(f._type(), value, context, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Field ").append(f.name()).append(" in ").append(errorContext.apply()).toString());
                    }
                    if (None$.MODULE$.equals(option2)) {
                        return ZPure$.MODULE$.when(f.defaultValue().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.validateType(f._type(), Value$NullValue$.MODULE$, context, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Field ").append(f.name()).append(" in ").append(errorContext.apply()).toString()));
                    }
                    throw new MatchError((Object)option2);
                }, (IdentityBoth)ZPure$.MODULE$.ZPureCovariantIdentityBoth(), (Covariant)ZPure$.MODULE$.ZPureCovariantIdentityBoth(), Invariant$.MODULE$.ListForEach());
            }
            if (Value$NullValue$.MODULE$.equals(argValue)) {
                return ZPure$.MODULE$.unit();
            }
            return this.failValidation(new StringBuilder(19).append(errorContext.apply()).append(" has invalid type: ").append(argValue).toString(), "Input field was supposed to be an input object.");
        }
        if (__TypeKind$ENUM$.MODULE$.equals(__TypeKind2)) {
            if (argValue instanceof Value.EnumValue) {
                String value = ((Value.EnumValue)argValue).value();
                return this.validateEnum(value, inputType, (Function0<String>)errorContext);
            }
            if (Value$NullValue$.MODULE$.equals(argValue)) {
                return ZPure$.MODULE$.unit();
            }
            return this.failValidation(new StringBuilder(19).append(errorContext.apply()).append(" has invalid type: ").append(argValue).toString(), "Input field was supposed to be an enum value.");
        }
        if (__TypeKind$SCALAR$.MODULE$.equals(__TypeKind2)) {
            return this.validateScalar(inputType, argValue, errorContext);
        }
        return this.failValidation(new StringBuilder(18).append(errorContext.apply()).append(" has invalid type ").append(inputType).toString(), "Input value is invalid, should be a scalar, list or input object.");
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateEnum(String value, __Type inputType, Function0<String> errorContext) {
        List possible = (List)((List)((Option)inputType.enumValues().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))))).getOrElse((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), List$.MODULE$.canBuildFrom());
        boolean exists = possible.contains((Object)value);
        return ZPure$.MODULE$.unless(exists, (Function0 & Serializable & scala.Serializable)() -> MODULE$.failValidation(new StringBuilder(25).append(errorContext.apply()).append(" has invalid enum value: ").append(value).toString(), new StringBuilder(26).append("Was supposed to be one of ").append(possible.mkString(", ")).toString())).unit();
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateScalar(__Type inputType, InputValue argValue, Function0<String> errorContext) {
        String string2 = (String)inputType.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        if ("String".equals(string2)) {
            if (argValue instanceof Value.StringValue ? true : Value$NullValue$.MODULE$.equals(argValue)) {
                return ZPure$.MODULE$.unit();
            }
            return this.failValidation(new StringBuilder(18).append(errorContext.apply()).append(" has invalid type ").append(argValue).toString(), "Expected 'String'");
        }
        if ("ID".equals(string2)) {
            if (argValue instanceof Value.StringValue ? true : Value$NullValue$.MODULE$.equals(argValue)) {
                return ZPure$.MODULE$.unit();
            }
            return this.failValidation(new StringBuilder(18).append(errorContext.apply()).append(" has invalid type ").append(argValue).toString(), "Expected 'ID'");
        }
        if ("Int".equals(string2)) {
            if (argValue instanceof Value.IntValue ? true : Value$NullValue$.MODULE$.equals(argValue)) {
                return ZPure$.MODULE$.unit();
            }
            return this.failValidation(new StringBuilder(18).append(errorContext.apply()).append(" has invalid type ").append(argValue).toString(), "Expected 'Int'");
        }
        if ("Float".equals(string2)) {
            if (argValue instanceof Value.FloatValue ? true : (argValue instanceof Value.IntValue ? true : Value$NullValue$.MODULE$.equals(argValue))) {
                return ZPure$.MODULE$.unit();
            }
            return this.failValidation(new StringBuilder(18).append(errorContext.apply()).append(" has invalid type ").append(argValue).toString(), "Expected 'Float'");
        }
        if ("Boolean".equals(string2)) {
            if (argValue instanceof Value.BooleanValue ? true : Value$NullValue$.MODULE$.equals(argValue)) {
                return ZPure$.MODULE$.unit();
            }
            return this.failValidation(new StringBuilder(18).append(errorContext.apply()).append(" has invalid type ").append(argValue).toString(), "Expected 'Boolean'");
        }
        return ZPure$.MODULE$.unit();
    }

    public <T> ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, T> failValidation(String msg, String explanatoryText) {
        return ZPure$.MODULE$.fail((Object)new CalibanError.ValidationError(msg, explanatoryText, CalibanError$ValidationError$.MODULE$.apply$default$3(), CalibanError$ValidationError$.MODULE$.apply$default$4()));
    }

    public static final /* synthetic */ void $anonfun$validateDefaultValue$3(BoxedUnit _) {
    }

    private ValueValidator$() {
        MODULE$ = this;
    }
}

