/*
 * Decompiled with CFR 0.152.
 */
package caliban.validation;

import caliban.CalibanError;
import caliban.CalibanError$ValidationError$;
import caliban.InputValue;
import caliban.Rendering$;
import caliban.Value;
import caliban.Value$NullValue$;
import caliban.execution.ExecutionRequest;
import caliban.execution.Field$;
import caliban.introspection.Introspector$;
import caliban.introspection.adt.__DeprecatedArgs;
import caliban.introspection.adt.__Directive;
import caliban.introspection.adt.__DirectiveLocation;
import caliban.introspection.adt.__DirectiveLocation$FIELD$;
import caliban.introspection.adt.__DirectiveLocation$FRAGMENT_DEFINITION$;
import caliban.introspection.adt.__DirectiveLocation$FRAGMENT_SPREAD$;
import caliban.introspection.adt.__DirectiveLocation$INLINE_FRAGMENT$;
import caliban.introspection.adt.__DirectiveLocation$MUTATION$;
import caliban.introspection.adt.__DirectiveLocation$QUERY$;
import caliban.introspection.adt.__DirectiveLocation$SUBSCRIPTION$;
import caliban.introspection.adt.__Field;
import caliban.introspection.adt.__InputValue;
import caliban.introspection.adt.__Type;
import caliban.introspection.adt.__TypeKind;
import caliban.introspection.adt.__TypeKind$;
import caliban.introspection.adt.__TypeKind$ENUM$;
import caliban.introspection.adt.__TypeKind$INPUT_OBJECT$;
import caliban.introspection.adt.__TypeKind$INTERFACE$;
import caliban.introspection.adt.__TypeKind$LIST$;
import caliban.introspection.adt.__TypeKind$NON_NULL$;
import caliban.introspection.adt.__TypeKind$OBJECT$;
import caliban.introspection.adt.__TypeKind$SCALAR$;
import caliban.introspection.adt.__TypeKind$UNION$;
import caliban.parsing.SourceMapper$;
import caliban.parsing.adt.Definition;
import caliban.parsing.adt.Directive;
import caliban.parsing.adt.Document;
import caliban.parsing.adt.OperationType;
import caliban.parsing.adt.OperationType$Mutation$;
import caliban.parsing.adt.OperationType$Query$;
import caliban.parsing.adt.OperationType$Subscription$;
import caliban.parsing.adt.Selection;
import caliban.parsing.adt.Type;
import caliban.parsing.adt.Type$;
import caliban.parsing.adt.VariableDefinition;
import caliban.schema.Operation;
import caliban.schema.RootSchema;
import caliban.schema.RootSchemaBuilder;
import caliban.schema.RootType;
import caliban.schema.Types$;
import caliban.validation.Validator;
import caliban.validation.Validator$$anonfun$;
import caliban.validation.Validator$$anonfun$$nestedInanonfun$validateObject$8$1$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.CanFail$;
import zio.IO$;
import zio.ZIO;

public final class Validator$ {
    public static final Validator$ MODULE$ = new Validator$();

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validate(Document document, RootType rootType) {
        return this.check(document, rootType).unit();
    }

    public <R> ZIO<Object, CalibanError.ValidationError, RootSchema<R>> validateSchema(RootSchemaBuilder<R> schema) {
        List<__Type> types = schema.types();
        return IO$.MODULE$.foreach((Iterable)types.sorted(__TypeKind$.MODULE$.typeOrdering()), (Function1 & Serializable)t -> MODULE$.validateType((__Type)t), BuildFrom$.MODULE$.buildFromIterableOps()).$times$greater((Function0 & Serializable)() -> MODULE$.validateClashingTypes(types)).$times$greater((Function0 & Serializable)() -> MODULE$.validateDirectives(types)).$times$greater((Function0 & Serializable)() -> MODULE$.validateRootQuery(schema));
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateType(__Type t) {
        __TypeKind __TypeKind2 = t.kind();
        Object object = __TypeKind$ENUM$.MODULE$.equals(__TypeKind2) ? this.validateEnum(t) : (__TypeKind$UNION$.MODULE$.equals(__TypeKind2) ? this.validateUnion(t) : (__TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2) ? this.validateInterface(t) : (__TypeKind$INPUT_OBJECT$.MODULE$.equals(__TypeKind2) ? this.validateInputObject(t) : (__TypeKind$OBJECT$.MODULE$.equals(__TypeKind2) ? this.validateObject(t) : IO$.MODULE$.unit()))));
        return object;
    }

    public <T> ZIO<Object, CalibanError.ValidationError, T> failValidation(String msg, String explanatoryText) {
        return IO$.MODULE$.fail((Function0 & Serializable)() -> new CalibanError.ValidationError(msg, explanatoryText, CalibanError$ValidationError$.MODULE$.apply$default$3(), CalibanError$ValidationError$.MODULE$.apply$default$4()));
    }

    public <R> ZIO<Object, CalibanError.ValidationError, ExecutionRequest> prepare(Document document, RootType rootType, RootSchema<R> rootSchema, Option<String> operationName, Map<String, InputValue> variables, boolean skipValidation) {
        ZIO<Object, CalibanError.ValidationError, Map<String, Definition.ExecutableDefinition.FragmentDefinition>> fragments = skipValidation ? IO$.MODULE$.succeed((Function0 & Serializable)() -> (Map)((LinearSeqOps)MODULE$.collectDefinitions(document)._2()).foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Map m = (Map)tuple2._1();
            Definition.ExecutableDefinition.FragmentDefinition f = (Definition.ExecutableDefinition.FragmentDefinition)tuple2._2();
            Map map2 = (Map)m.updated((Object)f.name(), (Object)f);
            return map2;
        })) : this.check(document, rootType);
        return fragments.flatMap(arg_0 -> Validator$.$anonfun$prepare$3(operationName, document, rootSchema, variables, arg_0));
    }

    private ZIO<Object, CalibanError.ValidationError, Map<String, Definition.ExecutableDefinition.FragmentDefinition>> check(Document document, RootType rootType) {
        Tuple4<List<Definition.ExecutableDefinition.OperationDefinition>, List<Definition.ExecutableDefinition.FragmentDefinition>, List<Definition.TypeSystemDefinition>, List<Definition.TypeSystemExtension>> tuple4 = this.collectDefinitions(document);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        List operations = (List)tuple4._1();
        List fragments = (List)tuple4._2();
        Tuple2 tuple2 = new Tuple2((Object)operations, (Object)fragments);
        Tuple2 tuple22 = tuple2;
        List operations2 = (List)tuple22._1();
        List fragments2 = (List)tuple22._2();
        return this.validateFragments((List<Definition.ExecutableDefinition.FragmentDefinition>)fragments2).flatMap((Function1 & Serializable)fragmentMap -> {
            List<Selection> selectionSets = MODULE$.collectSelectionSets((List<Selection>)((List)operations2.flatMap((Function1 & Serializable)x$2 -> x$2.selectionSet()).$plus$plus((IterableOnce)fragments2.flatMap((Function1 & Serializable)x$3 -> x$3.selectionSet()))));
            Validator.Context context = new Validator.Context(document, rootType, (List<Definition.ExecutableDefinition.OperationDefinition>)operations2, (Map<String, Definition.ExecutableDefinition.FragmentDefinition>)fragmentMap, selectionSets);
            return MODULE$.validateOperationNameUniqueness((List<Definition.ExecutableDefinition.OperationDefinition>)operations2).flatMap((Function1 & Serializable)x$10 -> {
                BoxedUnit boxedUnit = x$10;
                ZIO zIO = MODULE$.validateLoneAnonymousOperation((List<Definition.ExecutableDefinition.OperationDefinition>)operations2).flatMap((Function1 & Serializable)x$9 -> {
                    BoxedUnit boxedUnit = x$9;
                    ZIO zIO = MODULE$.validateDirectives(context).flatMap((Function1 & Serializable)x$8 -> {
                        BoxedUnit boxedUnit = x$8;
                        ZIO zIO = MODULE$.validateFragmentSpreads(context).flatMap((Function1 & Serializable)x$7 -> {
                            BoxedUnit boxedUnit = x$7;
                            ZIO zIO = MODULE$.validateVariables(context).flatMap((Function1 & Serializable)x$6 -> {
                                BoxedUnit boxedUnit = x$6;
                                ZIO zIO = MODULE$.validateSubscriptionOperation(context).flatMap((Function1 & Serializable)x$5 -> {
                                    BoxedUnit boxedUnit = x$5;
                                    ZIO zIO = MODULE$.validateDocumentFields(context).map((Function1 & Serializable)x$4 -> {
                                        BoxedUnit boxedUnit = x$4;
                                        Map map2 = fragmentMap;
                                        return map2;
                                    });
                                    return zIO;
                                });
                                return zIO;
                            });
                            return zIO;
                        });
                        return zIO;
                    });
                    return zIO;
                });
                return zIO;
            });
        });
    }

    private Tuple4<List<Definition.ExecutableDefinition.OperationDefinition>, List<Definition.ExecutableDefinition.FragmentDefinition>, List<Definition.TypeSystemDefinition>, List<Definition.TypeSystemExtension>> collectDefinitions(Document document) {
        return (Tuple4)document.definitions().foldLeft((Object)new Tuple4((Object)List$.MODULE$.empty(), (Object)List$.MODULE$.empty(), (Object)List$.MODULE$.empty(), (Object)List$.MODULE$.empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Definition.TypeSystemExtension typeSystemExtension;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple4 tuple4 = (Tuple4)tuple2._1();
                Definition o = (Definition)tuple2._2();
                if (tuple4 != null) {
                    List operations = (List)tuple4._1();
                    List fragments = (List)tuple4._2();
                    List types = (List)tuple4._3();
                    List extensions = (List)tuple4._4();
                    if (o instanceof Definition.ExecutableDefinition.OperationDefinition) {
                        Definition.ExecutableDefinition.OperationDefinition operationDefinition;
                        Definition.ExecutableDefinition.OperationDefinition operationDefinition2 = operationDefinition = (Definition.ExecutableDefinition.OperationDefinition)o;
                        return new Tuple4((Object)operations.$colon$colon((Object)operationDefinition2), (Object)fragments, (Object)types, (Object)extensions);
                    }
                }
            }
            if (tuple2 != null) {
                Tuple4 tuple4 = (Tuple4)tuple2._1();
                Definition f = (Definition)tuple2._2();
                if (tuple4 != null) {
                    List operations = (List)tuple4._1();
                    List fragments = (List)tuple4._2();
                    List types = (List)tuple4._3();
                    List extensions = (List)tuple4._4();
                    if (f instanceof Definition.ExecutableDefinition.FragmentDefinition) {
                        Definition.ExecutableDefinition.FragmentDefinition fragmentDefinition;
                        Definition.ExecutableDefinition.FragmentDefinition fragmentDefinition2 = fragmentDefinition = (Definition.ExecutableDefinition.FragmentDefinition)f;
                        return new Tuple4((Object)operations, (Object)fragments.$colon$colon((Object)fragmentDefinition2), (Object)types, (Object)extensions);
                    }
                }
            }
            if (tuple2 != null) {
                Tuple4 tuple4 = (Tuple4)tuple2._1();
                Definition t = (Definition)tuple2._2();
                if (tuple4 != null) {
                    List operations = (List)tuple4._1();
                    List fragments = (List)tuple4._2();
                    List types = (List)tuple4._3();
                    List extensions = (List)tuple4._4();
                    if (t instanceof Definition.TypeSystemDefinition) {
                        Definition.TypeSystemDefinition typeSystemDefinition;
                        Definition.TypeSystemDefinition typeSystemDefinition2 = typeSystemDefinition = (Definition.TypeSystemDefinition)t;
                        return new Tuple4((Object)operations, (Object)fragments, (Object)types.$colon$colon((Object)typeSystemDefinition2), (Object)extensions);
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple4 tuple4 = (Tuple4)tuple2._1();
            Definition e = (Definition)tuple2._2();
            if (tuple4 == null) throw new MatchError((Object)tuple2);
            List operations = (List)tuple4._1();
            List fragments = (List)tuple4._2();
            List types = (List)tuple4._3();
            List extensions = (List)tuple4._4();
            if (!(e instanceof Definition.TypeSystemExtension)) throw new MatchError((Object)tuple2);
            Definition.TypeSystemExtension typeSystemExtension2 = typeSystemExtension = (Definition.TypeSystemExtension)e;
            return new Tuple4((Object)operations, (Object)fragments, (Object)types, (Object)extensions.$colon$colon((Object)typeSystemExtension2));
        });
    }

    private scala.collection.immutable.Set<String> collectVariablesUsed(Validator.Context context, List<Selection> selectionSet) {
        List allValues = Validator$.collectValues$1(selectionSet, context);
        List varValues = Validator$.collectVariableValues$1(allValues);
        return varValues.map((Function1 & Serializable)x$16 -> x$16.name()).toSet();
    }

    private List<Selection> collectSelectionSets(List<Selection> selectionSet) {
        Builder sets = List$.MODULE$.newBuilder();
        Validator$.loop$1(selectionSet, sets);
        return (List)sets.result();
    }

    private ZIO<Object, CalibanError.ValidationError, List<Tuple2<Directive, __DirectiveLocation>>> collectAllDirectives(Validator.Context context) {
        return IO$.MODULE$.foreach(context.operations(), (Function1 & Serializable)op -> MODULE$.checkDirectivesUniqueness(op.directives()).as((Function0 & Serializable)() -> {
            List list2;
            OperationType operationType = op.operationType();
            if (OperationType$Query$.MODULE$.equals(operationType)) {
                list2 = op.directives().map((Function1 & Serializable)x$17 -> new Tuple2(x$17, (Object)__DirectiveLocation$QUERY$.MODULE$));
            } else if (OperationType$Mutation$.MODULE$.equals(operationType)) {
                list2 = op.directives().map((Function1 & Serializable)x$18 -> new Tuple2(x$18, (Object)__DirectiveLocation$MUTATION$.MODULE$));
            } else if (OperationType$Subscription$.MODULE$.equals(operationType)) {
                list2 = op.directives().map((Function1 & Serializable)x$19 -> new Tuple2(x$19, (Object)__DirectiveLocation$SUBSCRIPTION$.MODULE$));
            } else {
                throw new MatchError((Object)operationType);
            }
            return list2;
        }), BuildFrom$.MODULE$.buildFromIterableOps()).flatMap((Function1 & Serializable)opDirectives -> IO$.MODULE$.foreach(context.fragments().values(), (Function1 & Serializable)fragment -> MODULE$.checkDirectivesUniqueness(fragment.directives()).as((Function0 & Serializable)() -> fragment.directives().map((Function1 & Serializable)x$20 -> new Tuple2(x$20, (Object)__DirectiveLocation$FRAGMENT_DEFINITION$.MODULE$))), BuildFrom$.MODULE$.buildFromIterableOps()).flatMap((Function1 & Serializable)fragmentDirectives -> MODULE$.collectDirectives(context.selectionSets()).map((Function1 & Serializable)selectionDirectives -> (List)((IterableOps)((IterableOps)opDirectives.flatten(Predef$.MODULE$.$conforms())).$plus$plus((IterableOnce)fragmentDirectives.flatten(Predef$.MODULE$.$conforms()))).$plus$plus((IterableOnce)selectionDirectives))));
    }

    private ZIO<Object, CalibanError.ValidationError, List<Tuple2<Directive, __DirectiveLocation>>> collectDirectives(List<Selection> selectionSet) {
        return IO$.MODULE$.foreach(selectionSet, (Function1 & Serializable)x0$1 -> {
            ZIO zIO;
            Selection selection = x0$1;
            if (selection instanceof Selection.FragmentSpread) {
                Selection.FragmentSpread fragmentSpread = (Selection.FragmentSpread)selection;
                List<Directive> directives = fragmentSpread.directives();
                zIO = MODULE$.checkDirectivesUniqueness(directives).as((Function0 & Serializable)() -> directives.map((Function1 & Serializable)x$21 -> new Tuple2(x$21, (Object)__DirectiveLocation$FRAGMENT_SPREAD$.MODULE$)));
            } else if (selection instanceof Selection.Field) {
                Selection.Field field = (Selection.Field)selection;
                List<Directive> directives = field.directives();
                List<Selection> selectionSet = field.selectionSet();
                zIO = MODULE$.checkDirectivesUniqueness(directives).$times$greater((Function0 & Serializable)() -> MODULE$.collectDirectives(selectionSet).map((Function1 & Serializable)x$23 -> (List)directives.map((Function1 & Serializable)x$22 -> new Tuple2(x$22, (Object)__DirectiveLocation$FIELD$.MODULE$)).$plus$plus((IterableOnce)x$23)));
            } else if (selection instanceof Selection.InlineFragment) {
                Selection.InlineFragment inlineFragment = (Selection.InlineFragment)selection;
                List<Directive> directives = inlineFragment.dirs();
                List<Selection> selectionSet = inlineFragment.selectionSet();
                zIO = MODULE$.checkDirectivesUniqueness(directives).$times$greater((Function0 & Serializable)() -> MODULE$.collectDirectives(selectionSet).map((Function1 & Serializable)x$25 -> (List)directives.map((Function1 & Serializable)x$24 -> new Tuple2(x$24, (Object)__DirectiveLocation$INLINE_FRAGMENT$.MODULE$)).$plus$plus((IterableOnce)x$25)));
            } else {
                throw new MatchError((Object)selection);
            }
            return zIO;
        }, BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)x$26 -> (List)x$26.flatten(Predef$.MODULE$.$conforms()));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> checkDirectivesUniqueness(List<Directive> directives) {
        return IO$.MODULE$.whenCase((Function0 & Serializable)() -> directives.groupBy((Function1 & Serializable)x$27 -> x$27.name()).find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$checkDirectivesUniqueness$3(x0$1))), (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Option<Tuple2<String, List<Directive>>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ZIO<Object, CalibanError.ValidationError, T> zIO;
                Some some;
                Tuple2 tuple2;
                A1 A1 = x1;
                if (A1 instanceof Some && (tuple2 = (Tuple2)(some = (Some)A1).value()) != null) {
                    String name = (String)tuple2._1();
                    zIO = Validator$.MODULE$.failValidation(new StringBuilder(30).append("Directive '").append(name).append("' is defined twice.").toString(), "Directives are used to describe some metadata or behavioral change on the definition they apply to. When more than one directive of the same name is used, the expected metadata or behavior becomes ambiguous, therefore only one of each directive is allowed per location.");
                } else {
                    zIO = function1.apply(x1);
                }
                return (B1)zIO;
            }

            public final boolean isDefinedAt(Option<Tuple2<String, List<Directive>>> x1) {
                Some some;
                Tuple2 tuple2;
                Option<Tuple2<String, List<Directive>>> option2 = x1;
                boolean bl = option2 instanceof Some && (tuple2 = (Tuple2)(some = (Some)option2).value()) != null;
                return bl;
            }
        });
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateDirectives(Validator.Context context) {
        return this.collectAllDirectives(context).flatMap((Function1 & Serializable)directives -> IO$.MODULE$.foreach_((Iterable)directives, (Function1 & Serializable)x0$1 -> {
            ZIO zIO;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Directive d = (Directive)tuple2._1();
            __DirectiveLocation location = (__DirectiveLocation)tuple2._2();
            Option option2 = Introspector$.MODULE$.directives().find((Function1 & Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateDirectives$3(d, x$28)));
            if (None$.MODULE$.equals(option2)) {
                zIO = MODULE$.failValidation(new StringBuilder(30).append("Directive '").append(d.name()).append("' is not supported.").toString(), "GraphQL servers define what directives they support. For each usage of a directive, the directive must be available on that server.");
                return zIO;
            } else {
                if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                Some some = (Some)option2;
                __Directive directive = (__Directive)some.value();
                zIO = IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable)() -> !directive.locations().contains((Object)location), (Function0 & Serializable)() -> MODULE$.failValidation(new StringBuilder(44).append("Directive '").append(d.name()).append("' is used in invalid location '").append(location).append("'.").toString(), "GraphQL servers define what directives they support and where they support them. For each usage of a directive, the directive must be used in a location that the server has declared support for."));
            }
            return zIO;
        }));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateVariables(Validator.Context context) {
        return IO$.MODULE$.foreach_(context.operations(), (Function1 & Serializable)op -> IO$.MODULE$.foreach_((Iterable)op.variableDefinitions().groupBy((Function1 & Serializable)x$30 -> x$30.name()), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            List variables = (List)tuple2._2();
            ZIO zIO = IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable)() -> variables.length() > 1, (Function0 & Serializable)() -> MODULE$.failValidation(new StringBuilder(38).append("Variable '").append(name).append("' is defined more than once.").toString(), "If any operation defines more than one variable with the same name, it is ambiguous and invalid. It is invalid even if the type of the duplicate variable is the same."));
            return zIO;
        }).$times$greater((Function0 & Serializable)() -> IO$.MODULE$.foreach_(op.variableDefinitions(), (Function1 & Serializable)v -> {
            String t = Type$.MODULE$.innerType(v.variableType());
            return IO$.MODULE$.whenCase((Function0 & Serializable)() -> context.rootType().types().get((Object)t).map((Function1 & Serializable)x$31 -> x$31.kind()), (PartialFunction)new Serializable((VariableDefinition)v){
                private static final long serialVersionUID = 0L;
                private final VariableDefinition v$1;

                public final <A1 extends Option<__TypeKind>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Some some;
                    __TypeKind __TypeKind2;
                    Some some2;
                    __TypeKind __TypeKind3;
                    Some some3;
                    __TypeKind __TypeKind4;
                    A1 A1 = x1;
                    boolean bl = A1 instanceof Some && __TypeKind$OBJECT$.MODULE$.equals(__TypeKind4 = (__TypeKind)(some3 = (Some)A1).value()) ? true : (A1 instanceof Some && __TypeKind$UNION$.MODULE$.equals(__TypeKind3 = (__TypeKind)(some2 = (Some)A1).value()) ? true : A1 instanceof Some && __TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2 = (__TypeKind)(some = (Some)A1).value()));
                    ZIO<Object, CalibanError.ValidationError, T> zIO = bl ? Validator$.MODULE$.failValidation(new StringBuilder(46).append("Type of variable '").append(this.v$1.name()).append("' is not a valid input type.").toString(), "Variables can only be input types. Objects, unions, and interfaces cannot be used as inputs.") : function1.apply(x1);
                    return (B1)zIO;
                }

                public final boolean isDefinedAt(Option<__TypeKind> x1) {
                    Some some;
                    __TypeKind __TypeKind2;
                    Some some2;
                    __TypeKind __TypeKind3;
                    Some some3;
                    __TypeKind __TypeKind4;
                    Option<__TypeKind> option2 = x1;
                    boolean bl = option2 instanceof Some && __TypeKind$OBJECT$.MODULE$.equals(__TypeKind4 = (__TypeKind)(some3 = (Some)option2).value()) ? true : (option2 instanceof Some && __TypeKind$UNION$.MODULE$.equals(__TypeKind3 = (__TypeKind)(some2 = (Some)option2).value()) ? true : option2 instanceof Some && __TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2 = (__TypeKind)(some = (Some)option2).value()));
                    boolean bl2 = bl;
                    return bl2;
                }
                {
                    this.v$1 = v$1;
                }
            });
        })).$times$greater((Function0 & Serializable)() -> {
            scala.collection.immutable.Set<String> variableUsages = MODULE$.collectVariablesUsed(context, op.selectionSet());
            return IO$.MODULE$.foreach_(variableUsages, (Function1 & Serializable)v -> IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable)() -> !op.variableDefinitions().exists((Function1 & Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateVariables$13(v, x$32))), (Function0 & Serializable)() -> MODULE$.failValidation(new StringBuilder(27).append("Variable '").append((String)v).append("' is not defined.").toString(), "Variables are scoped on a per\u2010operation basis. That means that any variable used within the context of an operation must be defined at the top level of that operation"))).$times$greater((Function0 & Serializable)() -> IO$.MODULE$.foreach_(op.variableDefinitions(), (Function1 & Serializable)v -> IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable)() -> !variableUsages.contains((Object)v.name()), (Function0 & Serializable)() -> MODULE$.failValidation(new StringBuilder(24).append("Variable '").append(v.name()).append("' is not used.").toString(), "All variables defined by an operation must be used in that operation or a fragment transitively included by that operation. Unused variables cause a validation error."))));
        }));
    }

    private List<Selection.FragmentSpread> collectFragmentSpreads(List<Selection> selectionSet) {
        return selectionSet.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Selection, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Selection.FragmentSpread) {
                    Selection.FragmentSpread fragmentSpread = (Selection.FragmentSpread)A1;
                    object = fragmentSpread;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Selection x1) {
                Selection selection = x1;
                boolean bl = selection instanceof Selection.FragmentSpread;
                return bl;
            }
        });
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateFragmentSpreads(Validator.Context context) {
        List<Selection.FragmentSpread> spreads = this.collectFragmentSpreads(context.selectionSets());
        scala.collection.immutable.Set spreadNames = spreads.map((Function1 & Serializable)x$33 -> x$33.name()).toSet();
        return IO$.MODULE$.foreach_(context.fragments().values(), (Function1 & Serializable)f -> !spreadNames.contains((Object)f.name()) ? MODULE$.failValidation(new StringBuilder(38).append("Fragment '").append(f.name()).append("' is not used in any spread.").toString(), "Defined fragments must be used within a document.") : MODULE$.failValidation(new StringBuilder(26).append("Fragment '").append(f.name()).append("' forms a cycle.").toString(), "The graph of fragment spreads must not form any cycles including spreading itself. Otherwise an operation could infinitely spread or infinitely execute on cycles in the underlying data.").when((Function0)(JFunction0.mcZ.sp & Serializable)() -> MODULE$.detectCycles(context, (Definition.ExecutableDefinition.FragmentDefinition)f, MODULE$.detectCycles$default$3())));
    }

    private boolean detectCycles(Validator.Context context, Definition.ExecutableDefinition.FragmentDefinition fragment, scala.collection.immutable.Set<String> visited) {
        List<Selection> selectionSets = this.collectSelectionSets(fragment.selectionSet());
        List<Selection.FragmentSpread> descendantSpreads = this.collectFragmentSpreads(selectionSets);
        return descendantSpreads.exists((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$detectCycles$1(visited, context, s)));
    }

    private scala.collection.immutable.Set<String> detectCycles$default$3() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateDocumentFields(Validator.Context context) {
        return IO$.MODULE$.foreach_(context.document().definitions(), (Function1 & Serializable)x0$1 -> {
            ZIO zIO;
            Definition definition = x0$1;
            if (definition instanceof Definition.ExecutableDefinition.OperationDefinition) {
                ZIO zIO2;
                Definition.ExecutableDefinition.OperationDefinition operationDefinition = (Definition.ExecutableDefinition.OperationDefinition)definition;
                OperationType opType = operationDefinition.operationType();
                List<Selection> selectionSet = operationDefinition.selectionSet();
                OperationType operationType = opType;
                if (OperationType$Query$.MODULE$.equals(operationType)) {
                    zIO2 = MODULE$.validateFields(context, selectionSet, context.rootType().queryType());
                } else if (OperationType$Mutation$.MODULE$.equals(operationType)) {
                    zIO2 = (ZIO)context.rootType().mutationType().fold((Function0 & Serializable)() -> MODULE$.failValidation("Mutation operations are not supported on this schema.", ""), (Function1 & Serializable)x$34 -> MODULE$.validateFields(context, selectionSet, (__Type)x$34));
                } else if (OperationType$Subscription$.MODULE$.equals(operationType)) {
                    zIO2 = (ZIO)context.rootType().subscriptionType().fold((Function0 & Serializable)() -> MODULE$.failValidation("Subscription operations are not supported on this schema.", ""), (Function1 & Serializable)x$35 -> MODULE$.validateFields(context, selectionSet, (__Type)x$35));
                } else {
                    throw new MatchError((Object)operationType);
                }
                zIO = zIO2;
            } else if (definition instanceof Definition.ExecutableDefinition.FragmentDefinition) {
                zIO = IO$.MODULE$.unit();
            } else if (definition instanceof Definition.TypeSystemDefinition) {
                zIO = IO$.MODULE$.unit();
            } else if (definition instanceof Definition.TypeSystemExtension) {
                zIO = IO$.MODULE$.unit();
            } else {
                throw new MatchError((Object)definition);
            }
            return zIO;
        });
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateFields(Validator.Context context, List<Selection> selectionSet, __Type currentType) {
        return IO$.MODULE$.foreach_(selectionSet, (Function1 & Serializable)x0$1 -> {
            Object object;
            Selection selection = x0$1;
            if (selection instanceof Selection.Field) {
                Selection.Field field = (Selection.Field)selection;
                object = MODULE$.validateField(context, field, currentType);
            } else if (selection instanceof Selection.FragmentSpread) {
                Object object2;
                Selection.FragmentSpread fragmentSpread = (Selection.FragmentSpread)selection;
                String name = fragmentSpread.name();
                Option option2 = context.fragments().get((Object)name);
                if (None$.MODULE$.equals(option2)) {
                    object2 = MODULE$.failValidation(new StringBuilder(34).append("Fragment spread '").append(name).append("' is not defined.").toString(), "Named fragment spreads must refer to fragments defined within the document. It is a validation error if the target of a spread is not defined.");
                } else if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    Definition.ExecutableDefinition.FragmentDefinition fragment = (Definition.ExecutableDefinition.FragmentDefinition)some.value();
                    object2 = MODULE$.validateSpread(context, (Option<String>)new Some((Object)name), currentType, (Option<Type.NamedType>)new Some((Object)fragment.typeCondition()), fragment.selectionSet());
                } else {
                    throw new MatchError((Object)option2);
                }
                object = object2;
            } else if (selection instanceof Selection.InlineFragment) {
                Selection.InlineFragment inlineFragment = (Selection.InlineFragment)selection;
                Option<Type.NamedType> typeCondition = inlineFragment.typeCondition();
                List<Selection> selectionSet = inlineFragment.selectionSet();
                object = MODULE$.validateSpread(context, (Option<String>)None$.MODULE$, currentType, typeCondition, selectionSet);
            } else {
                throw new MatchError((Object)selection);
            }
            return object;
        }).$times$greater((Function0 & Serializable)() -> MODULE$.validateLeafFieldSelection(selectionSet, currentType));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateSpread(Validator.Context context, Option<String> name, __Type currentType, Option<Type.NamedType> typeCondition, List<Selection> selectionSet) {
        ZIO zIO;
        Option option2 = (Option)typeCondition.fold((Function0 & Serializable)() -> new Some((Object)currentType), (Function1 & Serializable)t -> context.rootType().types().get((Object)t.name()));
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            __Type fragmentType = (__Type)some.value();
            zIO = this.validateFragmentType(name, fragmentType).$times$greater((Function0 & Serializable)() -> {
                List possibleTypes = MODULE$.getPossibleTypes(currentType).flatMap((Function1 & Serializable)x$36 -> x$36.name());
                List possibleFragmentTypes = MODULE$.getPossibleTypes(fragmentType).flatMap((Function1 & Serializable)x$37 -> x$37.name());
                List applicableTypes = (List)possibleTypes.intersect((Seq)possibleFragmentTypes);
                return IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable)() -> applicableTypes.isEmpty(), (Function0 & Serializable)() -> MODULE$.failValidation(new StringBuilder(75).append(name.fold((Function0 & Serializable)() -> "Inline fragment spread", (Function1 & Serializable)n -> new StringBuilder(18).append("Fragment spread '").append((String)n).append("'").toString())).append(" is not possible: possible types are '").append(possibleTypes.mkString(", ")).append("' and possible fragment types are '").append(possibleFragmentTypes.mkString(", ")).append("'.").toString(), "Fragments are declared on a type and will only apply when the runtime object type matches the type condition. They also are spread within the context of a parent type. A fragment spread is only valid if its type condition could ever apply within the parent type.")).$times$greater((Function0 & Serializable)() -> MODULE$.validateFields(context, selectionSet, fragmentType));
            });
        } else if (None$.MODULE$.equals(option2)) {
            LazyRef typeConditionName$lzy = new LazyRef();
            zIO = this.failValidation(new StringBuilder(29).append(name.fold((Function0 & Serializable)() -> "Inline fragment spread", (Function1 & Serializable)n -> new StringBuilder(18).append("Fragment spread '").append((String)n).append("'").toString())).append(" targets an invalid type: '").append(Validator$.typeConditionName$1(typeConditionName$lzy, typeCondition)).append("'.").toString(), "Fragments must be specified on types that exist in the schema. This applies for both named and inline fragments. If they are not defined in the schema, the query does not validate.");
        } else {
            throw new MatchError((Object)option2);
        }
        return zIO;
    }

    private List<__Type> getPossibleTypes(__Type t) {
        boolean bl;
        __TypeKind __TypeKind2 = t.kind();
        Object object = __TypeKind$OBJECT$.MODULE$.equals(__TypeKind2) ? (List)new .colon.colon((Object)t, (List)Nil$.MODULE$) : ((bl = __TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$UNION$.MODULE$.equals(__TypeKind2)) ? (List)t.possibleTypes().getOrElse((Function0 & Serializable)() -> Nil$.MODULE$) : Nil$.MODULE$);
        return object;
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateField(Validator.Context context, Selection.Field field, __Type currentType) {
        return IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            String string2 = field.name();
            String string3 = "__typename";
            return string2 == null ? string3 != null : !string2.equals(string3);
        }, (Function0 & Serializable)() -> IO$.MODULE$.fromOption((Function0 & Serializable)() -> ((List)((Option)currentType.fields().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))))).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$)).find((Function1 & Serializable)x$39 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateField$5(field, x$39)))).orElseFail((Function0 & Serializable)() -> new CalibanError.ValidationError(new StringBuilder(35).append("Field '").append(field.name()).append("' does not exist on type '").append(Rendering$.MODULE$.renderTypeName(currentType)).append("'.").toString(), "The target field of a field selection must be defined on the scoped type of the selection set. There are no limitations on alias names.", CalibanError$ValidationError$.MODULE$.apply$default$3(), CalibanError$ValidationError$.MODULE$.apply$default$4()), CanFail$.MODULE$.canFail()).flatMap((Function1 & Serializable)f -> MODULE$.validateFields(context, field.selectionSet(), Types$.MODULE$.innerType((__Type)f.type().apply())).$times$greater((Function0 & Serializable)() -> MODULE$.validateArguments(field, (__Field)f, currentType))));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateArguments(Selection.Field field, __Field f, __Type currentType) {
        return IO$.MODULE$.foreach_(field.arguments(), (Function1 & Serializable)x0$1 -> {
            void var5_10;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String arg = (String)tuple2._1();
            InputValue argValue = (InputValue)tuple2._2();
            Option option2 = f.args().find((Function1 & Serializable)x$40 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateArguments$2(arg, x$40)));
            if (None$.MODULE$.equals(option2)) {
                ZIO zIO = MODULE$.failValidation(new StringBuilder(50).append("Argument '").append(arg).append("' is not defined on field '").append(field.name()).append("' of type '").append(currentType.name().getOrElse((Function0 & Serializable)() -> "")).append("'.").toString(), "Every argument provided to a field or directive must be defined in the set of possible arguments of that field or directive.");
                return var5_10;
            } else {
                if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                Some some = (Some)option2;
                __InputValue inputValue = (__InputValue)some.value();
                ZIO<Object, CalibanError.ValidationError, BoxedUnit> zIO = MODULE$.validateInputValues(inputValue, argValue);
            }
            return var5_10;
        }).$times$greater((Function0 & Serializable)() -> IO$.MODULE$.foreach_((Iterable)f.args().filter((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateArguments$5(a))), (Function1 & Serializable)arg -> IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable)() -> field.arguments().get((Object)arg.name()).forall((Function1 & Serializable)x$41 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateArguments$8(x$41))), (Function0 & Serializable)() -> MODULE$.failValidation(new StringBuilder(63).append("Required argument '").append(arg.name()).append("' is null or missing on field '").append(field.name()).append("' of type '").append(currentType.name().getOrElse((Function0 & Serializable)() -> "")).append("'.").toString(), "Arguments can be required. An argument is required if the argument type is non\u2010null and does not have a default value. Otherwise, the argument is optional."))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateInputValues(__InputValue inputValue, InputValue argValue) {
        __Type t = (__Type)inputValue.type().apply();
        __TypeKind __TypeKind2 = t.kind();
        __TypeKind$NON_NULL$ __TypeKind$NON_NULL$2 = __TypeKind$NON_NULL$.MODULE$;
        __Type inputType = !(__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$NON_NULL$2) : __TypeKind$NON_NULL$2 != null) ? (__Type)t.ofType().getOrElse((Function0 & Serializable)() -> t) : t;
        List inputFields = (List)inputType.inputFields().getOrElse((Function0 & Serializable)() -> Nil$.MODULE$);
        InputValue inputValue2 = argValue;
        if (!(inputValue2 instanceof InputValue.ObjectValue)) return IO$.MODULE$.unit();
        InputValue.ObjectValue objectValue = (InputValue.ObjectValue)inputValue2;
        Map<String, InputValue> fields = objectValue.fields();
        __TypeKind __TypeKind3 = inputType.kind();
        __TypeKind$INPUT_OBJECT$ __TypeKind$INPUT_OBJECT$2 = __TypeKind$INPUT_OBJECT$.MODULE$;
        if (__TypeKind3 != null) {
            if (!__TypeKind3.equals(__TypeKind$INPUT_OBJECT$2)) return IO$.MODULE$.unit();
            return IO$.MODULE$.foreach_(fields, (Function1 & Serializable)x0$1 -> {
                void var4_9;
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                String k = (String)tuple2._1();
                InputValue v = (InputValue)tuple2._2();
                Option option2 = inputFields.find((Function1 & Serializable)x$42 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateInputValues$4(k, x$42)));
                if (None$.MODULE$.equals(option2)) {
                    ZIO zIO = MODULE$.failValidation(new StringBuilder(41).append("Input field '").append(k).append("' is not defined on type '").append(inputType.name().getOrElse((Function0 & Serializable)() -> "?")).append("'.").toString(), "Every input field provided in an input object value must be defined in the set of possible fields of that input object\u2019s expected type.");
                    return var4_9;
                } else {
                    if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                    Some some = (Some)option2;
                    __InputValue value = (__InputValue)some.value();
                    ZIO<Object, CalibanError.ValidationError, BoxedUnit> zIO = MODULE$.validateInputValues(value, v);
                }
                return var4_9;
            }).$times$greater((Function0 & Serializable)() -> IO$.MODULE$.foreach_((Iterable)inputFields, (Function1 & Serializable)inputField -> IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                if (!inputField.defaultValue().isEmpty()) return false;
                __TypeKind __TypeKind2 = ((__Type)inputField.type().apply()).kind();
                __TypeKind$NON_NULL$ __TypeKind$NON_NULL$2 = __TypeKind$NON_NULL$.MODULE$;
                if (__TypeKind2 == null) {
                    if (__TypeKind$NON_NULL$2 != null) {
                        return false;
                    }
                } else if (!__TypeKind2.equals(__TypeKind$NON_NULL$2)) return false;
                if (fields.contains((Object)inputField.name())) return false;
                return true;
            }, (Function0 & Serializable)() -> MODULE$.failValidation(new StringBuilder(48).append("Required field '").append(inputField.name()).append("' on object '").append(inputType.name().getOrElse((Function0 & Serializable)() -> "?")).append("' was not provided.").toString(), "Input object fields may be required. Much like a field may have required arguments, an input object may have required fields. An input field is required if it has a non\u2010null type and does not have a default value. Otherwise, the input object field is optional."))));
        }
        if (__TypeKind$INPUT_OBJECT$2 == null) return IO$.MODULE$.foreach_(fields, (Function1 & Serializable)x0$1 -> {
            void var4_9;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String k = (String)tuple2._1();
            InputValue v = (InputValue)tuple2._2();
            Option option2 = inputFields.find((Function1 & Serializable)x$42 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateInputValues$4(k, x$42)));
            if (None$.MODULE$.equals(option2)) {
                ZIO zIO = MODULE$.failValidation(new StringBuilder(41).append("Input field '").append(k).append("' is not defined on type '").append(inputType.name().getOrElse((Function0 & Serializable)() -> "?")).append("'.").toString(), "Every input field provided in an input object value must be defined in the set of possible fields of that input object\u2019s expected type.");
                return var4_9;
            } else {
                if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                Some some = (Some)option2;
                __InputValue value = (__InputValue)some.value();
                ZIO<Object, CalibanError.ValidationError, BoxedUnit> zIO = MODULE$.validateInputValues(value, v);
            }
            return var4_9;
        }).$times$greater((Function0 & Serializable)() -> IO$.MODULE$.foreach_((Iterable)inputFields, (Function1 & Serializable)inputField -> IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            if (!inputField.defaultValue().isEmpty()) return false;
            __TypeKind __TypeKind2 = ((__Type)inputField.type().apply()).kind();
            __TypeKind$NON_NULL$ __TypeKind$NON_NULL$2 = __TypeKind$NON_NULL$.MODULE$;
            if (__TypeKind2 == null) {
                if (__TypeKind$NON_NULL$2 != null) {
                    return false;
                }
            } else if (!__TypeKind2.equals(__TypeKind$NON_NULL$2)) return false;
            if (fields.contains((Object)inputField.name())) return false;
            return true;
        }, (Function0 & Serializable)() -> MODULE$.failValidation(new StringBuilder(48).append("Required field '").append(inputField.name()).append("' on object '").append(inputType.name().getOrElse((Function0 & Serializable)() -> "?")).append("' was not provided.").toString(), "Input object fields may be required. Much like a field may have required arguments, an input object may have required fields. An input field is required if it has a non\u2010null type and does not have a default value. Otherwise, the input object field is optional."))));
        return IO$.MODULE$.unit();
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateLeafFieldSelection(List<Selection> selections, __Type currentType) {
        return IO$.MODULE$.whenCase((Function0 & Serializable)() -> currentType.kind(), (PartialFunction)new Serializable(selections, currentType){
            private static final long serialVersionUID = 0L;
            private final List selections$1;
            private final __Type currentType$5;

            public final <A1 extends __TypeKind, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                boolean bl;
                A1 A1 = x1;
                boolean bl2 = __TypeKind$SCALAR$.MODULE$.equals(A1) ? true : __TypeKind$ENUM$.MODULE$.equals(A1);
                ZIO<Object, CalibanError.ValidationError, T> zIO = bl2 && this.selections$1.nonEmpty() ? Validator$.MODULE$.failValidation(new StringBuilder(41).append("Field selection is impossible on type '").append(this.currentType$5.name().getOrElse((Function0 & Serializable)() -> "")).append("'.").toString(), "Field selections on scalars or enums are never allowed, because they are the leaf nodes of any GraphQL query.") : ((bl = __TypeKind$INTERFACE$.MODULE$.equals(A1) ? true : (__TypeKind$UNION$.MODULE$.equals(A1) ? true : __TypeKind$OBJECT$.MODULE$.equals(A1))) && this.selections$1.isEmpty() ? Validator$.MODULE$.failValidation(new StringBuilder(40).append("Field selection is mandatory on type '").append(this.currentType$5.name().getOrElse((Function0 & Serializable)() -> "")).append("'.").toString(), "Leaf selections on objects, interfaces, and unions without subfields are disallowed.") : function1.apply(x1));
                return (B1)zIO;
            }

            public final boolean isDefinedAt(__TypeKind x1) {
                boolean bl;
                __TypeKind __TypeKind2 = x1;
                boolean bl2 = __TypeKind$SCALAR$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$ENUM$.MODULE$.equals(__TypeKind2);
                boolean bl3 = bl2 && this.selections$1.nonEmpty() ? true : (bl = __TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2) ? true : (__TypeKind$UNION$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$OBJECT$.MODULE$.equals(__TypeKind2))) && this.selections$1.isEmpty();
                return bl3;
            }
            {
                this.selections$1 = selections$1;
                this.currentType$5 = currentType$5;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(), $anonfun$applyOrElse$2()}, serializedLambda);
            }
        });
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateOperationNameUniqueness(List<Definition.ExecutableDefinition.OperationDefinition> operations) {
        Map names = operations.flatMap((Function1 & Serializable)x$43 -> x$43.name()).groupBy((Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x));
        scala.collection.immutable.Iterable repeatedNames = (scala.collection.immutable.Iterable)names.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, List<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String name = (String)A1._1();
                    List items = (List)A1._2();
                    if (items.length() > 1) {
                        object = name;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, List<String>> x1) {
                List items;
                Tuple2<String, List<String>> tuple2 = x1;
                boolean bl = tuple2 != null && (items = (List)tuple2._2()).length() > 1;
                return bl;
            }
        });
        return IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable)() -> repeatedNames.nonEmpty(), (Function0 & Serializable)() -> MODULE$.failValidation(new StringBuilder(41).append("Multiple operations have the same name: ").append(repeatedNames.mkString(", ")).append(".").toString(), "Each named operation definition must be unique within a document when referred to by its name."));
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateLoneAnonymousOperation(List<Definition.ExecutableDefinition.OperationDefinition> operations) {
        List anonymous = operations.filter((Function1 & Serializable)x$44 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateLoneAnonymousOperation$1(x$44)));
        return IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable)() -> operations.length() > 1 && anonymous.nonEmpty(), (Function0 & Serializable)() -> MODULE$.failValidation("Found both anonymous and named operations.", "GraphQL allows a short\u2010hand form for defining query operations when only that one operation exists in the document."));
    }

    private ZIO<Object, CalibanError.ValidationError, Map<String, Definition.ExecutableDefinition.FragmentDefinition>> validateFragments(List<Definition.ExecutableDefinition.FragmentDefinition> fragments) {
        return IO$.MODULE$.foldLeft(fragments, (Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Definition.ExecutableDefinition.FragmentDefinition fragment;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Map fragmentMap = (Map)tuple2._1();
            ZIO zIO = fragmentMap.contains((Object)(fragment = (Definition.ExecutableDefinition.FragmentDefinition)tuple2._2()).name()) ? MODULE$.failValidation(new StringBuilder(38).append("Fragment '").append(fragment.name()).append("' is defined more than once.").toString(), "Fragment definitions are referenced in fragment spreads by name. To avoid ambiguity, each fragment\u2019s name must be unique within a document.") : IO$.MODULE$.succeed((Function0 & Serializable)() -> (Map)fragmentMap.updated((Object)fragment.name(), (Object)fragment));
            return zIO;
        });
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateSubscriptionOperation(Validator.Context context) {
        return IO$.MODULE$.fromOption((Function0 & Serializable)() -> context.rootType().subscriptionType().flatMap((Function1 & Serializable)t -> context.operations().filter((Function1 & Serializable)x$45 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateSubscriptionOperation$3(x$45))).find((Function1 & Serializable)op -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateSubscriptionOperation$4(context, t, op))))).map((Function1 & Serializable)op -> {
            String subscription = (String)op.name().fold((Function0 & Serializable)() -> "", (Function1 & Serializable)n -> new StringBuilder(2).append("'").append((String)n).append("'").toString());
            return new CalibanError.ValidationError(new StringBuilder(43).append("Subscription ").append(subscription).append(" has more than one root field.").toString(), "Subscription operations must have exactly one root field.", CalibanError$ValidationError$.MODULE$.apply$default$3(), CalibanError$ValidationError$.MODULE$.apply$default$4());
        }).flip().unit();
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateFragmentType(Option<String> name, __Type targetType) {
        ZIO zIO;
        __TypeKind __TypeKind2 = targetType.kind();
        boolean bl = __TypeKind$UNION$.MODULE$.equals(__TypeKind2) ? true : (__TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$OBJECT$.MODULE$.equals(__TypeKind2));
        if (bl) {
            zIO = IO$.MODULE$.unit();
        } else {
            String targetTypeName = (String)targetType.name().getOrElse((Function0 & Serializable)() -> "");
            zIO = this.failValidation(new StringBuilder(30).append(name.fold((Function0 & Serializable)() -> "Inline fragment", (Function1 & Serializable)n -> new StringBuilder(11).append("Fragment '").append((String)n).append("'").toString())).append(" is defined on invalid type '").append(targetTypeName).append("'").toString(), "Fragments can only be declared on unions, interfaces, and objects. They are invalid on scalars. They can only be applied on non\u2010leaf fields. This rule applies to both inline and named fragments.");
        }
        return zIO;
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateEnum(__Type t) {
        Some some;
        List list2;
        Option option2 = (Option)t.enumValues().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))));
        ZIO zIO = option2 instanceof Some && (list2 = (List)(some = (Some)option2).value()) instanceof .colon.colon ? IO$.MODULE$.unit() : this.failValidation(new StringBuilder(32).append("Enum ").append(t.name().getOrElse((Function0 & Serializable)() -> "")).append(" doesn't contain any values").toString(), "An Enum type must define one or more unique enum values.");
        return zIO;
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateUnion(__Type t2) {
        Some some;
        List types;
        Some some2;
        List list2;
        Option<List<__Type>> option2 = t2.possibleTypes();
        boolean bl = None$.MODULE$.equals(option2) ? true : option2 instanceof Some && Nil$.MODULE$.equals(list2 = (List)(some2 = (Some)option2).value());
        ZIO zIO = bl ? this.failValidation(new StringBuilder(32).append("Union ").append(t2.name().getOrElse((Function0 & Serializable)() -> "")).append(" doesn't contain any type.").toString(), "A Union type must include one or more unique member types.") : (option2 instanceof Some && !(types = (List)(some = (Some)option2).value()).forall((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)Validator$.isObject$1(t))) ? this.failValidation(new StringBuilder(0).append(new StringBuilder(48).append("Union ").append(t2.name().getOrElse((Function0 & Serializable)() -> "")).append(" contains the following non Object types: ").toString()).append(types.filterNot((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)Validator$.isObject$1(t))).map((Function1 & Serializable)x$46 -> (String)x$46.name().getOrElse((Function0 & Serializable)() -> "")).filterNot((Function1 & Serializable)x$47 -> BoxesRunTime.boxToBoolean((boolean)x$47.isEmpty())).mkString("", ", ", ".")).toString(), "The member types of a Union type must all be Object base types.") : IO$.MODULE$.unit());
        return zIO;
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateInputObject(__Type t) {
        ZIO zIO;
        Some some;
        List list2;
        String inputObjectContext = new StringBuilder(14).append("InputObject '").append(t.name().getOrElse((Function0 & Serializable)() -> "")).append("'").toString();
        Option<List<__InputValue>> option2 = t.inputFields();
        boolean bl = None$.MODULE$.equals(option2) ? true : option2 instanceof Some && Nil$.MODULE$.equals(list2 = (List)(some = (Some)option2).value());
        if (bl) {
            zIO = this.failValidation(new StringBuilder(21).append(inputObjectContext).append(" does not have fields").toString(), "An Input Object type must define one or more input fields");
        } else if (option2 instanceof Some) {
            Some some2 = (Some)option2;
            List fields = (List)some2.value();
            zIO = this.validateFields$1(fields, inputObjectContext);
        } else {
            throw new MatchError(option2);
        }
        return zIO;
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateInputValue(__InputValue inputValue, String errorContext) {
        String fieldContext = new StringBuilder(17).append("InputValue '").append(inputValue.name()).append("' of ").append(errorContext).toString();
        return this.doesNotStartWithUnderscore(inputValue, fieldContext).flatMap((Function1 & Serializable)x$51 -> {
            BoxedUnit boxedUnit = x$51;
            ZIO<Object, CalibanError.ValidationError, BoxedUnit> zIO = MODULE$.onlyInputType((__Type)inputValue.type().apply(), fieldContext);
            return zIO;
        });
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateInterface(__Type t) {
        Object object;
        Some some;
        List list2;
        String interfaceContext = new StringBuilder(12).append("Interface '").append(t.name().getOrElse((Function0 & Serializable)() -> "")).append("'").toString();
        Option option2 = (Option)t.fields().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))));
        boolean bl = None$.MODULE$.equals(option2) ? true : option2 instanceof Some && Nil$.MODULE$.equals(list2 = (List)(some = (Some)option2).value());
        if (bl) {
            object = this.failValidation(new StringBuilder(21).append(interfaceContext).append(" does not have fields").toString(), "An Interface type must define one or more fields");
        } else if (option2 instanceof Some) {
            Some some2 = (Some)option2;
            List fields = (List)some2.value();
            object = this.validateFields((List<__Field>)fields, interfaceContext);
        } else {
            throw new MatchError((Object)option2);
        }
        return object;
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateObject(__Type obj) {
        ZIO zIO;
        Some some;
        List list2;
        String objectContext = new StringBuilder(9).append("Object '").append(obj.name().getOrElse((Function0 & Serializable)() -> "")).append("'").toString();
        Option option2 = (Option)obj.fields().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))));
        boolean bl = None$.MODULE$.equals(option2) ? true : option2 instanceof Some && Nil$.MODULE$.equals(list2 = (List)(some = (Some)option2).value());
        if (bl) {
            zIO = this.failValidation(new StringBuilder(21).append(objectContext).append(" does not have fields").toString(), "An Object type must define one or more fields");
        } else if (option2 instanceof Some) {
            Some some2 = (Some)option2;
            List fields = (List)some2.value();
            zIO = this.validateFields((List<__Field>)fields, objectContext).$times$greater((Function0 & Serializable)() -> Validator$.validateInterfaceFields$1(obj, objectContext));
        } else {
            throw new MatchError((Object)option2);
        }
        return zIO;
    }

    public boolean caliban$validation$Validator$$isListField(__Field field) {
        __TypeKind __TypeKind2 = ((__Type)field.type().apply()).kind();
        __TypeKind$LIST$ __TypeKind$LIST$2 = __TypeKind$LIST$.MODULE$;
        return !(__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$LIST$2) : __TypeKind$LIST$2 != null);
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> onlyInputType(__Type type, String errorContext) {
        return IO$.MODULE$.whenCase((Function0 & Serializable)() -> Validator$.isInputType$1(type), (PartialFunction)new Serializable(errorContext){
            private static final long serialVersionUID = 0L;
            private final String errorContext$2;

            public final <A1 extends Either<__Type, BoxedUnit>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ZIO<Object, CalibanError.ValidationError, T> zIO;
                A1 A1 = x1;
                if (A1 instanceof Left) {
                    Left left = (Left)A1;
                    __Type errorType = (__Type)left.value();
                    zIO = Validator$.MODULE$.failValidation(new StringBuilder(38).append(errorType.name().getOrElse((Function0 & Serializable)() -> "")).append(" of ").append(this.errorContext$2).append(" is of kind ").append(errorType.kind()).append(", must be an InputType").toString(), "The input field must accept a type where IsInputType(type) returns true, https://spec.graphql.org/June2018/#IsInputType()");
                } else {
                    zIO = function1.apply(x1);
                }
                return (B1)zIO;
            }

            public final boolean isDefinedAt(Either<__Type, BoxedUnit> x1) {
                Either<__Type, BoxedUnit> either = x1;
                boolean bl = either instanceof Left;
                return bl;
            }
            {
                this.errorContext$2 = errorContext$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$11()}, serializedLambda);
            }
        });
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateFields(List<__Field> fields, String context) {
        return this.noDuplicateFieldName(fields, context).$less$times((Function0 & Serializable)() -> IO$.MODULE$.foreach_((Iterable)fields, (Function1 & Serializable)field -> {
            String fieldContext = new StringBuilder(12).append("Field '").append(field.name()).append("' of ").append(context).toString();
            return MODULE$.doesNotStartWithUnderscore((__Field)field, fieldContext).flatMap((Function1 & Serializable)x$63 -> {
                BoxedUnit boxedUnit = x$63;
                ZIO zIO = MODULE$.onlyOutputType((__Type)field.type().apply(), fieldContext).flatMap((Function1 & Serializable)x$62 -> {
                    BoxedUnit boxedUnit = x$62;
                    ZIO zIO = IO$.MODULE$.foreach_(field.args(), (Function1 & Serializable)x$60 -> MODULE$.validateInputValue((__InputValue)x$60, fieldContext)).map((Function1 & Serializable)x$61 -> {
                        BoxedUnit boxedUnit = x$61;
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        return boxedUnit2;
                    });
                    return zIO;
                });
                return zIO;
            });
        }));
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> noDuplicateFieldName(List<__Field> fields, String errorContext) {
        Function1 & Serializable messageBuilder = (Function1 & Serializable)f -> new StringBuilder(22).append(errorContext).append(" has repeated fields: ").append(f.name()).toString();
        String explanatory = "The field must have a unique name within that Interface type; no two fields may share the same name";
        return this.noDuplicateName(fields, (Function1 & Serializable)x$64 -> x$64.name(), messageBuilder, explanatory);
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> onlyOutputType(__Type type, String errorContext) {
        return IO$.MODULE$.whenCase((Function0 & Serializable)() -> Validator$.isOutputType$1(type), (PartialFunction)new Serializable(errorContext){
            private static final long serialVersionUID = 0L;
            private final String errorContext$4;

            public final <A1 extends Either<__Type, BoxedUnit>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ZIO<Object, CalibanError.ValidationError, T> zIO;
                A1 A1 = x1;
                if (A1 instanceof Left) {
                    Left left = (Left)A1;
                    __Type errorType = (__Type)left.value();
                    zIO = Validator$.MODULE$.failValidation(new StringBuilder(39).append(errorType.name().getOrElse((Function0 & Serializable)() -> "")).append(" of ").append(this.errorContext$4).append(" is of kind ").append(errorType.kind()).append(", must be an OutputType").toString(), "The input field must accept a type where IsOutputType(type) returns true, https://spec.graphql.org/June2018/#IsInputType()");
                } else {
                    zIO = function1.apply(x1);
                }
                return (B1)zIO;
            }

            public final boolean isDefinedAt(Either<__Type, BoxedUnit> x1) {
                Either<__Type, BoxedUnit> either = x1;
                boolean bl = either instanceof Left;
                return bl;
            }
            {
                this.errorContext$4 = errorContext$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$12()}, serializedLambda);
            }
        });
    }

    public <T> ZIO<Object, CalibanError.ValidationError, BoxedUnit> noDuplicateName(List<T> listOfNamed, Function1<T, String> nameExtractor, Function1<T, String> messageBuilder, String explanatoryText) {
        return (ZIO)listOfNamed.groupBy((Function1 & Serializable)x$65 -> (String)nameExtractor.apply(x$65)).collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, List<T>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                List list2;
                A1 A1 = x1;
                if (A1 != null && (list2 = (List)A1._2()) instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list2;
                    Object f = colon2.head();
                    List list3 = colon2.next$access$1();
                    if (list3 instanceof .colon.colon) {
                        object = f;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, List<T>> x1) {
                .colon.colon colon2;
                List list2;
                List list3;
                Tuple2<String, List<T>> tuple2 = x1;
                boolean bl = tuple2 != null && (list3 = (List)tuple2._2()) instanceof .colon.colon && (list2 = (colon2 = (.colon.colon)list3).next$access$1()) instanceof .colon.colon;
                return bl;
            }
        }).fold((Function0 & Serializable)() -> IO$.MODULE$.unit(), (Function1 & Serializable)duplicate -> MODULE$.failValidation((String)messageBuilder.apply(duplicate), explanatoryText));
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> doesNotStartWithUnderscore(__Field field, String errorContext) {
        String explanatory = "The field must not have a name which begins with the characters {\"__\"} (two underscores)";
        return this.doesNotStartWithUnderscore(field, (Function1 & Serializable)x$66 -> x$66.name(), errorContext, explanatory);
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> doesNotStartWithUnderscore(__InputValue inputValue, String errorContext) {
        String explanatory = "The input field must not have a name which begins with the characters \"__\" (two underscores)";
        return this.doesNotStartWithUnderscore(inputValue, (Function1 & Serializable)x$67 -> x$67.name(), errorContext, explanatory);
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> doesNotStartWithUnderscore(Directive directive, String errorContext) {
        String explanatory = "The directive must not have a name which begins with the characters \"__\" (two underscores)";
        return this.doesNotStartWithUnderscore(directive, (Function1 & Serializable)x$68 -> x$68.name(), errorContext, explanatory);
    }

    public <T> ZIO<Object, CalibanError.ValidationError, BoxedUnit> doesNotStartWithUnderscore(T t, Function1<T, String> nameExtractor, String errorContext, String explanatoryText) {
        return IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable)() -> ((String)nameExtractor.apply(t)).startsWith("__"), (Function0 & Serializable)() -> MODULE$.failValidation(new StringBuilder(22).append(errorContext).append(" can't start with '__'").toString(), explanatoryText));
    }

    public <R> ZIO<Object, CalibanError.ValidationError, RootSchema<R>> validateRootQuery(RootSchemaBuilder<R> schema) {
        ZIO zIO;
        Option<Operation<R>> option2 = schema.query();
        if (None$.MODULE$.equals(option2)) {
            zIO = this.failValidation("The query root operation is missing.", "The query root operation type must be provided and must be an Object type.");
        } else if (option2 instanceof Some) {
            Some some = (Some)option2;
            Operation query = (Operation)some.value();
            zIO = IO$.MODULE$.succeed((Function0 & Serializable)() -> new RootSchema(query, schema.mutation(), schema.subscription()));
        } else {
            throw new MatchError(option2);
        }
        return zIO;
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateClashingTypes(List<__Type> types) {
        Option check = types.groupBy((Function1 & Serializable)x$69 -> x$69.name()).collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Option<String>, List<__Type>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    Option option2 = (Option)A1._1();
                    List v = (List)A1._2();
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        String name = (String)some.value();
                        if (v.size() > 1) {
                            object = new Tuple2((Object)name, (Object)v);
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<Option<String>, List<__Type>> x1) {
                Tuple2<Option<String>, List<__Type>> tuple2 = x1;
                if (tuple2 == null) return false;
                Option option2 = (Option)tuple2._1();
                List v = (List)tuple2._2();
                if (!(option2 instanceof Some)) return false;
                if (v.size() <= 1) return false;
                return true;
            }
        });
        return IO$.MODULE$.whenCase((Function0 & Serializable)() -> check, (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Option<Tuple2<String, List<__Type>>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                ZIO<Object, CalibanError.ValidationError, T> zIO;
                Some some;
                Tuple2 tuple2;
                A1 A1 = x2;
                if (A1 instanceof Some && (tuple2 = (Tuple2)(some = (Some)A1).value()) != null) {
                    String name = (String)tuple2._1();
                    List values = (List)tuple2._2();
                    zIO = Validator$.MODULE$.failValidation(new StringBuilder(37).append("Type '").append(name).append("' is defined multiple times (").append(((List)values.sortBy((Function1 & Serializable)v -> (String)v.origin().getOrElse((Function0 & Serializable)() -> ""), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)v -> new StringBuilder(0).append(v.kind()).append(v.origin().fold((Function0 & Serializable)() -> "", (Function1 & Serializable)a -> new StringBuilder(4).append(" in ").append((String)a).toString())).toString()).mkString(", ")).append(").").toString(), "Each type must be defined only once.");
                } else {
                    zIO = function1.apply(x2);
                }
                return (B1)zIO;
            }

            public final boolean isDefinedAt(Option<Tuple2<String, List<__Type>>> x2) {
                Some some;
                Tuple2 tuple2;
                Option<Tuple2<String, List<__Type>>> option2 = x2;
                boolean bl = option2 instanceof Some && (tuple2 = (Tuple2)(some = (Some)option2).value()) != null;
                return bl;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$13(caliban.introspection.adt.__Type ), $anonfun$applyOrElse$14(), $anonfun$applyOrElse$15(caliban.introspection.adt.__Type ), $anonfun$applyOrElse$16(), $anonfun$applyOrElse$17(java.lang.String )}, serializedLambda);
            }
        });
    }

    private ZIO<Object, CalibanError.ValidationError, BoxedUnit> validateDirectives(List<__Type> types) {
        return IO$.MODULE$.foreach_(types, (Function1 & Serializable)t -> {
            String typeErrorContext = new StringBuilder(7).append("Type '").append(t.name().getOrElse((Function0 & Serializable)() -> "")).append("'").toString();
            return this.validateDirectives$1(t.directives(), typeErrorContext).flatMap((Function1 & Serializable)x$74 -> {
                BoxedUnit boxedUnit = x$74;
                ZIO zIO = this.validateInputValueDirectives$1((List)t.inputFields().getOrElse((Function0 & Serializable)() -> List$.MODULE$.empty()), typeErrorContext).flatMap((Function1 & Serializable)x$73 -> {
                    BoxedUnit boxedUnit = x$73;
                    ZIO zIO = IO$.MODULE$.foreach_((Iterable)((Option)t.fields().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))))).getOrElse((Function0 & Serializable)() -> List$.MODULE$.empty()), (Function1 & Serializable)x$71 -> this.validateFieldDirectives$1((__Field)x$71, typeErrorContext)).map((Function1 & Serializable)x$72 -> {
                        BoxedUnit boxedUnit = x$72;
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        return boxedUnit2;
                    });
                    return zIO;
                });
                return zIO;
            });
        });
    }

    public static final /* synthetic */ String $anonfun$prepare$4(String name$1) {
        return new StringBuilder(19).append("Unknown operation ").append(name$1).append(".").toString();
    }

    public static final /* synthetic */ Operation $anonfun$prepare$5(RootSchema rootSchema$1) {
        return rootSchema$1.query();
    }

    public static final /* synthetic */ Operation $anonfun$prepare$6(Operation m$1) {
        return m$1;
    }

    public static final /* synthetic */ Operation $anonfun$prepare$7(Operation m$2) {
        return m$2;
    }

    public static final /* synthetic */ ExecutionRequest $anonfun$prepare$8(Definition.ExecutableDefinition.OperationDefinition op$1, Map fragments$1, Map variables$1, Document document$1, Operation operation) {
        return new ExecutionRequest(Field$.MODULE$.apply(op$1.selectionSet(), (Map<String, Definition.ExecutableDefinition.FragmentDefinition>)fragments$1, (Map<String, InputValue>)variables$1, operation.opType(), document$1.sourceMapper(), (List<Directive>)Nil$.MODULE$), op$1.operationType(), op$1.variableDefinitions());
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ ZIO $anonfun$prepare$3(Option operationName$1, Document document$1, RootSchema rootSchema$1, Map variables$1, Map fragments) {
        block21: {
            block22: {
                block20: {
                    var12_5 = operationName$1;
                    if (!(var12_5 instanceof Some)) break block20;
                    var13_6 = (Some)var12_5;
                    name = (String)var13_6.value();
                    var9_8 = document$1.definitions().collectFirst((PartialFunction)new Serializable(name){
                        private static final long serialVersionUID = 0L;
                        private final String name$1;

                        public final <A1 extends Definition, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Definition.ExecutableDefinition.OperationDefinition operationDefinition;
                            A1 A1 = x1;
                            Object object = A1 instanceof Definition.ExecutableDefinition.OperationDefinition && (operationDefinition = (Definition.ExecutableDefinition.OperationDefinition)A1).name().contains((Object)this.name$1) ? operationDefinition : function1.apply(x1);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Definition x1) {
                            Definition.ExecutableDefinition.OperationDefinition operationDefinition;
                            Definition definition = x1;
                            boolean bl = definition instanceof Definition.ExecutableDefinition.OperationDefinition && (operationDefinition = (Definition.ExecutableDefinition.OperationDefinition)definition).name().contains((Object)this.name$1);
                            return bl;
                        }
                        {
                            this.name$1 = name$1;
                        }
                    }).toRight((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$prepare$4(java.lang.String ), ()Ljava/lang/String;)((String)name));
                    break block21;
                }
                if (!None$.MODULE$.equals(var12_5)) break block22;
                var15_9 = document$1.definitions().collect((PartialFunction)new Serializable(){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends Definition, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x2;
                        if (A1 instanceof Definition.ExecutableDefinition.OperationDefinition) {
                            Definition.ExecutableDefinition.OperationDefinition operationDefinition = (Definition.ExecutableDefinition.OperationDefinition)A1;
                            object = operationDefinition;
                        } else {
                            object = function1.apply(x2);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Definition x2) {
                        Definition definition = x2;
                        boolean bl = definition instanceof Definition.ExecutableDefinition.OperationDefinition;
                        return bl;
                    }
                });
                if (!(var15_9 instanceof .colon.colon)) ** GOTO lbl-1000
                var16_10 = (.colon.colon)var15_9;
                head = (Definition.ExecutableDefinition.OperationDefinition)var16_10.head();
                var18_12 = var16_10.next$access$1();
                if (Nil$.MODULE$.equals(var18_12)) {
                    var10_13 = package$.MODULE$.Right().apply((Object)head);
                } else lbl-1000:
                // 2 sources

                {
                    var10_13 = package$.MODULE$.Left().apply((Object)"Operation name is required.");
                }
                var9_8 = var10_13;
                break block21;
            }
            throw new MatchError((Object)var12_5);
        }
        var19_15 = operation = var9_8;
        if (var19_15 instanceof Left) {
            var20_16 = (Left)var19_15;
            error = (String)var20_16.value();
            var5_18 = Validator$.MODULE$.failValidation(error, "");
        } else if (var19_15 instanceof Right) {
            var22_19 = (Right)var19_15;
            op = (Definition.ExecutableDefinition.OperationDefinition)var22_19.value();
            var24_21 = op.operationType();
            if (OperationType$Query$.MODULE$.equals(var24_21)) {
                var6_22 = IO$.MODULE$.succeed((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$prepare$5(caliban.schema.RootSchema ), ()Lcaliban/schema/Operation;)((RootSchema)rootSchema$1));
            } else if (OperationType$Mutation$.MODULE$.equals(var24_21)) {
                var25_23 = rootSchema$1.mutation();
                if (var25_23 instanceof Some) {
                    var26_24 = (Some)var25_23;
                    m = (Operation)var26_24.value();
                    var8_26 = IO$.MODULE$.succeed((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$prepare$6(caliban.schema.Operation ), ()Lcaliban/schema/Operation;)((Operation)m));
                } else if (None$.MODULE$.equals(var25_23)) {
                    var8_26 = Validator$.MODULE$.failValidation("Mutations are not supported on this schema", "");
                } else {
                    throw new MatchError(var25_23);
                }
                var6_22 = var8_26;
            } else if (OperationType$Subscription$.MODULE$.equals(var24_21)) {
                var28_27 = rootSchema$1.subscription();
                if (var28_27 instanceof Some) {
                    var29_28 = (Some)var28_27;
                    m = (Operation)var29_28.value();
                    var7_30 = IO$.MODULE$.succeed((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$prepare$7(caliban.schema.Operation ), ()Lcaliban/schema/Operation;)((Operation)m));
                } else if (None$.MODULE$.equals(var28_27)) {
                    var7_30 = Validator$.MODULE$.failValidation("Subscriptions are not supported on this schema", "");
                } else {
                    throw new MatchError(var28_27);
                }
                var6_22 = var7_30;
            } else {
                throw new MatchError((Object)var24_21);
            }
            var5_18 = var6_22.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$prepare$8(caliban.parsing.adt.Definition$ExecutableDefinition$OperationDefinition scala.collection.immutable.Map scala.collection.immutable.Map caliban.parsing.adt.Document caliban.schema.Operation ), (Lcaliban/schema/Operation;)Lcaliban/execution/ExecutionRequest;)((Definition.ExecutableDefinition.OperationDefinition)op, (Map)fragments, (Map)variables$1, (Document)document$1));
        } else {
            throw new MatchError((Object)var19_15);
        }
        return var5_18;
    }

    private static final List collectValues$1(List selectionSet, Validator.Context context$2) {
        Builder inputValues = List$.MODULE$.newBuilder();
        selectionSet.foreach((Function1 & Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Selection selection = x0$1;
            if (selection instanceof Selection.FragmentSpread) {
                Selection.FragmentSpread fragmentSpread = (Selection.FragmentSpread)selection;
                String name = fragmentSpread.name();
                List<Directive> directives = fragmentSpread.directives();
                directives.foreach((Function1 & Serializable)x$12 -> (Builder)inputValues.$plus$plus$eq((IterableOnce)x$12.arguments().values()));
                context$2.fragments().get((Object)name).foreach((Function1 & Serializable)f -> {
                    f.directives().foreach((Function1 & Serializable)x$13 -> (Builder)inputValues.$plus$plus$eq((IterableOnce)x$13.arguments().values()));
                    return (Builder)inputValues.$plus$plus$eq((IterableOnce)Validator$.collectValues$1(f.selectionSet(), context$2));
                });
                boxedUnit = BoxedUnit.UNIT;
            } else if (selection instanceof Selection.Field) {
                Selection.Field field = (Selection.Field)selection;
                Map<String, InputValue> arguments = field.arguments();
                List<Directive> directives = field.directives();
                List<Selection> selectionSet = field.selectionSet();
                inputValues.$plus$plus$eq((IterableOnce)arguments.values());
                directives.foreach((Function1 & Serializable)x$14 -> (Builder)inputValues.$plus$plus$eq((IterableOnce)x$14.arguments().values()));
                boxedUnit = inputValues.$plus$plus$eq((IterableOnce)Validator$.collectValues$1(selectionSet, context$2));
            } else if (selection instanceof Selection.InlineFragment) {
                Selection.InlineFragment inlineFragment = (Selection.InlineFragment)selection;
                List<Directive> directives = inlineFragment.dirs();
                List<Selection> selectionSet = inlineFragment.selectionSet();
                directives.foreach((Function1 & Serializable)x$15 -> (Builder)inputValues.$plus$plus$eq((IterableOnce)x$15.arguments().values()));
                boxedUnit = inputValues.$plus$plus$eq((IterableOnce)Validator$.collectValues$1(selectionSet, context$2));
            } else {
                throw new MatchError((Object)selection);
            }
            return boxedUnit;
        });
        return (List)inputValues.result();
    }

    private static final List collectVariableValues$1(List values) {
        return values.flatMap((Function1 & Serializable)x0$1 -> {
            List list2;
            InputValue inputValue = x0$1;
            if (inputValue instanceof InputValue.ListValue) {
                InputValue.ListValue listValue = (InputValue.ListValue)inputValue;
                List<InputValue> values = listValue.values();
                list2 = Validator$.collectVariableValues$1(values);
            } else if (inputValue instanceof InputValue.ObjectValue) {
                InputValue.ObjectValue objectValue = (InputValue.ObjectValue)inputValue;
                Map<String, InputValue> fields = objectValue.fields();
                list2 = Validator$.collectVariableValues$1(fields.values().toList());
            } else if (inputValue instanceof InputValue.VariableValue) {
                InputValue.VariableValue variableValue = (InputValue.VariableValue)inputValue;
                list2 = (IterableOnce)new .colon.colon((Object)variableValue, (List)Nil$.MODULE$);
            } else if (inputValue instanceof Value) {
                list2 = Nil$.MODULE$;
            } else {
                throw new MatchError((Object)inputValue);
            }
            return list2;
        });
    }

    public static final /* synthetic */ void $anonfun$collectSelectionSets$1(Builder sets$1, Selection x0$1) {
        Selection selection = x0$1;
        if (selection instanceof Selection.Field) {
            Selection.Field field = (Selection.Field)selection;
            Validator$.loop$1(field.selectionSet(), sets$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (selection instanceof Selection.InlineFragment) {
            Selection.InlineFragment inlineFragment = (Selection.InlineFragment)selection;
            Validator$.loop$1(inlineFragment.selectionSet(), sets$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (selection instanceof Selection.FragmentSpread) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)selection);
        }
    }

    private static final void loop$1(List selectionSet, Builder sets$1) {
        sets$1.$plus$plus$eq((IterableOnce)selectionSet);
        selectionSet.foreach((Function1 & Serializable)x0$1 -> {
            Validator$.$anonfun$collectSelectionSets$1(sets$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkDirectivesUniqueness$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List v = (List)tuple2._2();
        boolean bl = v.length() > 1;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$validateDirectives$3(Directive d$1, __Directive x$28) {
        String string2 = x$28.name();
        String string3 = d$1.name();
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateVariables$13(String v$2, VariableDefinition x$32) {
        String string2 = x$32.name();
        String string3 = v$2;
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$detectCycles$1(scala.collection.immutable.Set visited$1, Validator.Context context$6, Selection.FragmentSpread s) {
        return visited$1.contains((Object)s.name()) || BoxesRunTime.unboxToBoolean((Object)context$6.fragments().get((Object)s.name()).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)Validator$.MODULE$.detectCycles(context$6, f, (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)visited$1.$plus((Object)s.name()))))));
    }

    private static final /* synthetic */ String typeConditionName$lzycompute$1(LazyRef typeConditionName$lzy$1, Option typeCondition$1) {
        String string2;
        LazyRef lazyRef = typeConditionName$lzy$1;
        synchronized (lazyRef) {
            string2 = typeConditionName$lzy$1.initialized() ? (String)typeConditionName$lzy$1.value() : (String)typeConditionName$lzy$1.initialize(typeCondition$1.fold((Function0 & Serializable)() -> "?", (Function1 & Serializable)x$38 -> x$38.name()));
        }
        return string2;
    }

    private static final String typeConditionName$1(LazyRef typeConditionName$lzy$1, Option typeCondition$1) {
        return typeConditionName$lzy$1.initialized() ? (String)typeConditionName$lzy$1.value() : Validator$.typeConditionName$lzycompute$1(typeConditionName$lzy$1, typeCondition$1);
    }

    public static final /* synthetic */ boolean $anonfun$validateField$5(Selection.Field field$1, __Field x$39) {
        String string2 = x$39.name();
        String string3 = field$1.name();
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateArguments$2(String arg$1, __InputValue x$40) {
        String string2 = x$40.name();
        String string3 = arg$1;
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateArguments$5(__InputValue a) {
        __TypeKind __TypeKind2 = ((__Type)a.type().apply()).kind();
        __TypeKind$NON_NULL$ __TypeKind$NON_NULL$2 = __TypeKind$NON_NULL$.MODULE$;
        return !(__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$NON_NULL$2) : __TypeKind$NON_NULL$2 != null) && a.defaultValue().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateArguments$8(InputValue x$41) {
        InputValue inputValue = x$41;
        Value$NullValue$ value$NullValue$ = Value$NullValue$.MODULE$;
        return !(inputValue != null ? !inputValue.equals(value$NullValue$) : value$NullValue$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateInputValues$4(String k$1, __InputValue x$42) {
        String string2 = x$42.name();
        String string3 = k$1;
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateLoneAnonymousOperation$1(Definition.ExecutableDefinition.OperationDefinition x$44) {
        return x$44.name().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateSubscriptionOperation$3(Definition.ExecutableDefinition.OperationDefinition x$45) {
        OperationType operationType = x$45.operationType();
        OperationType$Subscription$ operationType$Subscription$ = OperationType$Subscription$.MODULE$;
        return !(operationType != null ? !operationType.equals(operationType$Subscription$) : operationType$Subscription$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateSubscriptionOperation$4(Validator.Context context$11, __Type t$3, Definition.ExecutableDefinition.OperationDefinition op) {
        return Field$.MODULE$.apply(op.selectionSet(), context$11.fragments(), (Map<String, InputValue>)Predef$.MODULE$.Map().empty(), t$3, SourceMapper$.MODULE$.empty(), (List<Directive>)Nil$.MODULE$).fields().length() > 1;
    }

    private static final boolean isObject$1(__Type t) {
        __TypeKind __TypeKind2 = t.kind();
        boolean bl = __TypeKind$OBJECT$.MODULE$.equals(__TypeKind2);
        return bl;
    }

    private final ZIO noDuplicateInputValueName$1(List inputValues, String errorContext) {
        Function1 & Serializable messageBuilder = (Function1 & Serializable)i -> new StringBuilder(22).append(errorContext).append(" has repeated fields: ").append(i.name()).toString();
        String explanatory = "The input field must have a unique name within that Input Object type; no two input fields may share the same name";
        return this.noDuplicateName(inputValues, (Function1 & Serializable)x$48 -> x$48.name(), messageBuilder, explanatory);
    }

    private final ZIO validateFields$1(List fields, String inputObjectContext$1) {
        return this.noDuplicateInputValueName$1(fields, inputObjectContext$1).$less$times((Function0 & Serializable)() -> IO$.MODULE$.foreach_((Iterable)fields, (Function1 & Serializable)x$49 -> MODULE$.validateInputValue((__InputValue)x$49, inputObjectContext$1)));
    }

    private static final List fields$3(__Type t) {
        return (List)((Option)t.fields().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))))).toList().flatten(Predef$.MODULE$.$conforms());
    }

    private static final scala.collection.immutable.Set fieldNames$1(__Type t) {
        return Validator$.fields$3(t).map((Function1 & Serializable)x$52 -> x$52.name()).toSet();
    }

    private static final ZIO checkForMissingFields$1(__Type obj$1, List supertype$1, String objectContext$1) {
        scala.collection.immutable.Set objectFieldNames = Validator$.fieldNames$1(obj$1);
        scala.collection.immutable.Set interfaceFieldNames = (scala.collection.immutable.Set)supertype$1.map((Function1 & Serializable)t -> Validator$.fieldNames$1(t)).toSet().flatten(Predef$.MODULE$.$conforms());
        SetOps setOps = objectFieldNames.union((Set)interfaceFieldNames);
        scala.collection.immutable.Set set = objectFieldNames;
        boolean isMissingFields = setOps == null ? set != null : !setOps.equals(set);
        return IO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable)() -> interfaceFieldNames.nonEmpty() && isMissingFields, (Function0 & Serializable)() -> {
            List missingFields = (List)interfaceFieldNames.diff((Set)objectFieldNames).toList().sorted((Ordering)Ordering.String$.MODULE$);
            return MODULE$.failValidation(new StringBuilder(22).append(objectContext$1).append(" is missing field(s): ").append(missingFields.mkString(", ")).toString(), "An Object type must include a field of the same name for every field defined in an interface");
        });
    }

    public static final boolean caliban$validation$Validator$$isValidSubtype$1(__Type supertypeFieldType, __Type objectFieldType) {
        List supertypePossibleTypes = (List)supertypeFieldType.possibleTypes().toList().flatten(Predef$.MODULE$.$conforms());
        return Types$.MODULE$.same(supertypeFieldType, objectFieldType) || supertypePossibleTypes.exists((Function1 & Serializable)x$53 -> BoxesRunTime.boxToBoolean((boolean)Types$.MODULE$.same(x$53, objectFieldType)));
    }

    public static final /* synthetic */ boolean $anonfun$validateObject$10(__Field objField$1, __Field x$54) {
        String string2 = x$54.name();
        String string3 = objField$1.name();
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    private static final ZIO checkForInvalidSubtypeFields$1(__Type obj$1, List supertype$1, String objectContext$1) {
        List objectFields = Validator$.fields$3(obj$1);
        List supertypeFields = supertype$1.flatMap((Function1 & Serializable)t -> Validator$.fields$3(t));
        return IO$.MODULE$.foreach_((Iterable)objectFields, (Function1 & Serializable)objField -> {
            String fieldContext = new StringBuilder(8).append("Field '").append(objField.name()).append("'").toString();
            return IO$.MODULE$.whenCase((Function0 & Serializable)() -> supertypeFields.find((Function1 & Serializable)x$54 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateObject$10(objField, x$54))), (PartialFunction)new Serializable((__Field)objField, fieldContext, objectContext$1){
                private static final long serialVersionUID = 0L;
                private final __Field objField$1;
                public final String fieldContext$2;
                public final String objectContext$1;

                public final <A1 extends Option<__Field>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof Some) {
                        Some some = (Some)A1;
                        __Field superField = (__Field)some.value();
                        List extraArgs = this.objField$1.args().filterNot((Function1)superField.args().toSet());
                        object = IO$.MODULE$.whenCase((Function0 & Serializable)() -> new Tuple2.mcZZ.sp(this.fieldTypeIsValid$1(superField), Validator$.MODULE$.caliban$validation$Validator$$isListField(superField)), (PartialFunction)new Serializable(this, extraArgs, superField){
                            private static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$$nestedInanonfun$validateObject$8$1 $outer;
                            private final List extraArgs$1;
                            private final __Field superField$1;

                            /*
                             * Enabled aggressive block sorting
                             */
                            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                ZIO<Object, CalibanError.ValidationError, T> zIO;
                                boolean bl;
                                A1 A1 = x1;
                                if (A1 != null && (bl = A1._2$mcZ$sp()) && !this.$outer.caliban$validation$Validator$$nestedInanonfun$$nestedInanonfun$validateObject$8$1$$listItemTypeIsValid$1(this.superField$1)) {
                                    zIO = Validator$.MODULE$.failValidation(new StringBuilder(36).append(this.$outer.fieldContext$2).append(" in ").append(this.$outer.objectContext$1).append(" is an invalid list item subtype").toString(), "An object list item field type must be equal to or a possible type of the interface list item field type.");
                                    return (B1)zIO;
                                }
                                if (A1 != null) {
                                    boolean bl2 = A1._1$mcZ$sp();
                                    boolean bl3 = A1._2$mcZ$sp();
                                    if (!bl2 && !bl3) {
                                        zIO = Validator$.MODULE$.failValidation(new StringBuilder(26).append(this.$outer.fieldContext$2).append(" in ").append(this.$outer.objectContext$1).append(" is an invalid subtype").toString(), "An object field type must be equal to or a possible type of the interface field type.");
                                        return (B1)zIO;
                                    }
                                }
                                if (!anonfun$$nestedInanonfun$validateObject$8$1.caliban$validation$Validator$$nestedInanonfun$$nestedInanonfun$validateObject$8$1$$extraArgsAreValid$1(this.extraArgs$1)) {
                                    String argNames = this.extraArgs$1.filter((Function1 & Serializable)x$56 -> BoxesRunTime.boxToBoolean((boolean)anonfun$$nestedInanonfun$validateObject$8$1$$anonfun$applyOrElse$8.$anonfun$applyOrElse$9(x$56))).map((Function1 & Serializable)x$57 -> x$57.name()).mkString(", ");
                                    zIO = Validator$.MODULE$.failValidation(new StringBuilder(49).append(this.$outer.fieldContext$2).append(" with extra non-nullable arg(s) '").append(argNames).append("' in ").append(this.$outer.objectContext$1).append(" is invalid").toString(), "Any additional field arguments must not be of a non-nullable type.");
                                    return (B1)zIO;
                                }
                                zIO = function1.apply(x1);
                                return (B1)zIO;
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                                boolean bl;
                                Tuple2<Object, Object> tuple2 = x1;
                                if (tuple2 != null && (bl = tuple2._2$mcZ$sp()) && !this.$outer.caliban$validation$Validator$$nestedInanonfun$$nestedInanonfun$validateObject$8$1$$listItemTypeIsValid$1(this.superField$1)) {
                                    return true;
                                }
                                if (tuple2 != null) {
                                    boolean bl2 = tuple2._1$mcZ$sp();
                                    boolean bl3 = tuple2._2$mcZ$sp();
                                    if (!bl2 && !bl3) {
                                        return true;
                                    }
                                }
                                if (anonfun$$nestedInanonfun$validateObject$8$1.caliban$validation$Validator$$nestedInanonfun$$nestedInanonfun$validateObject$8$1$$extraArgsAreValid$1(this.extraArgs$1)) return false;
                                return true;
                            }

                            public static final /* synthetic */ boolean $anonfun$applyOrElse$9(__InputValue x$56) {
                                __TypeKind __TypeKind2 = ((__Type)x$56.type().apply()).kind();
                                __TypeKind$NON_NULL$ __TypeKind$NON_NULL$2 = __TypeKind$NON_NULL$.MODULE$;
                                return !(__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$NON_NULL$2) : __TypeKind$NON_NULL$2 != null);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.extraArgs$1 = extraArgs$1;
                                this.superField$1 = superField$1;
                            }

                            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10(caliban.introspection.adt.__InputValue ), $anonfun$applyOrElse$9$adapted(caliban.introspection.adt.__InputValue )}, serializedLambda);
                            }
                        });
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Option<__Field> x1) {
                    Option<__Field> option2 = x1;
                    boolean bl = option2 instanceof Some;
                    return bl;
                }

                private final boolean fieldTypeIsValid$1(__Field superField$1) {
                    return Validator$.caliban$validation$Validator$$isValidSubtype$1((__Type)superField$1.type().apply(), (__Type)this.objField$1.type().apply());
                }

                public static final /* synthetic */ boolean $anonfun$applyOrElse$4(__Type superListItemType$1, __Type objListItemType) {
                    return Validator$.caliban$validation$Validator$$isValidSubtype$1(superListItemType$1, objListItemType);
                }

                public final boolean caliban$validation$Validator$$nestedInanonfun$$nestedInanonfun$validateObject$8$1$$listItemTypeIsValid$1(__Field superField$1) {
                    return Validator$.MODULE$.caliban$validation$Validator$$isListField(superField$1) && Validator$.MODULE$.caliban$validation$Validator$$isListField(this.objField$1) && BoxesRunTime.unboxToBoolean((Object)((__Type)superField$1.type().apply()).ofType().flatMap((Function1 & Serializable)superListItemType -> ((__Type)$this.objField$1.type().apply()).ofType().map((Function1 & Serializable)objListItemType -> BoxesRunTime.boxToBoolean((boolean)anonfun$$nestedInanonfun$validateObject$8$1.$anonfun$applyOrElse$4(superListItemType, objListItemType)))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
                }

                public static final /* synthetic */ boolean $anonfun$applyOrElse$6(__InputValue x$55) {
                    __TypeKind __TypeKind2 = ((__Type)x$55.type().apply()).kind();
                    __TypeKind$NON_NULL$ __TypeKind$NON_NULL$2 = __TypeKind$NON_NULL$.MODULE$;
                    return !(__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$NON_NULL$2) : __TypeKind$NON_NULL$2 != null);
                }

                public static final boolean caliban$validation$Validator$$nestedInanonfun$$nestedInanonfun$validateObject$8$1$$extraArgsAreValid$1(List extraArgs$1) {
                    return !extraArgs$1.exists((Function1 & Serializable)x$55 -> BoxesRunTime.boxToBoolean((boolean)anonfun$$nestedInanonfun$validateObject$8$1.$anonfun$applyOrElse$6(x$55)));
                }
                {
                    this.objField$1 = objField$1;
                    this.fieldContext$2 = fieldContext$2;
                    this.objectContext$1 = objectContext$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(caliban.validation.Validator$$anonfun$$nestedInanonfun$validateObject$8$1 caliban.introspection.adt.__Type ), $anonfun$applyOrElse$4$adapted(caliban.introspection.adt.__Type caliban.introspection.adt.__Type ), $anonfun$applyOrElse$5(), $anonfun$applyOrElse$6$adapted(caliban.introspection.adt.__InputValue ), $anonfun$applyOrElse$7(caliban.validation.Validator$$anonfun$$nestedInanonfun$validateObject$8$1 caliban.introspection.adt.__Field )}, serializedLambda);
                }
            });
        });
    }

    private static final ZIO validateInterfaceFields$1(__Type obj, String objectContext$1) {
        List supertype = (List)((Option)obj.interfaces().apply()).toList().flatten(Predef$.MODULE$.$conforms());
        return Validator$.checkForMissingFields$1(obj, supertype, objectContext$1).flatMap((Function1 & Serializable)x$59 -> {
            BoxedUnit boxedUnit = x$59;
            ZIO zIO = Validator$.checkForInvalidSubtypeFields$1(obj, supertype, objectContext$1);
            return zIO;
        });
    }

    private static final Either isInputType$1(__Type t2) {
        boolean bl;
        __TypeKind __TypeKind2 = t2.kind();
        boolean bl2 = __TypeKind$LIST$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$NON_NULL$.MODULE$.equals(__TypeKind2);
        Object object = bl2 ? (Either)t2.ofType().fold((Function0 & Serializable)() -> package$.MODULE$.Left().apply((Object)t2), (Function1 & Serializable)t -> Validator$.isInputType$1(t)) : ((bl = __TypeKind$SCALAR$.MODULE$.equals(__TypeKind2) ? true : (__TypeKind$ENUM$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$INPUT_OBJECT$.MODULE$.equals(__TypeKind2))) ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)t2));
        return object;
    }

    private static final Either isOutputType$1(__Type t2) {
        boolean bl;
        __TypeKind __TypeKind2 = t2.kind();
        boolean bl2 = __TypeKind$LIST$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$NON_NULL$.MODULE$.equals(__TypeKind2);
        Object object = bl2 ? (Either)t2.ofType().fold((Function0 & Serializable)() -> package$.MODULE$.Left().apply((Object)t2), (Function1 & Serializable)t -> Validator$.isOutputType$1(t)) : ((bl = __TypeKind$SCALAR$.MODULE$.equals(__TypeKind2) ? true : (__TypeKind$OBJECT$.MODULE$.equals(__TypeKind2) ? true : (__TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2) ? true : (__TypeKind$UNION$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$ENUM$.MODULE$.equals(__TypeKind2))))) ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)t2));
        return object;
    }

    private static final ZIO validateArguments$1(Map args, String errorContext) {
        String explanatoryText = "The directive argument must not have a name which begins with the characters \"__\" (two underscores)";
        Function1 & Serializable argumentErrorContextBuilder = (Function1 & Serializable)name -> new StringBuilder(15).append("Argument '").append((String)name).append("' of ").append(errorContext).toString();
        return IO$.MODULE$.foreach_(args.keys(), (Function1 & Serializable)argName -> MODULE$.doesNotStartWithUnderscore(argName, (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x), (String)argumentErrorContextBuilder.apply(argName), explanatoryText));
    }

    private final ZIO validateDirective$1(Directive directive, String errorContext) {
        String directiveErrorContext = new StringBuilder(16).append("Directive '").append(directive.name()).append("' of ").append(errorContext).toString();
        return this.doesNotStartWithUnderscore(directive, directiveErrorContext).$times$greater((Function0 & Serializable)() -> Validator$.validateArguments$1(directive.arguments(), directiveErrorContext));
    }

    private final ZIO validateDirectives$1(Option directives, String errorContext) {
        return IO$.MODULE$.foreach_((Iterable)directives.getOrElse((Function0 & Serializable)() -> List$.MODULE$.empty()), (Function1 & Serializable)x$70 -> this.validateDirective$1((Directive)x$70, errorContext));
    }

    private final ZIO validateInputValueDirectives$1(List inputValues, String errorContext) {
        Function1 & Serializable inputValueErrorContextBuilder = (Function1 & Serializable)name -> new StringBuilder(17).append("InputValue '").append((String)name).append("' of ").append(errorContext).toString();
        return IO$.MODULE$.foreach_((Iterable)inputValues, (Function1 & Serializable)iv -> this.validateDirectives$1(iv.directives(), (String)inputValueErrorContextBuilder.apply((Object)iv.name())));
    }

    private final ZIO validateFieldDirectives$1(__Field field, String errorContext) {
        String fieldErrorContext = new StringBuilder(12).append("Field '").append(field.name()).append("' of ").append(errorContext).toString();
        return this.validateDirectives$1(field.directives(), fieldErrorContext).$times$greater((Function0 & Serializable)() -> this.validateInputValueDirectives$1(field.args(), fieldErrorContext));
    }

    private Validator$() {
    }
}

