/*
 * Decompiled with CFR 0.152.
 */
package caliban.validation;

import caliban.CalibanError;
import caliban.CalibanError$ValidationError$;
import caliban.InputValue;
import caliban.Rendering$;
import caliban.Value;
import caliban.Value$NullValue$;
import caliban.execution.ExecutionRequest;
import caliban.execution.Field;
import caliban.execution.Field$;
import caliban.introspection.Introspector$;
import caliban.introspection.adt.__DeprecatedArgs;
import caliban.introspection.adt.__Directive;
import caliban.introspection.adt.__DirectiveLocation;
import caliban.introspection.adt.__DirectiveLocation$FIELD$;
import caliban.introspection.adt.__DirectiveLocation$FRAGMENT_DEFINITION$;
import caliban.introspection.adt.__DirectiveLocation$FRAGMENT_SPREAD$;
import caliban.introspection.adt.__DirectiveLocation$INLINE_FRAGMENT$;
import caliban.introspection.adt.__DirectiveLocation$MUTATION$;
import caliban.introspection.adt.__DirectiveLocation$QUERY$;
import caliban.introspection.adt.__DirectiveLocation$SUBSCRIPTION$;
import caliban.introspection.adt.__Field;
import caliban.introspection.adt.__InputValue;
import caliban.introspection.adt.__Type;
import caliban.introspection.adt.__TypeKind;
import caliban.introspection.adt.__TypeKind$;
import caliban.introspection.adt.__TypeKind$ENUM$;
import caliban.introspection.adt.__TypeKind$INPUT_OBJECT$;
import caliban.introspection.adt.__TypeKind$INTERFACE$;
import caliban.introspection.adt.__TypeKind$LIST$;
import caliban.introspection.adt.__TypeKind$NON_NULL$;
import caliban.introspection.adt.__TypeKind$OBJECT$;
import caliban.introspection.adt.__TypeKind$SCALAR$;
import caliban.introspection.adt.__TypeKind$UNION$;
import caliban.parsing.SourceMapper$;
import caliban.parsing.adt.Definition;
import caliban.parsing.adt.Directive;
import caliban.parsing.adt.Document;
import caliban.parsing.adt.OperationType;
import caliban.parsing.adt.OperationType$Mutation$;
import caliban.parsing.adt.OperationType$Query$;
import caliban.parsing.adt.OperationType$Subscription$;
import caliban.parsing.adt.Selection;
import caliban.parsing.adt.Type;
import caliban.parsing.adt.Type$;
import caliban.parsing.adt.VariableDefinition;
import caliban.schema.Operation;
import caliban.schema.RootSchema;
import caliban.schema.RootSchemaBuilder;
import caliban.schema.RootType;
import caliban.schema.Types$;
import caliban.validation.FragmentValidator$;
import caliban.validation.Utils$;
import caliban.validation.ValueValidator$;
import caliban.validation.package;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.CanFail$;
import zio.FiberRef;
import zio.Unsafe$;
import zio.ZIO;
import zio.package;
import zio.prelude.Covariant;
import zio.prelude.Invariant$;
import zio.prelude.fx.ZPure;
import zio.prelude.fx.ZPure$;
import zio.prelude.package$;

public final class Validator$ {
    public static final Validator$ MODULE$ = new Validator$();
    private static List<ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit>> DefaultValidations;
    private static ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit> validateDirectives;
    private static ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit> validateVariables;
    private static ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit> validateFragmentSpreads;
    private static ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit> validateDocumentFields;
    private static ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit> validateOperationNameUniqueness;
    private static ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit> validateLoneAnonymousOperation;
    private static ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit> validateSubscriptionOperation;
    private static final FiberRef<List<ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit>>> validationFiberRef;
    private static final FiberRef<Object> skipQueryValidationRef;
    private static volatile byte bitmap$0;

    static {
        validationFiberRef = (FiberRef)Unsafe$.MODULE$.unsafe((Function1 & Serializable)u -> FiberRef.unsafe$.MODULE$.make(MODULE$.DefaultValidations(), FiberRef.unsafe$.MODULE$.make$default$2(), FiberRef.unsafe$.MODULE$.make$default$3(), u));
        skipQueryValidationRef = (FiberRef)Unsafe$.MODULE$.unsafe((Function1 & Serializable)u -> FiberRef.unsafe$.MODULE$.make((Object)BoxesRunTime.boxToBoolean((boolean)false), FiberRef.unsafe$.MODULE$.make$default$2(), FiberRef.unsafe$.MODULE$.make$default$3(), u));
    }

    private List<ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit>> DefaultValidations$lzycompute() {
        Validator$ validator$ = this;
        synchronized (validator$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                DefaultValidations = new .colon.colon(this.validateFragmentSpreads(), (List)new .colon.colon(this.validateOperationNameUniqueness(), (List)new .colon.colon(this.validateLoneAnonymousOperation(), (List)new .colon.colon(this.validateDirectives(), (List)new .colon.colon(this.validateVariables(), (List)new .colon.colon(this.validateSubscriptionOperation(), (List)new .colon.colon(this.validateDocumentFields(), (List)Nil$.MODULE$)))))));
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return DefaultValidations;
    }

    public List<ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit>> DefaultValidations() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.DefaultValidations$lzycompute();
        }
        return DefaultValidations;
    }

    public FiberRef<List<ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit>>> validationFiberRef() {
        return validationFiberRef;
    }

    public FiberRef<Object> skipQueryValidationRef() {
        return skipQueryValidationRef;
    }

    public ZIO<Object, CalibanError.ValidationError, BoxedUnit> validate(Document document, RootType rootType) {
        return this.check(document, rootType, (Map<String, InputValue>)Predef$.MODULE$.Map().empty()).unit().toZIO((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public <R> ZIO<Object, CalibanError.ValidationError, RootSchema<R>> validateSchema(RootSchemaBuilder<R> schema2) {
        List<__Type> types = schema2.types();
        return ZPure$.MODULE$.foreachDiscard((Iterable)types.sorted(__TypeKind$.MODULE$.typeOrdering()), (Function1 & Serializable)t -> MODULE$.validateType((__Type)t)).$times$greater(this.validateClashingTypes(types)).$times$greater(this.validateDirectives(types)).$times$greater(this.validateRootQuery(schema2)).toZIO((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public ZIO<Object, Nothing$, BoxedUnit> setSkipValidation(boolean skip) {
        return this.skipQueryValidationRef().set((Object)BoxesRunTime.boxToBoolean((boolean)skip), (Object)"caliban.validation.Validator.setSkipValidation(Validator.scala:64)").unit((Object)"caliban.validation.Validator.setSkipValidation(Validator.scala:64)");
    }

    public ZIO<Object, Nothing$, Object> skipValidation() {
        return this.skipQueryValidationRef().get((Object)"caliban.validation.Validator.skipValidation(Validator.scala:67)");
    }

    public ZIO<Object, Nothing$, BoxedUnit> setValidations(List<ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit>> validations) {
        return this.validationFiberRef().set(validations, (Object)"caliban.validation.Validator.setValidations(Validator.scala:70)").unit((Object)"caliban.validation.Validator.setValidations(Validator.scala:70)");
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateType(__Type t) {
        __TypeKind __TypeKind2 = t.kind();
        if (__TypeKind$ENUM$.MODULE$.equals(__TypeKind2)) {
            return this.validateEnum(t);
        }
        if (__TypeKind$UNION$.MODULE$.equals(__TypeKind2)) {
            return this.validateUnion(t);
        }
        if (__TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2)) {
            return this.validateInterface(t);
        }
        if (__TypeKind$INPUT_OBJECT$.MODULE$.equals(__TypeKind2)) {
            return this.validateInputObject(t);
        }
        if (__TypeKind$OBJECT$.MODULE$.equals(__TypeKind2)) {
            return this.validateObject(t);
        }
        return ZPure$.MODULE$.unit();
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, Nothing$> failValidation(String msg, String explanatoryText) {
        return ZPure$.MODULE$.fail((Object)new CalibanError.ValidationError(msg, explanatoryText, CalibanError$ValidationError$.MODULE$.apply$default$3(), CalibanError$ValidationError$.MODULE$.apply$default$4()));
    }

    public <R> ZIO<Object, CalibanError.ValidationError, ExecutionRequest> prepare(Document document, RootType rootType, RootSchema<R> rootSchema, Option<String> operationName, Map<String, InputValue> variables, boolean skipValidation) {
        ZPure fragments = skipValidation ? ZPure$.MODULE$.succeed(((LinearSeqOps)this.collectDefinitions(document)._2()).foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Map m = (Map)tuple2._1();
                Definition.ExecutableDefinition.FragmentDefinition f = (Definition.ExecutableDefinition.FragmentDefinition)tuple2._2();
                return (Map)m.updated((Object)f.name(), (Object)f);
            }
            throw new MatchError((Object)tuple2);
        })) : this.check(document, rootType, variables);
        return fragments.flatMap(arg_0 -> Validator$.$anonfun$prepare$2(operationName, document, rootSchema, variables, rootType, arg_0)).toZIO((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, Map<String, Definition.ExecutableDefinition.FragmentDefinition>> check(Document document, RootType rootType, Map<String, InputValue> variables) {
        Tuple4<List<Definition.ExecutableDefinition.OperationDefinition>, List<Definition.ExecutableDefinition.FragmentDefinition>, List<Definition.TypeSystemDefinition>, List<Definition.TypeSystemExtension>> tuple4 = this.collectDefinitions(document);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        List operations = (List)tuple4._1();
        List fragments = (List)tuple4._2();
        Tuple2 tuple2 = new Tuple2((Object)operations, (Object)fragments);
        List operations2 = (List)tuple2._1();
        List fragments2 = (List)tuple2._2();
        return this.validateFragments((List<Definition.ExecutableDefinition.FragmentDefinition>)fragments2).flatMap((Function1 & Serializable)fragmentMap -> {
            List<Selection> selectionSets = MODULE$.collectSelectionSets((List<Selection>)((List)operations2.flatMap((Function1 & Serializable)x$2 -> x$2.selectionSet()).$plus$plus((IterableOnce)fragments2.flatMap((Function1 & Serializable)x$3 -> x$3.selectionSet()))));
            package.Context context = new package.Context(document, rootType, (List<Definition.ExecutableDefinition.OperationDefinition>)operations2, (Map<String, Definition.ExecutableDefinition.FragmentDefinition>)fragmentMap, selectionSets, variables);
            return ZPure$.MODULE$.foreachDiscard(MODULE$.DefaultValidations(), (Function1 & Serializable)x -> (ZPure)Predef$.MODULE$.identity(x)).provideService((Function0 & Serializable)() -> context, package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(package.Context.class, LightTypeTag$.MODULE$.parse(-1704375265, "\u0004\u0000\u0001\u001acaliban.validation.Context\u0001\u0002\u0003\u0000\u0000\u001acaliban.validation.package\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\u001acaliban.validation.Context\u0001\u0002\u0003\u0000\u0000\u001acaliban.validation.package\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 21)))).as((Function0 & Serializable)() -> fragmentMap);
        });
    }

    private Tuple4<List<Definition.ExecutableDefinition.OperationDefinition>, List<Definition.ExecutableDefinition.FragmentDefinition>, List<Definition.TypeSystemDefinition>, List<Definition.TypeSystemExtension>> collectDefinitions(Document document) {
        return (Tuple4)document.definitions().foldLeft((Object)new Tuple4((Object)scala.package$.MODULE$.List().empty(), (Object)scala.package$.MODULE$.List().empty(), (Object)scala.package$.MODULE$.List().empty(), (Object)scala.package$.MODULE$.List().empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple4 tuple4 = (Tuple4)tuple2._1();
                Definition o = (Definition)tuple2._2();
                if (tuple4 != null) {
                    List operations = (List)tuple4._1();
                    List fragments = (List)tuple4._2();
                    List types = (List)tuple4._3();
                    List extensions = (List)tuple4._4();
                    if (o instanceof Definition.ExecutableDefinition.OperationDefinition) {
                        Definition.ExecutableDefinition.OperationDefinition operationDefinition;
                        Definition.ExecutableDefinition.OperationDefinition operationDefinition2 = operationDefinition = (Definition.ExecutableDefinition.OperationDefinition)o;
                        return new Tuple4((Object)operations.$colon$colon((Object)operationDefinition2), (Object)fragments, (Object)types, (Object)extensions);
                    }
                }
            }
            if (tuple2 != null) {
                Tuple4 tuple4 = (Tuple4)tuple2._1();
                Definition f = (Definition)tuple2._2();
                if (tuple4 != null) {
                    List operations = (List)tuple4._1();
                    List fragments = (List)tuple4._2();
                    List types = (List)tuple4._3();
                    List extensions = (List)tuple4._4();
                    if (f instanceof Definition.ExecutableDefinition.FragmentDefinition) {
                        Definition.ExecutableDefinition.FragmentDefinition fragmentDefinition;
                        Definition.ExecutableDefinition.FragmentDefinition fragmentDefinition2 = fragmentDefinition = (Definition.ExecutableDefinition.FragmentDefinition)f;
                        return new Tuple4((Object)operations, (Object)fragments.$colon$colon((Object)fragmentDefinition2), (Object)types, (Object)extensions);
                    }
                }
            }
            if (tuple2 != null) {
                Tuple4 tuple4 = (Tuple4)tuple2._1();
                Definition t = (Definition)tuple2._2();
                if (tuple4 != null) {
                    List operations = (List)tuple4._1();
                    List fragments = (List)tuple4._2();
                    List types = (List)tuple4._3();
                    List extensions = (List)tuple4._4();
                    if (t instanceof Definition.TypeSystemDefinition) {
                        Definition.TypeSystemDefinition typeSystemDefinition;
                        Definition.TypeSystemDefinition typeSystemDefinition2 = typeSystemDefinition = (Definition.TypeSystemDefinition)t;
                        return new Tuple4((Object)operations, (Object)fragments, (Object)types.$colon$colon((Object)typeSystemDefinition2), (Object)extensions);
                    }
                }
            }
            if (tuple2 != null) {
                Tuple4 tuple4 = (Tuple4)tuple2._1();
                Definition e = (Definition)tuple2._2();
                if (tuple4 != null) {
                    List operations = (List)tuple4._1();
                    List fragments = (List)tuple4._2();
                    List types = (List)tuple4._3();
                    List extensions = (List)tuple4._4();
                    if (e instanceof Definition.TypeSystemExtension) {
                        Definition.TypeSystemExtension typeSystemExtension;
                        Definition.TypeSystemExtension typeSystemExtension2 = typeSystemExtension = (Definition.TypeSystemExtension)e;
                        return new Tuple4((Object)operations, (Object)fragments, (Object)types, (Object)extensions.$colon$colon((Object)typeSystemExtension2));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private scala.collection.immutable.Set<String> collectVariablesUsed(package.Context context, List<Selection> selectionSet) {
        List allValues = Validator$.collectValues$1(selectionSet, context);
        List varValues = Validator$.collectVariableValues$1(allValues);
        return varValues.map((Function1 & Serializable)x$4 -> x$4.name()).toSet();
    }

    private List<Selection> collectSelectionSets(List<Selection> selectionSet) {
        Builder sets = scala.package$.MODULE$.List().newBuilder();
        Validator$.loop$1(selectionSet, sets);
        return (List)sets.result();
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, List<Tuple2<Directive, __DirectiveLocation>>> collectAllDirectives(package.Context context) {
        return ZPure$.MODULE$.succeed((Object)context.document().directiveDefinitions().groupBy((Function1 & Serializable)x$5 -> x$5.name())).flatMap((Function1 & Serializable)directiveDefinitions2 -> ZPure$.MODULE$.foreach(context.operations(), (Function1 & Serializable)op -> MODULE$.checkDirectivesUniqueness(op.directives(), (Map<String, List<Definition.TypeSystemDefinition.DirectiveDefinition>>)directiveDefinitions2).as((Function0 & Serializable)() -> {
            OperationType operationType = op.operationType();
            if (OperationType$Query$.MODULE$.equals(operationType)) {
                return op.directives().map((Function1 & Serializable)x$6 -> new Tuple2(x$6, (Object)__DirectiveLocation$QUERY$.MODULE$));
            }
            if (OperationType$Mutation$.MODULE$.equals(operationType)) {
                return op.directives().map((Function1 & Serializable)x$7 -> new Tuple2(x$7, (Object)__DirectiveLocation$MUTATION$.MODULE$));
            }
            if (OperationType$Subscription$.MODULE$.equals(operationType)) {
                return op.directives().map((Function1 & Serializable)x$8 -> new Tuple2(x$8, (Object)__DirectiveLocation$SUBSCRIPTION$.MODULE$));
            }
            throw new MatchError((Object)operationType);
        }), BuildFrom$.MODULE$.buildFromIterableOps()).flatMap((Function1 & Serializable)opDirectives -> ZPure$.MODULE$.foreach(context.fragments().values(), (Function1 & Serializable)fragment -> MODULE$.checkDirectivesUniqueness(fragment.directives(), (Map<String, List<Definition.TypeSystemDefinition.DirectiveDefinition>>)directiveDefinitions2).as((Function0 & Serializable)() -> fragment.directives().map((Function1 & Serializable)x$9 -> new Tuple2(x$9, (Object)__DirectiveLocation$FRAGMENT_DEFINITION$.MODULE$))), BuildFrom$.MODULE$.buildFromIterableOps()).flatMap((Function1 & Serializable)fragmentDirectives -> MODULE$.collectDirectives(context.selectionSets(), (Map<String, List<Definition.TypeSystemDefinition.DirectiveDefinition>>)directiveDefinitions2).map((Function1 & Serializable)selectionDirectives -> (List)((IterableOps)((IterableOps)opDirectives.flatten(Predef$.MODULE$.$conforms())).$plus$plus((IterableOnce)fragmentDirectives.flatten(Predef$.MODULE$.$conforms()))).$plus$plus((IterableOnce)selectionDirectives)))));
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, List<Tuple2<Directive, __DirectiveLocation>>> collectDirectives(List<Selection> selectionSet, Map<String, List<Definition.TypeSystemDefinition.DirectiveDefinition>> directiveDefinitions2) {
        Builder builder = scala.package$.MODULE$.List().newBuilder();
        Validator$.loop$2(selectionSet, builder);
        List directiveLists = (List)builder.result();
        return ZPure$.MODULE$.foreachDiscard((Iterable)directiveLists, (Function1 & Serializable)list2 -> MODULE$.checkDirectivesUniqueness((List<Directive>)list2.map((Function1 & Serializable)x$13 -> (Directive)x$13._1()), directiveDefinitions2)).as((Function0 & Serializable)() -> (List)directiveLists.flatten(Predef$.MODULE$.$conforms()));
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> checkDirectivesUniqueness(List<Directive> directives, Map<String, List<Definition.TypeSystemDefinition.DirectiveDefinition>> directiveDefinitions2) {
        Some some;
        Tuple2 tuple2;
        Option option2 = directives.groupBy((Function1 & Serializable)x$14 -> x$14.name()).find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$checkDirectivesUniqueness$2(directiveDefinitions2, x0$1)));
        if (None$.MODULE$.equals(option2)) {
            return ZPure$.MODULE$.unit();
        }
        if (option2 instanceof Some && (tuple2 = (Tuple2)(some = (Some)option2).value()) != null) {
            String name = (String)tuple2._1();
            return this.failValidation(new StringBuilder(39).append("Directive '").append(name).append("' is defined more than once.").toString(), "Directives are used to describe some metadata or behavioral change on the definition they apply to. When more than one directive of the same name is used, the expected metadata or behavior becomes ambiguous, therefore only one of each non-repeatable directive is allowed per location.");
        }
        throw new MatchError((Object)option2);
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit> validateDirectives$lzycompute() {
        Validator$ validator$ = this;
        synchronized (validator$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                validateDirectives = ZPure.ServiceWithPurePartiallyApplied$.MODULE$.apply$extension(ZPure$.MODULE$.serviceWithPure(), (Function1 & Serializable)context -> MODULE$.collectAllDirectives((package.Context)context).flatMap((Function1 & Serializable)directives -> ZPure$.MODULE$.foreachDiscard((Iterable)directives, (Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Directive d = (Directive)tuple2._1();
                        __DirectiveLocation location = (__DirectiveLocation)tuple2._2();
                        Option option2 = ((List)Introspector$.MODULE$.directives().$plus$plus(context.rootType().additionalDirectives())).find((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateDirectives$4(d, x$17)));
                        if (None$.MODULE$.equals(option2)) {
                            return MODULE$.failValidation(new StringBuilder(30).append("Directive '").append(d.name()).append("' is not supported.").toString(), "GraphQL servers define what directives they support. For each usage of a directive, the directive must be available on that server.");
                        }
                        if (option2 instanceof Some) {
                            Some some = (Some)option2;
                            __Directive directive = (__Directive)some.value();
                            return ZPure$.MODULE$.foreachDiscard(d.arguments(), (Function1 & Serializable)x0$2 -> {
                                Tuple2 tuple2 = x0$2;
                                if (tuple2 != null) {
                                    String arg = (String)tuple2._1();
                                    InputValue argValue = (InputValue)tuple2._2();
                                    Option option2 = directive.args().find((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateDirectives$6(arg, x$18)));
                                    if (None$.MODULE$.equals(option2)) {
                                        return MODULE$.failValidation(new StringBuilder(46).append("Argument '").append(arg).append("' is not defined on directive '").append(d.name()).append("' (").append(location).append(").").toString(), "Every argument provided to a field or directive must be defined in the set of possible arguments of that field or directive.");
                                    }
                                    if (option2 instanceof Some) {
                                        Some some = (Some)option2;
                                        __InputValue inputValue = (__InputValue)some.value();
                                        return MODULE$.validateInputValues(inputValue, argValue, (package.Context)context, new StringBuilder(29).append("InputValue '").append(inputValue.name()).append("' of Directive '").append(d.name()).append("'").toString());
                                    }
                                    throw new MatchError((Object)option2);
                                }
                                throw new MatchError((Object)tuple2);
                            }).$times$greater(ZPure$.MODULE$.when(!directive.locations().contains((Object)location), (Function0 & Serializable)() -> MODULE$.failValidation(new StringBuilder(44).append("Directive '").append(d.name()).append("' is used in invalid location '").append(location).append("'.").toString(), "GraphQL servers define what directives they support and where they support them. For each usage of a directive, the directive must be used in a location that the server has declared support for.")));
                        }
                        throw new MatchError((Object)option2);
                    }
                    throw new MatchError((Object)tuple2);
                }).map((Function1 & Serializable)x$19 -> {
                    boxedUnit = x$19;
                    return BoxedUnit.UNIT;
                })), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(package.Context.class, LightTypeTag$.MODULE$.parse(-1704375265, "\u0004\u0000\u0001\u001acaliban.validation.Context\u0001\u0002\u0003\u0000\u0000\u001acaliban.validation.package\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\u001acaliban.validation.Context\u0001\u0002\u0003\u0000\u0000\u001acaliban.validation.package\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 21))));
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return validateDirectives;
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit> validateDirectives() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.validateDirectives$lzycompute();
        }
        return validateDirectives;
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit> validateVariables$lzycompute() {
        Validator$ validator$ = this;
        synchronized (validator$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                validateVariables = ZPure.ServiceWithPurePartiallyApplied$.MODULE$.apply$extension(ZPure$.MODULE$.serviceWithPure(), (Function1 & Serializable)context -> ZPure$.MODULE$.foreachDiscard(context.operations(), (Function1 & Serializable)op -> {
                    scala.collection.immutable.Set<String> variableUsages = MODULE$.collectVariablesUsed((package.Context)context, op.selectionSet());
                    return ZPure$.MODULE$.foreachDiscard((Iterable)op.variableDefinitions().groupBy((Function1 & Serializable)x$20 -> x$20.name()), (Function1 & Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            String name = (String)tuple2._1();
                            List variables = (List)tuple2._2();
                            return ZPure$.MODULE$.when(variables.length() > 1, (Function0 & Serializable)() -> MODULE$.failValidation(new StringBuilder(38).append("Variable '").append(name).append("' is defined more than once.").toString(), "If any operation defines more than one variable with the same name, it is ambiguous and invalid. It is invalid even if the type of the duplicate variable is the same."));
                        }
                        throw new MatchError((Object)tuple2);
                    }).$times$greater(ZPure$.MODULE$.foreachDiscard(op.variableDefinitions(), (Function1 & Serializable)v -> {
                        String t = Type$.MODULE$.innerType(v.variableType());
                        return ZPure$.MODULE$.whenCase((Object)context.rootType().types().get((Object)t).map((Function1 & Serializable)x$21 -> x$21.kind()), (PartialFunction)new Serializable((VariableDefinition)v){
                            private static final long serialVersionUID = 0L;
                            private final VariableDefinition v$1;

                            public final <A1 extends Option<__TypeKind>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                Some some;
                                __TypeKind __TypeKind2;
                                Some some2;
                                __TypeKind __TypeKind3;
                                Some some3;
                                __TypeKind __TypeKind4;
                                A1 A1 = x1;
                                if (A1 instanceof Some && __TypeKind$OBJECT$.MODULE$.equals(__TypeKind4 = (__TypeKind)(some3 = (Some)A1).value()) ? true : (A1 instanceof Some && __TypeKind$UNION$.MODULE$.equals(__TypeKind3 = (__TypeKind)(some2 = (Some)A1).value()) ? true : A1 instanceof Some && __TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2 = (__TypeKind)(some = (Some)A1).value()))) {
                                    return (B1)Validator$.MODULE$.failValidation(new StringBuilder(46).append("Type of variable '").append(this.v$1.name()).append("' is not a valid input type.").toString(), "Variables can only be input types. Objects, unions, and interfaces cannot be used as inputs.");
                                }
                                return (B1)function1.apply(x1);
                            }

                            public final boolean isDefinedAt(Option<__TypeKind> x1) {
                                Some some;
                                __TypeKind __TypeKind2;
                                Some some2;
                                __TypeKind __TypeKind3;
                                Some some3;
                                __TypeKind __TypeKind4;
                                Option<__TypeKind> option2 = x1;
                                return option2 instanceof Some && __TypeKind$OBJECT$.MODULE$.equals(__TypeKind4 = (__TypeKind)(some3 = (Some)option2).value()) ? true : (option2 instanceof Some && __TypeKind$UNION$.MODULE$.equals(__TypeKind3 = (__TypeKind)(some2 = (Some)option2).value()) ? true : option2 instanceof Some && __TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2 = (__TypeKind)(some = (Some)option2).value()));
                            }
                            {
                                this.v$1 = v$1;
                            }
                        });
                    })).$times$greater(ZPure$.MODULE$.foreachDiscard(variableUsages, (Function1 & Serializable)v -> ZPure$.MODULE$.when(!op.variableDefinitions().exists((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateVariables$9(v, x$22))), (Function0 & Serializable)() -> MODULE$.failValidation(new StringBuilder(27).append("Variable '").append((String)v).append("' is not defined.").toString(), "Variables are scoped on a per\u2010operation basis. That means that any variable used within the context of an operation must be defined at the top level of that operation"))).$times$greater(ZPure$.MODULE$.foreachDiscard(op.variableDefinitions(), (Function1 & Serializable)v -> ZPure$.MODULE$.when(!variableUsages.contains((Object)v.name()), (Function0 & Serializable)() -> MODULE$.failValidation(new StringBuilder(24).append("Variable '").append(v.name()).append("' is not used.").toString(), "All variables defined by an operation must be used in that operation or a fragment transitively included by that operation. Unused variables cause a validation error.")))));
                }), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(package.Context.class, LightTypeTag$.MODULE$.parse(-1704375265, "\u0004\u0000\u0001\u001acaliban.validation.Context\u0001\u0002\u0003\u0000\u0000\u001acaliban.validation.package\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\u001acaliban.validation.Context\u0001\u0002\u0003\u0000\u0000\u001acaliban.validation.package\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 21))));
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return validateVariables;
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit> validateVariables() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.validateVariables$lzycompute();
        }
        return validateVariables;
    }

    private List<Selection.FragmentSpread> collectFragmentSpreads(List<Selection> selectionSet) {
        return selectionSet.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Selection, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Selection.FragmentSpread) {
                    Selection.FragmentSpread fragmentSpread = (Selection.FragmentSpread)A1;
                    return (B1)fragmentSpread;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Selection x1) {
                Selection selection = x1;
                return selection instanceof Selection.FragmentSpread;
            }
        });
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit> validateFragmentSpreads$lzycompute() {
        Validator$ validator$ = this;
        synchronized (validator$) {
            if ((byte)(bitmap$0 & 8) == 0) {
                validateFragmentSpreads = ZPure.ServiceWithPurePartiallyApplied$.MODULE$.apply$extension(ZPure$.MODULE$.serviceWithPure(), (Function1 & Serializable)context -> {
                    List<Selection.FragmentSpread> spreads = MODULE$.collectFragmentSpreads(context.selectionSets());
                    scala.collection.immutable.Set spreadNames = spreads.map((Function1 & Serializable)x$23 -> x$23.name()).toSet();
                    return ZPure$.MODULE$.foreachDiscard(context.fragments().values(), (Function1 & Serializable)f -> {
                        if (!spreadNames.contains((Object)f.name())) {
                            return MODULE$.failValidation(new StringBuilder(38).append("Fragment '").append(f.name()).append("' is not used in any spread.").toString(), "Defined fragments must be used within a document.");
                        }
                        return ZPure$.MODULE$.when(MODULE$.detectCycles((package.Context)context, (Definition.ExecutableDefinition.FragmentDefinition)f, MODULE$.detectCycles$default$3()), (Function0 & Serializable)() -> MODULE$.failValidation(new StringBuilder(26).append("Fragment '").append(f.name()).append("' forms a cycle.").toString(), "The graph of fragment spreads must not form any cycles including spreading itself. Otherwise an operation could infinitely spread or infinitely execute on cycles in the underlying data."));
                    });
                }, package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(package.Context.class, LightTypeTag$.MODULE$.parse(-1704375265, "\u0004\u0000\u0001\u001acaliban.validation.Context\u0001\u0002\u0003\u0000\u0000\u001acaliban.validation.package\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\u001acaliban.validation.Context\u0001\u0002\u0003\u0000\u0000\u001acaliban.validation.package\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 21))));
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return validateFragmentSpreads;
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit> validateFragmentSpreads() {
        if ((byte)(bitmap$0 & 8) == 0) {
            return this.validateFragmentSpreads$lzycompute();
        }
        return validateFragmentSpreads;
    }

    private boolean detectCycles(package.Context context, Definition.ExecutableDefinition.FragmentDefinition fragment, scala.collection.immutable.Set<String> visited) {
        List<Selection> selectionSets = this.collectSelectionSets(fragment.selectionSet());
        List<Selection.FragmentSpread> descendantSpreads = this.collectFragmentSpreads(selectionSets);
        return descendantSpreads.exists((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$detectCycles$1(visited, context, s)));
    }

    private scala.collection.immutable.Set<String> detectCycles$default$3() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit> validateDocumentFields$lzycompute() {
        Validator$ validator$ = this;
        synchronized (validator$) {
            if ((byte)(bitmap$0 & 0x10) == 0) {
                validateDocumentFields = ZPure.ServiceWithPurePartiallyApplied$.MODULE$.apply$extension(ZPure$.MODULE$.serviceWithPure(), (Function1 & Serializable)context -> ZPure$.MODULE$.foreachDiscard(context.document().definitions(), (Function1 & Serializable)x0$1 -> {
                    Definition definition = x0$1;
                    if (definition instanceof Definition.ExecutableDefinition.OperationDefinition) {
                        Definition.ExecutableDefinition.OperationDefinition operationDefinition = (Definition.ExecutableDefinition.OperationDefinition)definition;
                        OperationType opType = operationDefinition.operationType();
                        List<Selection> selectionSet = operationDefinition.selectionSet();
                        OperationType operationType = opType;
                        if (OperationType$Query$.MODULE$.equals(operationType)) {
                            return MODULE$.validateSelectionSet((package.Context)context, selectionSet, context.rootType().queryType());
                        }
                        if (OperationType$Mutation$.MODULE$.equals(operationType)) {
                            return (ZPure)context.rootType().mutationType().fold((Function0 & Serializable)() -> MODULE$.failValidation("Mutation operations are not supported on this schema.", ""), (Function1 & Serializable)x$24 -> MODULE$.validateSelectionSet((package.Context)context, selectionSet, (__Type)x$24));
                        }
                        if (OperationType$Subscription$.MODULE$.equals(operationType)) {
                            return (ZPure)context.rootType().subscriptionType().fold((Function0 & Serializable)() -> MODULE$.failValidation("Subscription operations are not supported on this schema.", ""), (Function1 & Serializable)x$25 -> MODULE$.validateSelectionSet((package.Context)context, selectionSet, (__Type)x$25));
                        }
                        throw new MatchError((Object)operationType);
                    }
                    if (definition instanceof Definition.ExecutableDefinition.FragmentDefinition) {
                        return ZPure$.MODULE$.unit();
                    }
                    if (definition instanceof Definition.TypeSystemDefinition) {
                        return ZPure$.MODULE$.unit();
                    }
                    if (definition instanceof Definition.TypeSystemExtension) {
                        return ZPure$.MODULE$.unit();
                    }
                    throw new MatchError((Object)definition);
                }), package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(package.Context.class, LightTypeTag$.MODULE$.parse(-1704375265, "\u0004\u0000\u0001\u001acaliban.validation.Context\u0001\u0002\u0003\u0000\u0000\u001acaliban.validation.package\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\u001acaliban.validation.Context\u0001\u0002\u0003\u0000\u0000\u001acaliban.validation.package\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 21))));
                bitmap$0 = (byte)(bitmap$0 | 0x10);
            }
        }
        return validateDocumentFields;
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit> validateDocumentFields() {
        if ((byte)(bitmap$0 & 0x10) == 0) {
            return this.validateDocumentFields$lzycompute();
        }
        return validateDocumentFields;
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateSelectionSet(package.Context context, List<Selection> selectionSet, __Type currentType) {
        return this.validateFields(context, selectionSet, currentType).$times$greater(FragmentValidator$.MODULE$.findConflictsWithinSelectionSet(context, context.rootType().queryType(), selectionSet));
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateFields(package.Context context, List<Selection> selectionSet, __Type currentType) {
        return ZPure$.MODULE$.foreachDiscard(selectionSet, (Function1 & Serializable)x0$1 -> {
            Selection selection = x0$1;
            if (selection instanceof Selection.Field) {
                Selection.Field field = (Selection.Field)selection;
                return MODULE$.validateField(context, field, currentType);
            }
            if (selection instanceof Selection.FragmentSpread) {
                Selection.FragmentSpread fragmentSpread = (Selection.FragmentSpread)selection;
                String name = fragmentSpread.name();
                Option option2 = context.fragments().get((Object)name);
                if (None$.MODULE$.equals(option2)) {
                    return MODULE$.failValidation(new StringBuilder(34).append("Fragment spread '").append(name).append("' is not defined.").toString(), "Named fragment spreads must refer to fragments defined within the document. It is a validation error if the target of a spread is not defined.");
                }
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    Definition.ExecutableDefinition.FragmentDefinition fragment = (Definition.ExecutableDefinition.FragmentDefinition)some.value();
                    return MODULE$.validateSpread(context, (Option<String>)new Some((Object)name), currentType, (Option<Type.NamedType>)new Some((Object)fragment.typeCondition()), fragment.selectionSet());
                }
                throw new MatchError((Object)option2);
            }
            if (selection instanceof Selection.InlineFragment) {
                Selection.InlineFragment inlineFragment = (Selection.InlineFragment)selection;
                Option<Type.NamedType> typeCondition = inlineFragment.typeCondition();
                List<Selection> selectionSet = inlineFragment.selectionSet();
                return MODULE$.validateSpread(context, (Option<String>)None$.MODULE$, currentType, typeCondition, selectionSet);
            }
            throw new MatchError((Object)selection);
        }).$times$greater(this.validateLeafFieldSelection(selectionSet, currentType));
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateSpread(package.Context context, Option<String> name, __Type currentType, Option<Type.NamedType> typeCondition, List<Selection> selectionSet) {
        Option option2 = (Option)typeCondition.fold((Function0 & Serializable)() -> new Some((Object)currentType), (Function1 & Serializable)t -> context.rootType().types().get((Object)t.name()));
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            __Type fragmentType = (__Type)some.value();
            List possibleTypes = this.getPossibleTypes(currentType).flatMap((Function1 & Serializable)x$26 -> x$26.name());
            List possibleFragmentTypes = this.getPossibleTypes(fragmentType).flatMap((Function1 & Serializable)x$27 -> x$27.name());
            List applicableTypes = (List)possibleTypes.intersect((Seq)possibleFragmentTypes);
            return this.validateFragmentType(name, fragmentType).$times$greater(ZPure$.MODULE$.when(applicableTypes.isEmpty(), (Function0 & Serializable)() -> MODULE$.failValidation(new StringBuilder(75).append(name.fold((Function0 & Serializable)() -> "Inline fragment spread", (Function1 & Serializable)n -> new StringBuilder(18).append("Fragment spread '").append((String)n).append("'").toString())).append(" is not possible: possible types are '").append(possibleTypes.mkString(", ")).append("' and possible fragment types are '").append(possibleFragmentTypes.mkString(", ")).append("'.").toString(), "Fragments are declared on a type and will only apply when the runtime object type matches the type condition. They also are spread within the context of a parent type. A fragment spread is only valid if its type condition could ever apply within the parent type.")).$times$greater(this.validateFields(context, selectionSet, fragmentType)));
        }
        if (None$.MODULE$.equals(option2)) {
            LazyRef typeConditionName$lzy = new LazyRef();
            return this.failValidation(new StringBuilder(29).append(name.fold((Function0 & Serializable)() -> "Inline fragment spread", (Function1 & Serializable)n -> new StringBuilder(18).append("Fragment spread '").append((String)n).append("'").toString())).append(" targets an invalid type: '").append(Validator$.typeConditionName$1(typeConditionName$lzy, typeCondition)).append("'.").toString(), "Fragments must be specified on types that exist in the schema. This applies for both named and inline fragments. If they are not defined in the schema, the query does not validate.");
        }
        throw new MatchError((Object)option2);
    }

    private List<__Type> getPossibleTypes(__Type t) {
        __TypeKind __TypeKind2 = t.kind();
        if (__TypeKind$OBJECT$.MODULE$.equals(__TypeKind2)) {
            return new .colon.colon((Object)t, (List)Nil$.MODULE$);
        }
        if (__TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$UNION$.MODULE$.equals(__TypeKind2)) {
            return (List)t.possibleTypes().getOrElse((Function0 & Serializable)() -> Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateField(package.Context context, Selection.Field field, __Type currentType) {
        String string2 = field.name();
        String string3 = "__typename";
        return ZPure$.MODULE$.when(string2 == null ? string3 != null : !string2.equals(string3), (Function0 & Serializable)() -> ZPure$.MODULE$.fromOption(((List)((Option)currentType.fields().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))))).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$)).find((Function1 & Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateField$3(field, x$29)))).orElseFail((Function0 & Serializable)() -> new CalibanError.ValidationError(new StringBuilder(35).append("Field '").append(field.name()).append("' does not exist on type '").append(Rendering$.MODULE$.renderTypeName(currentType)).append("'.").toString(), "The target field of a field selection must be defined on the scoped type of the selection set. There are no limitations on alias names.", CalibanError$ValidationError$.MODULE$.apply$default$3(), CalibanError$ValidationError$.MODULE$.apply$default$4()), CanFail$.MODULE$.canFail()).flatMap((Function1 & Serializable)f -> MODULE$.validateFields(context, field.selectionSet(), Types$.MODULE$.innerType((__Type)f.type().apply())).$times$greater(MODULE$.validateArguments(field, (__Field)f, currentType, context)))).unit();
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateArguments(Selection.Field field, __Field f, __Type currentType, package.Context context) {
        return ZPure$.MODULE$.foreachDiscard((Iterable)f.args().filter((Function1 & Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateArguments$1(x$30))), arg_0 -> Validator$.$anonfun$validateArguments$2(field, currentType, arg_0)).$times$greater(ZPure$.MODULE$.foreachDiscard(field.arguments(), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String arg = (String)tuple2._1();
                InputValue argValue = (InputValue)tuple2._2();
                Option option2 = f.args().find((Function1 & Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateArguments$6(arg, x$31)));
                if (None$.MODULE$.equals(option2)) {
                    return MODULE$.failValidation(new StringBuilder(50).append("Argument '").append(arg).append("' is not defined on field '").append(field.name()).append("' of type '").append(currentType.name().getOrElse((Function0 & Serializable)() -> "")).append("'.").toString(), "Every argument provided to a field or directive must be defined in the set of possible arguments of that field or directive.");
                }
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    __InputValue inputValue = (__InputValue)some.value();
                    return MODULE$.validateInputValues(inputValue, argValue, context, new StringBuilder(25).append("InputValue '").append(inputValue.name()).append("' of Field '").append(field.name()).append("'").toString());
                }
                throw new MatchError((Object)option2);
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    /*
     * Enabled aggressive block sorting
     */
    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateInputValues(__InputValue inputValue, InputValue argValue, package.Context context, String errorContext) {
        ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, Nothing$> zPure;
        __Type t = (__Type)inputValue.type().apply();
        __TypeKind __TypeKind2 = t.kind();
        __TypeKind$NON_NULL$ __TypeKind$NON_NULL$2 = __TypeKind$NON_NULL$.MODULE$;
        __Type inputType = !(__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$NON_NULL$2) : __TypeKind$NON_NULL$2 != null) ? (__Type)t.ofType().getOrElse((Function0 & Serializable)() -> t) : t;
        List inputFields = (List)inputType.inputFields().getOrElse((Function0 & Serializable)() -> Nil$.MODULE$);
        InputValue inputValue2 = argValue;
        if (inputValue2 instanceof InputValue.ObjectValue) {
            InputValue.ObjectValue objectValue = (InputValue.ObjectValue)inputValue2;
            Map<String, InputValue> fields = objectValue.fields();
            __TypeKind __TypeKind3 = inputType.kind();
            __TypeKind$INPUT_OBJECT$ __TypeKind$INPUT_OBJECT$2 = __TypeKind$INPUT_OBJECT$.MODULE$;
            if (!(__TypeKind3 != null ? !__TypeKind3.equals(__TypeKind$INPUT_OBJECT$2) : __TypeKind$INPUT_OBJECT$2 != null)) {
                zPure = ZPure$.MODULE$.foreachDiscard(fields, (Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        InputValue v = (InputValue)tuple2._2();
                        Option option2 = inputFields.find((Function1 & Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateInputValues$4(k, x$32)));
                        if (None$.MODULE$.equals(option2)) {
                            return MODULE$.failValidation(new StringBuilder(41).append("Input field '").append(k).append("' is not defined on type '").append(inputType.name().getOrElse((Function0 & Serializable)() -> "?")).append("'.").toString(), "Every input field provided in an input object value must be defined in the set of possible fields of that input object\u2019s expected type.");
                        }
                        if (option2 instanceof Some) {
                            Some some = (Some)option2;
                            __InputValue value = (__InputValue)some.value();
                            return MODULE$.validateInputValues(value, v, context, new StringBuilder(43).append("InputValue '").append(inputValue.name()).append("' of Field '").append(k).append("' of InputObject '").append(t.name().getOrElse((Function0 & Serializable)() -> "")).append("'").toString());
                        }
                        throw new MatchError((Object)option2);
                    }
                    throw new MatchError((Object)tuple2);
                }).$times$greater(ZPure$.MODULE$.foreachDiscard((Iterable)inputFields, (Function1 & Serializable)inputField -> {
                    boolean bl;
                    if (inputField.defaultValue().isEmpty()) {
                        __TypeKind __TypeKind2 = ((__Type)inputField.type().apply()).kind();
                        __TypeKind$NON_NULL$ __TypeKind$NON_NULL$2 = __TypeKind$NON_NULL$.MODULE$;
                        if (!(__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$NON_NULL$2) : __TypeKind$NON_NULL$2 != null)) {
                            Object object = fields.getOrElse((Object)inputField.name(), (Function0 & Serializable)() -> Value$NullValue$.MODULE$);
                            Value$NullValue$ value$NullValue$ = Value$NullValue$.MODULE$;
                            if (!(object != null ? !object.equals(value$NullValue$) : value$NullValue$ != null)) {
                                bl = true;
                                return ZPure$.MODULE$.when(bl, (Function0 & Serializable)() -> MODULE$.failValidation(new StringBuilder(48).append("Required field '").append(inputField.name()).append("' on object '").append(inputType.name().getOrElse((Function0 & Serializable)() -> "?")).append("' was not provided.").toString(), "Input object fields may be required. Much like a field may have required arguments, an input object may have required fields. An input field is required if it has a non\u2010null type and does not have a default value. Otherwise, the input object field is optional."));
                            }
                        }
                    }
                    bl = false;
                    return ZPure$.MODULE$.when(bl, (Function0 & Serializable)() -> MODULE$.failValidation(new StringBuilder(48).append("Required field '").append(inputField.name()).append("' on object '").append(inputType.name().getOrElse((Function0 & Serializable)() -> "?")).append("' was not provided.").toString(), "Input object fields may be required. Much like a field may have required arguments, an input object may have required fields. An input field is required if it has a non\u2010null type and does not have a default value. Otherwise, the input object field is optional."));
                }));
                return zPure.$times$greater(ValueValidator$.MODULE$.validateInputTypes(inputValue, argValue, context, errorContext));
            }
        }
        if (!(inputValue2 instanceof InputValue.VariableValue)) {
            zPure = ZPure$.MODULE$.unit();
            return zPure.$times$greater(ValueValidator$.MODULE$.validateInputTypes(inputValue, argValue, context, errorContext));
        }
        InputValue.VariableValue variableValue = (InputValue.VariableValue)inputValue2;
        String variableName = variableValue.name();
        Option option2 = context.variableDefinitions().get((Object)variableName);
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            VariableDefinition variableDefinition = (VariableDefinition)some.value();
            zPure = this.checkVariableUsageAllowed(variableDefinition, inputValue);
            return zPure.$times$greater(ValueValidator$.MODULE$.validateInputTypes(inputValue, argValue, context, errorContext));
        }
        if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
        zPure = this.failValidation(new StringBuilder(27).append("Variable '").append(variableName).append("' is not defined.").toString(), "Variables are scoped on a per\u2010operation basis. That means that any variable used within the context of an operation must be defined at the top level of that operation");
        return zPure.$times$greater(ValueValidator$.MODULE$.validateInputTypes(inputValue, argValue, context, errorContext));
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> checkVariableUsageAllowed(VariableDefinition variableDefinition, __InputValue inputValue) {
        __Type locationType = (__Type)inputValue.type().apply();
        Type variableType = variableDefinition.variableType();
        if (!locationType.isNullable() && !variableType.nonNull()) {
            boolean hasNonNullVariableDefaultValue = variableDefinition.defaultValue().exists((Function1 & Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$checkVariableUsageAllowed$1(x$33)));
            boolean hasLocationDefaultValue = inputValue.defaultValue().nonEmpty();
            if (!hasNonNullVariableDefaultValue && !hasLocationDefaultValue) {
                return this.failValidation(new StringBuilder(89).append("Variable '").append(variableDefinition.name()).append("' usage is not allowed because it is nullable and doesn't have a default value.").toString(), "Variable usages must be compatible with the arguments they are passed to.");
            }
            __Type nullableLocationType = (__Type)locationType.ofType().getOrElse((Function0 & Serializable)() -> locationType);
            return this.checkTypesCompatible(variableDefinition.name(), variableType, nullableLocationType);
        }
        return this.checkTypesCompatible(variableDefinition.name(), variableType, locationType);
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> checkTypesCompatible(String variableName, Type variableType, __Type locationType) {
        String explanation;
        block7: {
            Type type;
            while (true) {
                explanation = "Variable usages must be compatible with the arguments they are passed to.";
                if (!locationType.isNullable()) {
                    if (variableType.nullable()) {
                        return this.failValidation(new StringBuilder(76).append("Variable '").append(variableName).append("' usage is not allowed because it is nullable but it shouldn't be.").toString(), explanation);
                    }
                    __Type nullableLocationType = (__Type)locationType.ofType().getOrElse((Function0 & Serializable)() -> locationType);
                    Type nullableVariableType = variableType.toNullable();
                    locationType = nullableLocationType;
                    variableType = nullableVariableType;
                    continue;
                }
                if (variableType.nonNull()) {
                    Type nullableVariableType;
                    variableType = nullableVariableType = variableType.toNullable();
                    continue;
                }
                __TypeKind __TypeKind2 = locationType.kind();
                __TypeKind$LIST$ __TypeKind$LIST$2 = __TypeKind$LIST$.MODULE$;
                if (__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$LIST$2) : __TypeKind$LIST$2 != null) break block7;
                type = variableType;
                if (type instanceof Type.NamedType) {
                    return this.failValidation(new StringBuilder(77).append("Variable '").append(variableName).append("' usage is not allowed because it is a not a list but it should be.").toString(), explanation);
                }
                if (!(type instanceof Type.ListType)) break;
                Type.ListType listType = (Type.ListType)type;
                Type ofType = listType.ofType();
                __Type itemLocationType = (__Type)locationType.ofType().getOrElse((Function0 & Serializable)() -> locationType);
                Type itemVariableType = ofType;
                locationType = itemLocationType;
                variableType = itemVariableType;
            }
            throw new MatchError((Object)type);
        }
        Type type = variableType;
        if (type instanceof Type.ListType) {
            return this.failValidation(new StringBuilder(75).append("Variable '").append(variableName).append("' usage is not allowed because it is a list but it should not be.").toString(), explanation);
        }
        if (type instanceof Type.NamedType) {
            Type.NamedType namedType = (Type.NamedType)type;
            String name = namedType.name();
            return ZPure$.MODULE$.when(!locationType.name().contains((Object)name), (Function0 & Serializable)() -> MODULE$.failValidation(new StringBuilder(90).append("Variable '").append(variableName).append("' usage is not allowed because its type doesn't match the schema (").append(name).append(" instead of ").append(locationType.name().getOrElse((Function0 & Serializable)() -> "")).append(").").toString(), explanation)).unit();
        }
        throw new MatchError((Object)type);
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateLeafFieldSelection(List<Selection> selections, __Type currentType) {
        __TypeKind __TypeKind2 = currentType.kind();
        if ((__TypeKind$SCALAR$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$ENUM$.MODULE$.equals(__TypeKind2)) && selections.nonEmpty()) {
            return this.failValidation(new StringBuilder(41).append("Field selection is impossible on type '").append(currentType.name().getOrElse((Function0 & Serializable)() -> "")).append("'.").toString(), "Field selections on scalars or enums are never allowed, because they are the leaf nodes of any GraphQL query.");
        }
        if ((__TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2) ? true : (__TypeKind$UNION$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$OBJECT$.MODULE$.equals(__TypeKind2))) && selections.isEmpty()) {
            return this.failValidation(new StringBuilder(40).append("Field selection is mandatory on type '").append(currentType.name().getOrElse((Function0 & Serializable)() -> "")).append("'.").toString(), "Leaf selections on objects, interfaces, and unions without subfields are disallowed.");
        }
        return ZPure$.MODULE$.unit();
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit> validateOperationNameUniqueness$lzycompute() {
        Validator$ validator$ = this;
        synchronized (validator$) {
            if ((byte)(bitmap$0 & 0x20) == 0) {
                validateOperationNameUniqueness = ZPure.ServiceWithPurePartiallyApplied$.MODULE$.apply$extension(ZPure$.MODULE$.serviceWithPure(), (Function1 & Serializable)context -> {
                    List<Definition.ExecutableDefinition.OperationDefinition> operations = context.operations();
                    Map names = operations.flatMap((Function1 & Serializable)x$34 -> x$34.name()).groupBy((Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x));
                    scala.collection.immutable.Iterable repeatedNames = (scala.collection.immutable.Iterable)names.collect((PartialFunction)new Serializable(){
                        private static final long serialVersionUID = 0L;

                        public final <A1 extends Tuple2<String, List<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            if (A1 != null) {
                                String name = (String)A1._1();
                                List items = (List)A1._2();
                                if (items.length() > 1) {
                                    return (B1)name;
                                }
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Tuple2<String, List<String>> x1) {
                            List items;
                            Tuple2<String, List<String>> tuple2 = x1;
                            return tuple2 != null && (items = (List)tuple2._2()).length() > 1;
                        }
                    });
                    return ZPure$.MODULE$.when(repeatedNames.nonEmpty(), (Function0 & Serializable)() -> MODULE$.failValidation(new StringBuilder(41).append("Multiple operations have the same name: ").append(repeatedNames.mkString(", ")).append(".").toString(), "Each named operation definition must be unique within a document when referred to by its name.")).unit();
                }, package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(package.Context.class, LightTypeTag$.MODULE$.parse(-1704375265, "\u0004\u0000\u0001\u001acaliban.validation.Context\u0001\u0002\u0003\u0000\u0000\u001acaliban.validation.package\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\u001acaliban.validation.Context\u0001\u0002\u0003\u0000\u0000\u001acaliban.validation.package\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 21))));
                bitmap$0 = (byte)(bitmap$0 | 0x20);
            }
        }
        return validateOperationNameUniqueness;
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit> validateOperationNameUniqueness() {
        if ((byte)(bitmap$0 & 0x20) == 0) {
            return this.validateOperationNameUniqueness$lzycompute();
        }
        return validateOperationNameUniqueness;
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit> validateLoneAnonymousOperation$lzycompute() {
        Validator$ validator$ = this;
        synchronized (validator$) {
            if ((byte)(bitmap$0 & 0x40) == 0) {
                validateLoneAnonymousOperation = ZPure.ServiceWithPurePartiallyApplied$.MODULE$.apply$extension(ZPure$.MODULE$.serviceWithPure(), (Function1 & Serializable)context -> {
                    List<Definition.ExecutableDefinition.OperationDefinition> operations = context.operations();
                    List anonymous = operations.filter((Function1 & Serializable)x$35 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateLoneAnonymousOperation$2(x$35)));
                    return ZPure$.MODULE$.when(operations.length() > 1 && anonymous.nonEmpty(), (Function0 & Serializable)() -> MODULE$.failValidation("Found both anonymous and named operations.", "GraphQL allows a short\u2010hand form for defining query operations when only that one operation exists in the document.")).unit();
                }, package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(package.Context.class, LightTypeTag$.MODULE$.parse(-1704375265, "\u0004\u0000\u0001\u001acaliban.validation.Context\u0001\u0002\u0003\u0000\u0000\u001acaliban.validation.package\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\u001acaliban.validation.Context\u0001\u0002\u0003\u0000\u0000\u001acaliban.validation.package\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 21))));
                bitmap$0 = (byte)(bitmap$0 | 0x40);
            }
        }
        return validateLoneAnonymousOperation;
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit> validateLoneAnonymousOperation() {
        if ((byte)(bitmap$0 & 0x40) == 0) {
            return this.validateLoneAnonymousOperation$lzycompute();
        }
        return validateLoneAnonymousOperation;
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, Map<String, Definition.ExecutableDefinition.FragmentDefinition>> validateFragments(List<Definition.ExecutableDefinition.FragmentDefinition> fragments) {
        return (ZPure)package$.MODULE$.ForEachOps(fragments).foldLeftM((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Definition.ExecutableDefinition.FragmentDefinition fragment;
                Map fragmentMap = (Map)tuple2._1();
                if (fragmentMap.contains((Object)(fragment = (Definition.ExecutableDefinition.FragmentDefinition)tuple2._2()).name())) {
                    return MODULE$.failValidation(new StringBuilder(38).append("Fragment '").append(fragment.name()).append("' is defined more than once.").toString(), "Fragment definitions are referenced in fragment spreads by name. To avoid ambiguity, each fragment\u2019s name must be unique within a document.");
                }
                return ZPure$.MODULE$.succeed((Object)fragmentMap.updated((Object)fragment.name(), (Object)fragment));
            }
            throw new MatchError((Object)tuple2);
        }, ZPure$.MODULE$.ZPureIdentityFlatten(), (Covariant)ZPure$.MODULE$.ZPureCovariantIdentityBoth(), Invariant$.MODULE$.ListForEach());
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit> validateSubscriptionOperation$lzycompute() {
        Validator$ validator$ = this;
        synchronized (validator$) {
            if ((byte)(bitmap$0 & 0x80) == 0) {
                validateSubscriptionOperation = ZPure.ServiceWithPurePartiallyApplied$.MODULE$.apply$extension(ZPure$.MODULE$.serviceWithPure(), (Function1 & Serializable)context -> {
                    Option error = context.rootType().subscriptionType().flatMap((Function1 & Serializable)t -> context.operations().find((Function1 & Serializable)x$36 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateSubscriptionOperation$3(x$36))).map((Function1 & Serializable)op -> {
                        Field field = Field$.MODULE$.apply(op.selectionSet(), context.fragments(), (Map<String, InputValue>)Predef$.MODULE$.Map().empty(), (List<VariableDefinition>)scala.package$.MODULE$.List().empty(), (__Type)t, SourceMapper$.MODULE$.empty(), (List<Directive>)Nil$.MODULE$, context.rootType());
                        String subscription = (String)op.name().fold((Function0 & Serializable)() -> "", (Function1 & Serializable)n -> new StringBuilder(2).append("'").append((String)n).append("'").toString());
                        return new Tuple3(op, (Object)field, (Object)subscription);
                    }).flatMap((Function1 & Serializable)x$37 -> {
                        None$ none$;
                        Tuple3 tuple3 = x$37;
                        if (tuple3 == null) throw new MatchError((Object)tuple3);
                        Field field = (Field)tuple3._2();
                        String subscription = (String)tuple3._3();
                        List<Field> list2 = field.fields();
                        if (Nil$.MODULE$.equals(list2)) {
                            none$ = None$.MODULE$;
                            return none$.map((Function1 & Serializable)error -> error);
                        }
                        if (list2 instanceof .colon.colon) {
                            .colon.colon colon2 = (.colon.colon)list2;
                            Field head = (Field)colon2.head();
                            List list3 = colon2.next$access$1();
                            if (Nil$.MODULE$.equals(list3)) {
                                String string2 = head.name();
                                String string3 = "__typename";
                                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                                    none$ = new Some((Object)new CalibanError.ValidationError(new StringBuilder(45).append("Subscription ").append(subscription).append(" has a field named '__typename'.").toString(), "The root field of a subscription operation must not be an introspection field.", CalibanError$ValidationError$.MODULE$.apply$default$3(), CalibanError$ValidationError$.MODULE$.apply$default$4()));
                                    return none$.map((Function1 & Serializable)error -> error);
                                }
                                none$ = None$.MODULE$;
                                return none$.map((Function1 & Serializable)error -> error);
                            }
                        }
                        none$ = new Some((Object)new CalibanError.ValidationError(new StringBuilder(43).append("Subscription ").append(subscription).append(" has more than one root field.").toString(), "Subscription operations must have exactly one root field.", CalibanError$ValidationError$.MODULE$.apply$default$3(), CalibanError$ValidationError$.MODULE$.apply$default$4()));
                        return none$.map((Function1 & Serializable)error -> error);
                    }));
                    return ZPure$.MODULE$.fromOption(error).flip().unit();
                }, package.Tag$.MODULE$.apply(Tag$.MODULE$.apply(package.Context.class, LightTypeTag$.MODULE$.parse(-1704375265, "\u0004\u0000\u0001\u001acaliban.validation.Context\u0001\u0002\u0003\u0000\u0000\u001acaliban.validation.package\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\u001acaliban.validation.Context\u0001\u0002\u0003\u0000\u0000\u001acaliban.validation.package\u0001\u0001\u0003\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0002\u0003\u0000\u0000\u0090\u0003\u0001\u0001\u0003\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 21))));
                bitmap$0 = (byte)(bitmap$0 | 0x80);
            }
        }
        return validateSubscriptionOperation;
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, package.Context, CalibanError.ValidationError, BoxedUnit> validateSubscriptionOperation() {
        if ((byte)(bitmap$0 & 0x80) == 0) {
            return this.validateSubscriptionOperation$lzycompute();
        }
        return validateSubscriptionOperation;
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateFragmentType(Option<String> name, __Type targetType) {
        __TypeKind __TypeKind2 = targetType.kind();
        if (__TypeKind$UNION$.MODULE$.equals(__TypeKind2) ? true : (__TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$OBJECT$.MODULE$.equals(__TypeKind2))) {
            return ZPure$.MODULE$.unit();
        }
        String targetTypeName = (String)targetType.name().getOrElse((Function0 & Serializable)() -> "");
        return this.failValidation(new StringBuilder(30).append(name.fold((Function0 & Serializable)() -> "Inline fragment", (Function1 & Serializable)n -> new StringBuilder(11).append("Fragment '").append((String)n).append("'").toString())).append(" is defined on invalid type '").append(targetTypeName).append("'").toString(), "Fragments can only be declared on unions, interfaces, and objects. They are invalid on scalars. They can only be applied on non\u2010leaf fields. This rule applies to both inline and named fragments.");
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateEnum(__Type t) {
        Some some;
        List list2;
        Option option2 = (Option)t.enumValues().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))));
        if (option2 instanceof Some && (list2 = (List)(some = (Some)option2).value()) instanceof .colon.colon) {
            return ZPure$.MODULE$.unit();
        }
        return this.failValidation(new StringBuilder(32).append("Enum ").append(t.name().getOrElse((Function0 & Serializable)() -> "")).append(" doesn't contain any values").toString(), "An Enum type must define one or more unique enum values.");
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateUnion(__Type t2) {
        Some some;
        List types;
        Some some2;
        List list2;
        Option<List<__Type>> option2 = t2.possibleTypes();
        if (None$.MODULE$.equals(option2) ? true : option2 instanceof Some && Nil$.MODULE$.equals(list2 = (List)(some2 = (Some)option2).value())) {
            return this.failValidation(new StringBuilder(32).append("Union ").append(t2.name().getOrElse((Function0 & Serializable)() -> "")).append(" doesn't contain any type.").toString(), "A Union type must include one or more unique member types.");
        }
        if (option2 instanceof Some && !(types = (List)(some = (Some)option2).value()).forall((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.isObjectType(t)))) {
            return this.failValidation(new StringBuilder(48).append("Union ").append(t2.name().getOrElse((Function0 & Serializable)() -> "")).append(" contains the following non Object types: ").append(types.filterNot((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.isObjectType(t))).map((Function1 & Serializable)x$38 -> (String)x$38.name().getOrElse((Function0 & Serializable)() -> "")).filterNot((Function1 & Serializable)x$39 -> BoxesRunTime.boxToBoolean((boolean)x$39.isEmpty())).mkString("", ", ", ".")).toString(), "The member types of a Union type must all be Object base types.");
        }
        return ZPure$.MODULE$.unit();
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateInputObject(__Type t) {
        Some some;
        List list2;
        String inputObjectContext = new StringBuilder(14).append("InputObject '").append(t.name().getOrElse((Function0 & Serializable)() -> "")).append("'").toString();
        Option<List<__InputValue>> option2 = t.inputFields();
        if (None$.MODULE$.equals(option2) ? true : option2 instanceof Some && Nil$.MODULE$.equals(list2 = (List)(some = (Some)option2).value())) {
            return this.failValidation(new StringBuilder(21).append(inputObjectContext).append(" does not have fields").toString(), "An Input Object type must define one or more input fields");
        }
        if (option2 instanceof Some) {
            Some some2 = (Some)option2;
            List fields = (List)some2.value();
            return this.validateFields$1(fields, inputObjectContext);
        }
        throw new MatchError(option2);
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateInputValue(__InputValue inputValue, String errorContext) {
        String fieldContext = new StringBuilder(17).append("InputValue '").append(inputValue.name()).append("' of ").append(errorContext).toString();
        return ValueValidator$.MODULE$.validateDefaultValue(inputValue, fieldContext).flatMap((Function1 & Serializable)x$44 -> {
            BoxedUnit boxedUnit = x$44;
            return MODULE$.doesNotStartWithUnderscore(inputValue, fieldContext).flatMap((Function1 & Serializable)x$43 -> {
                BoxedUnit boxedUnit = x$43;
                return MODULE$.onlyInputType((__Type)inputValue.type().apply(), fieldContext).map((Function1 & Serializable)x$42 -> {
                    boxedUnit = x$42;
                    return BoxedUnit.UNIT;
                });
            });
        });
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateInterface(__Type t) {
        Some some;
        List list2;
        String interfaceContext = new StringBuilder(12).append("Interface '").append(t.name().getOrElse((Function0 & Serializable)() -> "")).append("'").toString();
        Option option2 = (Option)t.fields().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))));
        if (None$.MODULE$.equals(option2) ? true : option2 instanceof Some && Nil$.MODULE$.equals(list2 = (List)(some = (Some)option2).value())) {
            return this.failValidation(new StringBuilder(21).append(interfaceContext).append(" does not have fields").toString(), "An Interface type must define one or more fields");
        }
        if (option2 instanceof Some) {
            Some some2 = (Some)option2;
            List fields = (List)some2.value();
            return this.validateFields((List<__Field>)fields, interfaceContext);
        }
        throw new MatchError((Object)option2);
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateObject(__Type obj) {
        Some some;
        List list2;
        String objectContext = new StringBuilder(9).append("Object '").append(obj.name().getOrElse((Function0 & Serializable)() -> "")).append("'").toString();
        Option option2 = (Option)obj.fields().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))));
        if (None$.MODULE$.equals(option2) ? true : option2 instanceof Some && Nil$.MODULE$.equals(list2 = (List)(some = (Some)option2).value())) {
            return this.failValidation(new StringBuilder(21).append(objectContext).append(" does not have fields").toString(), "An Object type must define one or more fields");
        }
        if (option2 instanceof Some) {
            Some some2 = (Some)option2;
            List fields = (List)some2.value();
            return this.validateFields((List<__Field>)fields, objectContext).$times$greater(Validator$.validateInterfaceFields$1(obj, objectContext));
        }
        throw new MatchError((Object)option2);
    }

    private boolean isListField(__Field field) {
        __TypeKind __TypeKind2 = ((__Type)field.type().apply()).kind();
        __TypeKind$LIST$ __TypeKind$LIST$2 = __TypeKind$LIST$.MODULE$;
        return !(__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$LIST$2) : __TypeKind$LIST$2 != null);
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> onlyInputType(__Type type, String errorContext) {
        Either either = Validator$.isInputType$1(type);
        if (either instanceof Left) {
            Left left = (Left)either;
            __Type errorType = (__Type)left.value();
            return this.failValidation(new StringBuilder(38).append(errorType.name().getOrElse((Function0 & Serializable)() -> "")).append(" of ").append(errorContext).append(" is of kind ").append(errorType.kind()).append(", must be an InputType").toString(), "The input field must accept a type where IsInputType(type) returns true, https://spec.graphql.org/June2018/#IsInputType()");
        }
        if (either instanceof Right) {
            return ZPure$.MODULE$.unit();
        }
        throw new MatchError((Object)either);
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateFields(List<__Field> fields, String context) {
        return this.noDuplicateFieldName(fields, context).$less$times(ZPure$.MODULE$.foreachDiscard(fields, (Function1 & Serializable)field -> {
            String fieldContext = new StringBuilder(12).append("Field '").append(field.name()).append("' of ").append(context).toString();
            return MODULE$.doesNotStartWithUnderscore((__Field)field, fieldContext).flatMap((Function1 & Serializable)x$57 -> {
                BoxedUnit boxedUnit = x$57;
                return MODULE$.onlyOutputType((__Type)field.type().apply(), fieldContext).flatMap((Function1 & Serializable)x$56 -> {
                    BoxedUnit boxedUnit = x$56;
                    return ZPure$.MODULE$.foreachDiscard(field.args(), (Function1 & Serializable)x$54 -> MODULE$.validateInputValue((__InputValue)x$54, fieldContext)).map((Function1 & Serializable)x$55 -> {
                        boxedUnit = x$55;
                        return BoxedUnit.UNIT;
                    });
                });
            });
        }));
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> noDuplicateFieldName(List<__Field> fields, String errorContext) {
        Function1 & Serializable messageBuilder = (Function1 & Serializable)f -> new StringBuilder(22).append(errorContext).append(" has repeated fields: ").append(f.name()).toString();
        String explanatory = "The field must have a unique name within that Interface type; no two fields may share the same name";
        return this.noDuplicateName(fields, (Function1 & Serializable)x$58 -> x$58.name(), messageBuilder, explanatory);
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> onlyOutputType(__Type type, String errorContext) {
        Either either = Validator$.isOutputType$1(type);
        if (either instanceof Left) {
            Left left = (Left)either;
            __Type errorType = (__Type)left.value();
            return this.failValidation(new StringBuilder(39).append(errorType.name().getOrElse((Function0 & Serializable)() -> "")).append(" of ").append(errorContext).append(" is of kind ").append(errorType.kind()).append(", must be an OutputType").toString(), "The input field must accept a type where IsOutputType(type) returns true, https://spec.graphql.org/June2018/#IsInputType()");
        }
        if (either instanceof Right) {
            return ZPure$.MODULE$.unit();
        }
        throw new MatchError((Object)either);
    }

    public <T> ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> noDuplicateName(List<T> listOfNamed, Function1<T, String> nameExtractor, Function1<T, String> messageBuilder, String explanatoryText) {
        return (ZPure)listOfNamed.groupBy((Function1 & Serializable)x$59 -> (String)nameExtractor.apply(x$59)).collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<String, List<T>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                List list2;
                A1 A1 = x1;
                if (A1 != null && (list2 = (List)A1._2()) instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list2;
                    Object f = colon2.head();
                    List list3 = colon2.next$access$1();
                    if (list3 instanceof .colon.colon) {
                        return (B1)f;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<String, List<T>> x1) {
                .colon.colon colon2;
                List list2;
                List list3;
                Tuple2<String, List<T>> tuple2 = x1;
                return tuple2 != null && (list3 = (List)tuple2._2()) instanceof .colon.colon && (list2 = (colon2 = (.colon.colon)list3).next$access$1()) instanceof .colon.colon;
            }
        }).fold((Function0 & Serializable)() -> ZPure$.MODULE$.unit(), (Function1 & Serializable)duplicate -> MODULE$.failValidation((String)messageBuilder.apply(duplicate), explanatoryText));
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> doesNotStartWithUnderscore(__Field field, String errorContext) {
        String explanatory = "The field must not have a name which begins with the characters {\"__\"} (two underscores)";
        return this.doesNotStartWithUnderscore(field, (Function1 & Serializable)x$60 -> x$60.name(), errorContext, explanatory);
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> doesNotStartWithUnderscore(__InputValue inputValue, String errorContext) {
        String explanatory = "The input field must not have a name which begins with the characters \"__\" (two underscores)";
        return this.doesNotStartWithUnderscore(inputValue, (Function1 & Serializable)x$61 -> x$61.name(), errorContext, explanatory);
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> doesNotStartWithUnderscore(Directive directive, String errorContext) {
        String explanatory = "The directive must not have a name which begins with the characters \"__\" (two underscores)";
        return this.doesNotStartWithUnderscore(directive, (Function1 & Serializable)x$62 -> x$62.name(), errorContext, explanatory);
    }

    public <T> ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> doesNotStartWithUnderscore(T t, Function1<T, String> nameExtractor, String errorContext, String explanatoryText) {
        return ZPure$.MODULE$.when(((String)nameExtractor.apply(t)).startsWith("__"), (Function0 & Serializable)() -> MODULE$.failValidation(new StringBuilder(22).append(errorContext).append(" can't start with '__'").toString(), explanatoryText)).unit();
    }

    public <R> ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, RootSchema<R>> validateRootQuery(RootSchemaBuilder<R> schema2) {
        Option<Operation<R>> option2 = schema2.query();
        if (None$.MODULE$.equals(option2)) {
            return this.failValidation("The query root operation is missing.", "The query root operation type must be provided and must be an Object type.");
        }
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Operation query = (Operation)some.value();
            return ZPure$.MODULE$.succeed(new RootSchema<R>(query, schema2.mutation(), schema2.subscription()));
        }
        throw new MatchError(option2);
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateClashingTypes(List<__Type> types) {
        Some some;
        Tuple2 tuple2;
        Option check = types.groupBy((Function1 & Serializable)x$63 -> x$63.name()).collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<Option<String>, List<__Type>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    Option option2 = (Option)A1._1();
                    List v = (List)A1._2();
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        String name = (String)some.value();
                        if (v.size() > 1) {
                            return (B1)new Tuple2((Object)name, (Object)v);
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Option<String>, List<__Type>> x1) {
                Tuple2<Option<String>, List<__Type>> tuple2 = x1;
                if (tuple2 != null) {
                    Option option2 = (Option)tuple2._1();
                    List v = (List)tuple2._2();
                    if (option2 instanceof Some && v.size() > 1) {
                        return true;
                    }
                }
                return false;
            }
        });
        Option option2 = check;
        if (None$.MODULE$.equals(option2)) {
            return ZPure$.MODULE$.unit();
        }
        if (option2 instanceof Some && (tuple2 = (Tuple2)(some = (Some)option2).value()) != null) {
            String name = (String)tuple2._1();
            List values = (List)tuple2._2();
            return this.failValidation(new StringBuilder(37).append("Type '").append(name).append("' is defined multiple times (").append(((List)values.sortBy((Function1 & Serializable)v -> (String)v.origin().getOrElse((Function0 & Serializable)() -> ""), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)v -> new StringBuilder(0).append(v.kind()).append(v.origin().fold((Function0 & Serializable)() -> "", (Function1 & Serializable)a -> new StringBuilder(4).append(" in ").append((String)a).toString())).toString()).mkString(", ")).append(").").toString(), "Each type must be defined only once.");
        }
        throw new MatchError((Object)option2);
    }

    private ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateDirectives(List<__Type> types) {
        return ZPure$.MODULE$.foreachDiscard(types, (Function1 & Serializable)t -> {
            String typeErrorContext = new StringBuilder(7).append("Type '").append(t.name().getOrElse((Function0 & Serializable)() -> "")).append("'").toString();
            return this.validateDirectives$1(t.directives(), typeErrorContext).flatMap((Function1 & Serializable)x$68 -> {
                BoxedUnit boxedUnit = x$68;
                return this.validateInputValueDirectives$1((List)t.inputFields().getOrElse((Function0 & Serializable)() -> scala.package$.MODULE$.List().empty()), typeErrorContext).flatMap((Function1 & Serializable)x$67 -> {
                    BoxedUnit boxedUnit = x$67;
                    return ZPure$.MODULE$.foreachDiscard((Iterable)((Option)t.fields().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))))).getOrElse((Function0 & Serializable)() -> scala.package$.MODULE$.List().empty()), (Function1 & Serializable)x$65 -> this.validateFieldDirectives$1((__Field)x$65, typeErrorContext)).map((Function1 & Serializable)x$66 -> {
                        boxedUnit = x$66;
                        return BoxedUnit.UNIT;
                    });
                });
            });
        });
    }

    public static final /* synthetic */ String $anonfun$prepare$3(String name$1) {
        return new StringBuilder(19).append("Unknown operation ").append(name$1).append(".").toString();
    }

    public static final /* synthetic */ ExecutionRequest $anonfun$prepare$4(Definition.ExecutableDefinition.OperationDefinition op$1, Map fragments$1, Map variables$1, Document document$1, RootType rootType$1, Operation operation) {
        return new ExecutionRequest(Field$.MODULE$.apply(op$1.selectionSet(), (Map<String, Definition.ExecutableDefinition.FragmentDefinition>)fragments$1, (Map<String, InputValue>)variables$1, op$1.variableDefinitions(), operation.opType(), document$1.sourceMapper(), op$1.directives(), rootType$1), op$1.operationType());
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ ZPure $anonfun$prepare$2(Option operationName$1, Document document$1, RootSchema rootSchema$1, Map variables$1, RootType rootType$1, Map fragments) {
        block10: {
            block12: {
                block13: {
                    block15: {
                        block14: {
                            block11: {
                                block8: {
                                    block9: {
                                        block7: {
                                            var13_6 = operationName$1;
                                            if (!(var13_6 instanceof Some)) break block7;
                                            var14_7 = (Some)var13_6;
                                            name = (String)var14_7.value();
                                            v0 = document$1.definitions().collectFirst((PartialFunction)new Serializable(name){
                                                private static final long serialVersionUID = 0L;
                                                private final String name$1;

                                                public final <A1 extends Definition, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                                    Definition.ExecutableDefinition.OperationDefinition operationDefinition;
                                                    A1 A1 = x1;
                                                    if (A1 instanceof Definition.ExecutableDefinition.OperationDefinition && (operationDefinition = (Definition.ExecutableDefinition.OperationDefinition)A1).name().contains((Object)this.name$1)) {
                                                        return (B1)operationDefinition;
                                                    }
                                                    return (B1)function1.apply(x1);
                                                }

                                                public final boolean isDefinedAt(Definition x1) {
                                                    Definition.ExecutableDefinition.OperationDefinition operationDefinition;
                                                    Definition definition = x1;
                                                    return definition instanceof Definition.ExecutableDefinition.OperationDefinition && (operationDefinition = (Definition.ExecutableDefinition.OperationDefinition)definition).name().contains((Object)this.name$1);
                                                }
                                                {
                                                    this.name$1 = name$1;
                                                }
                                            }).toRight((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$prepare$3(java.lang.String ), ()Ljava/lang/String;)((String)name));
                                            break block8;
                                        }
                                        if (!None$.MODULE$.equals(var13_6)) break block9;
                                        var16_9 = document$1.definitions().collect((PartialFunction)new Serializable(){
                                            private static final long serialVersionUID = 0L;

                                            public final <A1 extends Definition, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                                A1 A1 = x2;
                                                if (A1 instanceof Definition.ExecutableDefinition.OperationDefinition) {
                                                    Definition.ExecutableDefinition.OperationDefinition operationDefinition = (Definition.ExecutableDefinition.OperationDefinition)A1;
                                                    return (B1)operationDefinition;
                                                }
                                                return (B1)function1.apply(x2);
                                            }

                                            public final boolean isDefinedAt(Definition x2) {
                                                Definition definition = x2;
                                                return definition instanceof Definition.ExecutableDefinition.OperationDefinition;
                                            }
                                        });
                                        if (!(var16_9 instanceof .colon.colon)) ** GOTO lbl-1000
                                        var17_10 = (.colon.colon)var16_9;
                                        head = (Definition.ExecutableDefinition.OperationDefinition)var17_10.head();
                                        var19_12 = var17_10.next$access$1();
                                        if (Nil$.MODULE$.equals(var19_12)) {
                                            v0 = scala.package$.MODULE$.Right().apply((Object)head);
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            v0 = scala.package$.MODULE$.Left().apply((Object)"Operation name is required.");
                                        }
                                        break block8;
                                    }
                                    throw new MatchError((Object)var13_6);
                                }
                                var20_14 = operation = v0;
                                if (var20_14 instanceof Left) {
                                    var21_15 = (Left)var20_14;
                                    error = (String)var21_15.value();
                                    return Validator$.MODULE$.failValidation(error, "");
                                }
                                if (!(var20_14 instanceof Right)) break block10;
                                var23_17 = (Right)var20_14;
                                op = (Definition.ExecutableDefinition.OperationDefinition)var23_17.value();
                                var25_19 = op.operationType();
                                if (!OperationType$Query$.MODULE$.equals(var25_19)) break block11;
                                v1 = ZPure$.MODULE$.succeed(rootSchema$1.query());
                                break block12;
                            }
                            if (!OperationType$Mutation$.MODULE$.equals(var25_19)) break block13;
                            var26_20 = rootSchema$1.mutation();
                            if (!(var26_20 instanceof Some)) break block14;
                            var27_21 = (Some)var26_20;
                            m = (Operation)var27_21.value();
                            v1 = ZPure$.MODULE$.succeed((Object)m);
                            break block12;
                        }
                        if (!None$.MODULE$.equals(var26_20)) break block15;
                        v1 = Validator$.MODULE$.failValidation("Mutations are not supported on this schema", "");
                        break block12;
                    }
                    throw new MatchError(var26_20);
                }
                if (!OperationType$Subscription$.MODULE$.equals(var25_19)) ** GOTO lbl60
                var29_23 = rootSchema$1.subscription();
                if (var29_23 instanceof Some) {
                    var30_24 = (Some)var29_23;
                    m = (Operation)var30_24.value();
                    v1 = ZPure$.MODULE$.succeed((Object)m);
                } else if (None$.MODULE$.equals(var29_23)) {
                    v1 = Validator$.MODULE$.failValidation("Subscriptions are not supported on this schema", "");
                } else {
                    throw new MatchError(var29_23);
lbl60:
                    // 1 sources

                    throw new MatchError((Object)var25_19);
                }
            }
            return v1.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$prepare$4(caliban.parsing.adt.Definition$ExecutableDefinition$OperationDefinition scala.collection.immutable.Map scala.collection.immutable.Map caliban.parsing.adt.Document caliban.schema.RootType caliban.schema.Operation ), (Lcaliban/schema/Operation;)Lcaliban/execution/ExecutionRequest;)((Definition.ExecutableDefinition.OperationDefinition)op, (Map)fragments, (Map)variables$1, (Document)document$1, (RootType)rootType$1));
        }
        throw new MatchError((Object)var20_14);
    }

    private static final Object add$1(Iterable list2, Builder inputValues$1) {
        if (list2.nonEmpty()) {
            return inputValues$1.$plus$plus$eq((IterableOnce)list2);
        }
        return BoxedUnit.UNIT;
    }

    private static final List collectValues$1(List selectionSet, package.Context context$2) {
        Builder inputValues = scala.package$.MODULE$.List().newBuilder();
        selectionSet.foreach((Function1 & Serializable)x0$1 -> {
            Selection selection = x0$1;
            if (selection instanceof Selection.FragmentSpread) {
                Selection.FragmentSpread fragmentSpread = (Selection.FragmentSpread)selection;
                String name = fragmentSpread.name();
                List<Directive> directives = fragmentSpread.directives();
                directives.foreach((Function1 & Serializable)d -> Validator$.add$1(d.arguments().values(), inputValues));
                context$2.fragments().get((Object)name).foreach((Function1 & Serializable)f -> {
                    f.directives().foreach((Function1 & Serializable)d -> Validator$.add$1(d.arguments().values(), inputValues));
                    return Validator$.add$1((Iterable)Validator$.collectValues$1(f.selectionSet(), context$2), inputValues);
                });
                return BoxedUnit.UNIT;
            }
            if (selection instanceof Selection.Field) {
                Selection.Field field = (Selection.Field)selection;
                Map<String, InputValue> arguments = field.arguments();
                List<Directive> directives = field.directives();
                List<Selection> selectionSet = field.selectionSet();
                Validator$.add$1(arguments.values(), inputValues);
                directives.foreach((Function1 & Serializable)d -> Validator$.add$1(d.arguments().values(), inputValues));
                return Validator$.add$1((Iterable)Validator$.collectValues$1(selectionSet, context$2), inputValues);
            }
            if (selection instanceof Selection.InlineFragment) {
                Selection.InlineFragment inlineFragment = (Selection.InlineFragment)selection;
                List<Directive> directives = inlineFragment.dirs();
                List<Selection> selectionSet = inlineFragment.selectionSet();
                directives.foreach((Function1 & Serializable)d -> Validator$.add$1(d.arguments().values(), inputValues));
                return Validator$.add$1((Iterable)Validator$.collectValues$1(selectionSet, context$2), inputValues);
            }
            throw new MatchError((Object)selection);
        });
        return (List)inputValues.result();
    }

    private static final List collectVariableValues$1(List values) {
        return values.flatMap((Function1 & Serializable)x0$1 -> {
            InputValue inputValue = x0$1;
            if (inputValue instanceof InputValue.ListValue) {
                InputValue.ListValue listValue = (InputValue.ListValue)inputValue;
                List<InputValue> values = listValue.values();
                return Validator$.collectVariableValues$1(values);
            }
            if (inputValue instanceof InputValue.ObjectValue) {
                InputValue.ObjectValue objectValue = (InputValue.ObjectValue)inputValue;
                Map<String, InputValue> fields = objectValue.fields();
                return Validator$.collectVariableValues$1(fields.values().toList());
            }
            if (inputValue instanceof InputValue.VariableValue) {
                InputValue.VariableValue variableValue = (InputValue.VariableValue)inputValue;
                return new .colon.colon((Object)variableValue, (List)Nil$.MODULE$);
            }
            if (inputValue instanceof Value) {
                return Nil$.MODULE$;
            }
            throw new MatchError((Object)inputValue);
        });
    }

    public static final /* synthetic */ void $anonfun$collectSelectionSets$1(Builder sets$1, Selection x0$1) {
        Selection selection = x0$1;
        if (selection instanceof Selection.Field) {
            Selection.Field field = (Selection.Field)selection;
            Validator$.loop$1(field.selectionSet(), sets$1);
            return;
        }
        if (selection instanceof Selection.InlineFragment) {
            Selection.InlineFragment inlineFragment = (Selection.InlineFragment)selection;
            Validator$.loop$1(inlineFragment.selectionSet(), sets$1);
            return;
        }
        if (selection instanceof Selection.FragmentSpread) {
            return;
        }
        throw new MatchError((Object)selection);
    }

    private static final void loop$1(List selectionSet, Builder sets$1) {
        Object object = selectionSet.nonEmpty() ? sets$1.$plus$plus$eq((IterableOnce)selectionSet) : BoxedUnit.UNIT;
        selectionSet.foreach((Function1 & Serializable)x0$1 -> {
            Validator$.$anonfun$collectSelectionSets$1(sets$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private static final void loop$2(List selectionSet, Builder builder$1) {
        selectionSet.foreach((Function1 & Serializable)x0$1 -> {
            Selection selection = x0$1;
            if (selection instanceof Selection.FragmentSpread) {
                Selection.FragmentSpread fragmentSpread = (Selection.FragmentSpread)selection;
                List<Directive> directives = fragmentSpread.directives();
                if (directives.nonEmpty()) {
                    return builder$1.$plus$eq((Object)directives.map((Function1 & Serializable)x$10 -> new Tuple2(x$10, (Object)__DirectiveLocation$FRAGMENT_SPREAD$.MODULE$)));
                }
                return BoxedUnit.UNIT;
            }
            if (selection instanceof Selection.Field) {
                Selection.Field field = (Selection.Field)selection;
                List<Directive> directives = field.directives();
                List<Selection> selectionSet = field.selectionSet();
                Object object = directives.nonEmpty() ? builder$1.$plus$eq((Object)directives.map((Function1 & Serializable)x$11 -> new Tuple2(x$11, (Object)__DirectiveLocation$FIELD$.MODULE$))) : BoxedUnit.UNIT;
                Validator$.loop$2(selectionSet, builder$1);
                return BoxedUnit.UNIT;
            }
            if (selection instanceof Selection.InlineFragment) {
                Selection.InlineFragment inlineFragment = (Selection.InlineFragment)selection;
                List<Directive> directives = inlineFragment.dirs();
                List<Selection> selectionSet = inlineFragment.selectionSet();
                Object object = directives.nonEmpty() ? builder$1.$plus$eq((Object)directives.map((Function1 & Serializable)x$12 -> new Tuple2(x$12, (Object)__DirectiveLocation$INLINE_FRAGMENT$.MODULE$))) : BoxedUnit.UNIT;
                Validator$.loop$2(selectionSet, builder$1);
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)selection);
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkDirectivesUniqueness$2(Map directiveDefinitions$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String n = (String)tuple2._1();
            List v = (List)tuple2._2();
            return v.lengthCompare(1) > 0 && !directiveDefinitions$3.get((Object)n).exists((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.exists((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.repeatable()))));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$validateDirectives$4(Directive d$1, __Directive x$17) {
        String string2 = x$17.name();
        String string3 = d$1.name();
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateDirectives$6(String arg$1, __InputValue x$18) {
        String string2 = x$18.name();
        String string3 = arg$1;
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateVariables$9(String v$2, VariableDefinition x$22) {
        String string2 = x$22.name();
        String string3 = v$2;
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$detectCycles$1(scala.collection.immutable.Set visited$1, package.Context context$7, Selection.FragmentSpread s) {
        return visited$1.contains((Object)s.name()) || BoxesRunTime.unboxToBoolean((Object)context$7.fragments().get((Object)s.name()).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)Validator$.MODULE$.detectCycles(context$7, f, (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)visited$1.$plus((Object)s.name()))))));
    }

    private static final /* synthetic */ String typeConditionName$lzycompute$1(LazyRef typeConditionName$lzy$1, Option typeCondition$1) {
        String string2;
        LazyRef lazyRef = typeConditionName$lzy$1;
        synchronized (lazyRef) {
            string2 = typeConditionName$lzy$1.initialized() ? (String)typeConditionName$lzy$1.value() : (String)typeConditionName$lzy$1.initialize(typeCondition$1.fold((Function0 & Serializable)() -> "?", (Function1 & Serializable)x$28 -> x$28.name()));
        }
        return string2;
    }

    private static final String typeConditionName$1(LazyRef typeConditionName$lzy$1, Option typeCondition$1) {
        if (typeConditionName$lzy$1.initialized()) {
            return (String)typeConditionName$lzy$1.value();
        }
        return Validator$.typeConditionName$lzycompute$1(typeConditionName$lzy$1, typeCondition$1);
    }

    public static final /* synthetic */ boolean $anonfun$validateField$3(Selection.Field field$1, __Field x$29) {
        String string2 = x$29.name();
        String string3 = field$1.name();
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateArguments$1(__InputValue x$30) {
        __TypeKind __TypeKind2 = ((__Type)x$30.type().apply()).kind();
        __TypeKind$NON_NULL$ __TypeKind$NON_NULL$2 = __TypeKind$NON_NULL$.MODULE$;
        return !(__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$NON_NULL$2) : __TypeKind$NON_NULL$2 != null);
    }

    public static final /* synthetic */ String $anonfun$validateArguments$3() {
        return "";
    }

    public static final /* synthetic */ String $anonfun$validateArguments$4() {
        return "";
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ ZPure $anonfun$validateArguments$2(Selection.Field field$2, __Type currentType$4, __InputValue arg) {
        block6: {
            block5: {
                var5_3 = new Tuple2(arg.defaultValue(), (Object)field$2.arguments().get((Object)arg.name()));
                if (var5_3 == null) break block5;
                var6_4 = (Option)var5_3._1();
                var7_5 = (Option)var5_3._2();
                if (!None$.MODULE$.equals(var6_4) || !None$.MODULE$.equals(var7_5)) break block5;
                v0 = true;
                break block6;
            }
            if (var5_3 == null) ** GOTO lbl-1000
            var8_6 = (Option)var5_3._1();
            var9_7 = (Option)var5_3._2();
            if (None$.MODULE$.equals(var8_6) && var9_7 instanceof Some && Value$NullValue$.MODULE$.equals(var11_9 = (InputValue)(var10_8 = (Some)var9_7).value())) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
        }
        if (v0) {
            return Validator$.MODULE$.failValidation(new StringBuilder(63).append("Required argument '").append(arg.name()).append("' is null or missing on field '").append(field$2.name()).append("' of type '").append(currentType$4.name().getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$validateArguments$3(), ()Ljava/lang/String;)())).append("'.").toString(), "Arguments can be required. An argument is required if the argument type is non\u2010null and does not have a default value. Otherwise, the argument is optional.");
        }
        if (var5_3 != null) {
            var12_10 = (Option)var5_3._1();
            var13_11 = (Option)var5_3._2();
            if (var12_10 instanceof Some && var13_11 instanceof Some && Value$NullValue$.MODULE$.equals(var15_13 = (InputValue)(var14_12 = (Some)var13_11).value())) {
                return Validator$.MODULE$.failValidation(new StringBuilder(46).append("Required argument '").append(arg.name()).append("' is null on '").append(field$2.name()).append("' of type '").append(currentType$4.name().getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$validateArguments$4(), ()Ljava/lang/String;)())).append("'.").toString(), "Arguments can be required. An argument is required if the argument type is non\u2010null and does not have a default value. Otherwise, the argument is optional.");
            }
        }
        return ZPure$.MODULE$.unit();
    }

    public static final /* synthetic */ boolean $anonfun$validateArguments$6(String arg$2, __InputValue x$31) {
        String string2 = x$31.name();
        String string3 = arg$2;
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateInputValues$4(String k$1, __InputValue x$32) {
        String string2 = x$32.name();
        String string3 = k$1;
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkVariableUsageAllowed$1(InputValue x$33) {
        InputValue inputValue = x$33;
        Value$NullValue$ value$NullValue$ = Value$NullValue$.MODULE$;
        return inputValue == null ? value$NullValue$ != null : !inputValue.equals(value$NullValue$);
    }

    public static final /* synthetic */ boolean $anonfun$validateLoneAnonymousOperation$2(Definition.ExecutableDefinition.OperationDefinition x$35) {
        return x$35.name().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateSubscriptionOperation$3(Definition.ExecutableDefinition.OperationDefinition x$36) {
        OperationType operationType = x$36.operationType();
        OperationType$Subscription$ operationType$Subscription$ = OperationType$Subscription$.MODULE$;
        return !(operationType != null ? !operationType.equals(operationType$Subscription$) : operationType$Subscription$ != null);
    }

    private final ZPure noDuplicateInputValueName$1(List inputValues, String errorContext) {
        Function1 & Serializable messageBuilder = (Function1 & Serializable)i -> new StringBuilder(22).append(errorContext).append(" has repeated fields: ").append(i.name()).toString();
        String explanatory = "The input field must have a unique name within that Input Object type; no two input fields may share the same name";
        return this.noDuplicateName(inputValues, (Function1 & Serializable)x$40 -> x$40.name(), messageBuilder, explanatory);
    }

    private final ZPure validateFields$1(List fields, String inputObjectContext$1) {
        return ZPure$.MODULE$.foreachDiscard((Iterable)fields, (Function1 & Serializable)x$41 -> MODULE$.validateInputValue((__InputValue)x$41, inputObjectContext$1)).$times$greater(this.noDuplicateInputValueName$1(fields, inputObjectContext$1));
    }

    private static final List fields$2(__Type t) {
        return (List)((Option)t.fields().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))))).toList().flatten(Predef$.MODULE$.$conforms());
    }

    private static final scala.collection.immutable.Set fieldNames$1(__Type t) {
        return Validator$.fields$2(t).map((Function1 & Serializable)x$45 -> x$45.name()).toSet();
    }

    private static final ZPure checkForMissingFields$1(__Type obj$1, List supertype$1, String objectContext$1) {
        scala.collection.immutable.Set objectFieldNames = Validator$.fieldNames$1(obj$1);
        scala.collection.immutable.Set interfaceFieldNames = (scala.collection.immutable.Set)supertype$1.map((Function1 & Serializable)t -> Validator$.fieldNames$1(t)).toSet().flatten(Predef$.MODULE$.$conforms());
        SetOps setOps = objectFieldNames.union((Set)interfaceFieldNames);
        scala.collection.immutable.Set set = objectFieldNames;
        boolean isMissingFields = setOps == null ? set != null : !setOps.equals(set);
        return ZPure$.MODULE$.when(interfaceFieldNames.nonEmpty() && isMissingFields, (Function0 & Serializable)() -> {
            List missingFields = (List)interfaceFieldNames.diff((Set)objectFieldNames).toList().sorted((Ordering)Ordering.String$.MODULE$);
            return MODULE$.failValidation(new StringBuilder(22).append(objectContext$1).append(" is missing field(s): ").append(missingFields.mkString(", ")).toString(), "An Object type must include a field of the same name for every field defined in an interface");
        }).unit();
    }

    private static final boolean isNonNullableSubtype$1(__Type supertypeFieldType, __Type objectFieldType) {
        __TypeKind __TypeKind2 = objectFieldType.kind();
        if (__TypeKind$NON_NULL$.MODULE$.equals(__TypeKind2)) {
            return objectFieldType.ofType().exists((Function1 & Serializable)x$46 -> BoxesRunTime.boxToBoolean((boolean)Types$.MODULE$.same(supertypeFieldType, x$46)));
        }
        return false;
    }

    private static final boolean isValidSubtype$1(__Type supertypeFieldType, __Type objectFieldType) {
        List supertypePossibleTypes = (List)supertypeFieldType.possibleTypes().toList().flatten(Predef$.MODULE$.$conforms());
        return Types$.MODULE$.same(supertypeFieldType, objectFieldType) || supertypePossibleTypes.exists((Function1 & Serializable)x$47 -> BoxesRunTime.boxToBoolean((boolean)Types$.MODULE$.same(x$47, objectFieldType))) || Validator$.isNonNullableSubtype$1(supertypeFieldType, objectFieldType);
    }

    public static final /* synthetic */ boolean $anonfun$validateObject$9(__Field objField$1, __Field x$48) {
        String string2 = x$48.name();
        String string3 = objField$1.name();
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateObject$13(__InputValue arg$3, __InputValue superArg) {
        return !Types$.MODULE$.same((__Type)arg$3.type().apply(), (__Type)superArg.type().apply());
    }

    public static final /* synthetic */ boolean $anonfun$validateObject$11(Map superArgs$1, __InputValue arg) {
        return BoxesRunTime.unboxToBoolean((Object)superArgs$1.get((Object)arg.name()).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> true, (Function1 & Serializable)superArg -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateObject$13(arg, superArg))));
    }

    private static final boolean fieldTypeIsValid$1(__Field superField$1, __Field objField$1) {
        return Validator$.isValidSubtype$1((__Type)superField$1.type().apply(), (__Type)objField$1.type().apply());
    }

    private static final boolean listItemTypeIsValid$1(__Field superField$1, __Field objField$1) {
        return MODULE$.isListField(superField$1) && MODULE$.isListField(objField$1) && BoxesRunTime.unboxToBoolean((Object)((__Type)superField$1.type().apply()).ofType().flatMap((Function1 & Serializable)superListItemType -> ((__Type)objField$1.type().apply()).ofType().map((Function1 & Serializable)objListItemType -> BoxesRunTime.boxToBoolean((boolean)Validator$.isValidSubtype$1(superListItemType, objListItemType)))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    public static final /* synthetic */ boolean $anonfun$validateObject$17(__InputValue x$49) {
        __TypeKind __TypeKind2 = ((__Type)x$49.type().apply()).kind();
        __TypeKind$NON_NULL$ __TypeKind$NON_NULL$2 = __TypeKind$NON_NULL$.MODULE$;
        return !(__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$NON_NULL$2) : __TypeKind$NON_NULL$2 != null);
    }

    private static final boolean extraArgsAreValid$1(List extraArgs$1) {
        return !extraArgs$1.exists((Function1 & Serializable)x$49 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateObject$17(x$49)));
    }

    public static final /* synthetic */ boolean $anonfun$validateObject$18(__InputValue x$50) {
        __TypeKind __TypeKind2 = ((__Type)x$50.type().apply()).kind();
        __TypeKind$NON_NULL$ __TypeKind$NON_NULL$2 = __TypeKind$NON_NULL$.MODULE$;
        return !(__TypeKind2 != null ? !__TypeKind2.equals(__TypeKind$NON_NULL$2) : __TypeKind$NON_NULL$2 != null);
    }

    private static final ZPure checkForInvalidSubtypeFields$1(__Type obj$1, List supertype$1, String objectContext$1) {
        List objectFields = Validator$.fields$2(obj$1);
        List supertypeFields = supertype$1.flatMap((Function1 & Serializable)t -> Validator$.fields$2(t));
        return ZPure$.MODULE$.foreachDiscard((Iterable)objectFields, (Function1 & Serializable)objField -> {
            String fieldContext = new StringBuilder(8).append("Field '").append(objField.name()).append("'").toString();
            Option option2 = supertypeFields.find((Function1 & Serializable)x$48 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateObject$9(objField, x$48)));
            if (None$.MODULE$.equals(option2)) {
                return ZPure$.MODULE$.unit();
            }
            if (option2 instanceof Some) {
                boolean bl;
                Some some = (Some)option2;
                __Field superField = (__Field)some.value();
                Map superArgs = superField.args().map((Function1 & Serializable)arg -> new Tuple2((Object)arg.name(), arg)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                List extraArgs = objField.args().filter((Function1 & Serializable)arg -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateObject$11(superArgs, arg)));
                Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(Validator$.fieldTypeIsValid$1(superField, objField), MODULE$.isListField(superField));
                if (sp2 != null && (bl = sp2._2$mcZ$sp()) && !Validator$.listItemTypeIsValid$1(superField, objField)) {
                    return MODULE$.failValidation(new StringBuilder(36).append(fieldContext).append(" in ").append(objectContext$1).append(" is an invalid list item subtype").toString(), "An object list item field type must be equal to or a possible type of the interface list item field type.");
                }
                if (sp2 != null) {
                    boolean bl2 = sp2._1$mcZ$sp();
                    boolean bl3 = sp2._2$mcZ$sp();
                    if (!bl2 && !bl3) {
                        return MODULE$.failValidation(new StringBuilder(26).append(fieldContext).append(" in ").append(objectContext$1).append(" is an invalid subtype").toString(), "An object field type must be equal to or a possible type of the interface field type.");
                    }
                }
                if (!Validator$.extraArgsAreValid$1(extraArgs)) {
                    String argNames = extraArgs.filter((Function1 & Serializable)x$50 -> BoxesRunTime.boxToBoolean((boolean)Validator$.$anonfun$validateObject$18(x$50))).map((Function1 & Serializable)x$51 -> x$51.name()).mkString(", ");
                    return MODULE$.failValidation(new StringBuilder(49).append(fieldContext).append(" with extra non-nullable arg(s) '").append(argNames).append("' in ").append(objectContext$1).append(" is invalid").toString(), "Any additional field arguments must not be of a non-nullable type.");
                }
                return ZPure$.MODULE$.unit();
            }
            throw new MatchError((Object)option2);
        });
    }

    private static final ZPure validateInterfaceFields$1(__Type obj, String objectContext$1) {
        List supertype = (List)((Option)obj.interfaces().apply()).toList().flatten(Predef$.MODULE$.$conforms());
        return Validator$.checkForMissingFields$1(obj, supertype, objectContext$1).flatMap((Function1 & Serializable)x$53 -> {
            BoxedUnit boxedUnit = x$53;
            return Validator$.checkForInvalidSubtypeFields$1(obj, supertype, objectContext$1).map((Function1 & Serializable)x$52 -> {
                boxedUnit = x$52;
                return BoxedUnit.UNIT;
            });
        });
    }

    private static final Either isInputType$1(__Type t2) {
        __TypeKind __TypeKind2 = t2.kind();
        if (__TypeKind$LIST$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$NON_NULL$.MODULE$.equals(__TypeKind2)) {
            return (Either)t2.ofType().fold((Function0 & Serializable)() -> scala.package$.MODULE$.Left().apply((Object)t2), (Function1 & Serializable)t -> Validator$.isInputType$1(t));
        }
        if (__TypeKind$SCALAR$.MODULE$.equals(__TypeKind2) ? true : (__TypeKind$ENUM$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$INPUT_OBJECT$.MODULE$.equals(__TypeKind2))) {
            return scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }
        return scala.package$.MODULE$.Left().apply((Object)t2);
    }

    private static final Either isOutputType$1(__Type t2) {
        __TypeKind __TypeKind2 = t2.kind();
        if (__TypeKind$LIST$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$NON_NULL$.MODULE$.equals(__TypeKind2)) {
            return (Either)t2.ofType().fold((Function0 & Serializable)() -> scala.package$.MODULE$.Left().apply((Object)t2), (Function1 & Serializable)t -> Validator$.isOutputType$1(t));
        }
        if (__TypeKind$SCALAR$.MODULE$.equals(__TypeKind2) ? true : (__TypeKind$OBJECT$.MODULE$.equals(__TypeKind2) ? true : (__TypeKind$INTERFACE$.MODULE$.equals(__TypeKind2) ? true : (__TypeKind$UNION$.MODULE$.equals(__TypeKind2) ? true : __TypeKind$ENUM$.MODULE$.equals(__TypeKind2))))) {
            return scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }
        return scala.package$.MODULE$.Left().apply((Object)t2);
    }

    private static final ZPure validateArguments$1(Map args, String errorContext) {
        String explanatoryText = "The directive argument must not have a name which begins with the characters \"__\" (two underscores)";
        Function1 & Serializable argumentErrorContextBuilder = (Function1 & Serializable)name -> new StringBuilder(15).append("Argument '").append((String)name).append("' of ").append(errorContext).toString();
        return ZPure$.MODULE$.foreachDiscard(args.keys(), (Function1 & Serializable)argName -> MODULE$.doesNotStartWithUnderscore(argName, (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x), (String)argumentErrorContextBuilder.apply(argName), explanatoryText));
    }

    private final ZPure validateDirective$1(Directive directive, String errorContext) {
        String directiveErrorContext = new StringBuilder(16).append("Directive '").append(directive.name()).append("' of ").append(errorContext).toString();
        return this.doesNotStartWithUnderscore(directive, directiveErrorContext).$times$greater(Validator$.validateArguments$1(directive.arguments(), directiveErrorContext));
    }

    private final ZPure validateDirectives$1(Option directives, String errorContext) {
        return ZPure$.MODULE$.foreachDiscard((Iterable)directives.getOrElse((Function0 & Serializable)() -> scala.package$.MODULE$.List().empty()), (Function1 & Serializable)x$64 -> this.validateDirective$1((Directive)x$64, errorContext));
    }

    private final ZPure validateInputValueDirectives$1(List inputValues, String errorContext) {
        Function1 & Serializable inputValueErrorContextBuilder = (Function1 & Serializable)name -> new StringBuilder(17).append("InputValue '").append((String)name).append("' of ").append(errorContext).toString();
        return ZPure$.MODULE$.foreachDiscard((Iterable)inputValues, (Function1 & Serializable)iv -> this.validateDirectives$1(iv.directives(), (String)inputValueErrorContextBuilder.apply((Object)iv.name())));
    }

    private final ZPure validateFieldDirectives$1(__Field field, String errorContext) {
        String fieldErrorContext = new StringBuilder(12).append("Field '").append(field.name()).append("' of ").append(errorContext).toString();
        return this.validateDirectives$1(field.directives(), fieldErrorContext).$times$greater(this.validateInputValueDirectives$1(field.args(), fieldErrorContext));
    }

    private Validator$() {
    }
}

