/*
 * Decompiled with CFR 0.152.
 */
package caliban.validation;

import caliban.CalibanError;
import caliban.CalibanError$ValidationError$;
import caliban.InputValue;
import caliban.Value;
import caliban.Value$NullValue$;
import caliban.introspection.adt.__DeprecatedArgs;
import caliban.introspection.adt.__InputValue;
import caliban.introspection.adt.__Type;
import caliban.introspection.adt.__TypeKind;
import caliban.introspection.adt.__TypeKind$ENUM$;
import caliban.introspection.adt.__TypeKind$INPUT_OBJECT$;
import caliban.introspection.adt.__TypeKind$LIST$;
import caliban.introspection.adt.__TypeKind$NON_NULL$;
import caliban.introspection.adt.__TypeKind$SCALAR$;
import caliban.parsing.Parser$;
import caliban.validation.Validator$;
import caliban.validation.package;
import caliban.validation.package$Context$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import zio.CanFail$;
import zio.prelude.Covariant;
import zio.prelude.IdentityBoth;
import zio.prelude.Invariant$;
import zio.prelude.fx.ZPure;
import zio.prelude.fx.ZPure$;
import zio.prelude.package$;

public final class ValueValidator$ {
    public static final ValueValidator$ MODULE$ = new ValueValidator$();

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateDefaultValue(__InputValue field, String errorContext) {
        Option<String> option2 = field.defaultValue();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String v = (String)some.value();
            return ZPure$.MODULE$.fromEither(Parser$.MODULE$.parseInputValue(v)).mapError((Function1 & Serializable)e -> new CalibanError.ValidationError(new StringBuilder(32).append(errorContext).append(" failed to parse default value: ").append(e.msg()).toString(), "The default value for a field must be written using GraphQL input syntax.", CalibanError$ValidationError$.MODULE$.apply$default$3(), CalibanError$ValidationError$.MODULE$.apply$default$4()), CanFail$.MODULE$.canFail()).flatMap((Function1 & Serializable)value -> Validator$.MODULE$.validateInputValues(field, (InputValue)value, package$Context$.MODULE$.empty(), errorContext).map((Function1 & Serializable)x$1 -> {
                boxedUnit = x$1;
                return BoxedUnit.UNIT;
            }));
        }
        if (None$.MODULE$.equals(option2)) {
            return ZPure$.MODULE$.unit();
        }
        throw new MatchError(option2);
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateInputTypes(__InputValue inputValue, InputValue argValue, package.Context context, String errorContext) {
        return this.validateType((__Type)inputValue.type().apply(), argValue, context, errorContext);
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateType(__Type inputType, InputValue argValue, package.Context context, String errorContext) {
        __TypeKind __TypeKind2;
        while (true) {
            InputValue inputValue;
            if ((inputValue = argValue) instanceof InputValue.VariableValue) {
                InputValue value;
                InputValue.VariableValue variableValue = (InputValue.VariableValue)inputValue;
                argValue = value = (InputValue)context.variables().getOrElse((Object)variableValue.name(), (Function0 & Serializable)() -> (InputValue)context.variableDefinitions().get((Object)variableValue.name()).flatMap((Function1 & Serializable)x$2 -> x$2.defaultValue()).getOrElse((Function0 & Serializable)() -> Value$NullValue$.MODULE$));
                continue;
            }
            __TypeKind2 = inputType.kind();
            if (__TypeKind$NON_NULL$.MODULE$.equals(__TypeKind2)) {
                InputValue inputValue2 = argValue;
                if (Value$NullValue$.MODULE$.equals(inputValue2)) {
                    return this.failValidation(new StringBuilder(8).append(errorContext).append(" is null").toString(), "Input field was null but was supposed to be non-null.");
                }
                argValue = inputValue2;
                inputType = (__Type)inputType.ofType().getOrElse((Function0 & Serializable)() -> inputType);
                continue;
            }
            if (!__TypeKind$LIST$.MODULE$.equals(__TypeKind2)) break;
            InputValue inputValue3 = argValue;
            if (inputValue3 instanceof InputValue.ListValue) {
                InputValue.ListValue listValue = (InputValue.ListValue)inputValue3;
                List<InputValue> values = listValue.values();
                return (ZPure)package$.MODULE$.ForEachOps(values).forEach_((Function1 & Serializable)v -> MODULE$.validateType((__Type)inputType.ofType().getOrElse((Function0 & Serializable)() -> inputType), (InputValue)v, context, new StringBuilder(13).append("List item in ").append(errorContext).toString()), (IdentityBoth)ZPure$.MODULE$.ZPureCovariantIdentityBoth(), (Covariant)ZPure$.MODULE$.ZPureCovariantIdentityBoth(), Invariant$.MODULE$.ListForEach());
            }
            if (Value$NullValue$.MODULE$.equals(inputValue3)) {
                return ZPure$.MODULE$.unit();
            }
            errorContext = new StringBuilder(13).append("List item in ").append(errorContext).toString();
            argValue = inputValue3;
            inputType = (__Type)inputType.ofType().getOrElse((Function0 & Serializable)() -> inputType);
        }
        if (__TypeKind$INPUT_OBJECT$.MODULE$.equals(__TypeKind2)) {
            InputValue inputValue = argValue;
            if (inputValue instanceof InputValue.ObjectValue) {
                InputValue.ObjectValue objectValue = (InputValue.ObjectValue)inputValue;
                Map<String, InputValue> fields = objectValue.fields();
                return (ZPure)package$.MODULE$.ForEachOps(inputType.inputFields().getOrElse((Function0 & Serializable)() -> scala.package$.MODULE$.List().empty())).forEach_((Function1 & Serializable)f -> {
                    Option option2 = fields.collectFirst((PartialFunction)new Serializable((__InputValue)f){
                        private static final long serialVersionUID = 0L;
                        private final __InputValue f$1;

                        public final <A1 extends Tuple2<String, InputValue>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            if (A1 != null) {
                                String name = (String)A1._1();
                                InputValue fieldValue = (InputValue)A1._2();
                                String string2 = name;
                                String string3 = this.f$1.name();
                                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                                    return (B1)fieldValue;
                                }
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Tuple2<String, InputValue> x1) {
                            Tuple2<String, InputValue> tuple2 = x1;
                            if (tuple2 != null) {
                                String name;
                                String string2 = name = (String)tuple2._1();
                                String string3 = this.f$1.name();
                                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                                    return true;
                                }
                            }
                            return false;
                        }
                        {
                            this.f$1 = f$1;
                        }
                    });
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        InputValue value = (InputValue)some.value();
                        return MODULE$.validateType((__Type)f.type().apply(), value, context, new StringBuilder(10).append("Field ").append(f.name()).append(" in ").append(errorContext).toString());
                    }
                    if (None$.MODULE$.equals(option2)) {
                        return ZPure$.MODULE$.when(f.defaultValue().isEmpty(), (Function0 & Serializable)() -> MODULE$.validateType((__Type)f.type().apply(), Value$NullValue$.MODULE$, context, new StringBuilder(10).append("Field ").append(f.name()).append(" in ").append(errorContext).toString()));
                    }
                    throw new MatchError((Object)option2);
                }, (IdentityBoth)ZPure$.MODULE$.ZPureCovariantIdentityBoth(), (Covariant)ZPure$.MODULE$.ZPureCovariantIdentityBoth(), Invariant$.MODULE$.ListForEach());
            }
            if (Value$NullValue$.MODULE$.equals(inputValue)) {
                return ZPure$.MODULE$.unit();
            }
            return this.failValidation(new StringBuilder(19).append(errorContext).append(" has invalid type: ").append(argValue).toString(), "Input field was supposed to be an input object.");
        }
        if (__TypeKind$ENUM$.MODULE$.equals(__TypeKind2)) {
            InputValue inputValue = argValue;
            if (inputValue instanceof Value.EnumValue) {
                Value.EnumValue enumValue = (Value.EnumValue)inputValue;
                String value = enumValue.value();
                return this.validateEnum(value, inputType, errorContext);
            }
            if (Value$NullValue$.MODULE$.equals(inputValue)) {
                return ZPure$.MODULE$.unit();
            }
            return this.failValidation(new StringBuilder(19).append(errorContext).append(" has invalid type: ").append(argValue).toString(), "Input field was supposed to be an enum value.");
        }
        if (__TypeKind$SCALAR$.MODULE$.equals(__TypeKind2)) {
            return this.validateScalar(inputType, argValue, errorContext);
        }
        return this.failValidation(new StringBuilder(18).append(errorContext).append(" has invalid type ").append(inputType).toString(), "Input value is invalid, should be a scalar, list or input object.");
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateEnum(String value, __Type inputType, String errorContext) {
        List possible = ((List)((Option)inputType.enumValues().apply((Object)new __DeprecatedArgs((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true))))).getOrElse((Function0 & Serializable)() -> scala.package$.MODULE$.List().empty())).map((Function1 & Serializable)x$3 -> x$3.name());
        boolean exists = possible.contains((Object)value);
        return ZPure$.MODULE$.unless(exists, (Function0 & Serializable)() -> MODULE$.failValidation(new StringBuilder(25).append(errorContext).append(" has invalid enum value: ").append(value).toString(), new StringBuilder(26).append("Was supposed to be one of ").append(possible.mkString(", ")).toString())).unit();
    }

    public ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, BoxedUnit> validateScalar(__Type inputType, InputValue argValue, String errorContext) {
        String string2 = (String)inputType.name().getOrElse((Function0 & Serializable)() -> "");
        switch (string2 == null ? 0 : string2.hashCode()) {
            case -1808118735: {
                if (!"String".equals(string2)) break;
                InputValue inputValue = argValue;
                if (inputValue instanceof Value.StringValue ? true : Value$NullValue$.MODULE$.equals(inputValue)) {
                    return ZPure$.MODULE$.unit();
                }
                return this.failValidation(new StringBuilder(18).append(errorContext).append(" has invalid type ").append(inputValue).toString(), "Expected 'String'");
            }
            case 2331: {
                if (!"ID".equals(string2)) break;
                InputValue inputValue = argValue;
                if (inputValue instanceof Value.StringValue ? true : Value$NullValue$.MODULE$.equals(inputValue)) {
                    return ZPure$.MODULE$.unit();
                }
                return this.failValidation(new StringBuilder(18).append(errorContext).append(" has invalid type ").append(inputValue).toString(), "Expected 'ID'");
            }
            case 73679: {
                if (!"Int".equals(string2)) break;
                InputValue inputValue = argValue;
                if (inputValue instanceof Value.IntValue ? true : Value$NullValue$.MODULE$.equals(inputValue)) {
                    return ZPure$.MODULE$.unit();
                }
                return this.failValidation(new StringBuilder(18).append(errorContext).append(" has invalid type ").append(inputValue).toString(), "Expected 'Int'");
            }
            case 67973692: {
                if (!"Float".equals(string2)) break;
                InputValue inputValue = argValue;
                if (inputValue instanceof Value.FloatValue ? true : (inputValue instanceof Value.IntValue ? true : Value$NullValue$.MODULE$.equals(inputValue))) {
                    return ZPure$.MODULE$.unit();
                }
                return this.failValidation(new StringBuilder(18).append(errorContext).append(" has invalid type ").append(inputValue).toString(), "Expected 'Float'");
            }
            case 1729365000: {
                if (!"Boolean".equals(string2)) break;
                InputValue inputValue = argValue;
                if (inputValue instanceof Value.BooleanValue ? true : Value$NullValue$.MODULE$.equals(inputValue)) {
                    return ZPure$.MODULE$.unit();
                }
                return this.failValidation(new StringBuilder(18).append(errorContext).append(" has invalid type ").append(inputValue).toString(), "Expected 'Boolean'");
            }
        }
        return ZPure$.MODULE$.unit();
    }

    public <T> ZPure<Nothing$, BoxedUnit, BoxedUnit, Object, CalibanError.ValidationError, T> failValidation(String msg, String explanatoryText) {
        return ZPure$.MODULE$.fail((Object)new CalibanError.ValidationError(msg, explanatoryText, CalibanError$ValidationError$.MODULE$.apply$default$3(), CalibanError$ValidationError$.MODULE$.apply$default$4()));
    }

    private ValueValidator$() {
    }
}

