package com.github.gigiosouza.japigeebundler;

import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;

public class XmlMapperFactory {

  private static XmlMapper mapper;

  private static XmlMapper createXmlMapper() {
    WstxInputFactory inputFactory = new WstxInputFactory();
    WstxOutputFactory outputFactory = new WstxOutputFactory();
    outputFactory.getConfig().doUseDoubleQuotesInXmlDecl(true);

    XmlFactory xf = new XmlFactory(inputFactory, outputFactory);

    mapper = new XmlMapper(xf);
    mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    mapper.enable(SerializationFeature.INDENT_OUTPUT);
    mapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
    mapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);

    return mapper;
  }


  public static XmlMapper getInstance() {
    if (mapper == null) {
      mapper = createXmlMapper();
    }
    return mapper;
  }

}
