package com.github.gigiosouza.japigeebundler.apigee;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.flows.proxyendpoint.ProxyEndpoint;
import com.github.gigiosouza.japigeebundler.apigee.flows.targetendpoint.TargetEndpoint;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import com.github.gigiosouza.japigeebundler.apigee.policies.extension.FlowCalloutPolicy;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data
@JacksonXmlRootElement(localName = "APIProxy")
public class APIProxy {

  @NotEmpty
  @NotNull
  @JacksonXmlProperty(isAttribute = true, localName = "name")
  private String name;

  @NotEmpty
  @NotNull
  @JacksonXmlProperty(isAttribute = true, localName = "revision")
  private Integer revision;

  @JacksonXmlProperty(localName = "ConfigurationVersion")
  private ConfigurationVersion configurationVersion;

  @JacksonXmlProperty(localName = "CreatedAt")
  private Long createdAt;

  @JacksonXmlProperty(localName = "CreatedBy")
  private String createdBy;

  @JacksonXmlProperty(localName = "LastModifiedAt")
  private Long lastModifiedAt;

  @JacksonXmlProperty(localName = "LastModifiedBy")
  private String lastModifiedBy;

  @JacksonXmlProperty(localName = "DisplayName")
  private String displayName;

  @JacksonXmlProperty(localName = "Description")
  private String description;

  @JacksonXmlElementWrapper(localName = "Basepaths")
  @JacksonXmlProperty(localName = "Basepath")
  private List<String> basepaths = new ArrayList<>();

  @JacksonXmlElementWrapper(localName = "Policies")
  @JacksonXmlProperty(localName = "Policy")
  private List<String> policies = new ArrayList<>();

  @JacksonXmlElementWrapper(localName = "ProxyEndpoints")
  @JacksonXmlProperty(localName = "ProxyEndpoint")
  private List<String> proxyEndpoints = new ArrayList<>();

  @JacksonXmlElementWrapper(localName = "TargetEndpoints")
  @JacksonXmlProperty(localName = "TargetEndpoint")
  private List<String> targetEndpoints = new ArrayList<>();

  @JacksonXmlElementWrapper(localName = "Resources")
  @JacksonXmlProperty(localName = "Resource")
  private List<String> resources = new ArrayList<>();

  @JacksonXmlElementWrapper(localName = "TargetServers")
  @JacksonXmlProperty(localName = "TargetServer")
  private List<String> targetServers = new ArrayList<>();

  @JacksonXmlProperty(localName = "Spec")
  private String spec;

  @JacksonXmlElementWrapper(localName = "SharedFlows")
  @JacksonXmlProperty(localName = "SharedFlow")
  private List<String> sharedFlows = new ArrayList<>();

  // TODO study about manifest version and manifest files

  public void defaultValues() {
    revision = 1;
    configurationVersion = new ConfigurationVersion(4, 0);
  }

  public void addProxyEndpoint(final ProxyEndpoint proxyEndpoint) {
    proxyEndpoints.add(proxyEndpoint.getName());
    basepaths.add(proxyEndpoint.getHttpProxyConnection().getBasePath());
  }

  public void addTargetEndpoint(final TargetEndpoint targetEndpoint) {
    targetEndpoints.add(targetEndpoint.getName());
    if (
      targetEndpoint.getHttpTargetConnection() != null &&
      targetEndpoint.getHttpTargetConnection().getLoadBalancer() != null &&
      targetEndpoint.getHttpTargetConnection().getLoadBalancer().getServers() != null &&
      !targetEndpoint.getHttpTargetConnection().getLoadBalancer().getServers().isEmpty()
    ) {
      targetEndpoint.getHttpTargetConnection()
                    .getLoadBalancer()
                    .getServers()
                    .forEach(s -> targetServers.add(s.getName()));
    }
  }

  public void addPolicy(final Policy policy) {
    policies.add(policy.getName());
    if (policy instanceof FlowCalloutPolicy) {
      FlowCalloutPolicy flowCallout = (FlowCalloutPolicy) policy;
      sharedFlows.add(flowCallout.getSharedFlowBundle());
    }
  }

  public void addResource(final Resource resource) {
    resources.add(resource.getType().name() + "://" + resource.getFile().getName());
  }

}
