package com.github.gigiosouza.japigeebundler.apigee.commons;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class NameValue {

  @NotEmpty
  @NotNull
  @JacksonXmlProperty(isAttribute = true, localName = "name")
  private String name;

  @JacksonXmlText
  private String value;

}
