package com.github.gigiosouza.japigeebundler.apigee.flows;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class Flow {

  @JacksonXmlProperty(localName = "name", isAttribute = true)
  private String name;

  @JacksonXmlProperty(localName = "Description")
  private String description;

  @JacksonXmlProperty(localName = "Condition")
  private String condition;

  @JacksonXmlProperty(localName = "Request")
  private Steps request = new Steps();

  @JacksonXmlProperty(localName = "Response")
  private Steps response = new Steps();

  public Flow(final String name) {
    this.name = name;
  }

}
