package com.github.gigiosouza.japigeebundler.apigee.flows;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class Step {

  @JacksonXmlProperty(localName = "Name")
  private String name;

  @JacksonXmlProperty(localName = "Condition")
  private String condition;

  public Step(final String name) {
    this.name = name;
  }

  public Step(final Policy policy) {
    this.name = policy.getName();
  }
}
