package com.github.gigiosouza.japigeebundler.apigee.flows;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.github.gigiosouza.japigeebundler.apigee.policies.Policy;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class Steps {

  @JacksonXmlElementWrapper(useWrapping = false)
  @JacksonXmlProperty(localName = "Step")
  private List<Step> steps = new ArrayList<>();

  public void appendSteps(final Step ...step) {
    this.steps.addAll(Arrays.asList(step));
  }

  public void appendSteps(final Policy ...policy) {
    this.steps.addAll(Arrays.stream(policy).map(Step::new).collect(Collectors.toList()));
  }

  public void prependSteps(final Step ...step) {
    this.steps.addAll(0, Arrays.asList(step));
  }

  public void prependSteps(final Policy ...policy) {
    this.steps.addAll(0, Arrays.stream(policy).map(Step::new).collect(Collectors.toList()));
  }

}
