package com.github.gigiosouza.japigeebundler.apigee.flows.proxyendpoint;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.github.gigiosouza.japigeebundler.apigee.commons.Properties;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class HTTPProxyConnection {

  @JacksonXmlProperty(localName = "BasePath")
  private String basePath;

  @JacksonXmlElementWrapper(useWrapping = false)
  @JacksonXmlProperty(localName = "VirtualHost")
  private List<String> virtualHosts = new ArrayList<>();

  @JacksonXmlProperty(localName = "Properties")
  private Properties properties;

  public void addVirtualHosts(final String ...virtualHosts) {
    this.virtualHosts.addAll(Arrays.asList(virtualHosts));
  }

}
