package com.github.gigiosouza.japigeebundler.apigee.flows.proxyendpoint;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.gigiosouza.japigeebundler.apigee.flows.FaultRule;
import com.github.gigiosouza.japigeebundler.apigee.flows.Flow;
import lombok.Data;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

@Data
@JacksonXmlRootElement(localName = "ProxyEndpoint")
@JsonPropertyOrder({
  "preFlow",
  "flows",
  "postFlow",
  "faultRules",
  "defaultFaultRule",
  "postClientFlow",
  "httpProxyConnection",
  "routeRules"
})
public class ProxyEndpoint {

  @JacksonXmlProperty(isAttribute = true, localName = "name")
  private String name;

  @JacksonXmlProperty(localName = "PreFlow")
  private Flow preFlow = new Flow("PreFlow");

  @JacksonXmlElementWrapper(localName = "Flows")
  @JacksonXmlProperty(localName = "Flow")
  private Set<Flow> flows = new LinkedHashSet<>();

  @JacksonXmlProperty(localName = "PostFlow")
  private Flow postFlow = new Flow("PostFlow");

  @JacksonXmlProperty(localName = "PostClientFlow")
  private PostClientFlow postClientFlow;

  @JacksonXmlProperty(localName = "DefaultFaultRule")
  private FaultRule defaultFaultRule;

  @JacksonXmlElementWrapper(localName = "FaultRules")
  @JacksonXmlProperty(localName = "FaultRule")
  private Set<FaultRule> faultRules = new LinkedHashSet<>();

  @JacksonXmlProperty(localName = "HTTPProxyConnection")
  private HTTPProxyConnection httpProxyConnection = new HTTPProxyConnection();

  @JacksonXmlElementWrapper(useWrapping = false)
  @JacksonXmlProperty(localName = "RouteRule")
  private Set<RouteRule> routeRules = new LinkedHashSet<>();

  public void prependFlows(final Flow... flows) {
    LinkedHashSet<Flow> newFlows = new LinkedHashSet<>();
    newFlows.addAll(Arrays.asList(flows));
    newFlows.addAll(this.flows);
    this.flows = newFlows;
  }

  public void appendFlows(final Flow... flows) {
    this.flows.addAll(Arrays.asList(flows));
  }

  public void prependRouteRules(final RouteRule... routeRules) {
    LinkedHashSet<RouteRule> newRouteRules = new LinkedHashSet<>();
    newRouteRules.addAll(Arrays.asList(routeRules));
    newRouteRules.addAll(this.routeRules);
    this.routeRules = newRouteRules;
  }

  public void appendRouteRules(final RouteRule... routeRules) {
    this.routeRules.addAll(Arrays.asList(routeRules));
  }

  public void prependFaultRules(final FaultRule... faultRules) {
    LinkedHashSet<FaultRule> newFaultRules = new LinkedHashSet<>();
    newFaultRules.addAll(Arrays.asList(faultRules));
    newFaultRules.addAll(this.faultRules);
    this.faultRules = newFaultRules;
  }

  public void appendFaultRules(final FaultRule... faultRules) {
    this.faultRules.addAll(Arrays.asList(faultRules));
  }

}
