package com.github.gigiosouza.japigeebundler.apigee.flows.targetendpoint;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.github.gigiosouza.japigeebundler.apigee.commons.Properties;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class HTTPTargetConnection {

  @JacksonXmlProperty(localName = "URL")
  private String url;

  @JacksonXmlProperty(localName = "Path")
  private String path;

  @JacksonXmlProperty(localName = "LoadBalancer")
  private LoadBalancer loadBalancer;

  @JacksonXmlProperty(localName = "SSLInfo")
  private SSLInfo sslInfo;

  @JacksonXmlProperty(localName = "Properties")
  private Properties properties;

}
