package com.github.gigiosouza.japigeebundler.apigee.flows.targetendpoint;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.github.gigiosouza.japigeebundler.apigee.commons.Name;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class LoadBalancer {

  @JacksonXmlProperty(localName = "Algorithm")
  private String algorithm;

  @JacksonXmlElementWrapper(useWrapping = false)
  @JacksonXmlProperty(localName = "Server")
  private List<Name> servers = new ArrayList<>();

  public void addServer(final String server) {
    this.servers.add(new Name(server));
  }

}
