package com.github.gigiosouza.japigeebundler.apigee.flows.targetendpoint;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class SSLInfo {

  @JacksonXmlProperty(localName = "Enabled")
  private Boolean enabled;

  @JacksonXmlProperty(localName = "ClientAuthEnabled")
  private Boolean clientAuthEnabled;

  @JacksonXmlProperty(localName = "KeyStore")
  private String keyStore;

  @JacksonXmlProperty(localName = "KeyAlias")
  private String keyAlias;

  @JacksonXmlProperty(localName = "TrustStore")
  private String trustStore;

  @JacksonXmlElementWrapper(localName = "Cyphers")
  @JacksonXmlProperty(localName = "Cypher")
  private List<String> cyphers;

  @JacksonXmlElementWrapper(localName = "Protocols")
  @JacksonXmlProperty(localName = "Protocol")
  private List<String> protocol;

}
