package com.github.gigiosouza.japigeebundler.apigee.flows.targetendpoint;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.github.gigiosouza.japigeebundler.apigee.commons.NameValue;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class ScriptTarget {

  @JacksonXmlProperty(localName = "ResourceURL")
  private String resourceURL;

  @JacksonXmlElementWrapper(localName = "EnvironmentVariables")
  @JacksonXmlProperty(localName = "EnvironmentVariable")
  private List<NameValue> environmentVariables;

  @JacksonXmlElementWrapper(localName = "Arguments")
  @JacksonXmlProperty(localName = "Argument")
  private List<String> arguments;

}
